/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.charts.views;

import com.codename1.charts.compat.Canvas;
import com.codename1.charts.compat.Paint;
import com.codename1.charts.models.Point;
import com.codename1.charts.models.SeriesSelection;
import com.codename1.charts.models.XYMultipleSeriesDataset;
import com.codename1.charts.models.XYSeries;
import com.codename1.charts.renderers.BasicStroke;
import com.codename1.charts.renderers.SimpleSeriesRenderer;
import com.codename1.charts.renderers.XYMultipleSeriesRenderer;
import com.codename1.charts.renderers.XYSeriesRenderer;
import com.codename1.charts.util.MathHelper;
import com.codename1.charts.views.AbstractChart;
import com.codename1.charts.views.ClickableArea;
import com.codename1.charts.views.ScatterChart;
import com.codename1.ui.Font;
import com.codename1.ui.geom.Rectangle;
import com.codename1.ui.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XYChart
extends AbstractChart {
    private final HashMap<Integer, double[]> mCalcRange = new HashMap();
    protected XYMultipleSeriesDataset mDataset;
    protected XYMultipleSeriesRenderer mRenderer;
    private float mScale;
    private float mTranslate;
    private Point mCenter;
    private Rectangle mScreenR;
    private HashMap<Integer, List<ClickableArea>> clickableAreas = new HashMap();

    protected XYChart() {
    }

    public XYChart(XYMultipleSeriesDataset dataset, XYMultipleSeriesRenderer renderer) {
        this.mDataset = dataset;
        this.mRenderer = renderer;
    }

    protected void setDatasetRenderer(XYMultipleSeriesDataset dataset, XYMultipleSeriesRenderer renderer) {
        this.mDataset = dataset;
        this.mRenderer = renderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(Canvas canvas, int x, int y, int width, int height, Paint paint) {
        int i;
        int angle;
        XYMultipleSeriesRenderer.Orientation or;
        paint.setAntiAlias(this.mRenderer.isAntialiasing());
        int legendSize = this.getLegendSize(this.mRenderer, height / 5, this.mRenderer.getAxisTitleTextSize());
        int[] margins = this.mRenderer.getMargins();
        int left = x + margins[1] + (int)this.mRenderer.getAxisTitleTextSize() + (this.mRenderer.isShowLabels() ? (int)this.mRenderer.getLabelsTextSize() : 0);
        int top = y + margins[0];
        int right = x + width - margins[3];
        int sLength = this.mDataset.getSeriesCount();
        String[] titles = new String[sLength];
        for (int i2 = 0; i2 < sLength; ++i2) {
            titles[i2] = this.mDataset.getSeriesAt(i2).getTitle();
        }
        if (this.mRenderer.isFitLegend() && this.mRenderer.isShowLegend()) {
            legendSize = this.drawLegend(canvas, this.mRenderer, titles, left, right, y, width, height, legendSize, paint, true);
        }
        int bottom = y + height - margins[2] - legendSize - (int)this.mRenderer.getAxisTitleTextSize() - (this.mRenderer.isShowLabels() ? (int)this.mRenderer.getLabelsTextSize() : 0);
        if (this.mScreenR == null) {
            this.mScreenR = new Rectangle();
        }
        this.mScreenR.setBounds(left, top, right - left, bottom - top);
        this.drawBackground(this.mRenderer, canvas, x, y, width, height, paint, false, 0);
        if (paint.getTypeface() == null || this.mRenderer.getTextTypeface() != null && paint.getTypeface().equals(this.mRenderer.getTextTypeface()) || !paint.getTypeface().toString().equals(this.mRenderer.getTextTypefaceName()) || paint.getTypeface().getStyle() != this.mRenderer.getTextTypefaceStyle()) {
            if (this.mRenderer.getTextTypeface() != null) {
                paint.setTypeface(this.mRenderer.getTextTypeface());
            } else {
                paint.setTypeface(Font.createSystemFont(this.mRenderer.getTextTypefaceName(), this.mRenderer.getTextTypefaceStyle(), 8));
            }
        }
        if ((or = this.mRenderer.getOrientation()) == XYMultipleSeriesRenderer.Orientation.VERTICAL) {
            right -= legendSize;
            bottom += legendSize - 20;
        }
        boolean rotate = (angle = or.getAngle()) == 90;
        this.mScale = (float)height / (float)width;
        this.mTranslate = Math.abs(width - height) / 2;
        if (this.mScale < 1.0f) {
            this.mTranslate *= -1.0f;
        }
        this.mCenter = new Point((x + width) / 2, (y + height) / 2);
        if (rotate) {
            this.transform(canvas, angle, false);
        }
        int maxScaleNumber = -2147483647;
        for (int i3 = 0; i3 < sLength; ++i3) {
            maxScaleNumber = Math.max(maxScaleNumber, this.mDataset.getSeriesAt(i3).getScaleNumber());
        }
        if (++maxScaleNumber < 0) {
            return;
        }
        double[] minX = new double[maxScaleNumber];
        double[] maxX = new double[maxScaleNumber];
        double[] minY = new double[maxScaleNumber];
        double[] maxY = new double[maxScaleNumber];
        boolean[] isMinXSet = new boolean[maxScaleNumber];
        boolean[] isMaxXSet = new boolean[maxScaleNumber];
        boolean[] isMinYSet = new boolean[maxScaleNumber];
        boolean[] isMaxYSet = new boolean[maxScaleNumber];
        for (int i4 = 0; i4 < maxScaleNumber; ++i4) {
            minX[i4] = this.mRenderer.getXAxisMin(i4);
            maxX[i4] = this.mRenderer.getXAxisMax(i4);
            minY[i4] = this.mRenderer.getYAxisMin(i4);
            maxY[i4] = this.mRenderer.getYAxisMax(i4);
            isMinXSet[i4] = this.mRenderer.isMinXSet(i4);
            isMaxXSet[i4] = this.mRenderer.isMaxXSet(i4);
            isMinYSet[i4] = this.mRenderer.isMinYSet(i4);
            isMaxYSet[i4] = this.mRenderer.isMaxYSet(i4);
            if (this.mCalcRange.get(i4) != null) continue;
            this.mCalcRange.put(i4, new double[4]);
        }
        double[] xPixelsPerUnit = new double[maxScaleNumber];
        double[] yPixelsPerUnit = new double[maxScaleNumber];
        for (i = 0; i < sLength; ++i) {
            XYSeries series = this.mDataset.getSeriesAt(i);
            int scale = series.getScaleNumber();
            if (series.getItemCount() == 0) continue;
            if (!isMinXSet[scale]) {
                double minimumX = series.getMinX();
                if (minimumX != -1.7976931348623157E308) {
                    minX[scale] = minX[scale] == -1.7976931348623157E308 ? minimumX : Math.min(minX[scale], minimumX);
                    this.mCalcRange.get((Object)Integer.valueOf((int)scale))[0] = minX[scale];
                } else {
                    minX[scale] = 0.0;
                    this.mCalcRange.get((Object)Integer.valueOf((int)scale))[0] = 0.0;
                }
            }
            if (!isMaxXSet[scale]) {
                double maximumX = series.getMaxX();
                if (maximumX != -1.7976931348623157E308) {
                    maxX[scale] = maxX[scale] == -1.7976931348623157E308 ? maximumX : Math.max(maxX[scale], maximumX);
                    this.mCalcRange.get((Object)Integer.valueOf((int)scale))[1] = maxX[scale];
                } else {
                    maxX[scale] = minX[scale] + 1.0;
                    this.mCalcRange.get((Object)Integer.valueOf((int)scale))[1] = maxX[scale];
                }
            }
            if (!isMinYSet[scale]) {
                double minimumY = series.getMinY();
                if (minimumY != -1.7976931348623157E308) {
                    minY[scale] = minY[scale] == -1.7976931348623157E308 ? minimumY : Math.min(minY[scale], (double)((float)minimumY));
                    this.mCalcRange.get((Object)Integer.valueOf((int)scale))[2] = minY[scale];
                } else {
                    minY[scale] = 0.0;
                    this.mCalcRange.get((Object)Integer.valueOf((int)scale))[2] = 0.0;
                }
            }
            if (isMaxYSet[scale]) continue;
            double maximumY = series.getMaxY();
            if (maximumY != -1.7976931348623157E308) {
                maxY[scale] = maxY[scale] == -1.7976931348623157E308 ? maximumY : Math.max(maxY[scale], (double)((float)maximumY));
                this.mCalcRange.get((Object)Integer.valueOf((int)scale))[3] = maxY[scale];
                continue;
            }
            maxY[scale] = minY[scale] + 1.0;
            this.mCalcRange.get((Object)Integer.valueOf((int)scale))[3] = maxY[scale];
        }
        for (i = 0; i < maxScaleNumber; ++i) {
            if (maxX[i] - minX[i] != 0.0) {
                xPixelsPerUnit[i] = (double)(right - left) / (maxX[i] - minX[i]);
            }
            if (maxY[i] - minY[i] != 0.0) {
                yPixelsPerUnit[i] = (float)((double)(bottom - top) / (maxY[i] - minY[i]));
            }
            if (i <= 0) continue;
            xPixelsPerUnit[i] = xPixelsPerUnit[0];
            minX[i] = minX[0];
            maxX[i] = maxX[0];
        }
        boolean hasValues = false;
        this.clickableAreas = new HashMap();
        for (int i5 = 0; i5 < sLength; ++i5) {
            XYSeries series = this.mDataset.getSeriesAt(i5);
            int scale = series.getScaleNumber();
            if (series.getItemCount() == 0) continue;
            hasValues = true;
            XYSeriesRenderer seriesRenderer = (XYSeriesRenderer)this.mRenderer.getSeriesRendererAt(i5);
            ArrayList<Float> points = new ArrayList<Float>();
            ArrayList<Double> values = new ArrayList<Double>();
            float yAxisValue = Math.min((float)bottom, (float)((double)bottom + yPixelsPerUnit[scale] * minY[scale]));
            LinkedList<ClickableArea> clickableArea = new LinkedList<ClickableArea>();
            this.clickableAreas.put(i5, clickableArea);
            XYSeries xYSeries = series;
            synchronized (xYSeries) {
                SortedMap<Double, Double> range = series.getRange(minX[scale], maxX[scale], seriesRenderer.isDisplayBoundingPoints());
                int startIndex = -1;
                for (Map.Entry<Double, Double> entry : range.entrySet()) {
                    Double value = entry.getKey();
                    double xValue = value;
                    Double rValue = entry.getValue();
                    double yValue = rValue;
                    if (startIndex < 0 && (!this.isNullValue(yValue) || this.isRenderNullValues())) {
                        startIndex = series.getIndexForKey(xValue);
                    }
                    values.add(value);
                    values.add(rValue);
                    if (!this.isNullValue(yValue)) {
                        points.add(Float.valueOf((float)((double)left + xPixelsPerUnit[scale] * (xValue - minX[scale]))));
                        points.add(Float.valueOf((float)((double)bottom - yPixelsPerUnit[scale] * (yValue - minY[scale]))));
                        continue;
                    }
                    if (this.isRenderNullValues()) {
                        points.add(Float.valueOf((float)((double)left + xPixelsPerUnit[scale] * (xValue - minX[scale]))));
                        points.add(Float.valueOf((float)((double)bottom - yPixelsPerUnit[scale] * -minY[scale])));
                        continue;
                    }
                    if (points.size() > 0) {
                        this.drawSeries(series, canvas, paint, points, seriesRenderer, yAxisValue, i5, or, startIndex);
                        ClickableArea[] clickableAreasForSubSeries = this.clickableAreasForPoints(points, values, yAxisValue, i5, startIndex);
                        clickableArea.addAll(Arrays.asList(clickableAreasForSubSeries));
                        points.clear();
                        values.clear();
                        startIndex = -1;
                    }
                    clickableArea.add(null);
                }
                int count = series.getAnnotationCount();
                if (count > 0) {
                    paint.setColor(seriesRenderer.getAnnotationsColor());
                    paint.setTextSize(seriesRenderer.getAnnotationsTextSize());
                    paint.setTextAlign(seriesRenderer.getAnnotationsTextAlign());
                    Rectangle2D bound = new Rectangle2D();
                    for (int j = 0; j < count; ++j) {
                        float xS = (float)((double)left + xPixelsPerUnit[scale] * (series.getAnnotationX(j) - minX[scale]));
                        float yS = (float)((double)bottom - yPixelsPerUnit[scale] * (series.getAnnotationY(j) - minY[scale]));
                        paint.getTextBounds(series.getAnnotationAt(j), 0, series.getAnnotationAt(j).length(), bound);
                        if (!((double)xS < (double)xS + bound.getWidth()) || !(yS < (float)canvas.getHeight())) continue;
                        this.drawString(canvas, series.getAnnotationAt(j), xS, yS, paint);
                    }
                }
                if (points.size() > 0) {
                    this.drawSeries(series, canvas, paint, points, seriesRenderer, yAxisValue, i5, or, startIndex);
                    ClickableArea[] clickableAreasForSubSeries = this.clickableAreasForPoints(points, values, yAxisValue, i5, startIndex);
                    clickableArea.addAll(Arrays.asList(clickableAreasForSubSeries));
                }
                continue;
            }
        }
        this.drawBackground(this.mRenderer, canvas, x, bottom, width, height - bottom, paint, true, this.mRenderer.getMarginsColor());
        this.drawBackground(this.mRenderer, canvas, x, y, width, margins[0], paint, true, this.mRenderer.getMarginsColor());
        if (or == XYMultipleSeriesRenderer.Orientation.HORIZONTAL) {
            this.drawBackground(this.mRenderer, canvas, x, y, left - x, height - y, paint, true, this.mRenderer.getMarginsColor());
            this.drawBackground(this.mRenderer, canvas, right, y, margins[3], height - y, paint, true, this.mRenderer.getMarginsColor());
        } else if (or == XYMultipleSeriesRenderer.Orientation.VERTICAL) {
            this.drawBackground(this.mRenderer, canvas, right, y, width - right, height - y, paint, true, this.mRenderer.getMarginsColor());
            this.drawBackground(this.mRenderer, canvas, x, y, left - x, height - y, paint, true, this.mRenderer.getMarginsColor());
        }
        boolean showLabels = this.mRenderer.isShowLabels() && hasValues;
        boolean showGridX = this.mRenderer.isShowGridX();
        boolean showTickMarks = this.mRenderer.isShowTickMarks();
        boolean showCustomTextGridY = this.mRenderer.isShowCustomTextGridY();
        if (showLabels || showGridX) {
            List<Double> xLabels = this.getValidLabels(this.getXLabels(minX[0], maxX[0], this.mRenderer.getXLabels()));
            Map<Integer, List<Double>> allYLabels = this.getYLabels(minY, maxY, maxScaleNumber);
            int xLabelsLeft = left;
            if (showLabels) {
                paint.setColor(this.mRenderer.getXLabelsColor());
                paint.setTextSize(this.mRenderer.getLabelsTextSize());
                paint.setTextAlign(this.mRenderer.getXLabelsAlign());
            }
            this.drawXLabels(xLabels, this.mRenderer.getXTextLabelLocations(), canvas, paint, xLabelsLeft, top, bottom, xPixelsPerUnit[0], minX[0], maxX[0]);
            this.drawYLabels(allYLabels, canvas, paint, maxScaleNumber, left, right, bottom, yPixelsPerUnit, minY);
            if (showLabels) {
                paint.setColor(this.mRenderer.getLabelsColor());
                for (int i6 = 0; i6 < maxScaleNumber; ++i6) {
                    Double[] yTextLabelLocations;
                    int axisAlign = this.mRenderer.getYAxisAlign(i6);
                    for (Double location : yTextLabelLocations = this.mRenderer.getYTextLabelLocations(i6)) {
                        if (!(minY[i6] <= location) || !(location <= maxY[i6])) continue;
                        float yLabel = (float)((double)bottom - yPixelsPerUnit[i6] * (location - minY[i6]));
                        String label = this.mRenderer.getYTextLabel(location, i6);
                        paint.setColor(this.mRenderer.getYLabelsColor(i6));
                        paint.setTextAlign(this.mRenderer.getYLabelsAlign(i6));
                        if (or == XYMultipleSeriesRenderer.Orientation.HORIZONTAL) {
                            if (axisAlign == 1) {
                                if (showTickMarks) {
                                    canvas.drawLine(left + this.getLabelLinePos(axisAlign), yLabel, left, yLabel, paint);
                                }
                                this.drawText(canvas, label, (float)left - this.mRenderer.getYLabelsPadding(), yLabel - this.mRenderer.getYLabelsVerticalPadding(), paint, this.mRenderer.getYLabelsAngle());
                            } else {
                                if (showTickMarks) {
                                    canvas.drawLine(right, yLabel, right + this.getLabelLinePos(axisAlign), yLabel, paint);
                                }
                                this.drawText(canvas, label, (float)right - this.mRenderer.getYLabelsPadding(), yLabel - this.mRenderer.getYLabelsVerticalPadding(), paint, this.mRenderer.getYLabelsAngle());
                            }
                            if (!showCustomTextGridY) continue;
                            paint.setColor(this.mRenderer.getGridColor(i6));
                            canvas.drawLine(left, yLabel, right, yLabel, paint);
                            continue;
                        }
                        if (showTickMarks) {
                            canvas.drawLine(right - this.getLabelLinePos(axisAlign), yLabel, right, yLabel, paint);
                        }
                        this.drawText(canvas, label, right + 10, yLabel - this.mRenderer.getYLabelsVerticalPadding(), paint, this.mRenderer.getYLabelsAngle());
                        if (!showCustomTextGridY) continue;
                        paint.setColor(this.mRenderer.getGridColor(i6));
                        canvas.drawLine(right, yLabel, left, yLabel, paint);
                    }
                }
            }
            if (showLabels) {
                paint.setColor(this.mRenderer.getLabelsColor());
                float size = this.mRenderer.getAxisTitleTextSize();
                paint.setTextSize(size);
                paint.setTextAlign(4);
                if (or == XYMultipleSeriesRenderer.Orientation.HORIZONTAL) {
                    this.drawText(canvas, this.mRenderer.getXTitle(), x + width / 2, (float)bottom + this.mRenderer.getLabelsTextSize() * 4.0f / 3.0f + this.mRenderer.getXLabelsPadding() + size, paint, 0.0f);
                    for (int i7 = 0; i7 < maxScaleNumber; ++i7) {
                        int axisAlign = this.mRenderer.getYAxisAlign(i7);
                        if (axisAlign == 1) {
                            this.drawText(canvas, this.mRenderer.getYTitle(i7), (float)x + size, y + height / 2, paint, -90.0f);
                            continue;
                        }
                        this.drawText(canvas, this.mRenderer.getYTitle(i7), x + width, y + height / 2, paint, -90.0f);
                    }
                    paint.setTextSize(this.mRenderer.getChartTitleTextSize());
                    this.drawText(canvas, this.mRenderer.getChartTitle(), x + width / 2, (float)y + this.mRenderer.getChartTitleTextSize(), paint, 0.0f);
                } else if (or == XYMultipleSeriesRenderer.Orientation.VERTICAL) {
                    this.drawText(canvas, this.mRenderer.getXTitle(), x + width / 2, (float)(y + height) - size + this.mRenderer.getXLabelsPadding(), paint, -90.0f);
                    this.drawText(canvas, this.mRenderer.getYTitle(), right + 20, y + height / 2, paint, 0.0f);
                    paint.setTextSize(this.mRenderer.getChartTitleTextSize());
                    this.drawText(canvas, this.mRenderer.getChartTitle(), (float)x + size, top + height / 2, paint, 0.0f);
                }
            }
        }
        if (or == XYMultipleSeriesRenderer.Orientation.HORIZONTAL) {
            this.drawLegend(canvas, this.mRenderer, titles, left, right, y + (int)this.mRenderer.getXLabelsPadding(), width, height, legendSize, paint, false);
        } else if (or == XYMultipleSeriesRenderer.Orientation.VERTICAL) {
            this.transform(canvas, angle, true);
            this.drawLegend(canvas, this.mRenderer, titles, left, right, y + (int)this.mRenderer.getXLabelsPadding(), width, height, legendSize, paint, false);
            this.transform(canvas, angle, false);
        }
        if (this.mRenderer.isShowAxes()) {
            paint.setColor(this.mRenderer.getXAxisColor());
            canvas.drawLine(left, bottom, right, bottom, paint);
            paint.setColor(this.mRenderer.getYAxisColor());
            boolean rightAxis = false;
            for (int i8 = 0; i8 < maxScaleNumber && !rightAxis; ++i8) {
                rightAxis = this.mRenderer.getYAxisAlign(i8) == 3;
            }
            if (or == XYMultipleSeriesRenderer.Orientation.HORIZONTAL) {
                canvas.drawLine(left, top, left, bottom, paint);
                if (rightAxis) {
                    canvas.drawLine(right, top, right, bottom, paint);
                }
            } else if (or == XYMultipleSeriesRenderer.Orientation.VERTICAL) {
                canvas.drawLine(right, top, right, bottom, paint);
            }
        }
        if (rotate) {
            this.transform(canvas, angle, true);
        }
    }

    protected List<Double> getXLabels(double min, double max, int count) {
        return MathHelper.getLabels(min, max, count);
    }

    protected Map<Integer, List<Double>> getYLabels(double[] minY, double[] maxY, int maxScaleNumber) {
        HashMap<Integer, List<Double>> allYLabels = new HashMap<Integer, List<Double>>();
        for (int i = 0; i < maxScaleNumber; ++i) {
            allYLabels.put(i, this.getValidLabels(MathHelper.getLabels(minY[i], maxY[i], this.mRenderer.getYLabels())));
        }
        return allYLabels;
    }

    protected Rectangle getScreenR() {
        return this.mScreenR;
    }

    protected void setScreenR(Rectangle screenR) {
        this.mScreenR = screenR;
    }

    private List<Double> getValidLabels(List<Double> labels) {
        ArrayList<Double> result = new ArrayList<Double>(labels);
        for (Double label : labels) {
            if (!label.isNaN()) continue;
            result.remove(label);
        }
        return result;
    }

    protected void drawSeries(XYSeries series, Canvas canvas, Paint paint, List<Float> pointsList, XYSeriesRenderer seriesRenderer, float yAxisValue, int seriesIndex, XYMultipleSeriesRenderer.Orientation or, int startIndex) {
        BasicStroke stroke = seriesRenderer.getStroke();
        int cap = paint.getStrokeCap();
        int join = paint.getStrokeJoin();
        float miter = paint.getStrokeMiter();
        Paint.Style style = paint.getStyle();
        if (stroke != null) {
            this.setStroke(stroke.getCap(), stroke.getJoin(), stroke.getMiter(), Paint.Style.FILL_AND_STROKE, paint);
        }
        this.drawSeries(canvas, paint, pointsList, seriesRenderer, yAxisValue, seriesIndex, startIndex);
        this.drawPoints(canvas, paint, pointsList, seriesRenderer, yAxisValue, seriesIndex, startIndex);
        paint.setTextSize(seriesRenderer.getChartValuesTextSize());
        if (or == XYMultipleSeriesRenderer.Orientation.HORIZONTAL) {
            paint.setTextAlign(4);
        } else {
            paint.setTextAlign(1);
        }
        if (seriesRenderer.isDisplayChartValues()) {
            paint.setTextAlign(seriesRenderer.getChartValuesTextAlign());
            this.drawChartValuesText(canvas, series, seriesRenderer, paint, pointsList, seriesIndex, startIndex);
        }
        if (stroke != null) {
            this.setStroke(cap, join, miter, style, paint);
        }
    }

    protected void drawPoints(Canvas canvas, Paint paint, List<Float> pointsList, XYSeriesRenderer seriesRenderer, float yAxisValue, int seriesIndex, int startIndex) {
        ScatterChart pointsChart;
        if (this.isRenderPoints(seriesRenderer) && (pointsChart = this.getPointsChart()) != null) {
            pointsChart.drawSeries(canvas, paint, pointsList, seriesRenderer, yAxisValue, seriesIndex, startIndex);
        }
    }

    private void setStroke(int cap, int join, float miter, Paint.Style style, Paint paint) {
        paint.setStrokeCap(cap);
        paint.setStrokeJoin(join);
        paint.setStrokeMiter(miter);
        paint.setStyle(style);
    }

    protected void drawChartValuesText(Canvas canvas, XYSeries series, XYSeriesRenderer renderer, Paint paint, List<Float> points, int seriesIndex, int startIndex) {
        if (points.size() > 2) {
            float previousPointX = points.get(0).floatValue();
            float previousPointY = points.get(1).floatValue();
            for (int k = 0; k < points.size(); k += 2) {
                if (k == 2 && (Math.abs(points.get(2).floatValue() - points.get(0).floatValue()) > (float)renderer.getDisplayChartValuesDistance() || Math.abs(points.get(3).floatValue() - points.get(1).floatValue()) > (float)renderer.getDisplayChartValuesDistance())) {
                    this.drawText(canvas, this.getLabel(renderer.getChartValuesFormat(), series.getY(startIndex)), points.get(0).floatValue(), points.get(1).floatValue() - renderer.getChartValuesSpacing(), paint, 0.0f);
                    this.drawText(canvas, this.getLabel(renderer.getChartValuesFormat(), series.getY(startIndex + 1)), points.get(2).floatValue(), points.get(3).floatValue() - renderer.getChartValuesSpacing(), paint, 0.0f);
                    previousPointX = points.get(2).floatValue();
                    previousPointY = points.get(3).floatValue();
                    continue;
                }
                if (k <= 2 || !(Math.abs(points.get(k).floatValue() - previousPointX) > (float)renderer.getDisplayChartValuesDistance()) && !(Math.abs(points.get(k + 1).floatValue() - previousPointY) > (float)renderer.getDisplayChartValuesDistance())) continue;
                this.drawText(canvas, this.getLabel(renderer.getChartValuesFormat(), series.getY(startIndex + k / 2)), points.get(k).floatValue(), points.get(k + 1).floatValue() - renderer.getChartValuesSpacing(), paint, 0.0f);
                previousPointX = points.get(k).floatValue();
                previousPointY = points.get(k + 1).floatValue();
            }
        } else {
            for (int k = 0; k < points.size(); k += 2) {
                this.drawText(canvas, this.getLabel(renderer.getChartValuesFormat(), series.getY(startIndex + k / 2)), points.get(k).floatValue(), points.get(k + 1).floatValue() - renderer.getChartValuesSpacing(), paint, 0.0f);
            }
        }
    }

    protected void drawText(Canvas canvas, String text, float x, float y, Paint paint, float extraAngle) {
        float angle = (float)(-this.mRenderer.getOrientation().getAngle()) + extraAngle;
        if (angle != 0.0f) {
            canvas.rotate(angle, x, y);
        }
        this.drawString(canvas, text, x, y, paint);
        if (angle != 0.0f) {
            canvas.rotate(-angle, x, y);
        }
    }

    private void transform(Canvas canvas, float angle, boolean inverse) {
        if (inverse) {
            canvas.scale(1.0f / this.mScale, this.mScale);
            canvas.translate(this.mTranslate, -this.mTranslate);
            canvas.rotate(-angle, this.mCenter.getX(), this.mCenter.getY());
        } else {
            canvas.rotate(angle, this.mCenter.getX(), this.mCenter.getY());
            canvas.translate(-this.mTranslate, this.mTranslate);
            canvas.scale(this.mScale, 1.0f / this.mScale);
        }
    }

    protected void drawXLabels(List<Double> xLabels, Double[] xTextLabelLocations, Canvas canvas, Paint paint, int left, int top, int bottom, double xPixelsPerUnit, double minX, double maxX) {
        int length = xLabels.size();
        boolean showLabels = this.mRenderer.isShowLabels();
        boolean showGridY = this.mRenderer.isShowGridY();
        boolean showTickMarks = this.mRenderer.isShowTickMarks();
        for (int i = 0; i < length; ++i) {
            double label = xLabels.get(i);
            float xLabel = (float)((double)left + xPixelsPerUnit * (label - minX));
            if (showLabels) {
                paint.setColor(this.mRenderer.getXLabelsColor());
                if (showTickMarks) {
                    canvas.drawLine(xLabel, bottom, xLabel, (float)bottom + this.mRenderer.getLabelsTextSize() / 3.0f, paint);
                }
                this.drawText(canvas, this.getLabel(this.mRenderer.getXLabelFormat(), label), xLabel, (float)bottom + this.mRenderer.getLabelsTextSize() * 4.0f / 3.0f + this.mRenderer.getXLabelsPadding(), paint, this.mRenderer.getXLabelsAngle());
            }
            if (!showGridY) continue;
            paint.setColor(this.mRenderer.getGridColor(0));
            canvas.drawLine(xLabel, bottom, xLabel, top, paint);
        }
        this.drawXTextLabels(xTextLabelLocations, canvas, paint, showLabels, left, top, bottom, xPixelsPerUnit, minX, maxX);
    }

    protected void drawYLabels(Map<Integer, List<Double>> allYLabels, Canvas canvas, Paint paint, int maxScaleNumber, int left, int right, int bottom, double[] yPixelsPerUnit, double[] minY) {
        XYMultipleSeriesRenderer.Orientation or = this.mRenderer.getOrientation();
        boolean showGridX = this.mRenderer.isShowGridX();
        boolean showLabels = this.mRenderer.isShowLabels();
        boolean showTickMarks = this.mRenderer.isShowTickMarks();
        paint.setTextSize(this.mRenderer.getLabelsTextSize());
        for (int i = 0; i < maxScaleNumber; ++i) {
            paint.setTextAlign(this.mRenderer.getYLabelsAlign(i));
            List<Double> yLabels = allYLabels.get(i);
            int length = yLabels.size();
            for (int j = 0; j < length; ++j) {
                double label = yLabels.get(j);
                int axisAlign = this.mRenderer.getYAxisAlign(i);
                boolean textLabel = this.mRenderer.getYTextLabel(label, i) != null;
                float yLabel = (float)((double)bottom - yPixelsPerUnit[i] * (label - minY[i]));
                if (or == XYMultipleSeriesRenderer.Orientation.HORIZONTAL) {
                    if (showLabels && !textLabel) {
                        paint.setColor(this.mRenderer.getYLabelsColor(i));
                        if (axisAlign == 1) {
                            if (showTickMarks) {
                                canvas.drawLine(left + this.getLabelLinePos(axisAlign), yLabel, left, yLabel, paint);
                            }
                            this.drawText(canvas, this.getLabel(this.mRenderer.getYLabelFormat(i), label), (float)left - this.mRenderer.getYLabelsPadding(), yLabel - this.mRenderer.getYLabelsVerticalPadding(), paint, this.mRenderer.getYLabelsAngle());
                        } else {
                            if (showTickMarks) {
                                canvas.drawLine(right, yLabel, right + this.getLabelLinePos(axisAlign), yLabel, paint);
                            }
                            this.drawText(canvas, this.getLabel(this.mRenderer.getYLabelFormat(i), label), (float)right + this.mRenderer.getYLabelsPadding(), yLabel - this.mRenderer.getYLabelsVerticalPadding(), paint, this.mRenderer.getYLabelsAngle());
                        }
                    }
                    if (!showGridX) continue;
                    paint.setColor(this.mRenderer.getGridColor(i));
                    canvas.drawLine(left, yLabel, right, yLabel, paint);
                    continue;
                }
                if (or != XYMultipleSeriesRenderer.Orientation.VERTICAL) continue;
                if (showLabels && !textLabel) {
                    paint.setColor(this.mRenderer.getYLabelsColor(i));
                    if (showTickMarks) {
                        canvas.drawLine(right - this.getLabelLinePos(axisAlign), yLabel, right, yLabel, paint);
                    }
                    this.drawText(canvas, this.getLabel(this.mRenderer.getLabelFormat(), label), (float)(right + 10) + this.mRenderer.getYLabelsPadding(), yLabel - this.mRenderer.getYLabelsVerticalPadding(), paint, this.mRenderer.getYLabelsAngle());
                }
                if (!showGridX) continue;
                paint.setColor(this.mRenderer.getGridColor(i));
                if (!showTickMarks) continue;
                canvas.drawLine(right, yLabel, left, yLabel, paint);
            }
        }
    }

    protected void drawXTextLabels(Double[] xTextLabelLocations, Canvas canvas, Paint paint, boolean showLabels, int left, int top, int bottom, double xPixelsPerUnit, double minX, double maxX) {
        boolean showCustomTextGridX = this.mRenderer.isShowCustomTextGridX();
        boolean showTickMarks = this.mRenderer.isShowTickMarks();
        if (showLabels) {
            paint.setColor(this.mRenderer.getXLabelsColor());
            for (Double location : xTextLabelLocations) {
                if (!(minX <= location) || !(location <= maxX)) continue;
                float xLabel = (float)((double)left + xPixelsPerUnit * (location - minX));
                paint.setColor(this.mRenderer.getXLabelsColor());
                if (showTickMarks) {
                    canvas.drawLine(xLabel, bottom, xLabel, (float)bottom + this.mRenderer.getLabelsTextSize() / 3.0f, paint);
                }
                this.drawText(canvas, this.mRenderer.getXTextLabel(location), xLabel, (float)bottom + this.mRenderer.getLabelsTextSize() * 4.0f / 3.0f + this.mRenderer.getXLabelsPadding(), paint, this.mRenderer.getXLabelsAngle());
                if (!showCustomTextGridX) continue;
                paint.setColor(this.mRenderer.getGridColor(0));
                canvas.drawLine(xLabel, bottom, xLabel, top, paint);
            }
        }
    }

    public XYMultipleSeriesRenderer getRenderer() {
        return this.mRenderer;
    }

    public XYMultipleSeriesDataset getDataset() {
        return this.mDataset;
    }

    public double[] getCalcRange(int scale) {
        return this.mCalcRange.get(scale);
    }

    public void setCalcRange(double[] range, int scale) {
        this.mCalcRange.put(scale, range);
    }

    public double[] toRealPoint(float screenX, float screenY) {
        return this.toRealPoint(screenX, screenY, 0);
    }

    public double[] toScreenPoint(double[] realPoint) {
        return this.toScreenPoint(realPoint, 0);
    }

    private int getLabelLinePos(int align) {
        int pos = 4;
        if (align == 1) {
            pos = -pos;
        }
        return pos;
    }

    public double[] toRealPoint(float screenX, float screenY, int scale) {
        double[] calcRange;
        double realMinX = this.mRenderer.getXAxisMin(scale);
        double realMaxX = this.mRenderer.getXAxisMax(scale);
        double realMinY = this.mRenderer.getYAxisMin(scale);
        double realMaxY = this.mRenderer.getYAxisMax(scale);
        if (!(this.mRenderer.isMinXSet(scale) && this.mRenderer.isMaxXSet(scale) && this.mRenderer.isMinYSet(scale) && this.mRenderer.isMaxYSet(scale) || (calcRange = this.getCalcRange(scale)) == null)) {
            realMinX = calcRange[0];
            realMaxX = calcRange[1];
            realMinY = calcRange[2];
            realMaxY = calcRange[3];
        }
        if (this.mScreenR != null) {
            return new double[]{(double)(screenX - (float)this.mScreenR.getX()) * (realMaxX - realMinX) / (double)this.mScreenR.getWidth() + realMinX, (double)((float)(this.mScreenR.getY() + this.mScreenR.getHeight()) - screenY) * (realMaxY - realMinY) / (double)this.mScreenR.getHeight() + realMinY};
        }
        return new double[]{screenX, screenY};
    }

    public double[] toScreenPoint(double[] realPoint, int scale) {
        double realMinX = this.mRenderer.getXAxisMin(scale);
        double realMaxX = this.mRenderer.getXAxisMax(scale);
        double realMinY = this.mRenderer.getYAxisMin(scale);
        double realMaxY = this.mRenderer.getYAxisMax(scale);
        if (!(this.mRenderer.isMinXSet(scale) && this.mRenderer.isMaxXSet(scale) && this.mRenderer.isMinYSet(scale) && this.mRenderer.isMaxYSet(scale))) {
            double[] calcRange = this.getCalcRange(scale);
            realMinX = calcRange[0];
            realMaxX = calcRange[1];
            realMinY = calcRange[2];
            realMaxY = calcRange[3];
        }
        if (this.mScreenR != null) {
            return new double[]{(realPoint[0] - realMinX) * (double)this.mScreenR.getWidth() / (realMaxX - realMinX) + (double)this.mScreenR.getX(), (realMaxY - realPoint[1]) * (double)this.mScreenR.getHeight() / (realMaxY - realMinY) + (double)this.mScreenR.getY()};
        }
        return realPoint;
    }

    @Override
    public SeriesSelection getSeriesAndPointForScreenCoordinate(Point screenPoint) {
        if (this.clickableAreas != null) {
            for (int seriesIndex = this.clickableAreas.size() - 1; seriesIndex >= 0; --seriesIndex) {
                int pointIndex = 0;
                if (this.clickableAreas.get(seriesIndex) == null) continue;
                for (ClickableArea area : this.clickableAreas.get(seriesIndex)) {
                    Rectangle2D rectangle;
                    if (area != null && (rectangle = area.getRect()) != null && rectangle.contains(screenPoint.getX(), screenPoint.getY())) {
                        return new SeriesSelection(seriesIndex, pointIndex, area.getX(), area.getY());
                    }
                    ++pointIndex;
                }
            }
        }
        return super.getSeriesAndPointForScreenCoordinate(screenPoint);
    }

    public abstract void drawSeries(Canvas var1, Paint var2, List<Float> var3, XYSeriesRenderer var4, float var5, int var6, int var7);

    protected abstract ClickableArea[] clickableAreasForPoints(List<Float> var1, List<Double> var2, float var3, int var4, int var5);

    protected boolean isRenderNullValues() {
        return false;
    }

    public boolean isRenderPoints(SimpleSeriesRenderer renderer) {
        return false;
    }

    public double getDefaultMinimum() {
        return -1.7976931348623157E308;
    }

    public ScatterChart getPointsChart() {
        return null;
    }

    public abstract String getChartType();
}

