/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.components;

import com.codename1.io.FileSystemStorage;
import com.codename1.io.Log;
import com.codename1.io.Util;
import com.codename1.ui.EncodedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileEncodedImage
extends EncodedImage {
    private final String fileName;
    private final boolean keep;
    private byte[] data;

    private FileEncodedImage(String fileName, int w, int h, boolean keep) {
        super(w, h);
        this.fileName = fileName;
        this.keep = keep;
    }

    public static FileEncodedImage create(String fileName, int width, int height) {
        return new FileEncodedImage(fileName, width, height, true);
    }

    public static FileEncodedImage create(String fileName, InputStream i, int width, int height) throws IOException {
        EncodedImage e = EncodedImage.create(i);
        FileEncodedImage f = new FileEncodedImage(fileName, width, height, true);
        f.data = e.getImageData();
        OutputStream o = FileSystemStorage.getInstance().openOutputStream(fileName);
        o.write(f.data);
        o.close();
        return f;
    }

    public static FileEncodedImage create(String fileName, int width, int height, boolean keep) {
        return new FileEncodedImage(fileName, width, height, keep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getImageData() {
        byte[] byArray;
        if (this.data != null) {
            return this.data;
        }
        InputStream i = null;
        try {
            byte[] imageData = new byte[(int)FileSystemStorage.getInstance().getLength(this.fileName)];
            i = FileSystemStorage.getInstance().openInputStream(this.fileName);
            Util.readFully(i, imageData);
            if (this.keep) {
                this.data = imageData;
            }
            byArray = imageData;
            Object var5_6 = null;
        }
        catch (IOException ex) {
            byte[] byArray2;
            try {
                Log.e(ex);
                byArray2 = null;
                Object var5_7 = null;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                Util.cleanup(i);
                throw throwable;
            }
            Util.cleanup(i);
            return byArray2;
        }
        Util.cleanup(i);
        return byArray;
    }
}

