/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.components;

import com.codename1.io.FileSystemStorage;
import com.codename1.io.Log;
import com.codename1.ui.tree.TreeModel;
import java.util.Vector;

public class FileTreeModel
implements TreeModel {
    private final boolean showFiles;
    private Vector ext;

    public FileTreeModel(boolean showFiles) {
        this.showFiles = showFiles;
    }

    public void addExtensionFilter(String extension) {
        if (this.ext == null) {
            this.ext = new Vector();
        }
        this.ext.addElement(extension);
    }

    public Vector getChildren(Object parent) {
        Vector<String> response = new Vector<String>();
        try {
            if (parent == null) {
                String[] roots = FileSystemStorage.getInstance().getRoots();
                for (int iter = 0; iter < roots.length; ++iter) {
                    response.addElement(roots[iter]);
                }
            } else {
                String[] res;
                String name = (String)parent;
                if (!name.endsWith("/")) {
                    name = name + "/";
                }
                if ((res = FileSystemStorage.getInstance().listFiles(name)) != null) {
                    if (this.showFiles) {
                        for (int iter = 0; iter < res.length; ++iter) {
                            String f = res[iter];
                            if (!FileSystemStorage.getInstance().isDirectory(name + f) && this.ext != null) {
                                String e;
                                int i = f.lastIndexOf(46);
                                if (i <= 0 || !this.ext.contains(e = f.substring(i + 1))) continue;
                                response.addElement(name + f);
                                continue;
                            }
                            response.addElement(name + f);
                        }
                    } else {
                        for (int iter = 0; iter < res.length; ++iter) {
                            if (!FileSystemStorage.getInstance().isDirectory(name + res[iter])) continue;
                            response.addElement(name + res[iter]);
                        }
                    }
                }
            }
        }
        catch (Throwable err) {
            Log.e(err);
            return new Vector();
        }
        return response;
    }

    public boolean isLeaf(Object node) {
        return !FileSystemStorage.getInstance().isDirectory((String)node);
    }
}

