/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.components;

import com.codename1.impl.CodenameOneImplementation;
import com.codename1.ui.Component;
import com.codename1.ui.ComponentSelector;
import com.codename1.ui.Display;
import com.codename1.ui.Form;
import com.codename1.ui.Graphics;
import com.codename1.ui.Image;
import com.codename1.ui.ImageFactory;
import com.codename1.ui.animations.Animation;
import com.codename1.ui.animations.Motion;
import com.codename1.ui.events.DataChangedListener;
import com.codename1.ui.events.SelectionListener;
import com.codename1.ui.geom.Dimension;
import com.codename1.ui.list.DefaultListModel;
import com.codename1.ui.list.ListModel;
import com.codename1.ui.plaf.Style;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageViewer
extends Component {
    public static final int IMAGE_FIT = 0;
    public static final int IMAGE_FILL = 1;
    private static final int MIN_ZOOM = 1;
    private static final int MAX_ZOOM = 10;
    private final CropBox cropBox = new CropBox();
    private float zoom = 1.0f;
    private float currentZoom = 1.0f;
    private Image image;
    private int imageX;
    private int imageY;
    private int imageDrawWidth;
    private int imageDrawHeight;
    private float panPositionX = 0.5f;
    private float panPositionY = 0.5f;
    private int pressX;
    private int pressY;
    private ListModel<Image> swipeableImages;
    private DataChangedListener listListener;
    private Image swipePlaceholder;
    private float swipeThreshold = 0.4f;
    private int imageInitialPosition = 0;
    private Motion motion;
    private boolean zooming = false;
    private boolean animateZoom = true;
    private boolean allowScaleDown;
    private int prefX;
    private int prefY;
    private int prefW;
    private int prefH;
    private boolean eagerLock = true;
    private boolean selectLock;
    private boolean cycleLeft = true;
    private boolean cycleRight = true;
    private boolean isPinchZooming;

    public ImageViewer() {
        this.setFocusable(true);
        this.setUIID("ImageViewer");
        ComponentSelector.$(this).selectAllStyles().setBgTransparency(0);
    }

    public ImageViewer(Image i) {
        this();
        this.setImage(i);
    }

    @Override
    protected void resetFocusable() {
        this.setFocusable(true);
    }

    @Override
    public String[] getPropertyNames() {
        return new String[]{"eagerLock", "image", "imageList", "swipePlaceholder"};
    }

    @Override
    protected boolean shouldBlockSideSwipe() {
        return true;
    }

    @Override
    public Class[] getPropertyTypes() {
        return new Class[]{Boolean.class, Image.class, CodenameOneImplementation.getImageArrayClass(), Image.class};
    }

    @Override
    public String[] getPropertyTypeNames() {
        return new String[]{"Boolean", "Image", "Image[]", "Image"};
    }

    @Override
    public Object getPropertyValue(String name) {
        if (name.equals("eagerLock")) {
            if (this.isEagerLock()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (name.equals("image")) {
            return this.getImage();
        }
        if (name.equals("imageList")) {
            if (this.getImageList() == null) {
                return null;
            }
            Image[] a = new Image[this.getImageList().getSize()];
            int alen = a.length;
            for (int iter = 0; iter < alen; ++iter) {
                a[iter] = this.getImageList().getItemAt(iter);
            }
            return a;
        }
        if (name.equals("swipePlaceholder")) {
            return this.getSwipePlaceholder();
        }
        return null;
    }

    @Override
    public String setPropertyValue(String name, Object value) {
        if (name.equals("eagerLock")) {
            this.setEagerLock(value != null && (Boolean)value != false);
            return null;
        }
        if (name.equals("image")) {
            this.setImage((Image)value);
            return null;
        }
        if (name.equals("imageList")) {
            if (value == null) {
                this.setImageList(null);
            } else {
                this.setImageList(new DefaultListModel<Image>((Image[])value));
            }
            return null;
        }
        if (name.equals("swipePlaceholder")) {
            this.setSwipePlaceholder((Image)value);
            return null;
        }
        return super.setPropertyValue(name, value);
    }

    @Override
    public void initComponent() {
        super.initComponent();
        if (this.image == null) {
            this.image = ImageFactory.createImage(this, 50, 50, 0);
        } else {
            this.image.lock();
        }
        if (this.image.isAnimation()) {
            this.getComponentForm().registerAnimated(this);
        }
        this.eagerLock();
    }

    private void eagerLock() {
        if (this.eagerLock && this.swipeableImages != null && this.swipeableImages.getSize() > 1) {
            Image left = this.getImageLeft();
            if (this.swipePlaceholder != null) {
                left.asyncLock(this.swipePlaceholder);
            } else {
                left.lock();
            }
            if (this.swipeableImages.getSize() > 2) {
                Image right = this.getImageRight();
                if (this.swipePlaceholder != null) {
                    right.asyncLock(this.swipePlaceholder);
                } else {
                    right.lock();
                }
            }
        }
    }

    private void eagerUnlock() {
        if (this.eagerLock && this.swipeableImages != null && this.swipeableImages.getSize() > 1) {
            this.getImageLeft().unlock();
            this.getImageRight().unlock();
        }
    }

    public int getImageX() {
        return this.imageX;
    }

    public int getImageY() {
        return this.imageY;
    }

    @Override
    public void deinitialize() {
        super.deinitialize();
        this.image.unlock();
        this.eagerUnlock();
    }

    @Override
    public void keyReleased(int key) {
        if (this.swipeableImages != null) {
            int gk = Display.getInstance().getGameAction(key);
            if (!(gk != 2 && gk != 1 || !this.cycleLeft && this.swipeableImages.getSelectedIndex() <= this.getImageLeftPos())) {
                new AnimatePanX(-1.0f, this.getImageLeft(), this.getImageLeftPos());
                return;
            }
            if (gk == 5 || gk == 5 && (this.cycleRight || this.swipeableImages.getSelectedIndex() < this.getImageRightPos())) {
                new AnimatePanX(2.0f, this.getImageRight(), this.getImageRightPos());
            }
        }
    }

    @Override
    public void pointerPressed(int x, int y) {
        this.pressX = x;
        this.pressY = y;
        this.currentZoom = this.zoom;
        this.getComponentForm().addComponentAwaitingRelease(this);
    }

    @Override
    protected void dragFinished(int x, int y) {
        super.dragFinished(x, y);
    }

    private Image getImageRight() {
        return this.swipeableImages.getItemAt(this.getImageRightPos());
    }

    private int getImageRightPos() {
        return (this.swipeableImages.getSelectedIndex() + 1) % this.swipeableImages.getSize();
    }

    private int getImageLeftPos() {
        int pos = this.swipeableImages.getSelectedIndex() - 1;
        if (pos < 0) {
            return this.swipeableImages.getSize() - 1;
        }
        return pos;
    }

    private Image getImageLeft() {
        return this.swipeableImages.getItemAt(this.getImageLeftPos());
    }

    @Override
    public void pointerReleased(int x, int y) {
        super.pointerReleased(x, y);
        this.isPinchZooming = false;
        if (this.panPositionX > 1.0f) {
            if (this.panPositionX >= 1.0f + this.swipeThreshold && (this.cycleRight || this.swipeableImages.getSelectedIndex() < this.getImageRightPos())) {
                new AnimatePanX(2.0f, this.getImageRight(), this.getImageRightPos());
            } else {
                new AnimatePanX(1.0f, null, 0);
            }
            return;
        }
        if (this.panPositionX < 0.0f) {
            if (this.panPositionX <= this.swipeThreshold * -1.0f && (this.cycleLeft || this.swipeableImages.getSelectedIndex() > this.getImageLeftPos())) {
                new AnimatePanX(-1.0f, this.getImageLeft(), this.getImageLeftPos());
            } else {
                new AnimatePanX(0.0f, null, 0);
            }
        }
    }

    @Override
    protected void pinchReleased(int x, int y) {
        this.pressX = x;
        this.pressY = y;
        this.currentZoom = this.zoom;
        this.isPinchZooming = false;
    }

    @Override
    public void pointerDragged(int x, int y) {
        float distanceX = ((float)this.pressX - (float)x) / this.getZoom();
        float distanceY = ((float)this.pressY - (float)y) / this.getZoom();
        distanceX /= (float)this.getWidth();
        distanceY /= (float)this.getHeight();
        if (this.getZoom() > 1.0f) {
            if (this.swipeableImages != null && this.swipeableImages.getSize() > 1) {
                if (this.panPositionX < 0.0f || this.panPositionX == 0.0f && distanceX < 0.0f) {
                    this.panPositionX = ((float)this.pressX - (float)x) / (float)this.getWidth();
                    this.repaint();
                    return;
                }
                if (this.panPositionX > 1.0f || this.panPositionX == 1.0f && distanceX > 0.0f) {
                    this.panPositionX = 1.0f + ((float)this.pressX - (float)x) / (float)this.getWidth();
                    this.repaint();
                    return;
                }
            }
            this.pressX = x;
            this.pressY = y;
            this.panPositionX += distanceX * this.getZoom();
            this.panPositionX = Math.min(1.0f, Math.max(0.0f, this.panPositionX));
            this.panPositionY = Math.min(1.0f, Math.max(0.0f, this.panPositionY + distanceY * this.getZoom()));
            this.updatePositions();
            this.repaint();
        } else if (this.swipeableImages != null && this.swipeableImages.getSize() > 1) {
            this.panPositionX = distanceX;
            if (this.panPositionX < 0.0f) {
                this.repaint();
            } else if (this.panPositionX > 0.0f) {
                this.panPositionX += 1.0f;
                this.repaint();
            }
        }
    }

    @Override
    protected void laidOut() {
        super.laidOut();
        this.updatePositions();
    }

    @Override
    protected boolean pinch(float scale) {
        this.isPinchZooming = true;
        this.zoom = this.currentZoom * scale;
        if (this.zoom < 1.0f) {
            this.zoom = 1.0f;
        } else if (this.zoom > 10.0f) {
            this.zoom = 10.0f;
        }
        this.updatePositions();
        this.repaint();
        return true;
    }

    private void imageAspectCalc(Image img) {
        if (img == null) {
            return;
        }
        int iW = img.getWidth();
        int iH = img.getHeight();
        Style s = this.getStyle();
        int width = this.getWidth() - s.getHorizontalPadding();
        int height = this.getHeight() - s.getVerticalPadding();
        float r2 = this.imageInitialPosition == 0 ? Math.min((float)width / (float)iW, (float)height / (float)iH) : Math.max((float)width / (float)iW, (float)height / (float)iH);
        this.prefW = (int)((float)iW * r2);
        this.prefH = (int)((float)iH * r2);
        this.prefX = s.getPaddingLeftNoRTL() + (width - this.prefW) / 2;
        this.prefY = s.getPaddingTop() + (height - this.prefH) / 2;
    }

    private void updatePositions() {
        if (this.zoom == 1.0f) {
            this.imageAspectCalc(this.image);
            this.imageDrawWidth = this.prefW;
            this.imageDrawHeight = this.prefH;
            this.imageX = this.prefX;
            this.imageY = this.prefY;
            int constrainedImageX = this.imageX;
            int constrainedImageY = this.imageY;
            if (this.imageDrawWidth > this.getInnerWidth()) {
                constrainedImageX = Math.max(Math.min(0, this.imageX), -this.imageDrawWidth + this.getInnerWidth());
            }
            if (this.imageDrawHeight > this.getInnerHeight()) {
                constrainedImageY = Math.max(Math.min(0, this.imageY), -this.imageDrawHeight + this.getInnerHeight());
            }
            this.cropBox.set((double)(-constrainedImageY) / (double)this.imageDrawHeight, (double)(constrainedImageX + this.imageDrawWidth - this.getWidth()) / (double)this.imageDrawWidth, (double)(constrainedImageY + this.imageDrawHeight - this.getHeight()) / (double)this.imageDrawHeight, (double)(-constrainedImageX) / (double)this.imageDrawWidth);
            return;
        }
        int iW = this.image.getWidth();
        int iH = this.image.getHeight();
        Style s = this.getStyle();
        int width = this.getWidth() - s.getHorizontalPadding();
        int height = this.getHeight() - s.getVerticalPadding();
        float r2 = this.allowScaleDown || this.imageInitialPosition == 0 ? Math.min((float)width / (float)iW, (float)height / (float)iH) : Math.max((float)width / (float)iW, (float)height / (float)iH);
        this.imageDrawWidth = (int)((float)iW * r2 * this.zoom);
        this.imageDrawHeight = (int)((float)iH * r2 * this.zoom);
        this.imageX = (int)((double)s.getPaddingLeftNoRTL() + (double)this.imageDrawWidth * (0.5 - (double)this.panPositionX));
        if (this.imageDrawWidth < this.getInnerWidth()) {
            this.imageX += (this.getInnerWidth() - this.imageDrawWidth) / 2;
        }
        this.imageY = (int)((double)s.getPaddingTop() + (double)this.imageDrawHeight * (0.5 - (double)this.panPositionY));
        if (this.imageDrawHeight < this.getInnerHeight()) {
            this.imageY += (this.getInnerHeight() - this.imageDrawHeight) / 2;
        }
        int constrainedImageX = this.imageX;
        int constrainedImageY = this.imageY;
        if (this.imageDrawWidth > this.getInnerWidth()) {
            constrainedImageX = Math.max(Math.min(0, this.imageX), -this.imageDrawWidth + this.getInnerWidth());
        }
        if (this.imageDrawHeight > this.getInnerHeight()) {
            constrainedImageY = Math.max(Math.min(0, this.imageY), -this.imageDrawHeight + this.getInnerHeight());
        }
        this.cropBox.set((double)(-constrainedImageY) / (double)this.imageDrawHeight, (double)(constrainedImageX + this.imageDrawWidth - this.getWidth()) / (double)this.imageDrawWidth, (double)(constrainedImageY + this.imageDrawHeight - this.getHeight()) / (double)this.imageDrawHeight, (double)(-constrainedImageX) / (double)this.imageDrawWidth);
    }

    public Image getCroppedImage(int backgroundColor) {
        if (this.image == null) {
            return null;
        }
        this.updatePositions();
        int width = (int)Math.round((double)(-this.image.getWidth()) * (this.cropBox.left + this.cropBox.right - 1.0));
        int height = (int)Math.round((double)(-this.image.getHeight()) * (this.cropBox.top + this.cropBox.bottom - 1.0));
        return this.getCroppedImage(width, height, backgroundColor);
    }

    public Image getCroppedImage(int width, int height, int backgroundColor) {
        if (this.image == null) {
            return null;
        }
        this.updatePositions();
        if (width < 0) {
            width = (int)Math.round((double)(height * this.getWidth()) / (double)this.getHeight());
        }
        if (height < 0) {
            height = (int)Math.round((double)(width * this.getHeight()) / (double)this.getWidth());
        }
        Image out = ImageFactory.createImage(this, width, height, backgroundColor);
        Graphics g = out.getGraphics();
        g.setColor(backgroundColor);
        g.fillRect(0, 0, width, height);
        this.cropBox.paint(g, width, height);
        return out;
    }

    @Override
    protected Dimension calcPreferredSize() {
        if (this.image != null) {
            return new Dimension(this.image.getWidth(), this.image.getHeight());
        }
        return new Dimension(Display.getInstance().getDisplayWidth(), Display.getInstance().getDisplayHeight());
    }

    @Override
    public boolean animate() {
        boolean result = false;
        if (this.image != null && this.image.isAnimation() && (result = this.image.animate())) {
            this.updatePositions();
        }
        if (this.zooming) {
            float v = this.motion.getValue();
            this.zoom = v /= 10000.0f;
            if (!result) {
                this.updatePositions();
            }
            if (this.motion.isFinished()) {
                this.zooming = false;
                if (!result) {
                    this.getComponentForm().deregisterAnimated(this);
                }
            }
            this.repaint();
        }
        return super.animate() || result;
    }

    public boolean isAllowScaleDown() {
        return this.allowScaleDown;
    }

    public void setAllowScaleDown(boolean allowScaleDown) {
        this.allowScaleDown = allowScaleDown;
    }

    @Override
    public void paint(Graphics g) {
        if (this.panPositionX < 0.0f) {
            Style s = this.getStyle();
            int width = this.getWidth() - s.getHorizontalPadding();
            float ratio = (float)width * (this.panPositionX * -1.0f);
            if (this.isPinchZooming) {
                g.setRenderingHints(1);
            }
            g.drawImage(this.image, (int)ratio + this.getX() + this.imageX, this.getY() + this.imageY, this.imageDrawWidth, this.imageDrawHeight);
            g.setRenderingHints(0);
            if (this.cycleLeft || this.swipeableImages.getSelectedIndex() > this.getImageLeftPos()) {
                Image left = this.getImageLeft();
                if (this.swipePlaceholder != null) {
                    left.asyncLock(this.swipePlaceholder);
                } else {
                    left.lock();
                }
                ratio -= (float)width;
                this.imageAspectCalc(left);
                if (this.isPinchZooming) {
                    g.setRenderingHints(1);
                }
                g.drawImage(left, (int)ratio + this.getX() + this.prefX, this.getY() + this.prefY, this.prefW, this.prefH);
                g.setRenderingHints(0);
            }
            return;
        }
        if (this.panPositionX > 1.0f) {
            Style s = this.getStyle();
            int width = this.getWidth() - s.getHorizontalPadding();
            float ratio = (float)width * (1.0f - this.panPositionX);
            if (this.isPinchZooming) {
                g.setRenderingHints(1);
            }
            g.drawImage(this.image, (int)ratio + this.getX() + this.imageX, this.getY() + this.imageY, this.imageDrawWidth, this.imageDrawHeight);
            g.setRenderingHints(0);
            if (this.cycleRight || this.swipeableImages.getSelectedIndex() < this.getImageRightPos()) {
                Image right = this.getImageRight();
                if (this.swipePlaceholder != null) {
                    right.asyncLock(this.swipePlaceholder);
                } else {
                    right.lock();
                }
                ratio += (float)width;
                this.imageAspectCalc(right);
                if (this.isPinchZooming) {
                    g.setRenderingHints(1);
                }
                g.drawImage(right, (int)ratio + this.getX() + this.prefX, this.getY() + this.prefY, this.prefW, this.prefH);
                g.setRenderingHints(0);
            }
            return;
        }
        if (this.image != null) {
            if (this.isPinchZooming) {
                g.setRenderingHints(1);
            }
            g.drawImage(this.image, this.imageDrawWidth <= this.getInnerWidth() ? this.getX() + this.imageX : Math.max(Math.min(this.getX(), this.getX() + this.imageX), this.getX() - this.imageDrawWidth + this.getInnerWidth()), this.imageDrawHeight <= this.getInnerHeight() ? this.getY() + this.imageY : Math.max(Math.min(this.getY(), this.getY() + this.imageY), this.getY() - this.imageDrawHeight + this.getInnerHeight()), this.imageDrawWidth, this.imageDrawHeight);
            g.setRenderingHints(0);
        }
    }

    @Override
    protected void paintBackground(Graphics g) {
        if (this.imageDrawWidth < this.getWidth() || this.imageDrawHeight < this.getHeight()) {
            super.paintBackground(g);
        }
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        if (this.image != image) {
            Form f;
            this.panPositionX = 0.5f;
            this.panPositionY = 0.5f;
            this.zoom = 1.0f;
            this.image = image;
            this.updatePositions();
            this.repaint();
            if (image.isAnimation() && (f = this.getComponentForm()) != null) {
                f.registerAnimated(this);
            }
        }
    }

    public void setImageNoReposition(Image image) {
        this.image = image;
        this.repaint();
    }

    public ListModel<Image> getImageList() {
        return this.swipeableImages;
    }

    public void setImageList(ListModel<Image> model) {
        if (model == null || model.getSize() == 0) {
            return;
        }
        if (this.image == null) {
            this.image = model.getItemAt(0);
        }
        if (this.swipeableImages != null) {
            this.swipeableImages.removeDataChangedListener(this.listListener);
            this.swipeableImages.removeSelectionListener((SelectionListener)((Object)this.listListener));
            model.addDataChangedListener(this.listListener);
            model.addSelectionListener((SelectionListener)((Object)this.listListener));
        } else {
            class Listener
            implements SelectionListener,
            DataChangedListener {
                Listener() {
                }

                public void selectionChanged(int oldSelected, int newSelected) {
                    if (ImageViewer.this.selectLock) {
                        return;
                    }
                    if (ImageViewer.this.swipeableImages.getSize() > 0 && newSelected > -1 && newSelected < ImageViewer.this.swipeableImages.getSize()) {
                        ImageViewer.this.setImage((Image)ImageViewer.this.swipeableImages.getItemAt(newSelected));
                    }
                }

                public void dataChanged(int type, int index) {
                    if (ImageViewer.this.swipeableImages.getSize() > 0 && ImageViewer.this.swipeableImages.getSelectedIndex() > -1 && ImageViewer.this.swipeableImages.getSelectedIndex() < ImageViewer.this.swipeableImages.getSize()) {
                        ImageViewer.this.setImage((Image)ImageViewer.this.swipeableImages.getItemAt(ImageViewer.this.swipeableImages.getSelectedIndex()));
                    }
                }
            }
            this.listListener = new Listener();
            model.addDataChangedListener(this.listListener);
            model.addSelectionListener((SelectionListener)((Object)this.listListener));
        }
        this.swipeableImages = model;
    }

    public void setAnimateZoom(boolean animateZoom) {
        this.animateZoom = animateZoom;
    }

    public boolean isAnimatedZoom() {
        return this.animateZoom;
    }

    public float getZoom() {
        return this.zoom;
    }

    public void setZoom(float zoom) {
        if (this.animateZoom) {
            this.zooming = true;
            float initZoom = this.zoom;
            this.motion = Motion.createEaseInOutMotion((int)(initZoom * 10000.0f), (int)(zoom * 10000.0f), 200);
            this.motion.start();
            this.getComponentForm().registerAnimated(this);
        } else {
            this.zoom = zoom;
            this.updatePositions();
            this.repaint();
        }
    }

    public void setZoom(float zoom, float panPositionX, float panPositionY) {
        if (panPositionX > 1.0f) {
            panPositionX = 1.0f;
        }
        if (panPositionX < 0.0f) {
            panPositionX = 0.0f;
        }
        if (panPositionY > 1.0f) {
            panPositionY = 1.0f;
        }
        if (panPositionY < 0.0f) {
            panPositionY = 0.0f;
        }
        this.panPositionX = panPositionX;
        this.panPositionY = panPositionY;
        if (this.animateZoom) {
            this.zooming = true;
            float initZoom = this.zoom;
            this.motion = Motion.createEaseInOutMotion((int)(initZoom * 10000.0f), (int)(zoom * 10000.0f), 200);
            this.motion.start();
            this.getComponentForm().registerAnimated(this);
        } else {
            this.zoom = zoom;
            this.updatePositions();
            this.repaint();
        }
    }

    public Image getSwipePlaceholder() {
        return this.swipePlaceholder;
    }

    public void setSwipePlaceholder(Image swipePlaceholder) {
        this.swipePlaceholder = swipePlaceholder;
    }

    public boolean isEagerLock() {
        return this.eagerLock;
    }

    public void setEagerLock(boolean eagerLock) {
        this.eagerLock = eagerLock;
    }

    public boolean isCycleLeft() {
        return this.cycleLeft;
    }

    public void setCycleLeft(boolean cycleLeft) {
        this.cycleLeft = cycleLeft;
    }

    public boolean isCycleRight() {
        return this.cycleRight;
    }

    public void setCycleRight(boolean cycleRight) {
        this.cycleRight = cycleRight;
    }

    public float getSwipeThreshold() {
        return this.swipeThreshold;
    }

    public void setSwipeThreshold(float swipeThreshold) {
        this.swipeThreshold = swipeThreshold;
    }

    public void setImageInitialPosition(int imageInitialPosition) {
        this.imageInitialPosition = imageInitialPosition;
    }

    class AnimatePanX
    implements Animation {
        private final Motion motion;
        private final Image replaceImage;
        private final int updatePos;

        public AnimatePanX(float destPan, Image replaceImage, int updatePos) {
            this.motion = Motion.createEaseInOutMotion((int)(ImageViewer.this.panPositionX * 10000.0f), (int)(destPan * 10000.0f), 200);
            this.motion.start();
            this.replaceImage = replaceImage;
            this.updatePos = updatePos;
            Display.getInstance().getCurrent().registerAnimated(this);
        }

        public boolean animate() {
            float v = this.motion.getValue();
            ImageViewer.this.panPositionX = (v /= 10000.0f);
            if (this.motion.isFinished()) {
                if (this.replaceImage != null) {
                    if (!ImageViewer.this.eagerLock) {
                        ImageViewer.this.getImage().unlock();
                        ImageViewer.this.setImage(this.replaceImage);
                    } else {
                        ImageViewer.this.setImage(this.replaceImage);
                        Image left = ImageViewer.this.getImageLeft();
                        Image right = ImageViewer.this.getImageRight();
                        if (left != this.replaceImage) {
                            left.unlock();
                        }
                        if (right != this.replaceImage) {
                            right.unlock();
                        }
                        ImageViewer.this.selectLock = true;
                        ImageViewer.this.swipeableImages.setSelectedIndex(this.updatePos);
                        ImageViewer.this.selectLock = false;
                        this.replaceImage.lock();
                        ImageViewer.this.eagerLock();
                    }
                    ImageViewer.this.selectLock = true;
                    ImageViewer.this.swipeableImages.setSelectedIndex(this.updatePos);
                    ImageViewer.this.selectLock = false;
                    ImageViewer.this.panPositionX = 0.5f;
                    ImageViewer.this.panPositionY = 0.5f;
                    ImageViewer.this.zoom = 1.0f;
                } else if (ImageViewer.this.swipeableImages != null && ImageViewer.this.swipeableImages.getSize() > 1) {
                    ImageViewer.this.getImageLeft().unlock();
                    ImageViewer.this.getImageRight().unlock();
                }
                Display.getInstance().getCurrent().deregisterAnimated(this);
            }
            ImageViewer.this.repaint();
            return false;
        }

        public void paint(Graphics g) {
        }
    }

    private class CropBox {
        private double top;
        private double left;
        private double right;
        private double bottom;

        CropBox() {
        }

        CropBox(double top, double right, double bottom, double left) {
            this.top = top;
            this.left = left;
            this.right = right;
            this.bottom = bottom;
        }

        void set(double top, double right, double bottom, double left) {
            this.top = top;
            this.left = left;
            this.right = right;
            this.bottom = bottom;
        }

        public String toString() {
            return "CropBox{" + this.top + ", " + this.right + ", " + this.bottom + ", " + this.left + "}";
        }

        private int imageWidthForCroppedWidth(int croppedWidth) {
            return (int)Math.round((double)(-croppedWidth) / (this.left + this.right - 1.0));
        }

        private int imageHeightForCroppedHeight(int croppedHeight) {
            return (int)Math.round((double)(-croppedHeight) / (this.top + this.bottom - 1.0));
        }

        private void paint(Graphics g, int imageWidth, int imageHeight) {
            int ih = this.imageHeightForCroppedHeight(imageHeight);
            int iw = this.imageWidthForCroppedWidth(imageWidth);
            g.drawImage(ImageViewer.this.image, (int)Math.round(-this.left * (double)iw), (int)Math.round(-this.top * (double)ih), iw, ih);
        }
    }
}

