/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.components;

import com.codename1.compat.java.util.Objects;
import com.codename1.ui.Button;
import com.codename1.ui.ButtonGroup;
import com.codename1.ui.CheckBox;
import com.codename1.ui.Command;
import com.codename1.ui.Component;
import com.codename1.ui.ComponentSelector;
import com.codename1.ui.Container;
import com.codename1.ui.Font;
import com.codename1.ui.Image;
import com.codename1.ui.Label;
import com.codename1.ui.RadioButton;
import com.codename1.ui.SelectableIconHolder;
import com.codename1.ui.TextHolder;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.events.ActionSource;
import com.codename1.ui.layouts.BorderLayout;
import com.codename1.ui.layouts.BoxLayout;
import com.codename1.ui.layouts.FlowLayout;
import com.codename1.ui.plaf.UIManager;
import java.util.List;
import java.util.StringTokenizer;

public class MultiButton
extends Container
implements ActionSource,
SelectableIconHolder,
TextHolder {
    private final Label firstRow = new Label("MultiButton");
    private final Label secondRow = new Label();
    private final Label thirdRow = new Label();
    private final Label forthRow = new Label();
    private final Button icon = new Button();
    private Button emblem = new Button();
    private boolean invert;
    private String group;
    private int gap;

    public MultiButton(String line1) {
        this();
        this.setTextLine1(line1);
    }

    public MultiButton() {
        this.setLayout(new BorderLayout());
        this.setFocusable(true);
        BorderLayout bl = new BorderLayout();
        Container iconContainer = new Container(bl);
        iconContainer.addComponent("Center", (Component)this.icon);
        Container labels = new Container(new BoxLayout(2));
        Container labelsBorder = new Container(new BorderLayout());
        labelsBorder.addComponent("South", (Component)labels);
        this.addComponent("Center", (Component)labelsBorder);
        this.addComponent("West", (Component)iconContainer);
        bl = new BorderLayout();
        Container emblemContainer = new Container(bl);
        emblemContainer.addComponent("Center", (Component)this.emblem);
        this.addComponent("East", (Component)emblemContainer);
        labelsBorder.addComponent("Center", (Component)this.firstRow);
        labels.addComponent(this.secondRow);
        labels.addComponent(this.thirdRow);
        labels.addComponent(this.forthRow);
        this.firstRow.setUIID("MultiLine1");
        this.secondRow.setUIID("MultiLine2");
        this.thirdRow.setUIID("MultiLine3");
        this.forthRow.setUIID("MultiLine4");
        this.firstRow.setName("Line1");
        this.secondRow.setName("Line2");
        this.thirdRow.setName("Line3");
        this.forthRow.setName("Line4");
        this.icon.setName("icon");
        this.emblem.setName("emblem");
        this.emblem.setUIID("Emblem");
        this.icon.setUIID("Label");
        this.setLeadComponent(this.emblem);
        this.setUIID("MultiButton");
        Image i = UIManager.getInstance().getThemeImageConstant("defaultEmblemImage");
        if (i != null) {
            this.emblem.setIcon(i);
        }
        this.icon.bindStateTo(this.emblem);
    }

    public boolean isLinesTogetherMode() {
        return this.firstRow.getParent() == this.secondRow.getParent();
    }

    public void setLinesTogetherMode(boolean l) {
        if (l != this.isLinesTogetherMode()) {
            if (l) {
                this.firstRow.getParent().removeComponent(this.firstRow);
                Container p = this.secondRow.getParent();
                p.addComponent(0, (Component)this.firstRow);
                Container pp = p.getParent();
                pp.removeComponent(p);
                pp.addComponent("Center", (Component)p);
            } else {
                this.secondRow.getParent().removeComponent(this.secondRow);
                this.thirdRow.getParent().addComponent(0, (Component)this.secondRow);
            }
        }
    }

    public Label getIconComponent() {
        return this.icon;
    }

    public void addActionListener(ActionListener al) {
        this.emblem.addActionListener(al);
    }

    public void removeActionListener(ActionListener al) {
        this.emblem.removeActionListener(al);
    }

    public void addLongPressListener(ActionListener l) {
        this.emblem.addLongPressListener(l);
    }

    public void removeLongPressListener(ActionListener l) {
        this.emblem.removeLongPressListener(l);
    }

    public void addPointerPressedListener(ActionListener l) {
        this.emblem.addPointerPressedListener(l);
    }

    public void removePointerPressedListener(ActionListener l) {
        this.emblem.removePointerPressedListener(l);
    }

    public void addPointerReleasedListener(ActionListener l) {
        this.emblem.addPointerReleasedListener(l);
    }

    public void removePointerReleasedListener(ActionListener l) {
        this.emblem.removePointerReleasedListener(l);
    }

    public Command getCommand() {
        return this.emblem.getCommand();
    }

    public void setCommand(Command c) {
        Image img = this.emblem.getIcon();
        this.emblem.setCommand(c);
        this.emblem.setIcon(img);
        this.emblem.setText("");
    }

    public boolean isCheckBox() {
        return this.emblem instanceof CheckBox;
    }

    public void setCheckBox(boolean b) {
        if (b != this.isCheckBox()) {
            Container par = this.emblem.getParent();
            Button old = this.emblem;
            this.emblem = b ? new CheckBox() : new Button();
            this.emblem.setUIID(old.getUIID());
            this.emblem.setName(old.getName());
            List actionListeners = (List)old.getListeners();
            if (actionListeners != null) {
                for (int iter = 0; iter < actionListeners.size(); ++iter) {
                    this.emblem.addActionListener((ActionListener)actionListeners.get(iter));
                }
            }
            if (old.getCommand() != null) {
                Image img = old.getIcon();
                this.emblem.setCommand(old.getCommand());
                this.emblem.setText("");
                this.emblem.setIcon(img);
            } else {
                this.emblem.setText(old.getText());
                if (old.getIcon() != null) {
                    this.emblem.setIcon(old.getIcon());
                }
            }
            par.replace((Component)old, (Component)this.emblem, null);
            this.setLeadComponent(this.emblem);
        }
    }

    public boolean isRadioButton() {
        return this.emblem instanceof RadioButton;
    }

    public void setRadioButton(boolean b) {
        if (b != this.isRadioButton()) {
            Container par = this.emblem.getParent();
            Button old = this.emblem;
            if (b) {
                this.emblem = new RadioButton();
                if (this.group != null) {
                    ((RadioButton)this.emblem).setGroup(this.group);
                }
            } else {
                this.emblem = new Button();
            }
            this.emblem.setName(old.getName());
            this.emblem.setUIID(old.getUIID());
            List actionListeners = (List)old.getListeners();
            if (actionListeners != null) {
                for (int iter = 0; iter < actionListeners.size(); ++iter) {
                    this.emblem.addActionListener((ActionListener)actionListeners.get(iter));
                }
            }
            if (old.getCommand() != null) {
                Image img = old.getIcon();
                this.emblem.setCommand(old.getCommand());
                this.emblem.setText("");
                this.emblem.setIcon(img);
            }
            par.replace((Component)old, (Component)this.emblem, null);
            this.setLeadComponent(this.emblem);
            this.emblem.setShowEvenIfBlank(true);
        }
    }

    public boolean isSelected() {
        return (this.emblem instanceof RadioButton || this.emblem instanceof CheckBox) && this.emblem.isSelected();
    }

    public void setSelected(boolean b) {
        if (this.emblem instanceof RadioButton) {
            ((RadioButton)this.emblem).setSelected(b);
            return;
        }
        if (this.emblem instanceof CheckBox) {
            ((CheckBox)this.emblem).setSelected(b);
        }
    }

    public boolean isHorizontalLayout() {
        return this.secondRow.getParent().getLayout() instanceof FlowLayout;
    }

    public void setHorizontalLayout(boolean b) {
        if (this.isHorizontalLayout() != b) {
            if (this.isHorizontalLayout()) {
                this.secondRow.getParent().getParent().removeComponent(this.secondRow.getParent());
            }
            this.secondRow.getParent().removeComponent(this.secondRow);
            if (b) {
                Container wrapper = new Container();
                Container c = this.firstRow.getParent();
                wrapper.addComponent(this.secondRow);
                c.addComponent("East", (Component)wrapper);
            } else {
                Container c = this.thirdRow.getParent();
                c.addComponent(0, (Component)this.secondRow);
            }
        }
    }

    public boolean isInvertFirstTwoEntries() {
        return this.invert;
    }

    public void setInvertFirstTwoEntries(boolean b) {
        if (b != this.invert) {
            this.invert = b;
            if (this.isHorizontalLayout()) {
                Container c = this.firstRow.getParent();
                c.removeComponent(this.secondRow);
                if (this.invert) {
                    c.addComponent("West", (Component)this.secondRow);
                } else {
                    c.addComponent("East", (Component)this.secondRow);
                }
            }
        }
    }

    public String getTextLine1() {
        return this.firstRow.getText();
    }

    public void setTextLine1(String t) {
        this.firstRow.setText(t);
    }

    public String getNameLine1() {
        return this.firstRow.getName();
    }

    public void setNameLine1(String t) {
        this.firstRow.setName(t);
    }

    public String getUIIDLine1() {
        return this.firstRow.getUIID();
    }

    public void setUIIDLine1(String t) {
        this.firstRow.setUIID(t);
    }

    public String getTextLine2() {
        return this.secondRow.getText();
    }

    public void setTextLine2(String t) {
        this.secondRow.setText(t);
    }

    public String getNameLine2() {
        return this.secondRow.getName();
    }

    public void setNameLine2(String t) {
        this.secondRow.setName(t);
    }

    public String getUIIDLine2() {
        return this.secondRow.getUIID();
    }

    public void setUIIDLine2(String t) {
        this.secondRow.setUIID(t);
    }

    public String getTextLine3() {
        return this.thirdRow.getText();
    }

    public void setTextLine3(String t) {
        this.thirdRow.setText(t);
    }

    public String getNameLine3() {
        return this.thirdRow.getName();
    }

    public void setNameLine3(String t) {
        this.thirdRow.setName(t);
    }

    public String getUIIDLine3() {
        return this.thirdRow.getUIID();
    }

    public void setUIIDLine3(String t) {
        this.thirdRow.setUIID(t);
    }

    public String getTextLine4() {
        return this.forthRow.getText();
    }

    public void setTextLine4(String t) {
        this.forthRow.setText(t);
    }

    public String getNameLine4() {
        return this.forthRow.getName();
    }

    public void setNameLine4(String t) {
        this.forthRow.setName(t);
    }

    public String getUIIDLine4() {
        return this.forthRow.getUIID();
    }

    public void setUIIDLine4(String t) {
        this.forthRow.setUIID(t);
    }

    public Image getIcon() {
        return this.icon.getIcon();
    }

    public void setIcon(Image i) {
        this.icon.setIcon(i);
        this.updateGap();
    }

    public Image getEmblem() {
        return this.emblem.getIcon();
    }

    public void setEmblem(Image i) {
        this.emblem.setIcon(i);
    }

    public String getIconPosition() {
        return (String)this.getLayout().getComponentConstraint(this.icon.getParent());
    }

    public void setIconPosition(String t) {
        String ip = this.getEmblemPosition();
        if (ip != null && ip.equals(t)) {
            String ep = this.getIconPosition();
            this.removeComponent(this.icon.getParent());
            this.setEmblemPosition(ep);
        } else {
            this.removeComponent(this.icon.getParent());
        }
        this.addComponent(t, (Component)this.icon.getParent());
        this.updateGap();
        this.revalidateLater();
    }

    public String getEmblemPosition() {
        return (String)this.getLayout().getComponentConstraint(this.emblem.getParent());
    }

    public void setEmblemPosition(String t) {
        String ip = this.getIconPosition();
        if (ip != null && ip.equals(t)) {
            String ep = this.getEmblemPosition();
            this.removeComponent(this.emblem.getParent());
            this.setIconPosition(ep);
        } else {
            this.removeComponent(this.emblem.getParent());
        }
        this.addComponent(t, (Component)this.emblem.getParent());
        this.revalidateLater();
    }

    public String getIconName() {
        return this.icon.getName();
    }

    public void setIconName(String t) {
        this.icon.setName(t);
    }

    public String getIconUIID() {
        return this.icon.getUIID();
    }

    public void setIconUIID(String t) {
        this.icon.setUIID(t);
    }

    public String getEmblemName() {
        return this.emblem.getName();
    }

    public void setEmblemName(String t) {
        this.emblem.setName(t);
    }

    public String getEmblemUIID() {
        return this.emblem.getUIID();
    }

    public void setEmblemUIID(String t) {
        this.emblem.setUIID(t);
    }

    public String getTextLines() {
        return this.getTextLine1() + "\n" + this.getTextLine2() + "\n" + this.getTextLine3() + "\n" + this.getTextLine4();
    }

    public void setTextLines(String text) {
        String currTextVal;
        String newTextVal0 = text;
        int line = 0;
        StringTokenizer strtok = new StringTokenizer(newTextVal0, "\n");
        block24: while (strtok.hasMoreTokens()) {
            String newTextVal;
            switch (++line) {
                case 1: {
                    currTextVal = this.getTextLine1();
                    break;
                }
                case 2: {
                    currTextVal = this.getTextLine2();
                    break;
                }
                case 3: {
                    currTextVal = this.getTextLine3();
                    break;
                }
                case 4: {
                    currTextVal = this.getTextLine4();
                    break;
                }
                default: {
                    currTextVal = this.getText();
                }
            }
            if (Objects.equals(currTextVal, newTextVal = strtok.nextToken().trim())) continue;
            switch (line) {
                case 1: {
                    this.setTextLine1(newTextVal);
                    continue block24;
                }
                case 2: {
                    this.setTextLine2(newTextVal);
                    continue block24;
                }
                case 3: {
                    this.setTextLine3(newTextVal);
                    continue block24;
                }
                case 4: {
                    this.setTextLine4(newTextVal);
                    continue block24;
                }
            }
            this.setText(newTextVal);
        }
        block25: while (line < 4) {
            switch (++line) {
                case 1: {
                    currTextVal = this.getTextLine1();
                    break;
                }
                case 2: {
                    currTextVal = this.getTextLine2();
                    break;
                }
                case 3: {
                    currTextVal = this.getTextLine3();
                    break;
                }
                case 4: {
                    currTextVal = this.getTextLine4();
                    break;
                }
                default: {
                    currTextVal = this.getText();
                }
            }
            if (Objects.equals(currTextVal, "")) continue;
            switch (line) {
                case 1: {
                    this.setTextLine1("");
                    continue block25;
                }
                case 2: {
                    this.setTextLine2("");
                    continue block25;
                }
                case 3: {
                    this.setTextLine3("");
                    continue block25;
                }
                case 4: {
                    this.setTextLine4("");
                    continue block25;
                }
            }
            this.setText("");
        }
    }

    public String getText() {
        return this.getTextLine1();
    }

    public void setText(String text) {
        this.setTextLine1(text);
    }

    public String[] getPropertyNames() {
        return new String[]{"line1", "line2", "line3", "line4", "name1", "name2", "name3", "name4", "uiid1", "uiid2", "uiid3", "uiid4", "icon", "iconName", "iconUiid", "iconPosition", "emblem", "emblemName", "emblemUiid", "emblemPosition", "horizontalLayout", "invertFirstTwoEntries", "checkBox", "radioButton", "group", "selected", "maskName"};
    }

    public Class[] getPropertyTypes() {
        return new Class[]{String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, Image.class, String.class, String.class, String.class, Image.class, String.class, String.class, String.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, String.class, Boolean.class, String.class};
    }

    public Object getPropertyValue(String name) {
        if (name.equals("line1")) {
            return this.getTextLine1();
        }
        if (name.equals("line2")) {
            return this.getTextLine2();
        }
        if (name.equals("line3")) {
            return this.getTextLine3();
        }
        if (name.equals("line4")) {
            return this.getTextLine4();
        }
        if (name.equals("name1")) {
            return this.getNameLine1();
        }
        if (name.equals("name2")) {
            return this.getNameLine2();
        }
        if (name.equals("name3")) {
            return this.getNameLine3();
        }
        if (name.equals("name4")) {
            return this.getNameLine4();
        }
        if (name.equals("uiid1")) {
            return this.getUIIDLine1();
        }
        if (name.equals("uiid2")) {
            return this.getUIIDLine2();
        }
        if (name.equals("uiid3")) {
            return this.getUIIDLine3();
        }
        if (name.equals("uiid4")) {
            return this.getUIIDLine4();
        }
        if (name.equals("icon")) {
            return this.getIcon();
        }
        if (name.equals("iconName")) {
            return this.getIconName();
        }
        if (name.equals("iconUiid")) {
            return this.getIconUIID();
        }
        if (name.equals("iconPosition")) {
            return this.getIconPosition();
        }
        if (name.equals("emblem")) {
            return this.getEmblem();
        }
        if (name.equals("emblemName")) {
            return this.getEmblemName();
        }
        if (name.equals("emblemUiid")) {
            return this.getEmblemUIID();
        }
        if (name.equals("emblemPosition")) {
            return this.getEmblemPosition();
        }
        if (name.equals("horizontalLayout")) {
            if (this.isHorizontalLayout()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (name.equals("invertFirstTwoEntries")) {
            if (this.isInvertFirstTwoEntries()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (name.equals("checkBox")) {
            if (this.isCheckBox()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (name.equals("radioButton")) {
            if (this.isRadioButton()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (name.equals("group")) {
            return this.getGroup();
        }
        if (name.equals("selected")) {
            if (this.isSelected()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (name.equals("maskName")) {
            return this.getMaskName();
        }
        return null;
    }

    public String setPropertyValue(String name, Object value) {
        if (name.equals("line1")) {
            this.setTextLine1((String)value);
            return null;
        }
        if (name.equals("line2")) {
            this.setTextLine2((String)value);
            return null;
        }
        if (name.equals("line3")) {
            this.setTextLine3((String)value);
            return null;
        }
        if (name.equals("line4")) {
            this.setTextLine4((String)value);
            return null;
        }
        if (name.equals("name1")) {
            this.setNameLine1((String)value);
            return null;
        }
        if (name.equals("name2")) {
            this.setNameLine2((String)value);
            return null;
        }
        if (name.equals("name3")) {
            this.setNameLine3((String)value);
            return null;
        }
        if (name.equals("name4")) {
            this.setNameLine4((String)value);
            return null;
        }
        if (name.equals("uiid1")) {
            this.setUIIDLine1((String)value);
            return null;
        }
        if (name.equals("uiid2")) {
            this.setUIIDLine2((String)value);
            return null;
        }
        if (name.equals("uiid3")) {
            this.setUIIDLine3((String)value);
            return null;
        }
        if (name.equals("uiid4")) {
            this.setUIIDLine4((String)value);
            return null;
        }
        if (name.equals("icon")) {
            this.setIcon((Image)value);
            return null;
        }
        if (name.equals("iconUiid")) {
            this.setIconUIID((String)value);
            return null;
        }
        if (name.equals("iconName")) {
            this.setIconName((String)value);
            return null;
        }
        if (name.equals("iconPosition")) {
            this.setIconPosition((String)value);
            return null;
        }
        if (name.equals("emblem")) {
            this.setEmblem((Image)value);
            return null;
        }
        if (name.equals("emblemUiid")) {
            this.setEmblemUIID((String)value);
            return null;
        }
        if (name.equals("emblemName")) {
            this.setEmblemName((String)value);
            return null;
        }
        if (name.equals("emblemPosition")) {
            this.setEmblemPosition((String)value);
            return null;
        }
        if (name.equals("horizontalLayout")) {
            this.setHorizontalLayout((Boolean)value);
            return null;
        }
        if (name.equals("invertFirstTwoEntries")) {
            this.setInvertFirstTwoEntries((Boolean)value);
            return null;
        }
        if (name.equals("checkBox")) {
            this.setCheckBox((Boolean)value);
            return null;
        }
        if (name.equals("radioButton")) {
            this.setRadioButton((Boolean)value);
            return null;
        }
        if (name.equals("group")) {
            this.setGroup((String)value);
            return null;
        }
        if (name.equals("selected")) {
            this.setSelected((Boolean)value);
            return null;
        }
        if (name.equals("maskName")) {
            this.setMaskName((String)value);
            return null;
        }
        return super.setPropertyValue(name, value);
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
        if (this.emblem instanceof RadioButton) {
            ((RadioButton)this.emblem).setGroup(group);
        }
    }

    public void setGroup(ButtonGroup bg) {
        bg.add((RadioButton)this.emblem);
    }

    public String getMaskName() {
        return this.icon.getMaskName();
    }

    public void setMaskName(String maskName) {
        this.icon.setMaskName(maskName);
    }

    public boolean isShouldLocalize() {
        return this.firstRow.isShouldLocalize();
    }

    public void setShouldLocalize(boolean shouldLocalize) {
        this.firstRow.setShouldLocalize(shouldLocalize);
        this.secondRow.setShouldLocalize(shouldLocalize);
        this.thirdRow.setShouldLocalize(shouldLocalize);
        this.forthRow.setShouldLocalize(shouldLocalize);
    }

    public int getGap() {
        return this.gap;
    }

    public void setGap(int gap) {
        if (gap != this.gap) {
            this.gap = gap;
            this.updateGap();
        }
    }

    public int getTextPosition() {
        String iconPosition = this.getIconPosition();
        if ("North".equals(iconPosition)) {
            return 2;
        }
        if ("South".equals(iconPosition)) {
            return 0;
        }
        if ("East".equals(iconPosition)) {
            return 1;
        }
        if ("West".equals(iconPosition)) {
            return 3;
        }
        return 1;
    }

    public void setTextPosition(int textPosition) {
        switch (textPosition) {
            case 0: {
                this.setIconPosition("South");
                break;
            }
            case 2: {
                this.setIconPosition("North");
                break;
            }
            case 1: {
                this.setIconPosition("East");
                break;
            }
            case 3: {
                this.setIconPosition("West");
                break;
            }
            default: {
                this.setIconPosition("East");
            }
        }
    }

    private void updateGap() {
        if (this.getIcon() == null) {
            ComponentSelector.$(this.icon).setMargin(0);
        } else if ("North".equals(this.getIconPosition())) {
            ComponentSelector.$(this.icon).selectAllStyles().setMargin(0, 0, this.gap, 0);
        } else if ("South".equals(this.getIconPosition())) {
            ComponentSelector.$(this.icon).selectAllStyles().setMargin(this.gap, 0, 0, 0);
        } else if ("East".equals(this.getIconPosition())) {
            ComponentSelector.$(this.icon).selectAllStyles().setMargin(0, 0, 0, this.gap);
        } else if ("West".equals(this.getIconPosition())) {
            ComponentSelector.$(this.icon).selectAllStyles().setMargin(0, this.gap, 0, 0);
        }
    }

    public Component getIconStyleComponent() {
        return this.icon;
    }

    public void setMaterialIcon(char c, float size) {
        this.icon.setMaterialIcon(c, size);
    }

    public void setFontIcon(Font font, char c, float size) {
        this.icon.setFontIcon(font, c, size);
    }

    public Image getRolloverIcon() {
        return this.icon.getRolloverIcon();
    }

    public void setRolloverIcon(Image arg0) {
        this.icon.setRolloverIcon(arg0);
    }

    public Image getPressedIcon() {
        return this.icon.getPressedIcon();
    }

    public void setPressedIcon(Image arg0) {
        this.icon.setPressedIcon(arg0);
    }

    public Image getDisabledIcon() {
        return this.icon.getDisabledIcon();
    }

    public void setDisabledIcon(Image arg0) {
        this.icon.setDisabledIcon(arg0);
    }

    public Image getRolloverPressedIcon() {
        return this.icon.getRolloverPressedIcon();
    }

    public void setRolloverPressedIcon(Image icn) {
        this.icon.setRolloverPressedIcon(icn);
    }

    public Image getIconFromState() {
        return this.icon.getIconFromState();
    }

    public String getBadgeText() {
        return this.icon.getBadgeText();
    }

    public void setBadgeText(String badgeText) {
        this.icon.setBadgeText(badgeText);
    }

    public void setBadgeUIID(String badgeUIID) {
        this.icon.setBadgeUIID(badgeUIID);
    }

    public Component getBadgeStyleComponent() {
        return this.icon.getBadgeStyleComponent();
    }
}

