/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.components;

import com.codename1.ui.EncodedImage;

public class ReplaceableImage
extends EncodedImage {
    private boolean replaced;
    private byte[] data;
    private final boolean opaque;

    private ReplaceableImage(EncodedImage placeholder) {
        super(placeholder.getWidth(), placeholder.getHeight());
        this.data = placeholder.getImageData();
        this.opaque = placeholder.isOpaque();
    }

    public static ReplaceableImage create(EncodedImage placeholder) {
        return new ReplaceableImage(placeholder);
    }

    public byte[] getImageData() {
        this.replaced = false;
        return this.data;
    }

    public void replace(EncodedImage newImage) {
        this.data = newImage.getImageData();
        super.resetCache();
        this.replaced = true;
    }

    public boolean animate() {
        return this.replaced;
    }

    public boolean isAnimation() {
        return true;
    }

    public boolean isOpaque() {
        return this.opaque;
    }
}

