/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.components;

import com.codename1.ui.Display;
import com.codename1.ui.Form;
import com.codename1.ui.Image;
import com.codename1.ui.Label;
import com.codename1.ui.geom.Dimension;
import com.codename1.ui.plaf.Style;

public class ScaleImageLabel
extends Label {
    private int preferredH = -1;
    private int preferredW = -1;

    public ScaleImageLabel() {
        this.setUIID("Label");
        this.setShowEvenIfBlank(true);
        this.getAllStyles().setBackgroundType((byte)34);
    }

    public ScaleImageLabel(Image i) {
        this.setUIID("Label");
        this.setShowEvenIfBlank(true);
        this.getAllStyles().setBackgroundType((byte)34);
        this.setIcon(i);
    }

    public byte getBackgroundType() {
        return this.getUnselectedStyle().getBackgroundType();
    }

    public void setBackgroundType(byte behavior) {
        this.getAllStyles().setBackgroundType(behavior);
    }

    protected Dimension calcPreferredSize() {
        Image i = this.getIcon();
        if (i == null) {
            return new Dimension();
        }
        int dw = Display.getInstance().getDisplayWidth();
        int iw = i.getWidth();
        int ih = i.getHeight();
        if (iw > dw) {
            float ratio = (float)iw / (float)dw;
            iw = (int)((float)iw / ratio);
            ih = (int)((float)ih / ratio);
        }
        Style s = this.getStyle();
        return new Dimension(iw + s.getPaddingLeftNoRTL() + s.getPaddingRightNoRTL(), ih + s.getPaddingTop() + s.getPaddingBottom());
    }

    protected void initComponent() {
        super.initComponent();
        this.checkAnimation(this.getIcon());
    }

    void checkAnimation(Image icon) {
        Form parent;
        if (icon != null && icon.isAnimation() && (parent = this.getComponentForm()) != null) {
            parent.registerAnimated(this);
        }
    }

    public Image getIcon() {
        return this.getUnselectedStyle().getBgImage();
    }

    public void setIcon(Image i) {
        this.setShouldCalcPreferredSize(true);
        this.getAllStyles().setBgImage(i);
        if (i != null && i.isAnimation()) {
            this.checkAnimation(i);
        }
        this.repaint();
    }

    public void setText(String text) {
    }

    public void setUIID(String id) {
        byte type = this.getBackgroundType();
        Image icon = this.getIcon();
        super.setUIID(id);
        this.setIcon(icon);
        this.getAllStyles().setBackgroundType(type);
    }

    protected void refreshTheme(String id, boolean merge) {
        byte type = this.getBackgroundType();
        Image icon = this.getIcon();
        super.refreshTheme(id, merge);
        this.setIcon(icon);
        this.getAllStyles().setBackgroundType(type);
    }

    public String[] getPropertyNames() {
        return new String[]{"backgroundType"};
    }

    public Class[] getPropertyTypes() {
        return new Class[]{Byte.class};
    }

    public String[] getPropertyTypeNames() {
        return new String[]{"Byte"};
    }

    public Object getPropertyValue(String name) {
        if (name.equals("backgroundType")) {
            return this.getBackgroundType();
        }
        return null;
    }

    public String setPropertyValue(String name, Object value) {
        if (name.equals("backgroundType")) {
            this.setBackgroundType((Byte)value);
            return null;
        }
        return super.setPropertyValue(name, value);
    }

    public int getPreferredH() {
        Image i;
        if (this.preferredH > 0) {
            return this.preferredH;
        }
        if (this.preferredW > 0 && (i = this.getIcon()) != null && this.preferredW < i.getWidth()) {
            return (int)((double)(i.getHeight() * this.preferredW) / (double)i.getWidth());
        }
        return super.getPreferredH();
    }

    public void setPreferredH(int preferredH) {
        this.preferredH = preferredH;
    }

    public int getPreferredW() {
        Image i;
        if (this.preferredW > 0) {
            return this.preferredW;
        }
        if (this.preferredH > 0 && (i = this.getIcon()) != null && this.preferredH < i.getHeight()) {
            return (int)((double)(i.getWidth() * this.preferredH) / (double)i.getHeight());
        }
        return super.getPreferredW();
    }

    public void setPreferredW(int preferredW) {
        this.preferredW = preferredW;
    }
}

