/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.components;

import com.codename1.ui.Button;
import com.codename1.ui.Component;
import com.codename1.ui.Container;
import com.codename1.ui.Dialog;
import com.codename1.ui.Display;
import com.codename1.ui.Font;
import com.codename1.ui.Graphics;
import com.codename1.ui.Image;
import com.codename1.ui.ImageFactory;
import com.codename1.ui.Stroke;
import com.codename1.ui.animations.Animation;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.events.ActionSource;
import com.codename1.ui.geom.Dimension;
import com.codename1.ui.geom.GeneralPath;
import com.codename1.ui.geom.Rectangle;
import com.codename1.ui.layouts.BorderLayout;
import com.codename1.ui.layouts.GridLayout;
import com.codename1.ui.plaf.Style;
import com.codename1.ui.plaf.UIManager;
import com.codename1.ui.util.EventDispatcher;

public class SignatureComponent
extends Container
implements ActionSource {
    private final SignaturePanel signaturePanel = new SignaturePanel();
    private final Button lead;
    private final EventDispatcher eventDispatcher = new EventDispatcher();
    private final Font xFont;
    private Image signatureImage;
    private final Animation iconAnimation = new Animation(){

        public boolean animate() {
            if (SignatureComponent.this.signatureImage != null && SignatureComponent.this.signatureImage.animate()) {
                Style s = SignatureComponent.this.getStyle();
                Image icon = SignatureComponent.this.signatureImage;
                if (icon.getWidth() > SignatureComponent.this.getWidth() - s.getHorizontalPadding() || icon.getHeight() > SignatureComponent.this.getHeight() - s.getVerticalPadding()) {
                    icon = SignatureComponent.this.signatureImage.scaledSmallerRatio(SignatureComponent.this.getWidth() - s.getHorizontalPadding(), SignatureComponent.this.getHeight() - s.getVerticalPadding());
                }
                SignatureComponent.this.lead.setIcon(icon);
                SignatureComponent.this.repaint();
                return true;
            }
            return false;
        }

        public void paint(Graphics g) {
        }
    };

    public SignatureComponent() {
        this.setLayout(new BorderLayout());
        this.xFont = Font.createSystemFont(0, 1, 16);
        final Style signatureButtonBoxStyle = this.getUIManager().getComponentStyle("SignatureButtonBox");
        this.lead = new Button(){

            protected void paintBackground(Graphics g) {
                super.paintBackground(g);
                g.setColor(signatureButtonBoxStyle.getFgColor());
                int alpha = g.concatenateAlpha(signatureButtonBoxStyle.getFgAlpha());
                Style s = this.getStyle();
                g.drawRect(this.getX() + s.getPaddingLeftNoRTL(), this.getY() + s.getPaddingTop(), this.getWidth() - s.getPaddingRightNoRTL() - s.getPaddingLeftNoRTL(), this.getHeight() - s.getPaddingBottom() - s.getPaddingTop());
                g.setFont(SignatureComponent.this.xFont);
                g.drawString("X", this.getX() + this.getStyle().getPaddingLeftNoRTL() + Display.getInstance().convertToPixels(3, true), this.getY() + this.getHeight() / 2);
                g.setAlpha(alpha);
            }
        };
        this.lead.setText(this.localize("SignatureComponent.LeadText", "Press to sign"));
        this.lead.setUIID("SignatureButton");
        this.lead.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                final Dialog dialog = new Dialog(SignatureComponent.this.localize("SignatureComponent.DialogTitle", "Sign Here"));
                final SignatureDialogBody sigBody = new SignatureDialogBody(){

                    protected void onCancel() {
                        super.onCancel();
                        dialog.dispose();
                    }
                };
                SignatureComponent.this.signaturePanel.clear();
                sigBody.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent sigDoneEvent) {
                        dialog.dispose();
                        SignatureComponent.this.setSignatureImage(sigBody.getValue());
                        SignatureComponent.this.fireActionEvent();
                    }
                });
                dialog.setLayout(new BorderLayout());
                dialog.addComponent("Center", (Component)sigBody);
                dialog.setScrollable(false);
                dialog.setFocusable(false);
                dialog.show();
            }
        });
        this.addComponent("Center", (Component)this.lead);
    }

    protected void onSignatureReset() {
    }

    public void addActionListener(ActionListener l) {
        this.eventDispatcher.addListener(l);
    }

    public void removeActionListener(ActionListener l) {
        this.eventDispatcher.removeListener(l);
    }

    protected void fireActionEvent() {
        this.eventDispatcher.fireActionEvent(new ActionEvent(this));
    }

    protected void initComponent() {
        super.initComponent();
        this.getComponentForm().registerAnimated(this.iconAnimation);
    }

    protected void deinitialize() {
        this.getComponentForm().deregisterAnimated(this.iconAnimation);
        super.deinitialize();
    }

    private String localize(String key, String defaultVal) {
        return UIManager.getInstance().localize(key, defaultVal);
    }

    protected Dimension calcPreferredSize() {
        int w = Display.getInstance().convertToPixels(75, true);
        int h = Display.getInstance().convertToPixels(40, true);
        return new Dimension(w, h);
    }

    public Image getSignatureImage() {
        if (this.signatureImage != null) {
            return this.signatureImage;
        }
        return this.signaturePanel.getImage();
    }

    public void setSignatureImage(Image img) {
        if (img != this.signatureImage) {
            this.signatureImage = img;
            this.lead.setText("");
            if (img != null) {
                int maxW = this.lead.getWidth() - this.lead.getStyle().getPaddingLeftNoRTL() - this.lead.getStyle().getPaddingRightNoRTL();
                int maxH = this.lead.getHeight() - this.lead.getStyle().getPaddingTop() - this.lead.getStyle().getPaddingBottom();
                Image icon = img;
                if ((icon.getWidth() > maxW || icon.getHeight() > maxH) && maxW > 1 && maxH > 1) {
                    icon = icon.scaledSmallerRatio(maxW, maxH);
                }
                this.lead.setIcon(icon);
            } else {
                this.lead.setText(this.localize("SignatureComponent.LeadText", "Press to sign"));
                this.lead.setIcon(null);
            }
        }
    }

    public Component getSignaturePanel() {
        return this.signaturePanel;
    }

    public void clearSignaturePanel() {
        this.signaturePanel.clear();
    }

    private class SignaturePanel
    extends Component {
        private final GeneralPath path = new GeneralPath();
        private final Stroke stroke = new Stroke();
        private final Rectangle signatureRect = new Rectangle();
        private boolean initialized;
        private final Style signatureBoxStyle;
        private final Style signatureStyle;

        SignaturePanel() {
            this.setUIID("SignaturePanel");
            this.signatureBoxStyle = this.getUIManager().getComponentStyle("SignaturePanelBox");
            this.signatureStyle = this.getUIManager().getComponentStyle("SignaturePanelSignature");
            this.stroke.setLineWidth(Math.max(1, Display.getInstance().convertToPixels(1, true) / 2));
        }

        protected int getDragRegionStatus(int x, int y) {
            return 23;
        }

        public void paint(Graphics g) {
            super.paint(g);
            g.setColor(this.signatureBoxStyle.getFgColor());
            int alpha = g.concatenateAlpha(this.signatureBoxStyle.getFgAlpha());
            this.calcSignatureRect(this.signatureRect);
            g.drawRect(this.signatureRect.getX(), this.signatureRect.getY(), this.signatureRect.getWidth(), this.signatureRect.getHeight());
            g.drawString("X", this.signatureRect.getX() + Display.getInstance().convertToPixels(1, true), this.signatureRect.getY() + this.signatureRect.getHeight() / 2);
            g.pushClip();
            g.clipRect(this.signatureRect.getX(), this.signatureRect.getY(), this.signatureRect.getWidth(), this.signatureRect.getHeight());
            this.paintSignature(g);
            g.popClip();
            g.setAlpha(alpha);
        }

        private void paintSignature(Graphics g) {
            g.setColor(this.signatureStyle.getFgColor());
            int alpha = g.concatenateAlpha(this.signatureStyle.getFgAlpha());
            boolean oldAA = g.isAntiAliased();
            g.setAntiAliased(true);
            g.drawShape(this.path, this.stroke);
            g.setAntiAliased(oldAA);
            g.setAlpha(alpha);
        }

        private void calcSignatureRect(Rectangle r) {
            int w = this.getWidth() - Display.getInstance().convertToPixels(6, true);
            int h = (int)((double)w * 9.0 / 16.0);
            if (h > this.getHeight()) {
                h = this.getHeight() - Display.getInstance().convertToPixels(6, false);
                w = (int)((double)h * 16.0 / 9.0);
            }
            r.setX(this.getX() + (this.getWidth() - w) / 2);
            r.setY(this.getY() + (this.getHeight() - h) / 2);
            r.setWidth(w);
            r.setHeight(h);
        }

        protected Dimension calcPreferredSize() {
            Display d = Display.getInstance();
            return new Dimension(d.convertToPixels(80, true), d.convertToPixels(40, false));
        }

        public void pointerPressed(int x, int y) {
            this.path.moveTo(this.x(x), this.y(y));
            this.initialized = true;
            this.repaint();
        }

        public void pointerDragged(int x, int y) {
            if (!this.initialized) {
                this.initialized = true;
                this.path.moveTo(this.x(x), this.y(y));
            } else {
                this.path.lineTo(this.x(x), this.y(y));
            }
            this.repaint();
        }

        public void pointerReleased(int x, int y) {
            this.path.lineTo(this.x(x), this.y(y));
            this.repaint();
        }

        private int x(int x) {
            return x - this.getParent().getAbsoluteX();
        }

        private int y(int y) {
            return y - this.getParent().getAbsoluteY();
        }

        public Image getImage() {
            if (this.path.getPointsSize() < 2) {
                return null;
            }
            this.calcSignatureRect(this.signatureRect);
            Image img = ImageFactory.createImage(this, this.signatureRect.getWidth(), this.signatureRect.getHeight(), 0xFFFFFF);
            Graphics g = img.getGraphics();
            g.translate(-this.signatureRect.getX(), -this.signatureRect.getY());
            this.paintSignature(g);
            return img;
        }

        public void clear() {
            this.path.reset();
        }
    }

    private class SignatureDialogBody
    extends Container {
        private final EventDispatcher eventDispatcher = new EventDispatcher();
        private final Button doneButton;
        private final Button resetButton;
        private final Button cancelButton;
        private Image value;

        public SignatureDialogBody() {
            this.setLayout(new BorderLayout());
            this.addComponent("Center", (Component)SignatureComponent.this.signaturePanel);
            this.doneButton = new Button(SignatureComponent.this.localize("SignatureComponent.SaveButtonLabel", "Save"), this.getUIManager().getThemeConstant("sigButtonOKUIID", "Button"));
            this.resetButton = new Button(SignatureComponent.this.localize("SignatureComponent.ResetButtonLabel", "Reset"), this.getUIManager().getThemeConstant("sigButtonResetUIID", "Button"));
            this.cancelButton = new Button(SignatureComponent.this.localize("SignatureComponent.CancelButtonLabel", "Cancel"), this.getUIManager().getThemeConstant("sigButtonCancelUIID", "Button"));
            this.doneButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    SignatureDialogBody.this.value = SignatureComponent.this.signaturePanel.getImage();
                    if (SignatureDialogBody.this.value == null) {
                        Dialog.show(SignatureComponent.this.localize("SignatureComponent.ErrorDialog.SignatureRequired.Title", "Signature Required"), SignatureComponent.this.localize("SignatureComponent.ErrorDialog.SignatureRequired.Body", "Please draw your signature in the space provided."), SignatureComponent.this.localize("SignatureComponent.ErrorDialog.OK", "OK"), null);
                        return;
                    }
                    SignatureDialogBody.this.eventDispatcher.fireActionEvent(new ActionEvent(this));
                    SignatureDialogBody.this.removeComponent(SignatureComponent.this.signaturePanel);
                }
            });
            this.resetButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    SignatureComponent.this.signaturePanel.clear();
                    SignatureComponent.this.onSignatureReset();
                    SignatureDialogBody.this.repaint();
                }
            });
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    SignatureDialogBody.this.removeComponent(SignatureComponent.this.signaturePanel);
                    SignatureDialogBody.this.onCancel();
                }
            });
            this.addComponent("South", (Component)GridLayout.encloseIn(3, this.cancelButton, this.resetButton, this.doneButton));
        }

        protected void onCancel() {
        }

        public void addActionListener(ActionListener l) {
            this.eventDispatcher.addListener(l);
        }

        public void removeActionListener(ActionListener l) {
            this.eventDispatcher.removeListener(l);
        }

        protected void deinitialize() {
            if (this.value == null) {
                this.value = SignatureComponent.this.signaturePanel.getImage();
            }
            super.deinitialize();
        }

        public Image getValue() {
            if (this.value == null) {
                this.value = SignatureComponent.this.signaturePanel.getImage();
            }
            return this.value;
        }
    }
}

