/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.components;

import com.codename1.io.ConnectionRequest;
import com.codename1.io.NetworkEvent;
import com.codename1.io.NetworkManager;
import com.codename1.ui.Slider;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import java.util.Vector;

public class SliderBridge
extends Slider {
    private ConnectionRequest[] sources;

    public SliderBridge() {
        SliderBridge.bindProgress((ConnectionRequest[])null, (Slider)this);
    }

    public SliderBridge(ConnectionRequest source) {
        if (source != null) {
            this.sources = new ConnectionRequest[]{source};
        }
        SliderBridge.bindProgress(this.sources, (Slider)this);
    }

    public SliderBridge(ConnectionRequest[] sources) {
        this.sources = sources;
        SliderBridge.bindProgress(sources, (Slider)this);
    }

    public static void bindProgress(ConnectionRequest source, Slider s) {
        if (source == null) {
            SliderBridge.bindProgress((ConnectionRequest[])null, s);
        } else {
            SliderBridge.bindProgress(new ConnectionRequest[]{source}, s);
        }
    }

    public static void bindProgress(final ConnectionRequest[] sources, final Slider s) {
        Vector<ConnectionRequest> v = null;
        int portions = 100;
        if (sources != null) {
            v = new Vector<ConnectionRequest>();
            int slen = sources.length;
            for (int iter = 0; iter < slen; ++iter) {
                v.addElement(sources[iter]);
            }
            portions /= slen;
        }
        final Vector<ConnectionRequest> sourceVec = v;
        final int portionPerSource = portions;
        NetworkManager.getInstance().addProgressListener(new ActionListener(){
            private float currentLength;
            private int soFar;

            public void actionPerformed(ActionEvent evt) {
                if (sources != null && !sourceVec.contains(evt.getSource())) {
                    return;
                }
                NetworkEvent e = (NetworkEvent)evt;
                switch (e.getProgressType()) {
                    case 4: {
                        s.setInfinite(false);
                        this.soFar += portionPerSource;
                        s.setProgress(this.soFar);
                        if (sources == null) break;
                        NetworkManager.getInstance().removeProgressListener(this);
                        break;
                    }
                    case 1: {
                        s.setInfinite(true);
                        break;
                    }
                    case 2: 
                    case 3: {
                        if (e.getLength() > 0) {
                            this.currentLength = e.getLength();
                            s.setInfinite(false);
                            float sentReceived = e.getSentReceived();
                            sentReceived = sentReceived / this.currentLength * (float)portionPerSource;
                            s.setProgress((int)sentReceived + this.soFar);
                            break;
                        }
                        s.setInfinite(true);
                    }
                }
            }
        });
    }
}

