/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.components;

import com.codename1.components.InfiniteProgress;
import com.codename1.io.ConnectionRequest;
import com.codename1.io.Log;
import com.codename1.ui.BrowserComponent;
import com.codename1.ui.Component;
import com.codename1.ui.Container;
import com.codename1.ui.Form;
import com.codename1.ui.Graphics;
import com.codename1.ui.Painter;
import com.codename1.ui.animations.Animation;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.events.BrowserNavigationCallback;
import com.codename1.ui.geom.Rectangle;
import com.codename1.ui.html.AsyncDocumentRequestHandlerImpl;
import com.codename1.ui.html.DefaultHTMLCallback;
import com.codename1.ui.html.DocumentInfo;
import com.codename1.ui.html.HTMLComponent;
import com.codename1.ui.html.IOCallback;
import com.codename1.ui.layouts.BorderLayout;
import com.codename1.util.Base64;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class WebBrowser
extends Container {
    private Component internal;
    private boolean isNative;
    private String page;
    private Loading loading;

    public WebBrowser(String url) {
        this();
        this.setURL(url);
    }

    public WebBrowser() {
        super(new BorderLayout());
        try {
            if (BrowserComponent.isNativeBrowserSupported()) {
                this.isNative = true;
                BrowserComponent b = new BrowserComponent();
                b.addWebEventListener("onStart", new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        WebBrowser.this.onStart((String)evt.getSource());
                    }
                });
                b.addWebEventListener("onLoad", new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        WebBrowser.this.onLoad((String)evt.getSource());
                    }
                });
                b.addWebEventListener("onError", new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        WebBrowser.this.onError((String)evt.getSource(), evt.getKeyEvent());
                    }
                });
                this.internal = b;
                this.addComponent("Center", this.internal);
                return;
            }
        }
        catch (Throwable t) {
            Log.e(t);
        }
        this.isNative = false;
        HTMLComponent h = new HTMLComponent(new AsyncDocumentRequestHandlerImpl(){

            protected ConnectionRequest createConnectionRequest(final DocumentInfo docInfo, final IOCallback callback, final Object[] response) {
                return new ConnectionRequest(){

                    protected void buildRequestBody(OutputStream os) throws IOException {
                        if (this.isPost() && docInfo.getParams() != null) {
                            String enc = docInfo.getEncoding();
                            if (enc.indexOf(47) > -1) {
                                enc = enc.indexOf("charset=") > -1 ? enc.substring(enc.indexOf("charset=") + 8) : "UTF-8";
                            }
                            OutputStreamWriter w = new OutputStreamWriter(os, enc);
                            w.write(docInfo.getParams());
                            w.flush();
                        }
                    }

                    protected void handleIOException(IOException err) {
                        if (callback == null) {
                            response[0] = err;
                        }
                        super.handleIOException(err);
                    }

                    protected boolean shouldAutoCloseResponse() {
                        return callback != null;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected void readResponse(InputStream input) throws IOException {
                        if (callback != null) {
                            callback.streamReady(input, docInfo);
                        } else {
                            response[0] = input;
                            Object object = LOCK;
                            synchronized (object) {
                                LOCK.notify();
                            }
                        }
                    }

                    protected void handleErrorResponseCode(int code, String message) {
                        WebBrowser.this.onError(message, code);
                    }

                    protected void handleException(Exception err) {
                        System.out.println("Error occured");
                        Log.e(err);
                        if (WebBrowser.this.loading != null) {
                            WebBrowser.this.loading.unInstall();
                        }
                    }

                    public boolean onRedirect(String url) {
                        WebBrowser.this.onStart(url);
                        if (((HTMLComponent)WebBrowser.this.internal).getPageStatus() == -1) {
                            return true;
                        }
                        return super.onRedirect(url);
                    }
                };
            }
        });
        h.setIgnoreCSS(true);
        h.setHTMLCallback(new DefaultHTMLCallback(){

            public void pageStatusChanged(HTMLComponent htmlC, int status, String url) {
                Form f = htmlC.getComponentForm();
                if (f != null) {
                    if (status == 0 || WebBrowser.this.loading == null && status == 1) {
                        WebBrowser.this.loading = new Loading(f);
                        WebBrowser.this.loading.install();
                    } else if (WebBrowser.this.loading != null && (status == 3 || status == -2 || status == -1)) {
                        WebBrowser.this.loading.unInstall();
                    }
                }
                if (status == 0 && url != null) {
                    WebBrowser.this.onStart(url);
                } else if (status == 3 && url != null) {
                    WebBrowser.this.onLoad(url);
                } else if (status == -2) {
                    WebBrowser.this.onError("error on page", -1);
                }
            }
        });
        this.internal = h;
        this.addComponent("Center", this.internal);
    }

    public static String createDataURI(byte[] data, String mime) {
        return "data:" + mime + ";base64," + Base64.encodeNoNewline(data);
    }

    public void onStart(String url) {
    }

    public void onLoad(String url) {
    }

    public BrowserNavigationCallback getBrowserNavigationCallback() {
        if (BrowserComponent.isNativeBrowserSupported()) {
            return ((BrowserComponent)this.getInternal()).getBrowserNavigationCallback();
        }
        return null;
    }

    public void setBrowserNavigationCallback(BrowserNavigationCallback callback) {
        if (BrowserComponent.isNativeBrowserSupported()) {
            ((BrowserComponent)this.getInternal()).setBrowserNavigationCallback(callback);
        }
    }

    public void onError(String message, int errorCode) {
    }

    public Component getInternal() {
        return this.internal;
    }

    public String getTitle() {
        if (this.isNative) {
            return ((BrowserComponent)this.internal).getTitle();
        }
        return ((HTMLComponent)this.internal).getTitle();
    }

    public String getURL() {
        if (this.isNative) {
            return ((BrowserComponent)this.internal).getURL();
        }
        return ((HTMLComponent)this.internal).getPageURL();
    }

    public void setURL(String url) {
        if (this.isNative) {
            ((BrowserComponent)this.internal).setURL(url);
        } else {
            ((HTMLComponent)this.internal).setPage(url);
        }
    }

    public void reload() {
        if (this.isNative) {
            ((BrowserComponent)this.internal).reload();
        } else {
            ((HTMLComponent)this.internal).refreshDOM();
        }
    }

    public void stop() {
        if (this.isNative) {
            ((BrowserComponent)this.internal).stop();
        } else {
            ((HTMLComponent)this.internal).cancel();
        }
    }

    public void destroy() {
        if (this.isNative) {
            ((BrowserComponent)this.internal).setPage("<html><body></body></html>", null);
            ((BrowserComponent)this.internal).destroy();
        }
        this.internal = null;
    }

    public void setPage(String html, String baseUrl) {
        this.page = html;
        if (this.isNative) {
            ((BrowserComponent)this.internal).setPage(html, baseUrl);
        } else {
            ((HTMLComponent)this.internal).setHTML(html, "UTF-8", null, true);
        }
    }

    public String getPage() {
        return this.page;
    }

    public String[] getPropertyNames() {
        return new String[]{"url", "html"};
    }

    public Class[] getPropertyTypes() {
        return new Class[]{String.class, String.class};
    }

    public String[] getPropertyTypeNames() {
        return new String[]{"String", "String"};
    }

    public Object getPropertyValue(String name) {
        if (name.equals("url")) {
            return this.getURL();
        }
        if (name.equals("html")) {
            return this.getPage();
        }
        return null;
    }

    public String setPropertyValue(String name, Object value) {
        if (name.equals("url")) {
            this.setURL((String)value);
            return null;
        }
        if (name.equals("html")) {
            this.setPage((String)value, null);
            return null;
        }
        return super.setPropertyValue(name, value);
    }

    class Loading
    implements Painter,
    Animation {
        private final Form f;
        private final InfiniteProgress progress = new InfiniteProgress();

        Loading(Form f) {
            this.f = f;
        }

        public void paint(Graphics g, Rectangle rect) {
            int x = this.f.getWidth() / 2 - this.progress.getPreferredW() / 2;
            int y = this.f.getHeight() / 2 - this.progress.getPreferredH() / 2;
            this.progress.setX(x);
            this.progress.setY(y);
            this.progress.setWidth(this.progress.getPreferredW());
            this.progress.setHeight(this.progress.getPreferredH());
            this.progress.paintComponent(g, true);
        }

        public boolean animate() {
            return true;
        }

        public void paint(Graphics g) {
            this.paint(g, null);
        }

        void install() {
            this.f.setGlassPane(this);
            this.f.registerAnimated(this);
        }

        void unInstall() {
            this.f.setGlassPane(null);
            this.f.deregisterAnimated(this);
        }
    }
}

