/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.db;

import com.codename1.db.Cursor;
import com.codename1.db.Row;
import com.codename1.db.RowExt;
import com.codename1.ui.Display;
import java.io.IOException;

public abstract class Database {
    public static boolean isCustomPathSupported() {
        return Display.getInstance().isDatabaseCustomPathSupported();
    }

    private static void validateDatabaseNameArgument(String databaseName) {
        if (!(Database.isCustomPathSupported() || databaseName.indexOf("/") == -1 && databaseName.indexOf("\\") == -1)) {
            throw new IllegalArgumentException("This platform does not support custom database paths.  The database name cannot contain file separators.");
        }
    }

    public static Database openOrCreate(String databaseName) throws IOException {
        Database.validateDatabaseNameArgument(databaseName);
        return Display.getInstance().openOrCreate(databaseName);
    }

    public static boolean exists(String databaseName) {
        Database.validateDatabaseNameArgument(databaseName);
        return Display.getInstance().exists(databaseName);
    }

    public static void delete(String databaseName) throws IOException {
        Database.validateDatabaseNameArgument(databaseName);
        Display.getInstance().delete(databaseName);
    }

    public static String getDatabasePath(String databaseName) {
        Database.validateDatabaseNameArgument(databaseName);
        return Display.getInstance().getDatabasePath(databaseName);
    }

    public static boolean wasNull(Row row) throws IOException {
        if (row instanceof RowExt) {
            return ((RowExt)row).wasNull();
        }
        return false;
    }

    public static boolean supportsWasNull(Row row) throws IOException {
        return row instanceof RowExt;
    }

    public abstract void beginTransaction() throws IOException;

    public abstract void commitTransaction() throws IOException;

    public abstract void rollbackTransaction() throws IOException;

    public abstract void close() throws IOException;

    public abstract void execute(String var1) throws IOException;

    public abstract void execute(String var1, String[] var2) throws IOException;

    public void execute(String sql, Object ... params) throws IOException {
        if (params == null) {
            this.execute(sql);
        } else {
            int len = params.length;
            String[] strParams = new String[len];
            for (int i = 0; i < len; ++i) {
                if (params[i] instanceof byte[]) {
                    throw new RuntimeException("Blobs aren't supported on this platform");
                }
                strParams[i] = params[i] == null ? null : params[i].toString();
            }
            this.execute(sql, strParams);
        }
    }

    public abstract Cursor executeQuery(String var1, String[] var2) throws IOException;

    public Cursor executeQuery(String sql, Object ... params) throws IOException {
        if (params == null || params.length == 0) {
            return this.executeQuery(sql);
        }
        int len = params.length;
        String[] strParams = new String[len];
        for (int i = 0; i < len; ++i) {
            if (params[i] instanceof byte[]) {
                throw new RuntimeException("Blobs aren't supported on this platform");
            }
            strParams[i] = params[i] == null ? null : params[i].toString();
        }
        return this.executeQuery(sql, strParams);
    }

    public abstract Cursor executeQuery(String var1) throws IOException;
}

