/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.facebook;

import com.codename1.components.SliderBridge;
import com.codename1.facebook.Album;
import com.codename1.facebook.FBObject;
import com.codename1.facebook.FacebookRESTService;
import com.codename1.facebook.Page;
import com.codename1.facebook.Photo;
import com.codename1.facebook.Post;
import com.codename1.facebook.User;
import com.codename1.io.AccessToken;
import com.codename1.io.ConnectionRequest;
import com.codename1.io.NetworkEvent;
import com.codename1.io.NetworkManager;
import com.codename1.io.Oauth2;
import com.codename1.io.Storage;
import com.codename1.io.services.ImageDownloadService;
import com.codename1.ui.Component;
import com.codename1.ui.Display;
import com.codename1.ui.EncodedImage;
import com.codename1.ui.Label;
import com.codename1.ui.Slider;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.geom.Dimension;
import com.codename1.ui.list.DefaultListModel;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class FaceBookAccess {
    private static final String TEMP_STORAGE = "FaceBookAccesstmp";
    private static String clientId = "132970916828080";
    private static String redirectURI = "https://www.codenameone.com/";
    private static String clientSecret = "6aaf4c8ea791f08ea15735eb647becfe";
    private static String[] permissions = new String[]{"public_profile", "email", "user_friends"};
    private static final FaceBookAccess instance = new FaceBookAccess();
    private static String token;
    private static String apiVersion;
    private Slider slider;
    private ConnectionRequest current;
    private final Vector responseCodeListeners = new Vector();

    private FaceBookAccess() {
    }

    public static FaceBookAccess getInstance() {
        return instance;
    }

    public static DefaultListModel createObjectsModel(DefaultListModel hashtablesModel, Class fbObjectClass) throws IllegalAccessException, InstantiationException {
        DefaultListModel<FBObject> model = new DefaultListModel<FBObject>();
        for (int i = 0; i < hashtablesModel.getSize(); ++i) {
            Hashtable table = (Hashtable)hashtablesModel.getItemAt(i);
            FBObject obj = (FBObject)fbObjectClass.newInstance();
            obj.copy(table);
            model.addItem(obj);
        }
        return model;
    }

    public static void setClientId(String clientId) {
        FaceBookAccess.clientId = clientId;
    }

    public static void setClientSecret(String clientSecret) {
        FaceBookAccess.clientSecret = clientSecret;
    }

    public static void setPermissions(String[] permissions) {
        FaceBookAccess.permissions = permissions;
    }

    public static void setRedirectURI(String redirectURI) {
        FaceBookAccess.redirectURI = redirectURI;
    }

    public static String getToken() {
        return token;
    }

    public static void setToken(String tok) {
        token = tok;
    }

    public static void logOut() {
        ConnectionRequest req = new ConnectionRequest();
        req.setPost(false);
        req.setUrl("https://www.facebook.com/logout.php?access_token=" + token + "&confirm=1&next=" + redirectURI);
        NetworkManager.getInstance().addToQueueAndWait(req);
        token = null;
    }

    public static void anonymousLogin(String appid, String clientSecret) {
        ConnectionRequest req = new ConnectionRequest();
        req.setPost(false);
        req.setUrl("https://graph.facebook.com/oauth/access_token");
        req.addArgument("client_id", appid);
        req.addArgument("client_secret", clientSecret);
        req.addArgument("grant_type", "client_credentials");
        NetworkManager.getInstance().addToQueueAndWait(req);
        if (req.getResponseData() != null) {
            token = new String(req.getResponseData());
            token = token.substring(token.indexOf(61) + 1);
        }
    }

    public static String getApiVersion() {
        return apiVersion;
    }

    public static void setApiVersion(String apiVersion) {
        if (!(apiVersion.equals("1.0") || apiVersion.equals("2.0") || apiVersion.equals("2.1"))) {
            throw new IllegalArgumentException("version must be one of the following 1.0, 2.0, 2.1");
        }
        FaceBookAccess.apiVersion = "v" + apiVersion;
    }

    public Oauth2 createOAuth() {
        String scope = "";
        if (permissions != null && permissions.length > 0) {
            for (String permission : permissions) {
                scope = scope + permission + ",";
            }
            scope = scope.substring(0, scope.length() - 1);
        }
        Hashtable<String, String> additionalParams = new Hashtable<String, String>();
        String p = Display.getInstance().getPlatformName();
        if (Display.getInstance().getProperty("OS", "SE").equals("SE") || p.equals("rim") || p.equals("me")) {
            additionalParams.put("display", "popup");
        } else {
            additionalParams.put("display", "touch");
        }
        return new Oauth2("https://www.facebook.com/dialog/oauth", clientId, redirectURI, scope, "https://graph.facebook.com/oauth/access_token", clientSecret, additionalParams);
    }

    public Component createAuthComponent(final ActionListener al) {
        return this.createOAuth().createAuthComponent(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (evt.getSource() instanceof String) {
                    token = (String)evt.getSource();
                }
                al.actionPerformed(evt);
            }
        });
    }

    public void showAuthentication(final ActionListener al) {
        this.createOAuth().showAuthentication(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (evt.getSource() instanceof String) {
                    token = (String)evt.getSource();
                }
                if (evt.getSource() instanceof AccessToken) {
                    AccessToken t = (AccessToken)evt.getSource();
                    token = t.getToken();
                }
                al.actionPerformed(evt);
            }
        });
    }

    public boolean isAuthenticated() {
        return token != null;
    }

    private void checkAuthentication() throws IOException {
        if (!this.isAuthenticated()) {
            throw new IOException("service is not authenticated, call public void authenticate(String clientId, String redirectURI, String [] permissions) first");
        }
    }

    public void setProgress(Slider slider) {
        this.slider = slider;
    }

    public void getFaceBookObject(String faceBookId, final ActionListener callback) throws IOException {
        this.checkAuthentication();
        final FacebookRESTService con = new FacebookRESTService(token, faceBookId, "", false);
        con.addResponseListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (!con.isAlive()) {
                    return;
                }
                if (callback != null) {
                    callback.actionPerformed(evt);
                }
            }
        });
        if (this.slider != null) {
            SliderBridge.bindProgress(con, this.slider);
        }
        for (int i = 0; i < this.responseCodeListeners.size(); ++i) {
            con.addResponseCodeListener((ActionListener)this.responseCodeListeners.elementAt(i));
        }
        this.current = con;
        NetworkManager.getInstance().addToQueue(con);
    }

    public void getFaceBookObject(String faceBookId, final ActionListener callback, boolean needToken, boolean async) throws IOException {
        if (needToken) {
            this.checkAuthentication();
        }
        final FacebookRESTService con = new FacebookRESTService(token, faceBookId, "", false);
        con.addResponseListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (!con.isAlive()) {
                    return;
                }
                if (callback != null) {
                    callback.actionPerformed(evt);
                }
            }
        });
        if (this.slider != null) {
            SliderBridge.bindProgress(con, this.slider);
        }
        for (int i = 0; i < this.responseCodeListeners.size(); ++i) {
            con.addResponseCodeListener((ActionListener)this.responseCodeListeners.elementAt(i));
        }
        this.current = con;
        if (async) {
            NetworkManager.getInstance().addToQueue(con);
        } else {
            NetworkManager.getInstance().addToQueueAndWait(con);
        }
    }

    public void getFaceBookObjectItems(String faceBookId, String itemsConnection, DefaultListModel feed, Hashtable params, ActionListener callback) throws IOException {
        this.checkAuthentication();
        FacebookRESTService con = new FacebookRESTService(token, faceBookId, itemsConnection, false);
        con.setResponseDestination(feed);
        con.addResponseListener(new Listener(con, callback));
        if (params != null) {
            Enumeration keys = params.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                con.addArgument(key, (String)params.get(key));
            }
        }
        if (this.slider != null) {
            SliderBridge.bindProgress(con, this.slider);
        }
        for (int i = 0; i < this.responseCodeListeners.size(); ++i) {
            con.addResponseCodeListener((ActionListener)this.responseCodeListeners.elementAt(i));
        }
        this.current = con;
        NetworkManager.getInstance().addToQueue(con);
    }

    public void getUser(String userId, final User user, final ActionListener callback) throws IOException {
        String id = userId;
        if (id == null) {
            id = "me";
        }
        this.getFaceBookObject(id, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Vector v = (Vector)((NetworkEvent)evt).getMetaData();
                Hashtable t = (Hashtable)v.elementAt(0);
                if (user != null) {
                    user.copy(t);
                }
                if (callback != null) {
                    callback.actionPerformed(evt);
                }
            }
        });
    }

    public User getUser(String userId) throws IOException {
        String id = userId;
        if (id == null) {
            id = "me";
        }
        final User user = new User();
        final Vector err = new Vector();
        this.addResponseCodeListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NetworkEvent ne = (NetworkEvent)evt;
                err.addElement(ne);
                FaceBookAccess.this.removeResponseCodeListener(this);
            }
        });
        this.getFaceBookObject(id, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Vector v = (Vector)((NetworkEvent)evt).getMetaData();
                Hashtable t = (Hashtable)v.elementAt(0);
                user.copy(t);
            }
        }, true, false);
        if (err.size() > 0) {
            throw new IOException(((NetworkEvent)err.elementAt(0)).getResponseCode() + ": " + ((NetworkEvent)err.elementAt(0)).getMessage());
        }
        return user;
    }

    public Page getPage(String pageId) throws IOException {
        final Page page = new Page();
        final Vector err = new Vector();
        this.addResponseCodeListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NetworkEvent ne = (NetworkEvent)evt;
                err.addElement(ne);
                FaceBookAccess.this.removeResponseCodeListener(this);
            }
        });
        this.getFaceBookObject(pageId, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Vector v = (Vector)((NetworkEvent)evt).getMetaData();
                Hashtable t = (Hashtable)v.elementAt(0);
                page.copy(t);
            }
        }, false, false);
        if (err.size() > 0) {
            throw new IOException(((NetworkEvent)err.elementAt(0)).getResponseCode() + ": " + ((NetworkEvent)err.elementAt(0)).getMessage());
        }
        return page;
    }

    public void getPost(String postId, final Post post, final ActionListener callback) throws IOException {
        this.getFaceBookObject(postId, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Vector v = (Vector)((NetworkEvent)evt).getMetaData();
                Hashtable t = (Hashtable)v.elementAt(0);
                if (post != null) {
                    post.copy(t);
                }
                if (callback != null) {
                    callback.actionPerformed(evt);
                }
            }
        });
    }

    public Post getPost(String postId, boolean needAuth) throws IOException {
        final Post post = new Post();
        final Vector err = new Vector();
        this.addResponseCodeListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NetworkEvent ne = (NetworkEvent)evt;
                err.addElement(ne);
                FaceBookAccess.this.removeResponseCodeListener(this);
            }
        });
        this.getFaceBookObject(postId, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Vector v = (Vector)((NetworkEvent)evt).getMetaData();
                Hashtable t = (Hashtable)v.elementAt(0);
                post.copy(t);
            }
        }, needAuth, false);
        if (err.size() > 0) {
            throw new IOException(((NetworkEvent)err.elementAt(0)).getResponseCode() + ": " + ((NetworkEvent)err.elementAt(0)).getMessage());
        }
        return post;
    }

    public void getPhoto(String photoId, final Photo photo, final ActionListener callback) throws IOException {
        this.getFaceBookObject(photoId, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Vector v = (Vector)((NetworkEvent)evt).getMetaData();
                Hashtable t = (Hashtable)v.elementAt(0);
                if (photo != null) {
                    photo.copy(t);
                }
                if (callback != null) {
                    callback.actionPerformed(evt);
                }
            }
        });
    }

    public Photo getPhoto(String photoId, boolean needAuth) throws IOException {
        final Photo photo = new Photo();
        final Vector err = new Vector();
        this.addResponseCodeListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NetworkEvent ne = (NetworkEvent)evt;
                err.addElement(ne);
                FaceBookAccess.this.removeResponseCodeListener(this);
            }
        });
        this.getFaceBookObject(photoId, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Vector v = (Vector)((NetworkEvent)evt).getMetaData();
                Hashtable t = (Hashtable)v.elementAt(0);
                photo.copy(t);
            }
        }, needAuth, false);
        if (err.size() > 0) {
            throw new IOException(((NetworkEvent)err.elementAt(0)).getResponseCode() + ": " + ((NetworkEvent)err.elementAt(0)).getMessage());
        }
        return photo;
    }

    public void getAlbum(String albumId, final Album album, final ActionListener callback) throws IOException {
        this.getFaceBookObject(albumId, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Vector v = (Vector)((NetworkEvent)evt).getMetaData();
                Hashtable t = (Hashtable)v.elementAt(0);
                if (album != null) {
                    album.copy(t);
                }
                if (callback != null) {
                    callback.actionPerformed(evt);
                }
            }
        });
    }

    public Album getAlbum(String albumId, boolean needAuth) throws IOException {
        final Album album = new Album();
        final Vector err = new Vector();
        this.addResponseCodeListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NetworkEvent ne = (NetworkEvent)evt;
                err.addElement(ne);
                FaceBookAccess.this.removeResponseCodeListener(this);
            }
        });
        this.getFaceBookObject(albumId, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Vector v = (Vector)((NetworkEvent)evt).getMetaData();
                Hashtable t = (Hashtable)v.elementAt(0);
                album.copy(t);
            }
        }, needAuth, false);
        if (err.size() > 0) {
            throw new IOException(((NetworkEvent)err.elementAt(0)).getResponseCode() + ": " + ((NetworkEvent)err.elementAt(0)).getMessage());
        }
        return album;
    }

    public void getNewsFeed(String userId, DefaultListModel feed, ActionListener callback) throws IOException {
        this.getNewsFeed(userId, feed, 13, callback);
    }

    public void getNewsFeed(String userId, DefaultListModel feed, int limit, ActionListener callback) throws IOException {
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("limit", "" + limit);
        this.getFaceBookObjectItems(userId, FacebookRESTService.HOME, feed, params, callback);
    }

    public void getWallFeed(String userId, DefaultListModel feed, ActionListener callback) throws IOException {
        this.getWallFeed(userId, feed, 13, callback);
    }

    public void getWallFeed(String userId, DefaultListModel feed, int limit, ActionListener callback) throws IOException {
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("limit", "" + limit);
        this.getFaceBookObjectItems(userId, FacebookRESTService.FEED, feed, params, callback);
    }

    public void getWallPosts(String userId, DefaultListModel feed, ActionListener callback) throws IOException {
        this.getWallPosts(userId, feed, 13, callback);
    }

    public void getWallPosts(String userId, DefaultListModel feed, int limit, ActionListener callback) throws IOException {
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("limit", "" + limit);
        this.getFaceBookObjectItems(userId, FacebookRESTService.POSTS, feed, params, callback);
    }

    public void getPicture(String id, Label label, Dimension toScale, boolean tempStorage) throws IOException {
        this.checkAuthentication();
        FacebookRESTService fb = new FacebookRESTService(token, id, FacebookRESTService.PICTURE, false);
        if (toScale != null) {
            fb.addArgument("width", "" + toScale.getWidth());
            fb.addArgument("height", "" + toScale.getHeight());
        } else {
            fb.addArgument("type", "small");
        }
        String cacheKey = id;
        if (tempStorage && !Storage.getInstance().exists(id)) {
            cacheKey = TEMP_STORAGE + id;
        }
        ImageDownloadService.createImageToStorage(fb.requestURL(), label, cacheKey, toScale);
    }

    public void getPicture(String id, ActionListener callback, Dimension toScale, boolean tempStorage) throws IOException {
        this.checkAuthentication();
        FacebookRESTService fb = new FacebookRESTService(token, id, FacebookRESTService.PICTURE, false);
        if (toScale != null) {
            fb.addArgument("width", "" + toScale.getWidth());
            fb.addArgument("height", "" + toScale.getHeight());
        } else {
            fb.addArgument("type", "small");
        }
        String cacheKey = id;
        if (tempStorage && !Storage.getInstance().exists(id)) {
            cacheKey = TEMP_STORAGE + id;
        }
        ImageDownloadService.createImageToStorage(fb.requestURL(), callback, cacheKey);
    }

    public EncodedImage getPictureAndWait(String id, Dimension toScale) {
        ImageDownloadService im = new ImageDownloadService(this.getImageURL(id, toScale), (ActionListener)null);
        NetworkManager.getInstance().addToQueueAndWait(im);
        return im.getResult();
    }

    public String getImageURL(String id, Dimension toScale) {
        try {
            this.checkAuthentication();
            FacebookRESTService fb = new FacebookRESTService(token, id, FacebookRESTService.PICTURE, false);
            if (toScale != null) {
                fb.addArgument("width", "" + toScale.getWidth());
                fb.addArgument("height", "" + toScale.getHeight());
            } else {
                fb.addArgument("type", "thumbnail");
            }
            return fb.requestURL();
        }
        catch (IOException err) {
            return null;
        }
    }

    public void getPicture(String id, Component targetList, int targetOffset, String targetKey, Dimension toScale, boolean tempStorage) throws IOException {
        this.checkAuthentication();
        FacebookRESTService fb = new FacebookRESTService(token, id, FacebookRESTService.PICTURE, false);
        if (toScale != null) {
            fb.addArgument("width", "" + toScale.getWidth());
            fb.addArgument("height", "" + toScale.getHeight());
        } else {
            fb.addArgument("type", "small");
        }
        String cacheKey = id;
        if (tempStorage && !Storage.getInstance().exists(id)) {
            cacheKey = TEMP_STORAGE + id;
        }
        ImageDownloadService.createImageToStorage(fb.requestURL(), targetList, targetOffset, targetKey, cacheKey, toScale, (byte)30);
    }

    public void getPhotoThumbnail(String photoId, ActionListener callback, boolean tempStorage) throws IOException {
        this.checkAuthentication();
        FacebookRESTService fb = new FacebookRESTService(token, photoId, FacebookRESTService.PICTURE, false);
        fb.addArgument("type", "small");
        String cacheKey = photoId;
        if (tempStorage && !Storage.getInstance().exists(photoId)) {
            cacheKey = TEMP_STORAGE + photoId;
        }
        ImageDownloadService.createImageToStorage(fb.requestURL(), callback, cacheKey);
    }

    public void getPhotoThumbnail(String photoId, Label label, Dimension toScale, boolean tempStorage) throws IOException {
        this.checkAuthentication();
        FacebookRESTService fb = new FacebookRESTService(token, photoId, FacebookRESTService.PICTURE, false);
        fb.addArgument("type", "thumbnail");
        String cacheKey = photoId;
        if (tempStorage && !Storage.getInstance().exists(photoId)) {
            cacheKey = TEMP_STORAGE + photoId;
        }
        ImageDownloadService.createImageToStorage(fb.requestURL(), label, cacheKey, toScale);
    }

    public void getUserFriends(String userId, DefaultListModel friends, ActionListener callback) throws IOException {
        this.getFaceBookObjectItems(userId, FacebookRESTService.FRIENDS, friends, null, callback);
    }

    public void getUserAlbums(String userId, DefaultListModel albums, ActionListener callback) throws IOException {
        this.getFaceBookObjectItems(userId, FacebookRESTService.ALBUMS, albums, null, callback);
    }

    public void getAlbumPhotos(String albumId, DefaultListModel photos, int offset, int limit, ActionListener callback) throws IOException {
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("limit", "" + limit);
        params.put("offset", "" + offset);
        this.getFaceBookObjectItems(albumId, FacebookRESTService.PHOTOS, photos, params, callback);
    }

    public void getPostComments(String postId, DefaultListModel comments, ActionListener callback) throws IOException {
        this.getFaceBookObjectItems(postId, FacebookRESTService.COMMENTS, comments, null, callback);
    }

    public void getUserInboxThreads(String userId, DefaultListModel threads, int limit, ActionListener callback) throws IOException {
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("limit", "" + limit);
        this.getFaceBookObjectItems(userId, FacebookRESTService.INBOX, threads, params, callback);
    }

    public void postOnWall(String userId, String message) throws IOException {
        this.postOnWall(userId, message, null);
    }

    public void postLike(String postId) throws IOException {
        this.postLike(postId, null);
    }

    public void postComment(String postId, String message) throws IOException {
        this.postComment(postId, message, null);
    }

    public void createNote(String userId, String subject, String message) throws IOException {
        this.createNote(userId, subject, message, null);
    }

    public void postOnWall(String userId, String message, ActionListener callback) throws IOException {
        this.checkAuthentication();
        FacebookRESTService con = new FacebookRESTService(token, userId, FacebookRESTService.FEED, true);
        con.addArgument("message", message);
        con.addResponseListener(new Listener(con, callback));
        if (this.slider != null) {
            SliderBridge.bindProgress(con, this.slider);
        }
        for (int i = 0; i < this.responseCodeListeners.size(); ++i) {
            con.addResponseCodeListener((ActionListener)this.responseCodeListeners.elementAt(i));
        }
        this.current = con;
        NetworkManager.getInstance().addToQueueAndWait(con);
    }

    public void postOnWall(String userId, String message, String name, String link, String description, String picture, String caption, ActionListener callback) throws IOException {
        this.checkAuthentication();
        FacebookRESTService con = new FacebookRESTService(token, userId, FacebookRESTService.FEED, true);
        if (message != null) {
            con.addArgument("message", message);
        }
        if (name != null) {
            con.addArgument("name", name);
        }
        if (link != null) {
            con.addArgument("link", link);
        }
        if (description != null) {
            con.addArgument("description", description);
        }
        if (picture != null) {
            con.addArgument("picture", picture);
        }
        if (caption != null) {
            con.addArgument("caption", caption);
        }
        con.addResponseListener(new Listener(con, callback));
        if (this.slider != null) {
            SliderBridge.bindProgress(con, this.slider);
        }
        for (int i = 0; i < this.responseCodeListeners.size(); ++i) {
            con.addResponseCodeListener((ActionListener)this.responseCodeListeners.elementAt(i));
        }
        this.current = con;
        NetworkManager.getInstance().addToQueueAndWait(con);
    }

    public void postLike(String postId, ActionListener callback) throws IOException {
        this.checkAuthentication();
        FacebookRESTService con = new FacebookRESTService(token, postId, FacebookRESTService.LIKES, true);
        con.addResponseListener(new Listener(con, callback));
        if (this.slider != null) {
            SliderBridge.bindProgress(con, this.slider);
        }
        for (int i = 0; i < this.responseCodeListeners.size(); ++i) {
            con.addResponseCodeListener((ActionListener)this.responseCodeListeners.elementAt(i));
        }
        this.current = con;
        NetworkManager.getInstance().addToQueueAndWait(con);
    }

    public void postComment(String postId, String message, ActionListener callback) throws IOException {
        this.checkAuthentication();
        FacebookRESTService con = new FacebookRESTService(token, postId, FacebookRESTService.COMMENTS, true);
        con.addResponseListener(new Listener(con, callback));
        con.addArgument("message", message);
        if (this.slider != null) {
            SliderBridge.bindProgress(con, this.slider);
        }
        for (int i = 0; i < this.responseCodeListeners.size(); ++i) {
            con.addResponseCodeListener((ActionListener)this.responseCodeListeners.elementAt(i));
        }
        this.current = con;
        NetworkManager.getInstance().addToQueueAndWait(con);
    }

    public void createNote(String userId, String subject, String message, ActionListener callback) throws IOException {
        this.checkAuthentication();
        FacebookRESTService con = new FacebookRESTService(token, userId, FacebookRESTService.NOTES, true);
        con.addResponseListener(new Listener(con, callback));
        con.addArgument("subject", subject);
        con.addArgument("message", message);
        if (this.slider != null) {
            SliderBridge.bindProgress(con, this.slider);
        }
        for (int i = 0; i < this.responseCodeListeners.size(); ++i) {
            con.addResponseCodeListener((ActionListener)this.responseCodeListeners.elementAt(i));
        }
        this.current = con;
        System.out.println(con.getUrl());
        NetworkManager.getInstance().addToQueueAndWait(con);
    }

    public void getUserNotifications(String userId, String startTime, boolean includeRead, DefaultListModel notifications, final ActionListener callback) throws IOException {
        this.checkAuthentication();
        final FacebookRESTService con = new FacebookRESTService(token, "https://api.facebook.com/method/notifications.getList", false);
        con.addArgument("start_time", startTime);
        con.addArgument("include_read", includeRead ? "true" : "false");
        con.addArgument("format", "json");
        con.setResponseDestination(notifications);
        con.addResponseListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (!con.isAlive()) {
                    return;
                }
                if (callback != null) {
                    callback.actionPerformed(evt);
                }
            }
        });
        if (this.slider != null) {
            SliderBridge.bindProgress(con, this.slider);
        }
        for (int i = 0; i < this.responseCodeListeners.size(); ++i) {
            con.addResponseCodeListener((ActionListener)this.responseCodeListeners.elementAt(i));
        }
        this.current = con;
        NetworkManager.getInstance().addToQueue(con);
    }

    public void getUsersDetails(String[] usersIds, String[] fields, final ActionListener callback) throws IOException {
        int i;
        this.checkAuthentication();
        final FacebookRESTService con = new FacebookRESTService(token, "https://api.facebook.com/method/users.getInfo", false);
        String ids = usersIds[0];
        int ulen = usersIds.length;
        for (int i2 = 1; i2 < ulen; ++i2) {
            ids = ids + "," + usersIds[i2];
        }
        con.addArgumentNoEncoding("uids", ids);
        String fieldsStr = fields[0];
        int flen = fields.length;
        for (i = 1; i < flen; ++i) {
            fieldsStr = fieldsStr + "," + fields[i];
        }
        con.addArgumentNoEncoding("fields", fieldsStr);
        con.addArgument("format", "json");
        con.addResponseListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (!con.isAlive()) {
                    return;
                }
                if (callback != null) {
                    callback.actionPerformed(evt);
                }
            }
        });
        if (this.slider != null) {
            SliderBridge.bindProgress(con, this.slider);
        }
        for (i = 0; i < this.responseCodeListeners.size(); ++i) {
            con.addResponseCodeListener((ActionListener)this.responseCodeListeners.elementAt(i));
        }
        this.current = con;
        NetworkManager.getInstance().addToQueue(con);
    }

    public void getUserEvents(String userId, DefaultListModel events, ActionListener callback) throws IOException {
        this.getFaceBookObjectItems(userId, FacebookRESTService.EVENTS, events, null, callback);
    }

    public void search(String objectType, String query, DefaultListModel results, ActionListener callback) throws IOException {
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("q", query);
        params.put("type", objectType);
        this.getFaceBookObjectItems("search", "", results, params, callback);
    }

    public void killCurrentRequest() {
        this.current.kill();
    }

    public void addResponseCodeListener(ActionListener a) {
        this.responseCodeListeners.addElement(a);
    }

    public void removeResponseCodeListener(ActionListener a) {
        this.responseCodeListeners.removeElement(a);
    }

    public void cleanTempStorage() {
        for (String key : Storage.getInstance().listEntries()) {
            if (!key.startsWith(TEMP_STORAGE)) continue;
            Storage.getInstance().deleteStorageFile(key);
        }
    }

    static {
        apiVersion = "v2.0";
    }

    class Listener
    implements ActionListener {
        private final FacebookRESTService con;
        private final ActionListener callback;

        Listener(FacebookRESTService con, ActionListener callback) {
            this.con = con;
            this.callback = callback;
        }

        public void actionPerformed(ActionEvent evt) {
            if (!this.con.isAlive()) {
                return;
            }
            if (this.callback != null) {
                this.callback.actionPerformed(evt);
            }
        }
    }
}

