/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.impl;

import com.codename1.components.WebBrowser;
import com.codename1.impl.FullScreenAdService;
import com.codename1.io.ConnectionRequest;
import com.codename1.io.JSONParser;
import com.codename1.io.Log;
import com.codename1.io.NetworkManager;
import com.codename1.io.services.ImageDownloadService;
import com.codename1.ui.BrowserComponent;
import com.codename1.ui.Button;
import com.codename1.ui.Component;
import com.codename1.ui.Display;
import com.codename1.ui.Image;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.events.BrowserNavigationCallback;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Vector;

public class VServAds
extends FullScreenAdService {
    public static final int CAT_ID_ACTION_ADVENTURE = 18;
    public static final int CAT_ID_SPORTS = 19;
    public static final int CAT_ID_MOVIES = 20;
    public static final int CAT_ID_KIDS = 21;
    public static final int CAT_ID_RACING = 22;
    public static final int CAT_ID_ARCADE = 23;
    public static final int CAT_ID_ADULT = 24;
    public static final int CAT_ID_STRATEGY = 25;
    public static final int CAT_ID_TRAVEL = 27;
    public static final int CAT_ID_EDUCATION = 28;
    public static final int CAT_ID_PRODUCTIVITY = 29;
    public static final int CAT_ID_ENTERTAINMENT = 30;
    public static final int CAT_ID_MULTIMEDIA = 31;
    public static final int CAT_ID_SPIRITUAL = 32;
    public static final int CAT_ID_UTILITY = 33;
    public static final int CAT_ID_SOCIAL_NETWORKING = 34;
    public static final int CAT_ID_HEALTH = 35;
    public static final int CAT_ID_OTHERS = 36;
    private static final String URL = "https://a.vserv.mobi/delivery/adapi.php";
    boolean failed;
    private String zoneId = "6216";
    private String countryCode;
    private String networkCode;
    private String locale = "en";
    private int category = 29;
    private String destination;
    private String imageURL;
    private String contentType;
    private int backgroundColor;
    private String renderNotify;
    private String actionNotify;

    protected ConnectionRequest createAdRequest() {
        ConnectionRequest con = new ConnectionRequest(){

            protected void handleErrorResponseCode(int code, String message) {
                VServAds.this.failed = true;
            }

            protected void handleException(Exception err) {
                VServAds.this.failed = true;
                Log.e(err);
            }

            private String getString(Hashtable h, String n) {
                Object v = h.get(n);
                if (v == null) {
                    return null;
                }
                if (v instanceof Vector) {
                    return (String)((Vector)v).elementAt(0);
                }
                return (String)v;
            }

            protected void readResponse(InputStream input) throws IOException {
                JSONParser parser = new JSONParser();
                Hashtable<String, Object> h = parser.parse(new InputStreamReader(input, "UTF-8"));
                if (h.size() == 0) {
                    return;
                }
                VServAds.this.backgroundColor = Integer.parseInt((String)((Hashtable)((Vector)h.get("style")).elementAt(0)).get("background-color"), 16);
                Hashtable actionHash = (Hashtable)((Vector)h.get("action")).elementAt(0);
                VServAds.this.actionNotify = this.getString(actionHash, "notify");
                if (VServAds.this.actionNotify == null) {
                    VServAds.this.actionNotify = this.getString(actionHash, "notify-once");
                }
                VServAds.this.destination = (String)actionHash.get("data");
                Hashtable renderHash = (Hashtable)((Vector)h.get("render")).elementAt(0);
                VServAds.this.contentType = (String)renderHash.get("type");
                VServAds.this.renderNotify = this.getString(renderHash, "notify");
                if (VServAds.this.renderNotify == null) {
                    VServAds.this.renderNotify = this.getString(renderHash, "notify-once");
                }
                VServAds.this.imageURL = (String)renderHash.get("data");
            }
        };
        con.setUrl(URL);
        con.setPost(false);
        con.addArgument("zoneid", this.getZoneId());
        con.addArgument("ua", Display.getInstance().getProperty("User-Agent", ""));
        con.addArgument("app", "1");
        con.addArgument("aid", Display.getInstance().getProperty("androidId", ""));
        con.addArgument("uuid", Display.getInstance().getProperty("uuid", ""));
        con.addArgument("im", Display.getInstance().getProperty("imei", ""));
        con.addArgument("sw", "" + Display.getInstance().getDisplayWidth());
        con.addArgument("sh", "" + Display.getInstance().getDisplayHeight());
        con.addArgument("mn", Display.getInstance().getProperty("AppName", ""));
        con.addArgument("vs3", "1");
        con.addArgument("partnerid", "1");
        con.addArgument("zc", "" + this.category);
        if (this.countryCode != null) {
            con.addArgument("cc", this.countryCode);
        }
        if (this.networkCode != null) {
            con.addArgument("nc", this.networkCode);
        }
        if (this.locale != null) {
            con.addArgument("lc", this.locale);
        }
        return con;
    }

    protected boolean hasPendingAd() {
        return this.imageURL != null;
    }

    protected void clearPendingAd() {
        this.imageURL = null;
        this.renderNotify = null;
    }

    protected Component getPendingAd() {
        if (this.imageURL == null) {
            return null;
        }
        if (this.renderNotify != null && this.renderNotify.length() > 0) {
            ConnectionRequest c = new ConnectionRequest();
            c.setFailSilently(true);
            c.setUrl(this.renderNotify);
            c.setPost(false);
            NetworkManager.getInstance().addToQueue(c);
        }
        if ("image".equalsIgnoreCase(this.contentType)) {
            Button adComponent = new Button(){

                public void setIcon(Image icon) {
                    if (icon != null && VServAds.this.isScaleMode()) {
                        icon = icon.scaledWidth(Display.getInstance().getDisplayWidth());
                    }
                    super.setIcon(icon);
                }
            };
            adComponent.setUIID("Container");
            adComponent.getStyle().setBgColor(this.backgroundColor);
            adComponent.getStyle().setOpacity(255);
            ImageDownloadService imd = new ImageDownloadService(this.imageURL, adComponent);
            NetworkManager.getInstance().addToQueueAndWait(imd);
            return adComponent;
        }
        WebBrowser wb = new WebBrowser();
        if (wb.getInternal() instanceof BrowserComponent) {
            BrowserComponent bc = (BrowserComponent)wb.getInternal();
            bc.setBrowserNavigationCallback(new BrowserNavigationCallback(){

                public boolean shouldNavigate(final String url) {
                    VServAds.this.unlock(new ActionListener(){

                        public void actionPerformed(ActionEvent evt) {
                            Display.getInstance().execute(url);
                        }
                    });
                    return false;
                }
            });
        }
        wb.setURL(this.imageURL);
        return wb;
    }

    protected String getAdDestination() {
        if (this.actionNotify != null && this.actionNotify.length() > 0) {
            ConnectionRequest c = new ConnectionRequest();
            c.setFailSilently(true);
            c.setUrl(this.actionNotify);
            c.setPost(false);
            NetworkManager.getInstance().addToQueue(c);
        }
        return this.destination;
    }

    protected boolean failed() {
        return this.failed;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public void setNetworkCode(String networkCode) {
        this.networkCode = networkCode;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public int getCategory() {
        return this.category;
    }

    public void setCategory(int category) {
        this.category = category;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(String zoneId) {
        this.zoneId = zoneId;
    }

    public boolean isAllowSkipping() {
        return true;
    }
}

