/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.io;

import com.codename1.compat.java.util.Objects;
import com.codename1.io.Externalizable;
import com.codename1.io.Util;
import com.codename1.util.DateUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;

public class AccessToken
implements Externalizable {
    private String token;
    private String expires;
    private Date expiryDate;
    private String refreshToken;
    private String identityToken;

    public AccessToken(String token, String expires) {
        this(token, expires, null);
    }

    public AccessToken(String token, String expires, String refreshToken) {
        this(token, expires, refreshToken, null);
    }

    public AccessToken(String token, String expires, String refreshToken, String identityToken) {
        this.token = token;
        this.expires = expires;
        this.expiryDate = AccessToken.parseDate(expires);
        this.refreshToken = refreshToken;
        this.identityToken = identityToken;
    }

    public AccessToken() {
    }

    public static AccessToken createWithExpiryDate(String token, Date expiryDate) {
        AccessToken out = new AccessToken(token, null);
        out.expiryDate = expiryDate;
        return out;
    }

    private static Long parseLong(String str) {
        if (str == null) {
            return null;
        }
        int decimalPos = str.indexOf(46);
        if (decimalPos >= 0) {
            str = str.substring(0, decimalPos);
        }
        for (char c : str.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return null;
        }
        return Long.parseLong(str);
    }

    private static Date parseDate(String dateStr) {
        Long longExpires = AccessToken.parseLong(dateStr);
        if (longExpires != null) {
            long l = longExpires;
            if (l == 0L) {
                return null;
            }
            return new Date(System.currentTimeMillis() + l * 1000L);
        }
        return null;
    }

    public String getToken() {
        return this.token;
    }

    public String getExpires() {
        return this.expires;
    }

    public int getVersion() {
        return 4;
    }

    public void externalize(DataOutputStream out) throws IOException {
        Util.writeUTF(this.token, out);
        Util.writeUTF(this.expires, out);
        Util.writeObject(this.expiryDate, out);
        Util.writeUTF(this.refreshToken, out);
        Util.writeUTF(this.identityToken, out);
    }

    public void internalize(int version, DataInputStream in) throws IOException {
        this.token = Util.readUTF(in);
        this.expires = Util.readUTF(in);
        if (version >= 2) {
            this.expiryDate = (Date)Util.readObject(in);
        }
        if (version >= 3) {
            this.refreshToken = Util.readUTF(in);
        }
        if (version >= 4) {
            this.identityToken = Util.readUTF(in);
        }
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getObjectId() {
        return "AccessToken";
    }

    public boolean equals(Object obj) {
        if (obj instanceof AccessToken) {
            AccessToken tok = (AccessToken)obj;
            return Objects.equals(this.token, tok.token) && Objects.equals(this.expiryDate, tok.expiryDate);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int hash = 3;
        hash = 53 * hash + (this.token != null ? this.token.hashCode() : 0);
        hash = 53 * hash + (this.expiryDate != null ? this.expiryDate.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return "AccessToken {" + this.token + ", expires=" + this.expiryDate + "}";
    }

    public Date getExpiryDate() {
        return this.expiryDate;
    }

    public void setExpiryDate(Date date) {
        this.expiryDate = date;
    }

    public boolean isExpired() {
        return this.expiryDate != null && DateUtil.compare(this.expiryDate, new Date()) < 0;
    }

    public String getIdentityToken() {
        return this.identityToken;
    }

    public void setIdentityToken(String identityToken) {
        this.identityToken = identityToken;
    }
}

