/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.io;

import com.codename1.io.IOProgressListener;
import com.codename1.io.Util;
import com.codename1.ui.Display;
import java.io.IOException;
import java.io.InputStream;

public class BufferedInputStream
extends InputStream {
    private static int streamCount = 0;
    private static int defaultBufferSize = 8192;
    private int actualAvailable = defaultBufferSize;
    private Object connection;
    private InputStream in;
    private byte[] buf;
    private IOProgressListener progressListener;
    private boolean disableBuffering;
    private boolean closed;
    private boolean stopped;
    private int count;
    private long lastActivityTime;
    private int totalBytesRead;
    private boolean printInput;
    private final String name;
    private int yield = -1;
    private long elapsedSinceLastYield;
    private int pos;
    private int markpos = -1;
    private int marklimit;

    public BufferedInputStream(InputStream in) {
        this(in, defaultBufferSize);
    }

    public BufferedInputStream(InputStream in, String name) {
        this(in, defaultBufferSize, name);
    }

    public BufferedInputStream(InputStream in, int size) {
        this(in, size, "unnamed");
    }

    public BufferedInputStream(InputStream in, int size, String name) {
        this.in = in;
        if (size <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.buf = new byte[size];
        this.name = name;
        Util.getImplementation().logStreamCreate(name, true, ++streamCount);
    }

    public static int getDefaultBufferSize() {
        return defaultBufferSize;
    }

    public static void setDefaultBufferSize(int aDefaultBufferSize) {
        defaultBufferSize = aDefaultBufferSize;
    }

    public String getName() {
        return this.name;
    }

    private InputStream getInIfOpen() throws IOException {
        InputStream input = this.in;
        if (input == null) {
            throw new IOException("Stream closed");
        }
        return input;
    }

    private byte[] getBufIfOpen() throws IOException {
        byte[] buffer = this.buf;
        if (buffer == null) {
            throw new IOException("Stream closed");
        }
        return buffer;
    }

    private void fill() throws IOException {
        byte[] buffer = this.getBufIfOpen();
        if (this.markpos < 0) {
            this.pos = 0;
        } else if (this.pos >= buffer.length) {
            if (this.markpos > 0) {
                int sz = this.pos - this.markpos;
                System.arraycopy(buffer, this.markpos, buffer, 0, sz);
                this.pos = sz;
                this.markpos = 0;
            } else if (buffer.length >= this.marklimit) {
                this.markpos = -1;
                this.pos = 0;
            } else {
                int nsz = this.pos * 2;
                if (nsz > this.marklimit) {
                    nsz = this.marklimit;
                }
                byte[] nbuf = new byte[nsz];
                System.arraycopy(buffer, 0, nbuf, 0, this.pos);
                if (buffer != this.buf) {
                    throw new IOException("Stream closed");
                }
                this.buf = nbuf;
                buffer = nbuf;
            }
        }
        this.count = this.pos;
        if (this.actualAvailable < 0) {
            return;
        }
        int sizeOfBuffer = buffer.length - this.pos;
        int n = this.getInIfOpen().read(buffer, this.pos, sizeOfBuffer);
        if (n > 0) {
            this.count = n + this.pos;
        } else if (n < 0) {
            this.actualAvailable = -1;
        }
    }

    public InputStream getInternal() {
        return this.in;
    }

    public synchronized int read() throws IOException {
        if (this.stopped) {
            return -1;
        }
        this.lastActivityTime = System.currentTimeMillis();
        if (this.disableBuffering) {
            int v = this.getInIfOpen().read();
            if (this.printInput && v > -1) {
                System.out.print((char)v);
            }
            ++this.totalBytesRead;
            this.fireProgress();
            return v;
        }
        if (this.pos >= this.count) {
            this.fill();
            if (this.pos >= this.count) {
                return -1;
            }
        }
        ++this.totalBytesRead;
        this.fireProgress();
        int v = this.getBufIfOpen()[this.pos++] & 0xFF;
        if (this.printInput) {
            System.out.print((char)v);
        }
        return v;
    }

    private void fireProgress() {
        if (this.progressListener != null) {
            this.progressListener.ioStreamUpdate(this, this.totalBytesRead);
        }
    }

    private int read1(byte[] b, int off, int len) throws IOException {
        int avail = this.count - this.pos;
        if (avail <= 0) {
            if (len >= this.getBufIfOpen().length && this.markpos < 0) {
                int val = this.getInIfOpen().read(b, off, len);
                if (val < 0) {
                    this.actualAvailable = -1;
                } else if (this.printInput) {
                    System.out.print(new String(b, off, val));
                }
                return val;
            }
            this.fill();
            avail = this.count - this.pos;
            if (avail <= 0) {
                return -1;
            }
        }
        int cnt = avail < len ? avail : len;
        System.arraycopy(this.getBufIfOpen(), this.pos, b, off, cnt);
        if (this.printInput) {
            System.out.print(new String(b, off, cnt));
        }
        this.pos += cnt;
        return cnt;
    }

    private void yieldTime() {
        long time = System.currentTimeMillis();
        if (time - this.elapsedSinceLastYield > 300L) {
            try {
                Thread.sleep(this.yield);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.elapsedSinceLastYield = time;
        }
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (this.stopped) {
            return -1;
        }
        if (this.yield > -1 && !Display.getInstance().isEdt()) {
            this.yieldTime();
        }
        this.lastActivityTime = System.currentTimeMillis();
        if (this.disableBuffering) {
            int v = this.getInIfOpen().read(b, off, len);
            if (v > -1) {
                if (this.printInput) {
                    System.out.print(new String(b, off, v));
                }
                this.totalBytesRead += v;
                this.fireProgress();
            }
            return v;
        }
        this.getBufIfOpen();
        if ((off | len | off + len | b.length - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int n = 0;
        while (true) {
            InputStream input;
            if (this.stopped) {
                return -1;
            }
            this.lastActivityTime = System.currentTimeMillis();
            int nread = this.read1(b, off + n, len - n);
            if (nread <= 0) {
                n = n == 0 ? nread : n;
                break;
            }
            if ((n += nread) >= len || (input = this.in) != null && this.superAvailable() <= 0) break;
            if (this.yield <= -1 || Display.getInstance().isEdt()) continue;
            this.yieldTime();
        }
        if (n > 0) {
            this.totalBytesRead += n;
            this.fireProgress();
        }
        this.lastActivityTime = System.currentTimeMillis();
        return n;
    }

    public synchronized long skip(long n) throws IOException {
        if (this.disableBuffering) {
            long v = this.getInIfOpen().skip(n);
            this.totalBytesRead = (int)((long)this.totalBytesRead + v);
            this.fireProgress();
            return v;
        }
        this.getBufIfOpen();
        if (n <= 0L) {
            return 0L;
        }
        long avail = this.count - this.pos;
        if (avail <= 0L) {
            if (this.markpos < 0) {
                return this.getInIfOpen().skip(n);
            }
            this.fill();
            avail = this.count - this.pos;
            if (avail <= 0L) {
                return 0L;
            }
        }
        long skipped = avail < n ? avail : n;
        this.pos = (int)((long)this.pos + skipped);
        this.totalBytesRead += (int)skipped;
        this.fireProgress();
        this.lastActivityTime = System.currentTimeMillis();
        return skipped;
    }

    public synchronized int available() throws IOException {
        if (this.disableBuffering) {
            return this.available();
        }
        return this.superAvailable() + (this.count - this.pos);
    }

    public synchronized void mark(int readlimit) {
        this.marklimit = readlimit;
        this.markpos = this.pos;
    }

    public synchronized void reset() throws IOException {
        this.getBufIfOpen();
        if (this.markpos < 0) {
            throw new IOException("Resetting to invalid mark");
        }
        this.pos = this.markpos;
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    private int superAvailable() {
        try {
            if (this.actualAvailable < 0) {
                return -1;
            }
            return this.in.available();
        }
        catch (IOException err) {
            return this.actualAvailable;
        }
    }

    public void close() throws IOException {
        block4: {
            byte[] buffer;
            if (this.closed) {
                Util.getImplementation().logStreamDoubleClose(this.name, true);
                return;
            }
            this.closed = true;
            Util.getImplementation().logStreamClose(this.name, true, --streamCount);
            if (this.connection != null) {
                Util.getImplementation().cleanup(this.connection);
            }
            do {
                buffer = this.buf;
                if (this.buf == null) break block4;
            } while (this.buf != buffer);
            this.buf = null;
            InputStream input = this.in;
            this.in = null;
            if (input != null) {
                input.close();
            }
            return;
        }
    }

    public long getLastActivityTime() {
        return this.lastActivityTime;
    }

    public int getTotalBytesRead() {
        return this.totalBytesRead;
    }

    public void setProgressListener(IOProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public Object getConnection() {
        return this.connection;
    }

    public void setConnection(Object connection) {
        this.connection = connection;
    }

    public boolean isDisableBuffering() {
        return this.disableBuffering;
    }

    public void setDisableBuffering(boolean disableBuffering) {
        this.disableBuffering = disableBuffering;
    }

    public boolean isPrintInput() {
        return this.printInput;
    }

    public void setPrintInput(boolean printInput) {
        this.printInput = printInput;
    }

    public int getYield() {
        return this.yield;
    }

    public void setYield(int yield) {
        this.yield = yield;
    }

    public void stop() {
        this.stopped = true;
    }
}

