/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Vector;

public class CSVParser {
    private final char separatorChar;
    private Reader currentReader;
    private final char[] buffer = new char[8192];
    private int bufferSize = -1;
    private int bufferOffset;

    public CSVParser() {
        this(',');
    }

    public CSVParser(char separatorChar) {
        this.separatorChar = separatorChar;
    }

    public String[][] parse(InputStream r) throws IOException {
        return this.parse(new InputStreamReader(r));
    }

    public String[][] parse(InputStream r, String encoding) throws IOException {
        return this.parse(new InputStreamReader(r, encoding));
    }

    private int nextChar() throws IOException {
        int response = this.peekNextChar();
        ++this.bufferOffset;
        return response;
    }

    private int peekNextChar() throws IOException {
        if (this.bufferOffset >= this.bufferSize) {
            this.bufferSize = this.currentReader.read(this.buffer);
            if (this.bufferSize == -1) {
                return -1;
            }
            this.bufferOffset = 0;
        }
        char response = this.buffer[this.bufferOffset];
        return response;
    }

    public String[][] parse(Reader r) throws IOException {
        this.currentReader = r;
        StringBuilder stringBuf = new StringBuilder();
        boolean isQuoteMode = false;
        Vector returnValue = new Vector();
        Vector<String> currentVector = new Vector<String>();
        returnValue.addElement(currentVector);
        int currentChar = this.nextChar();
        while (currentChar > -1) {
            if (isQuoteMode) {
                if (currentChar == 34) {
                    int next = this.peekNextChar();
                    if (next == 34) {
                        stringBuf.append('\"');
                        this.nextChar();
                    } else {
                        isQuoteMode = false;
                    }
                } else {
                    stringBuf.append((char)currentChar);
                }
            } else {
                if (stringBuf.length() == 0 && currentChar == 34) {
                    isQuoteMode = true;
                    currentChar = this.nextChar();
                    continue;
                }
                if (currentChar == this.separatorChar) {
                    currentVector.addElement(stringBuf.toString());
                    stringBuf.setLength(0);
                    currentChar = this.nextChar();
                    continue;
                }
                if (currentChar == 10 || currentChar == 13) {
                    while (currentChar == 10 || currentChar == 13) {
                        currentChar = this.nextChar();
                    }
                    currentVector.addElement(stringBuf.toString());
                    stringBuf.setLength(0);
                    currentVector = new Vector();
                    returnValue.addElement(currentVector);
                    continue;
                }
                stringBuf.append((char)currentChar);
            }
            currentChar = this.nextChar();
        }
        if (stringBuf.length() > 0) {
            currentVector.addElement(stringBuf.toString());
        }
        String[][] actualReturnValue = new String[returnValue.size()][];
        int arlen = actualReturnValue.length;
        for (int iter = 0; iter < arlen; ++iter) {
            Vector e = (Vector)returnValue.elementAt(iter);
            actualReturnValue[iter] = new String[e.size()];
            int arlen2 = actualReturnValue[iter].length;
            for (int i = 0; i < arlen2; ++i) {
                actualReturnValue[iter][i] = (String)e.elementAt(i);
            }
        }
        this.currentReader.close();
        this.currentReader = null;
        return actualReturnValue;
    }
}

