/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.io;

import com.codename1.io.Storage;
import com.codename1.ui.Display;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CacheMap {
    private int cacheSize = 10;
    private final Hashtable memoryCache = new Hashtable();
    private final Hashtable weakCache = new Hashtable();
    private int storageCacheSize = 0;
    private Vector storageCacheContentVec;
    private String cachePrefix = "";
    private boolean alwaysStore;
    private final int storageKey = -1;

    public CacheMap() {
    }

    public CacheMap(String prefix) {
        this.cachePrefix = prefix;
    }

    private Vector getStorageCacheContent() {
        if (this.storageCacheContentVec == null) {
            this.storageCacheContentVec = (Vector)Storage.getInstance().readObject("$CACHE$Idx" + this.cachePrefix);
            if (this.storageCacheContentVec == null) {
                this.storageCacheContentVec = new Vector();
            }
        }
        return this.storageCacheContentVec;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public void put(Object key, Object value) {
        if (this.cacheSize <= this.memoryCache.size()) {
            Enumeration e = this.memoryCache.keys();
            long oldest = System.currentTimeMillis();
            Object oldestKey = null;
            Object[] oldestValue = null;
            while (e.hasMoreElements()) {
                Object currentKey = e.nextElement();
                Object[] currentValue = (Object[])this.memoryCache.get(currentKey);
                long currentAge = (Long)currentValue[0];
                if (currentAge > oldest && oldestValue != null) continue;
                oldest = currentAge;
                oldestKey = currentKey;
                oldestValue = currentValue;
            }
            this.placeInStorageCache(oldestKey, oldest, oldestValue[1]);
            this.weakCache.put(oldestKey, Display.getInstance().createSoftWeakRef(oldestValue[1]));
            this.memoryCache.remove(oldestKey);
        }
        long lastAccess = System.currentTimeMillis();
        this.memoryCache.put(key, new Object[]{lastAccess, value});
        if (this.alwaysStore) {
            this.placeInStorageCache(key, lastAccess, value);
        }
    }

    public void delete(Object key) {
        this.memoryCache.remove(key);
        this.weakCache.remove(key);
        Vector storageCacheContent = this.getStorageCacheContent();
        int s = storageCacheContent.size();
        for (int iter = 0; iter < s; ++iter) {
            Object[] obj = (Object[])storageCacheContent.elementAt(iter);
            if (!obj[1].equals(key)) continue;
            Storage.getInstance().deleteStorageFile("$CACHE$" + this.cachePrefix + key);
            obj[0] = Long.MIN_VALUE;
            obj[1] = obj[0];
            Storage.getInstance().writeObject("$CACHE$Idx" + this.cachePrefix, storageCacheContent);
            return;
        }
    }

    public Object get(Object key) {
        Object[] o = (Object[])this.memoryCache.get(key);
        if (o != null) {
            return o[1];
        }
        Object ref = this.weakCache.get(key);
        if (ref != null && (ref = Display.getInstance().extractHardRef(ref)) != null) {
            this.put(key, ref);
            return ref;
        }
        if (this.storageCacheSize > 0) {
            Vector storageCacheContent = this.getStorageCacheContent();
            for (int iter = 0; iter < storageCacheContent.size(); ++iter) {
                Object[] obj = (Object[])storageCacheContent.elementAt(iter);
                if (!obj[1].equals(key)) continue;
                Vector v = (Vector)Storage.getInstance().readObject("$CACHE$" + this.cachePrefix + key);
                if (v != null) {
                    Object val = v.elementAt(0);
                    this.put(key, val);
                    return val;
                }
                return null;
            }
        }
        return null;
    }

    public void clearAllCache() {
        this.clearMemoryCache();
        this.clearStorageCache();
    }

    public void clearMemoryCache() {
        this.memoryCache.clear();
        this.weakCache.clear();
    }

    private void placeInStorageCache(Object key, long lastAccessed, Object value) {
        if (this.storageCacheSize < 1) {
            return;
        }
        Vector storageCacheContent = this.getStorageCacheContent();
        int vecSize = storageCacheContent.size();
        for (int iter = 0; iter < vecSize; ++iter) {
            Object[] index = (Object[])storageCacheContent.elementAt(iter);
            Object indexKey = index[1];
            if (!indexKey.equals(key)) continue;
            this.placeInStorageCache(iter, key, lastAccessed, value);
            return;
        }
        if (storageCacheContent.size() < this.storageCacheSize) {
            this.placeInStorageCache(storageCacheContent.size(), key, lastAccessed, value);
        } else {
            long smallest = Long.MAX_VALUE;
            int offset = 0;
            for (int iter = 0; iter < vecSize; ++iter) {
                Object[] index = (Object[])storageCacheContent.elementAt(iter);
                long current = (Long)index[0];
                if (smallest <= current) continue;
                smallest = current;
                offset = iter;
            }
            this.placeInStorageCache(offset, key, lastAccessed, value);
        }
    }

    private void placeInStorageCache(int offset, Object key, long lastAccessed, Object value) {
        Vector<Object> v = new Vector<Object>();
        v.addElement(value);
        Long l = lastAccessed;
        v.addElement(l);
        v.addElement(key);
        Storage.getInstance().writeObject("$CACHE$" + this.cachePrefix + key.toString(), v);
        Vector storageCacheContent = this.getStorageCacheContent();
        if (storageCacheContent.size() > offset) {
            storageCacheContent.setElementAt(new Object[]{l, key}, offset);
        } else {
            storageCacheContent.insertElementAt(new Object[]{l, key}, offset);
        }
        Storage.getInstance().writeObject("$CACHE$Idx" + this.cachePrefix, storageCacheContent);
    }

    public Vector getKeysInCache() {
        Vector<Object> r = new Vector<Object>();
        Enumeration en = this.memoryCache.keys();
        while (en.hasMoreElements()) {
            r.addElement(en.nextElement());
        }
        Vector storageCacheContent = this.getStorageCacheContent();
        for (int iter = 0; iter < storageCacheContent.size(); ++iter) {
            Object[] o = (Object[])storageCacheContent.elementAt(iter);
            if (r.contains(o[1])) continue;
            r.addElement(o[1]);
        }
        return r;
    }

    private Vector fetchFromStorageCache(int offset) {
        Vector v = this.getStorageCacheContent();
        Object[] arr = (Object[])v.elementAt(offset);
        return (Vector)Storage.getInstance().readObject("$CACHE$" + this.cachePrefix + arr[1].toString());
    }

    public void clearStorageCache() {
        if (this.storageCacheSize > 0) {
            Vector v = this.getStorageCacheContent();
            int s = v.size();
            for (int iter = 0; iter < s; ++iter) {
                Object[] arr = (Object[])v.elementAt(iter);
                Storage.getInstance().deleteStorageFile("$CACHE$" + this.cachePrefix + arr[iter].toString());
            }
            Storage.getInstance().deleteStorageFile("$CACHE$Idx" + this.cachePrefix);
            this.storageCacheContentVec = new Vector();
        }
    }

    public int getStorageCacheSize() {
        return this.storageCacheSize;
    }

    public void setStorageCacheSize(int storageCacheSize) {
        this.storageCacheSize = storageCacheSize;
        if (storageCacheSize == 0) {
            this.alwaysStore = false;
        }
    }

    public String getCachePrefix() {
        return this.cachePrefix;
    }

    public void setCachePrefix(String cachePrefix) {
        this.cachePrefix = cachePrefix;
    }

    public boolean isAlwaysStore() {
        return this.alwaysStore;
    }

    public void setAlwaysStore(boolean alwaysStore) {
        this.alwaysStore = alwaysStore;
    }
}

