/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.io;

import com.codename1.io.Externalizable;
import com.codename1.io.Storage;
import com.codename1.io.Util;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Cookie
implements Externalizable {
    public static String STORAGE_NAME = "Cookies";
    private static boolean autoStored = true;
    private String name;
    private String value;
    private String domain;
    private String path = "/";
    private boolean secure = false;
    private boolean httpOnly = false;
    private long expires;

    public static boolean isAutoStored() {
        return autoStored;
    }

    public static void setAutoStored(boolean autoStored) {
        Cookie.autoStored = autoStored;
    }

    public static void clearCookiesFromStorage() {
        if (Storage.getInstance().exists(STORAGE_NAME)) {
            Storage.getInstance().deleteStorageFile(STORAGE_NAME);
        }
        Util.getImplementation().clearNativeCookies();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public void setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public long getExpires() {
        return this.expires;
    }

    public void setExpires(long expires) {
        this.expires = expires;
    }

    public int getVersion() {
        return 1;
    }

    public void externalize(DataOutputStream out) throws IOException {
        out.writeUTF(this.name);
        if (this.value != null) {
            out.writeBoolean(true);
            out.writeUTF(this.value);
        } else {
            out.writeBoolean(false);
        }
        if (this.domain != null) {
            out.writeBoolean(true);
            out.writeUTF(this.domain);
        } else {
            out.writeBoolean(false);
        }
        out.writeLong(this.expires);
    }

    public void internalize(int version, DataInputStream in) throws IOException {
        this.name = in.readUTF();
        if (in.readBoolean()) {
            this.value = in.readUTF();
        }
        if (in.readBoolean()) {
            this.domain = in.readUTF();
        }
        this.expires = in.readLong();
    }

    public String getObjectId() {
        return "Cookie";
    }

    public String toString() {
        return "name = " + this.name + " value = " + this.value + " domain = " + this.domain + "expires = " + this.expires + " secure = " + this.secure + " path = " + this.path;
    }

    static {
        Util.register("Cookie", Cookie.class);
    }
}

