/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.io;

import com.codename1.io.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Timer;
import java.util.TimerTask;

public class FileSystemStorage {
    public static final int ROOT_TYPE_MAINSTORAGE = 1;
    public static final int ROOT_TYPE_SDCARD = 2;
    public static final int ROOT_TYPE_UNKNOWN = 3;
    private static final FileSystemStorage INSTANCE = new FileSystemStorage();

    private FileSystemStorage() {
    }

    public static FileSystemStorage getInstance() {
        return INSTANCE;
    }

    public String[] getRoots() {
        return Util.getImplementation().listFilesystemRoots();
    }

    public int getRootType(String root) {
        return Util.getImplementation().getRootType(root);
    }

    public String[] listFiles(String directory) throws IOException {
        return Util.getImplementation().listFiles(directory);
    }

    public long getRootSizeBytes(String root) {
        return Util.getImplementation().getRootSizeBytes(root);
    }

    public long getRootAvailableSpace(String root) {
        return Util.getImplementation().getRootAvailableSpace(root);
    }

    public void mkdir(String directory) {
        Util.getImplementation().mkdir(directory);
    }

    public void delete(String file) {
        Util.getImplementation().deleteFile(file);
    }

    public void deleteRetry(final String file, final int retryCount) {
        System.gc();
        try {
            Util.getImplementation().deleteFile(file);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (Util.getImplementation().exists(file) && retryCount > 0) {
            new Timer().schedule(new TimerTask(){

                public void run() {
                    FileSystemStorage.this.deleteRetry(file, retryCount - 1);
                }
            }, 500L);
        }
    }

    public boolean exists(String file) {
        return Util.getImplementation().exists(file);
    }

    public boolean isHidden(String file) {
        return Util.getImplementation().isHidden(file);
    }

    public void setHidden(String file, boolean h) {
        Util.getImplementation().setHidden(file, h);
    }

    public void rename(String file, String newName) {
        if (newName.indexOf(47) > -1) {
            throw new RuntimeException("Rename accepts only relative file names not full paths: " + newName);
        }
        Util.getImplementation().rename(file, newName);
    }

    public long getLength(String file) {
        return Util.getImplementation().getFileLength(file);
    }

    public long getLastModified(String file) {
        return Util.getImplementation().getFileLastModified(file);
    }

    public boolean isDirectory(String file) {
        return Util.getImplementation().isDirectory(file);
    }

    public char getFileSystemSeparator() {
        return Util.getImplementation().getFileSystemSeparator();
    }

    public OutputStream openOutputStream(String file) throws IOException {
        return Util.getImplementation().openFileOutputStream(file);
    }

    public InputStream openInputStream(String file) throws IOException {
        return Util.getImplementation().openFileInputStream(file);
    }

    public OutputStream openOutputStream(String file, int offset) throws IOException {
        return Util.getImplementation().openOutputStream(file, offset);
    }

    public String getAppHomePath() {
        return Util.getImplementation().getAppHomePath();
    }

    public boolean hasCachesDir() {
        return Util.getImplementation().hasCachesDir();
    }

    public String getCachesDir() {
        return Util.getImplementation().getCachesDir();
    }

    public String toNativePath(String path) {
        return Util.getImplementation().toNativePath(path);
    }
}

