/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.io;

import com.codename1.io.ConnectionRequest;
import com.codename1.io.FileSystemStorage;
import com.codename1.io.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;

public class MultipartRequest
extends ConnectionRequest {
    private static final String CRLF = "\r\n";
    private static boolean canFlushStream = true;
    private static boolean leaveInputStreamsOpen;
    private String boundary;
    private LinkedHashMap args = new LinkedHashMap();
    private Hashtable filenames = new Hashtable();
    private Hashtable filesizes = new Hashtable();
    private Hashtable mimeTypes = new Hashtable();
    private long contentLength = -1L;
    private boolean manualRedirect = true;
    private Vector ignoreEncoding = new Vector();
    private boolean base64Binaries = true;

    public MultipartRequest() {
        this.setPost(true);
        this.setWriteRequest(true);
        this.boundary = Long.toString(System.currentTimeMillis(), 16);
        this.setContentType("multipart/form-data; boundary=" + this.boundary);
    }

    public static boolean isLeaveInputStreamsOpen() {
        return leaveInputStreamsOpen;
    }

    public static void setLeaveInputStreamsOpen(boolean aLeaveInputStreamsOpen) {
        leaveInputStreamsOpen = aLeaveInputStreamsOpen;
    }

    public static void setCanFlushStream(boolean flush) {
        canFlushStream = flush;
    }

    public String getBoundary() {
        return this.boundary;
    }

    public void setBoundary(String boundary) {
        this.boundary = boundary;
        this.setContentType("multipart/form-data; boundary=" + boundary);
    }

    protected void initConnection(Object connection) {
        this.contentLength = this.calculateContentLength();
        this.addRequestHeader("Content-Length", Long.toString(this.contentLength));
        super.initConnection(connection);
    }

    public void addData(String name, byte[] data, String mimeType) {
        this.args.put(name, data);
        this.mimeTypes.put(name, mimeType);
        if (!this.filenames.containsKey(name)) {
            this.filenames.put(name, name);
        }
        this.filesizes.put(name, String.valueOf(data.length));
    }

    public void addData(String name, String filePath, String mimeType) throws IOException {
        this.addData(name, FileSystemStorage.getInstance().openInputStream(filePath), FileSystemStorage.getInstance().getLength(filePath), mimeType);
    }

    public void addData(String name, InputStream data, long dataSize, String mimeType) {
        this.args.put(name, data);
        if (!this.filenames.containsKey(name)) {
            this.filenames.put(name, name);
        }
        this.filesizes.put(name, String.valueOf(dataSize));
        this.mimeTypes.put(name, mimeType);
    }

    public void setFilename(String arg, String filename) {
        this.filenames.put(arg, filename);
    }

    public void addArgumentNoEncoding(String key, String value) {
        this.args.put(key, value);
        if (!this.filenames.containsKey(key)) {
            this.filenames.put(key, key);
        }
        this.ignoreEncoding.addElement(key);
    }

    public void addArgumentNoEncoding(String key, String[] value) {
        this.addArgument(key, value);
        this.ignoreEncoding.add(key);
    }

    public void addArgumentNoEncodingArray(String key, String ... value) {
        this.addArgumentNoEncoding(key, value);
    }

    public void addArgument(String name, String[] value) {
        this.args.put(name, value);
    }

    public void addArgument(String name, String value) {
        this.args.put(name, value);
        if (!this.filenames.containsKey(name)) {
            this.filenames.put(name, name);
        }
    }

    protected long calculateContentLength() {
        long length = 0L;
        Iterator entries = this.args.entrySet().iterator();
        long dLength = "Content-Disposition: form-data; name=\"\"; filename=\"\"".length() + 2;
        long ctLength = "Content-Type: ".length() + 2;
        long cteLength = "Content-Transfer-Encoding: binary".length() + 4;
        long bLength = this.boundary.length() + 4;
        long baseBinaryLength = dLength + ctLength + cteLength + bLength + 2L;
        dLength = "Content-Disposition: form-data; name=\"\"".length() + 2;
        ctLength = "Content-Type: text/plain; charset=UTF-8".length() + 4;
        long baseTextLength = dLength + ctLength + bLength + 2L;
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String) {
                length += baseTextLength;
                length += (long)key.length();
                if (this.ignoreEncoding.contains(key)) {
                    try {
                        length += (long)value.toString().getBytes("UTF-8").length;
                    }
                    catch (UnsupportedEncodingException ex) {
                        length += (long)value.toString().getBytes().length;
                    }
                    continue;
                }
                if (this.base64Binaries) {
                    length += (long)Util.encodeBody((String)value).length();
                    continue;
                }
                length += (long)((String)value).length();
                continue;
            }
            if (value instanceof String[]) {
                for (String s : (String[])value) {
                    length += baseTextLength;
                    length += (long)key.length();
                    if (this.ignoreEncoding.contains(key)) {
                        try {
                            length += (long)s.toString().getBytes("UTF-8").length;
                        }
                        catch (UnsupportedEncodingException ex) {
                            length += (long)value.toString().getBytes().length;
                        }
                        continue;
                    }
                    if (this.base64Binaries) {
                        length += (long)Util.encodeBody(s).length();
                        continue;
                    }
                    length += (long)s.length();
                }
                continue;
            }
            length += baseBinaryLength;
            length += (long)key.length();
            try {
                length += (long)((String)this.filenames.get(key)).getBytes("UTF-8").length;
            }
            catch (UnsupportedEncodingException ex) {
                length += (long)((String)this.filenames.get(key)).getBytes().length;
            }
            length += (long)((String)this.mimeTypes.get(key)).length();
            length += Long.parseLong((String)this.filesizes.get(key));
        }
        return length += bLength + 2L;
    }

    protected void buildRequestBody(OutputStream os) throws IOException {
        OutputStreamWriter writer = null;
        writer = new OutputStreamWriter(os, "UTF-8");
        Iterator entries = this.args.entrySet().iterator();
        while (entries.hasNext() && !this.shouldStop()) {
            Map.Entry entry = entries.next();
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            writer.write("--");
            writer.write(this.boundary);
            writer.write(CRLF);
            if (value instanceof String) {
                writer.write("Content-Disposition: form-data; name=\"");
                writer.write(key);
                writer.write("\"");
                writer.write(CRLF);
                writer.write("Content-Type: text/plain; charset=UTF-8");
                writer.write(CRLF);
                writer.write(CRLF);
                if (canFlushStream) {
                    ((Writer)writer).flush();
                }
                if (this.ignoreEncoding.contains(key)) {
                    writer.write((String)value);
                } else if (this.base64Binaries) {
                    writer.write(Util.encodeBody((String)value));
                } else {
                    writer.write((String)value);
                }
                if (canFlushStream) {
                    ((Writer)writer).flush();
                }
            } else if (value instanceof String[]) {
                boolean first = true;
                for (String s : (String[])value) {
                    if (!first) {
                        writer.write(CRLF);
                        writer.write("--");
                        writer.write(this.boundary);
                        writer.write(CRLF);
                    }
                    first = false;
                    writer.write("Content-Disposition: form-data; name=\"");
                    writer.write(key);
                    writer.write("\"");
                    writer.write(CRLF);
                    writer.write("Content-Type: text/plain; charset=UTF-8");
                    writer.write(CRLF);
                    writer.write(CRLF);
                    if (canFlushStream) {
                        ((Writer)writer).flush();
                    }
                    if (this.ignoreEncoding.contains(key)) {
                        writer.write(s);
                    } else if (this.base64Binaries) {
                        writer.write(Util.encodeBody(s));
                    } else {
                        writer.write(s);
                    }
                    if (!canFlushStream) continue;
                    ((Writer)writer).flush();
                }
            } else {
                writer.write("Content-Disposition: form-data; name=\"" + key + "\"; filename=\"" + this.filenames.get(key) + "\"");
                writer.write(CRLF);
                writer.write("Content-Type: ");
                writer.write((String)this.mimeTypes.get(key));
                writer.write(CRLF);
                writer.write("Content-Transfer-Encoding: binary");
                writer.write(CRLF);
                writer.write(CRLF);
                if (canFlushStream) {
                    ((Writer)writer).flush();
                }
                InputStream i = value instanceof InputStream ? (InputStream)value : new ByteArrayInputStream((byte[])value);
                byte[] buffer = new byte[8192];
                int s = i.read(buffer);
                while (s > -1 && !this.shouldStop()) {
                    os.write(buffer, 0, s);
                    if (canFlushStream) {
                        ((Writer)writer).flush();
                    }
                    s = i.read(buffer);
                }
                if (value instanceof InputStream) {
                    if (!leaveInputStreamsOpen) {
                        Util.cleanup(i);
                    }
                } else {
                    Util.cleanup(i);
                }
                value = null;
                if (canFlushStream) {
                    ((Writer)writer).flush();
                }
            }
            writer.write(CRLF);
            if (!canFlushStream) continue;
            ((Writer)writer).flush();
        }
        writer.write("--" + this.boundary + "--");
        writer.write(CRLF);
        ((Writer)writer).close();
    }

    public int getContentLength() {
        return (int)this.contentLength;
    }

    public boolean onRedirect(String url) {
        return this.manualRedirect;
    }

    public boolean isManualRedirect() {
        return this.manualRedirect;
    }

    public void setManualRedirect(boolean autoRedirect) {
        this.manualRedirect = autoRedirect;
    }

    public boolean isBase64Binaries() {
        return this.base64Binaries;
    }

    public void setBase64Binaries(boolean base64Binaries) {
        this.base64Binaries = base64Binaries;
    }
}

