/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.io;

import com.codename1.io.ConnectionRequest;
import com.codename1.ui.events.ActionEvent;

public class NetworkEvent
extends ActionEvent {
    public static final int PROGRESS_TYPE_INITIALIZING = 1;
    public static final int PROGRESS_TYPE_OUTPUT = 2;
    public static final int PROGRESS_TYPE_INPUT = 3;
    public static final int PROGRESS_TYPE_COMPLETED = 4;
    private Exception error;
    private int progressType;
    private int length = -1;
    private int received;
    private Object metaData;
    private String message;

    public NetworkEvent(ConnectionRequest source, Exception error) {
        super((Object)source, ActionEvent.Type.Exception);
        this.error = error;
    }

    public NetworkEvent(ConnectionRequest request, int responseCode, String message) {
        super((Object)request, ActionEvent.Type.Response);
        this.progressType = responseCode;
        this.message = message;
    }

    public NetworkEvent(ConnectionRequest request, int progressType) {
        super((Object)request, ActionEvent.Type.Progress);
        this.progressType = progressType;
    }

    public NetworkEvent(ConnectionRequest request, Object metaData) {
        super((Object)request, ActionEvent.Type.Data);
        if (request != null) {
            this.progressType = request.getResponseCode();
        }
        this.metaData = metaData;
    }

    public ConnectionRequest getConnectionRequest() {
        return (ConnectionRequest)this.getSource();
    }

    public Exception getError() {
        return this.error;
    }

    public void setError(Exception error) {
        this.error = error;
    }

    public int getProgressType() {
        return this.progressType;
    }

    public int getResponseCode() {
        return this.progressType;
    }

    public int getLength() {
        return this.length;
    }

    void setLength(int length) {
        this.length = length;
    }

    public int getSentReceived() {
        return this.received;
    }

    void setSentReceived(int received) {
        this.received = received;
    }

    public int getProgressPercentage() {
        if (this.length > 0) {
            return (int)((float)this.received / (float)this.length * 100.0f);
        }
        return -1;
    }

    public Object getMetaData() {
        return this.metaData;
    }

    public String getMessage() {
        return this.message;
    }
}

