/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.io;

import com.codename1.io.PreferenceListener;
import com.codename1.io.Storage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Preferences {
    private static final HashMap<String, ArrayList<PreferenceListener>> listenerMap = new HashMap();
    private static Hashtable<String, Object> p;
    private static String preferencesLocation;

    Preferences() {
    }

    public static String getPreferencesLocation() {
        return preferencesLocation;
    }

    public static void setPreferencesLocation(String storageFileName) {
        preferencesLocation = storageFileName;
        p = null;
    }

    private static synchronized Hashtable<String, Object> get() {
        if (p == null) {
            if (Storage.getInstance().exists(preferencesLocation)) {
                p = (Hashtable)Storage.getInstance().readObject(preferencesLocation);
            }
            if (p == null) {
                p = new Hashtable();
            }
        }
        return p;
    }

    private static synchronized void save() {
        Storage.getInstance().writeObject(preferencesLocation, p);
    }

    private static void set(String pref, Object o) {
        String prior = Preferences.get(pref, null);
        if (o == null) {
            Preferences.get().remove(pref);
        } else {
            Preferences.get().put(pref, o);
        }
        Preferences.save();
        Preferences.fireChange(pref, prior, o);
    }

    public static void set(Map<String, Object> values) {
        ArrayList<Object[]> changeParams = new ArrayList<Object[]>();
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            String pref = entry.getKey();
            Object o = entry.getValue();
            String prior = Preferences.get(pref, null);
            if (o == null) {
                Preferences.get().remove(pref);
            } else {
                Preferences.get().put(pref, o);
            }
            changeParams.add(new Object[]{pref, prior, o});
        }
        Preferences.save();
        for (Object[] params : changeParams) {
            Preferences.fireChange((String)params[0], params[1], params[2]);
        }
    }

    public static void set(String pref, String s) {
        Preferences.set(pref, (Object)s);
    }

    public static void set(String pref, int i) {
        Preferences.set(pref, (Object)i);
    }

    public static void set(String pref, long l) {
        Preferences.set(pref, (Object)l);
    }

    public static void set(String pref, double d) {
        Preferences.set(pref, new Double(d));
    }

    public static void set(String pref, float f) {
        Preferences.set(pref, new Float(f));
    }

    public static void delete(String pref) {
        String prior = Preferences.get(pref, null);
        Preferences.get().remove(pref);
        Preferences.save();
        Preferences.fireChange(pref, prior, null);
    }

    public static void clearAll() {
        Hashtable<String, Object> priorValues = null;
        if (!listenerMap.isEmpty()) {
            priorValues = new Hashtable<String, Object>();
            for (String key : listenerMap.keySet()) {
                Object currentValue = Preferences.get().get(key);
                if (currentValue == null) continue;
                priorValues.put(key, currentValue);
            }
        }
        Preferences.get().clear();
        Preferences.save();
        if (priorValues != null) {
            for (String key : listenerMap.keySet()) {
                Preferences.fireChange(key, priorValues.get(key), null);
            }
        }
    }

    static Set<String> keySet() {
        return p.keySet();
    }

    public static void set(String pref, boolean b) {
        if (b) {
            Preferences.set(pref, Boolean.TRUE);
        } else {
            Preferences.set(pref, Boolean.FALSE);
        }
    }

    public static String get(String pref, String def) {
        Object t = Preferences.get().get(pref);
        if (t == null) {
            return def;
        }
        return t.toString();
    }

    public static String getAndSet(String pref, String def) {
        Object t = Preferences.get().get(pref);
        if (t == null) {
            Preferences.set(pref, def);
            return def;
        }
        return t.toString();
    }

    public static int getAndSet(String pref, int def) {
        Integer t = (Integer)Preferences.get().get(pref);
        if (t == null) {
            Preferences.set(pref, def);
            return def;
        }
        return t;
    }

    public static int get(String pref, int def) {
        Integer t = (Integer)Preferences.get().get(pref);
        if (t == null) {
            return def;
        }
        return t;
    }

    public static long getAndSet(String pref, long def) {
        Long t = (Long)Preferences.get().get(pref);
        if (t == null) {
            Preferences.set(pref, def);
            return def;
        }
        return t;
    }

    public static long get(String pref, long def) {
        Long t = (Long)Preferences.get().get(pref);
        if (t == null) {
            return def;
        }
        return t;
    }

    public static double getAndSet(String pref, double def) {
        Double t = (Double)Preferences.get().get(pref);
        if (t == null) {
            Preferences.set(pref, def);
            return def;
        }
        return t;
    }

    public static double get(String pref, double def) {
        Double t = (Double)Preferences.get().get(pref);
        if (t == null) {
            return def;
        }
        return t;
    }

    public static float getAndSet(String pref, float def) {
        Float t = (Float)Preferences.get().get(pref);
        if (t == null) {
            Preferences.set(pref, def);
            return def;
        }
        return t.floatValue();
    }

    public static float get(String pref, float def) {
        Float t = (Float)Preferences.get().get(pref);
        if (t == null) {
            return def;
        }
        return t.floatValue();
    }

    public static boolean getAndSet(String pref, boolean def) {
        Boolean t = (Boolean)Preferences.get().get(pref);
        if (t == null) {
            Preferences.set(pref, def);
            return def;
        }
        return t;
    }

    public static boolean get(String pref, boolean def) {
        Boolean t = (Boolean)Preferences.get().get(pref);
        if (t == null) {
            return def;
        }
        return t;
    }

    private static void fireChange(String pref, Object priorValue, Object value) {
        ArrayList<PreferenceListener> listenerList;
        boolean valueChanged;
        boolean bl = valueChanged = priorValue != value && (priorValue == null || !priorValue.equals(value));
        if (valueChanged && (listenerList = listenerMap.get(pref)) != null) {
            for (int i = listenerList.size() - 1; i >= 0; --i) {
                PreferenceListener listener = listenerList.get(i);
                listener.preferenceChanged(pref, priorValue, value);
            }
        }
    }

    public static void addPreferenceListener(String pref, PreferenceListener listener) {
        if (listener == null) {
            throw new NullPointerException("Null PreferenceListener not allowed");
        }
        ArrayList<PreferenceListener> listenerList = listenerMap.get(pref);
        if (listenerList == null) {
            listenerList = new ArrayList();
            listenerMap.put(pref, listenerList);
        }
        listenerList.add(listener);
    }

    public static boolean removePreferenceListener(String pref, PreferenceListener listener) {
        ArrayList<PreferenceListener> listenerList = listenerMap.get(pref);
        if (listenerList != null) {
            return listenerList.remove(listener);
        }
        return false;
    }

    static {
        preferencesLocation = "CN1Preferences";
    }
}

