/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.io;

import com.codename1.io.ConnectionRequest;
import com.codename1.io.NetworkManager;
import com.codename1.io.Util;
import com.codename1.util.Callback;
import com.codename1.util.FailureCallback;
import com.codename1.util.SuccessCallback;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class WebServiceProxyCall {
    public static final int TYPE_VOID = 0;
    public static final int TYPE_BYTE = 1;
    public static final int TYPE_CHAR = 2;
    public static final int TYPE_SHORT = 3;
    public static final int TYPE_INT = 4;
    public static final int TYPE_LONG = 5;
    public static final int TYPE_DOUBLE = 6;
    public static final int TYPE_FLOAT = 7;
    public static final int TYPE_BOOLEAN = 8;
    public static final int TYPE_BYTE_OBJECT = 9;
    public static final int TYPE_CHARACTER_OBJECT = 10;
    public static final int TYPE_SHORT_OBJECT = 11;
    public static final int TYPE_INTEGER_OBJECT = 12;
    public static final int TYPE_LONG_OBJECT = 13;
    public static final int TYPE_DOUBLE_OBJECT = 14;
    public static final int TYPE_FLOAT_OBJECT = 15;
    public static final int TYPE_BOOLEAN_OBJECT = 16;
    public static final int TYPE_STRING = 17;
    public static final int TYPE_BYTE_ARRAY = 18;
    public static final int TYPE_CHAR_ARRAY = 19;
    public static final int TYPE_SHORT_ARRAY = 20;
    public static final int TYPE_INT_ARRAY = 21;
    public static final int TYPE_LONG_ARRAY = 22;
    public static final int TYPE_DOUBLE_ARRAY = 23;
    public static final int TYPE_FLOAT_ARRAY = 24;
    public static final int TYPE_BOOLEAN_ARRAY = 25;
    public static final int TYPE_STRING_ARRAY = 26;
    public static final int TYPE_EXTERNALIABLE = 1000;

    public static Object invokeWebserviceSync(WSDefinition def, Object ... arguments) throws IOException {
        WSConnection cr = new WSConnection(def, null, arguments);
        NetworkManager.getInstance().addToQueueAndWait(cr);
        int rc = cr.getResponseCode();
        if (rc != 200 && rc != 201) {
            throw new IOException("Server error: " + cr.getResponseCode());
        }
        return cr.returnValue;
    }

    public static void invokeWebserviceASync(WSDefinition def, SuccessCallback scall, FailureCallback fcall, Object ... arguments) {
        WSConnection cr = new WSConnection(def, scall, fcall, arguments);
        NetworkManager.getInstance().addToQueue(cr);
    }

    public static void invokeWebserviceASync(WSDefinition def, Callback call, Object ... arguments) {
        WSConnection cr = new WSConnection(def, call, arguments);
        NetworkManager.getInstance().addToQueue(cr);
    }

    public static WSDefinition defineWebService(String url, String serviceName, int returnType, int ... argumentTypes) {
        WSDefinition def = new WSDefinition();
        def.url = url;
        def.name = serviceName;
        def.returnType = returnType;
        def.arguments = argumentTypes;
        return def;
    }

    static class WSConnection
    extends ConnectionRequest {
        Object returnValue;
        private final WSDefinition def;
        private final Object[] arguments;
        private final SuccessCallback scall;
        private final FailureCallback fcall;

        public WSConnection(WSDefinition def, Callback call, Object ... arguments) {
            this(def, (SuccessCallback)call, call, arguments);
        }

        public WSConnection(WSDefinition def, SuccessCallback scall, FailureCallback fcall, Object ... arguments) {
            this.def = def;
            this.setUrl(def.url);
            this.arguments = arguments;
            this.scall = scall;
            this.fcall = fcall;
            this.setPost(true);
        }

        protected void postResponse() {
            if (this.scall != null) {
                this.scall.onSucess(this.returnValue);
            }
        }

        protected void handleErrorResponseCode(int code, String message) {
            if (this.fcall != null) {
                this.fcall.onError(this, null, code, message);
            }
        }

        protected void handleException(Exception err) {
            if (this.fcall != null) {
                this.fcall.onError(this, err, -1, null);
            }
        }

        protected void readResponse(InputStream input) throws IOException {
            DataInputStream dis = new DataInputStream(input);
            switch (this.def.returnType) {
                case 0: {
                    return;
                }
                case 1: {
                    this.returnValue = dis.readByte();
                    break;
                }
                case 2: {
                    this.returnValue = new Character(dis.readChar());
                    break;
                }
                case 3: {
                    this.returnValue = dis.readShort();
                    break;
                }
                case 4: {
                    this.returnValue = dis.readInt();
                    break;
                }
                case 5: {
                    this.returnValue = dis.readLong();
                    break;
                }
                case 6: {
                    this.returnValue = new Double(dis.readDouble());
                    break;
                }
                case 7: {
                    this.returnValue = new Float(dis.readFloat());
                    break;
                }
                case 8: {
                    this.returnValue = dis.readBoolean();
                    break;
                }
                case 9: {
                    if (!dis.readBoolean()) break;
                    this.returnValue = dis.readByte();
                    break;
                }
                case 10: {
                    if (!dis.readBoolean()) break;
                    this.returnValue = new Character(dis.readChar());
                    break;
                }
                case 11: {
                    if (!dis.readBoolean()) break;
                    this.returnValue = dis.readShort();
                    break;
                }
                case 12: {
                    if (!dis.readBoolean()) break;
                    this.returnValue = dis.readInt();
                    break;
                }
                case 13: {
                    if (!dis.readBoolean()) break;
                    this.returnValue = dis.readLong();
                    break;
                }
                case 14: {
                    if (!dis.readBoolean()) break;
                    this.returnValue = new Double(dis.readDouble());
                    break;
                }
                case 15: {
                    if (!dis.readBoolean()) break;
                    this.returnValue = new Float(dis.readFloat());
                    break;
                }
                case 16: {
                    if (!dis.readBoolean()) break;
                    this.returnValue = dis.readBoolean();
                    break;
                }
                case 17: {
                    if (!dis.readBoolean()) break;
                    this.returnValue = dis.readUTF();
                    break;
                }
                case 18: {
                    int size = dis.readInt();
                    if (size <= -1) break;
                    byte[] b = new byte[size];
                    for (int iter = 0; iter < size; ++iter) {
                        b[iter] = dis.readByte();
                    }
                    this.returnValue = b;
                    break;
                }
                case 19: {
                    int size = dis.readInt();
                    if (size <= -1) break;
                    char[] b = new char[size];
                    for (int iter = 0; iter < size; ++iter) {
                        b[iter] = dis.readChar();
                    }
                    this.returnValue = b;
                    break;
                }
                case 20: {
                    int size = dis.readInt();
                    if (size <= -1) break;
                    short[] b = new short[size];
                    for (int iter = 0; iter < size; ++iter) {
                        b[iter] = dis.readShort();
                    }
                    this.returnValue = b;
                    break;
                }
                case 21: {
                    int size = dis.readInt();
                    if (size <= -1) break;
                    int[] b = new int[size];
                    for (int iter = 0; iter < size; ++iter) {
                        b[iter] = dis.readInt();
                    }
                    this.returnValue = b;
                    break;
                }
                case 22: {
                    int size = dis.readInt();
                    if (size <= -1) break;
                    long[] b = new long[size];
                    for (int iter = 0; iter < size; ++iter) {
                        b[iter] = dis.readLong();
                    }
                    this.returnValue = b;
                    break;
                }
                case 23: {
                    int size = dis.readInt();
                    if (size <= -1) break;
                    double[] b = new double[size];
                    for (int iter = 0; iter < size; ++iter) {
                        b[iter] = dis.readDouble();
                    }
                    this.returnValue = b;
                    break;
                }
                case 24: {
                    int size = dis.readInt();
                    if (size <= -1) break;
                    float[] b = new float[size];
                    for (int iter = 0; iter < size; ++iter) {
                        b[iter] = dis.readFloat();
                    }
                    this.returnValue = b;
                    break;
                }
                case 25: {
                    int size = dis.readInt();
                    if (size <= -1) break;
                    boolean[] b = new boolean[size];
                    for (int iter = 0; iter < size; ++iter) {
                        b[iter] = dis.readBoolean();
                    }
                    this.returnValue = b;
                    break;
                }
                case 26: {
                    int size = dis.readInt();
                    if (size <= -1) break;
                    String[] b = new String[size];
                    for (int iter = 0; iter < size; ++iter) {
                        b[iter] = dis.readUTF();
                    }
                    this.returnValue = b;
                    break;
                }
                case 1000: {
                    this.returnValue = Util.readObject(dis);
                    break;
                }
                default: {
                    throw new RuntimeException("Unrecognized type: " + this.returnValue);
                }
            }
        }

        protected void buildRequestBody(OutputStream os) throws IOException {
            DataOutputStream dos = new DataOutputStream(os);
            dos.writeUTF(this.def.name);
            int alen = this.arguments.length;
            block29: for (int iter = 0; iter < alen; ++iter) {
                switch (this.def.arguments[iter]) {
                    case 1: {
                        dos.writeByte(((Byte)this.arguments[iter]).byteValue());
                        continue block29;
                    }
                    case 2: {
                        dos.writeChar(((Character)this.arguments[iter]).charValue());
                        continue block29;
                    }
                    case 3: {
                        dos.writeShort(((Short)this.arguments[iter]).shortValue());
                        continue block29;
                    }
                    case 4: {
                        dos.writeInt((Integer)this.arguments[iter]);
                        continue block29;
                    }
                    case 5: {
                        dos.writeLong((Long)this.arguments[iter]);
                        continue block29;
                    }
                    case 6: {
                        dos.writeDouble((Double)this.arguments[iter]);
                        continue block29;
                    }
                    case 7: {
                        dos.writeFloat(((Float)this.arguments[iter]).floatValue());
                        continue block29;
                    }
                    case 8: {
                        dos.writeBoolean((Boolean)this.arguments[iter]);
                        continue block29;
                    }
                    case 9: {
                        if (this.arguments[iter] != null) {
                            dos.writeBoolean(true);
                            dos.writeByte(((Byte)this.arguments[iter]).byteValue());
                            continue block29;
                        }
                        dos.writeBoolean(false);
                        continue block29;
                    }
                    case 10: {
                        if (this.arguments[iter] != null) {
                            dos.writeBoolean(true);
                            dos.writeChar(((Character)this.arguments[iter]).charValue());
                            continue block29;
                        }
                        dos.writeBoolean(false);
                        continue block29;
                    }
                    case 11: {
                        if (this.arguments[iter] != null) {
                            dos.writeBoolean(true);
                            dos.writeShort(((Short)this.arguments[iter]).shortValue());
                            continue block29;
                        }
                        dos.writeBoolean(false);
                        continue block29;
                    }
                    case 12: {
                        if (this.arguments[iter] != null) {
                            dos.writeBoolean(true);
                            dos.writeInt((Integer)this.arguments[iter]);
                            continue block29;
                        }
                        dos.writeBoolean(false);
                        continue block29;
                    }
                    case 13: {
                        if (this.arguments[iter] != null) {
                            dos.writeBoolean(true);
                            dos.writeLong((Long)this.arguments[iter]);
                            continue block29;
                        }
                        dos.writeBoolean(false);
                        continue block29;
                    }
                    case 14: {
                        if (this.arguments[iter] != null) {
                            dos.writeBoolean(true);
                            dos.writeDouble((Double)this.arguments[iter]);
                            continue block29;
                        }
                        dos.writeBoolean(false);
                        continue block29;
                    }
                    case 15: {
                        if (this.arguments[iter] != null) {
                            dos.writeBoolean(true);
                            dos.writeFloat(((Float)this.arguments[iter]).floatValue());
                            continue block29;
                        }
                        dos.writeBoolean(false);
                        continue block29;
                    }
                    case 16: {
                        if (this.arguments[iter] != null) {
                            dos.writeBoolean(true);
                            dos.writeBoolean((Boolean)this.arguments[iter]);
                            continue block29;
                        }
                        dos.writeBoolean(false);
                        continue block29;
                    }
                    case 17: {
                        if (this.arguments[iter] != null) {
                            dos.writeBoolean(true);
                            dos.writeUTF((String)this.arguments[iter]);
                            continue block29;
                        }
                        dos.writeBoolean(false);
                        continue block29;
                    }
                    case 18: {
                        Object[] b;
                        if (this.arguments[iter] != null) {
                            b = (byte[])this.arguments[iter];
                            dos.writeInt(b.length);
                            for (byte by : b) {
                                dos.writeByte(by);
                            }
                            continue block29;
                        }
                        dos.writeInt(-1);
                        continue block29;
                    }
                    case 19: {
                        Object[] b;
                        if (this.arguments[iter] != null) {
                            b = (char[])this.arguments[iter];
                            dos.writeInt(b.length);
                            for (byte by : b) {
                                dos.writeChar(by);
                            }
                            continue block29;
                        }
                        dos.writeInt(-1);
                        continue block29;
                    }
                    case 20: {
                        Object[] b;
                        if (this.arguments[iter] != null) {
                            b = (short[])this.arguments[iter];
                            dos.writeInt(b.length);
                            for (byte by : b) {
                                dos.writeShort(by);
                            }
                            continue block29;
                        }
                        dos.writeInt(-1);
                        continue block29;
                    }
                    case 21: {
                        Object[] b;
                        if (this.arguments[iter] != null) {
                            b = (int[])this.arguments[iter];
                            dos.writeInt(b.length);
                            for (byte by : b) {
                                dos.writeInt(by);
                            }
                            continue block29;
                        }
                        dos.writeInt(-1);
                        continue block29;
                    }
                    case 22: {
                        Object[] b;
                        if (this.arguments[iter] != null) {
                            b = (long[])this.arguments[iter];
                            dos.writeInt(b.length);
                            for (byte by : b) {
                                dos.writeLong(by);
                            }
                            continue block29;
                        }
                        dos.writeInt(-1);
                        continue block29;
                    }
                    case 23: {
                        Object[] b;
                        if (this.arguments[iter] != null) {
                            b = (double[])this.arguments[iter];
                            dos.writeInt(b.length);
                            for (byte by : b) {
                                dos.writeDouble(by);
                            }
                            continue block29;
                        }
                        dos.writeInt(-1);
                        continue block29;
                    }
                    case 24: {
                        Object[] b;
                        if (this.arguments[iter] != null) {
                            b = (float[])this.arguments[iter];
                            dos.writeInt(b.length);
                            for (byte by : b) {
                                dos.writeFloat(by);
                            }
                            continue block29;
                        }
                        dos.writeInt(-1);
                        continue block29;
                    }
                    case 25: {
                        Object[] b;
                        if (this.arguments[iter] != null) {
                            b = (boolean[])this.arguments[iter];
                            dos.writeInt(b.length);
                            for (boolean bl : b) {
                                dos.writeBoolean(bl);
                            }
                            continue block29;
                        }
                        dos.writeInt(-1);
                        continue block29;
                    }
                    case 26: {
                        Object[] b;
                        if (this.arguments[iter] != null) {
                            b = (String[])this.arguments[iter];
                            dos.writeInt(b.length);
                            for (byte by : b) {
                                dos.writeUTF((String)by);
                            }
                            continue block29;
                        }
                        dos.writeInt(-1);
                        continue block29;
                    }
                    case 1000: {
                        Util.writeObject(this.arguments[iter], dos);
                        continue block29;
                    }
                    default: {
                        throw new RuntimeException("Unrecognized type: " + this.def.arguments[iter]);
                    }
                }
            }
        }
    }

    public static class WSDefinition {
        String url;
        String name;
        int returnType;
        int[] arguments;
    }
}

