/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.io.services;

import com.codename1.io.ConnectionRequest;
import com.codename1.io.JSONParser;
import com.codename1.io.NetworkEvent;
import com.codename1.io.NetworkManager;
import com.codename1.util.Base64;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TwitterRESTService
extends ConnectionRequest {
    public static final String METHOD_USER_TIMELINE = "statuses/user_timeline";
    public static final String METHOD_TWEETS = "search/tweets";
    private static String authToken;
    private Hashtable parseTree;

    public TwitterRESTService(String method) {
        this(method, "1.1", false);
    }

    public TwitterRESTService(String method, boolean post) {
        this(method, "1.1", post);
    }

    public TwitterRESTService(String method, String version, boolean post) {
        this.setPost(post);
        this.setUrl("https://api.twitter.com/" + version + "/" + method + ".json");
        this.addRequestHeader("Authorization", "Bearer " + authToken);
        this.setContentType("application/json");
        this.addRequestHeader("Accept", "application/json");
    }

    public static String initToken(String consumerKey, String consumerSecret) {
        ConnectionRequest auth = new ConnectionRequest(){

            protected void readResponse(InputStream input) throws IOException {
                JSONParser p = new JSONParser();
                Hashtable<String, Object> h = p.parse(new InputStreamReader(input));
                authToken = (String)h.get("access_token");
                if (authToken == null) {
                    // empty if block
                }
            }
        };
        auth.setPost(true);
        auth.setUrl("https://api.twitter.com/oauth2/token");
        String encoded = Base64.encodeNoNewline((consumerKey + ":" + consumerSecret).getBytes());
        auth.addRequestHeader("Authorization", "Basic " + encoded);
        auth.setContentType("application/x-www-form-urlencoded;charset=UTF-8");
        auth.addArgument("grant_type", "client_credentials");
        NetworkManager.getInstance().addToQueueAndWait(auth);
        return authToken;
    }

    public static void setToken(String token) {
        authToken = token;
    }

    @Override
    protected void readResponse(InputStream input) throws IOException {
        InputStreamReader i = new InputStreamReader(input, "UTF-8");
        this.parseTree = new JSONParser().parse(i);
        this.fireResponseListener(new NetworkEvent((ConnectionRequest)this, this.parseTree));
    }

    public Hashtable<String, Object> getParseTree() {
        return this.parseTree;
    }

    public int getStatusesCount() {
        Vector v = (Vector)this.parseTree.get("statuses");
        if (v == null) {
            return 0;
        }
        return v.size();
    }

    public Hashtable<String, Object> getStatus(int offset) {
        Vector v = (Vector)this.parseTree.get("statuses");
        return (Hashtable)v.get(offset);
    }

    public String getIdStr() {
        if (this.getStatusesCount() > 0) {
            return (String)this.getStatus(0).get("id_str");
        }
        return null;
    }
}

