/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.io.tar;

import com.codename1.io.FileSystemStorage;
import com.codename1.io.tar.Octal;
import com.codename1.io.tar.TarHeader;
import java.util.Date;

public class TarEntry {
    protected String file = null;
    protected TarHeader header = new TarHeader();

    private TarEntry() {
    }

    public TarEntry(String file, String entryName) {
        this();
        this.file = file;
        this.extractTarHeader(entryName);
    }

    public TarEntry(byte[] headerBuf) {
        this();
        this.parseTarHeader(headerBuf);
    }

    public boolean equals(TarEntry it) {
        return this.header.name.toString().equals(it.header.name.toString());
    }

    public boolean isDescendent(TarEntry desc) {
        return desc.header.name.toString().startsWith(this.header.name.toString());
    }

    public TarHeader getHeader() {
        return this.header;
    }

    public String getName() {
        return this.header.name.toString();
    }

    public void setName(String name) {
        this.header.name = new StringBuffer(name);
    }

    public int getUserId() {
        return this.header.userId;
    }

    public void setUserId(int userId) {
        this.header.userId = userId;
    }

    public int getGroupId() {
        return this.header.groupId;
    }

    public void setGroupId(int groupId) {
        this.header.groupId = groupId;
    }

    public String getUserName() {
        return this.header.userName.toString();
    }

    public void setUserName(String userName) {
        this.header.userName = new StringBuffer(userName);
    }

    public String getGroupName() {
        return this.header.groupName.toString();
    }

    public void setGroupName(String groupName) {
        this.header.groupName = new StringBuffer(groupName);
    }

    public void setIds(int userId, int groupId) {
        this.setUserId(userId);
        this.setGroupId(groupId);
    }

    public Date getModTime() {
        return new Date(this.header.modTime * 1000L);
    }

    public void setModTime(long time) {
        this.header.modTime = time / 1000L;
    }

    public void setModTime(Date time) {
        this.header.modTime = time.getTime() / 1000L;
    }

    public String getFile() {
        return this.file;
    }

    public long getSize() {
        return this.header.size;
    }

    public void setSize(long size) {
        this.header.size = size;
    }

    public boolean isDirectory() {
        if (this.file != null) {
            return FileSystemStorage.getInstance().isDirectory(this.file);
        }
        if (this.header != null) {
            if (this.header.linkFlag == 53) {
                return true;
            }
            return this.header.name.toString().endsWith("/");
        }
        return false;
    }

    public void extractTarHeader(String entryName) {
        String name = entryName;
        FileSystemStorage fileSystem = FileSystemStorage.getInstance();
        if ((name = name.replace(fileSystem.getFileSystemSeparator(), '/')).startsWith("/")) {
            name = name.substring(1);
        }
        this.header.linkName = new StringBuffer();
        this.header.name = new StringBuffer(name);
        if (fileSystem.isDirectory(this.file)) {
            this.header.mode = 16877;
            this.header.linkFlag = (byte)53;
            if (this.header.name.charAt(this.header.name.length() - 1) != '/') {
                this.header.name.append("/");
            }
            this.header.size = 0L;
        } else {
            this.header.size = fileSystem.getLength(this.file);
            this.header.mode = 33188;
            this.header.linkFlag = (byte)48;
        }
        this.header.modTime = 0L;
        this.header.checkSum = 0;
        this.header.devMajor = 0;
        this.header.devMinor = 0;
    }

    public long computeCheckSum(byte[] buf) {
        long sum = 0L;
        int blen = buf.length;
        for (int i = 0; i < blen; ++i) {
            sum += (long)(0xFF & buf[i]);
        }
        return sum;
    }

    public void writeEntryHeader(byte[] outbuf) {
        int offset = 0;
        offset = TarHeader.getNameBytes(this.header.name, outbuf, offset, 100);
        offset = Octal.getOctalBytes(this.header.mode, outbuf, offset, 8);
        offset = Octal.getOctalBytes(this.header.userId, outbuf, offset, 8);
        offset = Octal.getOctalBytes(this.header.groupId, outbuf, offset, 8);
        long size = this.header.size;
        offset = Octal.getLongOctalBytes(size, outbuf, offset, 12);
        int csOffset = offset = Octal.getLongOctalBytes(this.header.modTime, outbuf, offset, 12);
        for (int c = 0; c < 8; ++c) {
            outbuf[offset++] = 32;
        }
        outbuf[offset++] = this.header.linkFlag;
        offset = TarHeader.getNameBytes(this.header.linkName, outbuf, offset, 100);
        offset = TarHeader.getNameBytes(this.header.magic, outbuf, offset, 8);
        offset = TarHeader.getNameBytes(this.header.userName, outbuf, offset, 32);
        offset = TarHeader.getNameBytes(this.header.groupName, outbuf, offset, 32);
        offset = Octal.getOctalBytes(this.header.devMajor, outbuf, offset, 8);
        offset = Octal.getOctalBytes(this.header.devMinor, outbuf, offset, 8);
        int oblen = outbuf.length;
        while (offset < oblen) {
            outbuf[offset++] = 0;
        }
        long checkSum = this.computeCheckSum(outbuf);
        Octal.getCheckSumOctalBytes(checkSum, outbuf, csOffset, 8);
    }

    public void parseTarHeader(byte[] bh) {
        int offset = 0;
        this.header.name = TarHeader.parseName(bh, offset, 100);
        this.header.mode = (int)Octal.parseOctal(bh, offset += 100, 8);
        this.header.userId = (int)Octal.parseOctal(bh, offset += 8, 8);
        this.header.groupId = (int)Octal.parseOctal(bh, offset += 8, 8);
        this.header.size = Octal.parseOctal(bh, offset += 8, 12);
        this.header.modTime = Octal.parseOctal(bh, offset += 12, 12);
        this.header.checkSum = (int)Octal.parseOctal(bh, offset += 12, 8);
        offset += 8;
        this.header.linkFlag = bh[offset++];
        this.header.linkName = TarHeader.parseName(bh, offset, 100);
        this.header.magic = TarHeader.parseName(bh, offset += 100, 8);
        this.header.userName = TarHeader.parseName(bh, offset += 8, 32);
        this.header.groupName = TarHeader.parseName(bh, offset += 32, 32);
        this.header.devMajor = (int)Octal.parseOctal(bh, offset += 32, 8);
        this.header.devMinor = (int)Octal.parseOctal(bh, offset += 8, 8);
    }
}

