/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.io.tar;

import com.codename1.io.FileSystemStorage;
import java.io.IOException;

public class TarUtils {
    public static long calculateTarSize(String path) throws IOException {
        return TarUtils.tarSize(path) + 1024L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static long tarSize(String path) throws IOException {
        long size = 0L;
        FileSystemStorage fileSystem = FileSystemStorage.getInstance();
        if (!fileSystem.isDirectory(path)) return TarUtils.entrySize(fileSystem.getLength(path));
        String[] subFiles = fileSystem.listFiles(path);
        if (subFiles == null || subFiles.length <= 0) return 512L;
        for (String file : subFiles) {
            if (fileSystem.isDirectory(file)) {
                size += TarUtils.tarSize(file);
                continue;
            }
            size += TarUtils.entrySize(fileSystem.getLength(file));
        }
        return size;
    }

    private static long entrySize(long fileSize) {
        long size = 0L;
        size += 512L;
        long extra = (size += fileSize) % 512L;
        if (extra > 0L) {
            size += 512L - extra;
        }
        return size;
    }
}

