/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.l10n;

import com.codename1.l10n.DateFormat;
import com.codename1.l10n.DateFormatSymbols;
import com.codename1.l10n.L10NManager;
import com.codename1.l10n.ParseException;
import com.codename1.util.DateUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleDateFormat
extends DateFormat {
    private static final char ERA_LETTER = 'G';
    private static final char YEAR_LETTER = 'y';
    private static final char MONTH_LETTER = 'M';
    private static final char WEEK_IN_YEAR_LETTER = 'w';
    private static final char WEEK_IN_MONTH_LETTER = 'W';
    private static final char DAY_IN_YEAR_LETTER = 'D';
    private static final char DAY_LETTER = 'd';
    private static final char DOW_IN_MONTH_LETTER = 'F';
    private static final char DAY_OF_WEEK_LETTER = 'E';
    private static final char AMPM_LETTER = 'a';
    private static final char HOUR_LETTER = 'H';
    private static final char HOUR_1_LETTER = 'k';
    private static final char HOUR12_LETTER = 'K';
    private static final char HOUR12_1_LETTER = 'h';
    private static final char MINUTE_LETTER = 'm';
    private static final char SECOND_LETTER = 's';
    private static final char MILLISECOND_LETTER = 'S';
    private static final char TIMEZONE_LETTER = 'z';
    private static final char TIMEZONE822_LETTER = 'Z';
    private static final char LITERAL_LETTER = '*';
    private static final char EXPLICIT_LITERAL = '\'';
    private static final char SIGN_POSITIVE = '+';
    private static final char SIGN_NEGATIVE = '-';
    private static final int MILLIS_TO_MINUTES = 60000;
    private static final String PATTERN_LETTERS = "adDEFGHhKkMmsSwWyzZ";
    private static final String GMT = "GMT";
    private static final int ERA = 0;
    private static final int WEEK_OF_MONTH = 4;
    private static final int WEEK_OF_YEAR = 3;
    private static final int DAY_OF_WEEK_IN_MONTH = 8;
    private static final int DAY_OF_YEAR = 6;
    private static boolean restrictMonthNameLength;
    private DateFormatSymbols dateFormatSymbols;
    private String pattern;
    private List<String> patternTokens;

    public SimpleDateFormat() {
    }

    public SimpleDateFormat(String pattern) {
        this.pattern = pattern;
    }

    public static boolean isRestrictMonthNameLength() {
        return restrictMonthNameLength;
    }

    public static void setRestrictMonthNameLength(boolean restrict) {
        restrictMonthNameLength = restrict;
    }

    private static String applyMonthLengthRestriction(String value, int len) {
        if (restrictMonthNameLength && value != null && value.length() > len) {
            return value.substring(0, len);
        }
        return value;
    }

    public String toPattern() {
        return this.pattern;
    }

    public DateFormatSymbols getDateFormatSymbols() {
        if (this.dateFormatSymbols == null) {
            this.dateFormatSymbols = new DateFormatSymbols();
        }
        return this.dateFormatSymbols;
    }

    public void setDateFormatSymbols(DateFormatSymbols newSymbols) {
        this.dateFormatSymbols = newSymbols;
    }

    public void applyPattern(String pattern) {
        this.pattern = pattern;
        if (this.patternTokens != null) {
            this.patternTokens.clear();
            this.patternTokens = null;
        }
    }

    List<String> getPatternTokens() {
        if (this.patternTokens == null) {
            this.patternTokens = this.parseDatePattern(this.pattern);
        }
        return this.patternTokens;
    }

    @Override
    public Object clone() {
        SimpleDateFormat sdf = new SimpleDateFormat(this.pattern);
        sdf.setDateFormatSymbols(this.dateFormatSymbols);
        return sdf;
    }

    @Override
    public String format(Date source) {
        return this.format(source, new StringBuilder());
    }

    @Override
    String format(Date source, StringBuffer toAppendTo) {
        StringBuilder sb = new StringBuilder();
        this.format(source, sb);
        toAppendTo.append((CharSequence)sb);
        return toAppendTo.toString();
    }

    @Override
    String format(Date source, StringBuilder toAppendTo) {
        if (this.pattern == null) {
            return super.format(source, toAppendTo);
        }
        Calendar calendar = Calendar.getInstance(TimeZone.getDefault());
        calendar.setTime(source);
        List<String> pattern = this.getPatternTokens();
        block19: for (int i = 0; i < pattern.size(); ++i) {
            String token = pattern.get(i);
            char patternChar = token.charAt(0);
            token = token.substring(1);
            int len = token.length();
            int v = -1;
            switch (patternChar) {
                case '*': {
                    toAppendTo.append(token);
                    continue block19;
                }
                case 'a': {
                    boolean am = calendar.get(9) == 0;
                    String[] ampm = this.getDateFormatSymbols().getAmPmStrings();
                    toAppendTo.append(am ? ampm[0] : ampm[1]);
                    continue block19;
                }
                case 'G': {
                    toAppendTo.append(this.getDateFormatSymbols().getEras()[calendar.get(0)]);
                    continue block19;
                }
                case 'E': {
                    v = calendar.get(7) - 1;
                    if (len > 3) {
                        toAppendTo.append(this.getDateFormatSymbols().getWeekdays()[v]);
                        continue block19;
                    }
                    toAppendTo.append(this.getDateFormatSymbols().getShortWeekdays()[v]);
                    continue block19;
                }
                case 'z': {
                    String[] names = this.getTimeZoneDisplayNames(calendar.getTimeZone().getID());
                    if (names == null) {
                        toAppendTo.append(calendar.getTimeZone().getID());
                        continue block19;
                    }
                    DateUtil du = new DateUtil(TimeZone.getTimeZone(names[0]));
                    toAppendTo.append(names[du.inDaylightTime(source) ? 4 : 2]);
                    continue block19;
                }
                case 'Z': {
                    v = this.getOffsetInMinutes(calendar, calendar.getTimeZone());
                    if (v < 0) {
                        toAppendTo.append('-');
                        v = -v;
                    } else {
                        toAppendTo.append('+');
                    }
                    toAppendTo.append(this.leftPad(v / 60, 2));
                    toAppendTo.append(this.leftPad(v % 60, 2));
                    continue block19;
                }
                case 'y': {
                    v = calendar.get(1);
                    if (len == 2) {
                        v %= 100;
                    }
                    toAppendTo.append(this.leftPad(v, len));
                    continue block19;
                }
                case 'M': {
                    v = calendar.get(2) - 0;
                    if (len > 3) {
                        toAppendTo.append(SimpleDateFormat.applyMonthLengthRestriction(L10NManager.getInstance().getLongMonthName(source), len));
                        continue block19;
                    }
                    if (len == 3) {
                        toAppendTo.append(SimpleDateFormat.applyMonthLengthRestriction(L10NManager.getInstance().getShortMonthName(source), len));
                        continue block19;
                    }
                    toAppendTo.append(this.leftPad(v + 1, len));
                    continue block19;
                }
                case 'd': {
                    v = calendar.get(5);
                    toAppendTo.append(this.leftPad(v, len));
                    continue block19;
                }
                case 'H': 
                case 'K': 
                case 'h': 
                case 'k': {
                    v = calendar.get(11);
                    if (patternChar == 'k' && v == 0) {
                        v = 24;
                    }
                    if (patternChar == 'h') {
                        if ((v %= 12) == 0) {
                            v = 12;
                        }
                    } else if (patternChar == 'K') {
                        v %= 12;
                    }
                    toAppendTo.append(this.leftPad(v, len));
                    continue block19;
                }
                case 'm': {
                    v = calendar.get(12);
                    toAppendTo.append(this.leftPad(v, len));
                    continue block19;
                }
                case 's': {
                    v = calendar.get(13);
                    toAppendTo.append(this.leftPad(v, len));
                    continue block19;
                }
                case 'S': {
                    v = calendar.get(14);
                    toAppendTo.append(this.leftPad(v, len));
                    continue block19;
                }
                case 'w': {
                    v = calendar.get(3);
                    toAppendTo.append(this.leftPad(v, len));
                    continue block19;
                }
                case 'W': {
                    v = calendar.get(4);
                    toAppendTo.append(this.leftPad(v, len));
                    continue block19;
                }
                case 'D': {
                    v = calendar.get(6);
                    toAppendTo.append(this.leftPad(v, len));
                    continue block19;
                }
                case 'F': {
                    v = calendar.get(8);
                    toAppendTo.append(this.leftPad(v, len));
                }
            }
        }
        return toAppendTo.toString();
    }

    private String[] getTimeZoneDisplayNames(String id) {
        for (String[] zoneStrings : this.getDateFormatSymbols().getZoneStrings()) {
            if (!zoneStrings[0].equalsIgnoreCase(id)) continue;
            return zoneStrings;
        }
        return null;
    }

    String leftPad(int v, int size) {
        String s = String.valueOf(v);
        for (int i = s.length(); i < size; ++i) {
            s = '0' + s;
        }
        return s;
    }

    @Override
    public Date parse(String source) throws ParseException {
        if (this.pattern == null) {
            throw new ParseException("You must provide a template before calling the SimpleDateFormat.parse(...) method", 0);
        }
        int startIndex = 0;
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone(GMT));
        TimeZone parsedTimeZone = null;
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        int tzMinutes = -1;
        int pmMinutes = 0;
        List<String> pattern = this.getPatternTokens();
        for (int i = 0; i < pattern.size(); ++i) {
            String token = pattern.get(i);
            boolean adjacent = false;
            if (i < pattern.size() - 1) {
                adjacent = pattern.get(i + 1).charAt(0) != '*';
            }
            String s = null;
            int v = -1;
            char patternChar = token.charAt(0);
            token = token.substring(1);
            switch (patternChar) {
                case '*': {
                    s = this.readLiteral(source, startIndex, token);
                    if (s.equalsIgnoreCase(token)) break;
                    throw new ParseException("Unparseable string " + source, startIndex);
                }
                case 'a': {
                    s = this.readAmPmMarker(source, startIndex);
                    if (s == null || (v = this.parseAmPmMarker(source, startIndex)) == -1) {
                        this.throwInvalid("am/pm marker", startIndex);
                    }
                    if (v != 1) break;
                    pmMinutes = 720;
                    break;
                }
                case 'E': {
                    s = this.readDayOfWeek(source, startIndex);
                    if (s != null) break;
                    this.throwInvalid("weekday", startIndex);
                    break;
                }
                case 'Z': 
                case 'z': {
                    s = this.readTimeZone(source, startIndex);
                    TimeZoneResult res = new TimeZoneResult();
                    if (s == null || (v = this.parseTimeZone(s, startIndex, res)) == -1) {
                        this.throwInvalid("timezone", startIndex);
                    }
                    if (res != null) {
                        parsedTimeZone = res.timeZone;
                    }
                    tzMinutes = (tzMinutes == -1 ? 0 : tzMinutes) + v;
                    break;
                }
                case 'y': {
                    s = this.readNumber(source, startIndex, token, adjacent);
                    calendar.set(1, this.parseYear(s, token, startIndex));
                    break;
                }
                case 'M': {
                    s = this.readMonth(source, startIndex, token, adjacent);
                    calendar.set(2, this.parseMonth(s, startIndex));
                    break;
                }
                case 'd': {
                    s = this.readNumber(source, startIndex, token, adjacent);
                    calendar.set(5, this.parseNumber(s, startIndex, "day of month", 1, 31));
                    break;
                }
                case 'H': 
                case 'K': 
                case 'h': 
                case 'k': {
                    s = this.readNumber(source, startIndex, token, adjacent);
                    calendar.set(11, this.parseHour(s, patternChar, startIndex));
                    break;
                }
                case 'm': {
                    s = this.readNumber(source, startIndex, token, adjacent);
                    calendar.set(12, this.parseNumber(s, startIndex, "minute", 0, 59));
                    break;
                }
                case 's': {
                    s = this.readNumber(source, startIndex, token, adjacent);
                    calendar.set(13, this.parseNumber(s, startIndex, "second", 0, 59));
                    break;
                }
                case 'S': {
                    s = this.readNumber(source, startIndex, token, adjacent);
                    calendar.set(14, this.parseNumber(s, startIndex, "millisecond", 0, 999));
                    break;
                }
                case 'w': {
                    s = this.readNumber(source, startIndex, token, adjacent);
                    calendar.set(3, this.parseNumber(s, startIndex, "week of year", 1, 52));
                    break;
                }
                case 'W': {
                    s = this.readNumber(source, startIndex, token, adjacent);
                    calendar.set(4, this.parseNumber(s, startIndex, "week of month", 0, 5));
                    break;
                }
                case 'D': {
                    s = this.readNumber(source, startIndex, token, adjacent);
                    calendar.set(6, this.parseNumber(s, startIndex, "day of year", 1, 365));
                    break;
                }
                case 'F': {
                    s = this.readNumber(source, startIndex, token, adjacent);
                    calendar.set(8, this.parseNumber(s, startIndex, "day of week in month", -5, 5));
                }
            }
            if (s == null) continue;
            startIndex += s.length();
        }
        TimeZone localTimezone = Calendar.getInstance().getTimeZone();
        calendar.getTime();
        calendar.setTimeZone(localTimezone);
        if (pmMinutes != 0) {
            calendar.set(12, calendar.get(12) + pmMinutes);
        }
        long rawOffset = localTimezone.getRawOffset();
        int rawOffsetMinutes = (int)(rawOffset / 60000L);
        int localDSTOffset = this.getLocalDSTOffset(calendar);
        if (tzMinutes != -1) {
            tzMinutes = -rawOffsetMinutes - tzMinutes;
            int tzDstOffset = 0;
            if (parsedTimeZone != null) {
                Calendar tzCalendar = Calendar.getInstance(parsedTimeZone);
                tzCalendar.setTime(calendar.getTime());
                tzDstOffset = this.getDSTOffset(tzCalendar);
            }
            calendar.set(12, calendar.get(12) - (tzMinutes -= localDSTOffset - tzDstOffset));
        }
        calendar.set(12, calendar.get(12) - rawOffsetMinutes - localDSTOffset);
        return calendar.getTime();
    }

    int parseHour(String source, char patternChar, int offset) throws ParseException {
        int min = 0;
        boolean oneBased = patternChar == 'k' || patternChar == 'h';
        int max = (patternChar == 'H' || patternChar == 'k' ? 23 : 11) + (oneBased ? 1 : 0);
        return this.parseNumber(source, offset, "hour", min, max);
    }

    void validateNumber(int i, int ofs, String name, int min, int max) throws ParseException {
        if (i < min || i > max) {
            this.throwInvalid(name, ofs);
        }
    }

    int throwInvalid(String name, int offset) throws ParseException {
        throw new ParseException("Invalid " + name + " value", offset);
    }

    int parseNumber(String source, int ofs, String name, int min, int max) throws ParseException {
        if (source == null) {
            this.throwInvalid(name, ofs);
        }
        int v = -1;
        try {
            v = Integer.parseInt(source);
        }
        catch (NumberFormatException nfe) {
            this.throwInvalid(name, ofs);
        }
        if (min != max) {
            this.validateNumber(v, ofs, name, min, max);
        }
        return v;
    }

    int getLocalDSTOffset(Calendar source) {
        TimeZone localTimezone = Calendar.getInstance().getTimeZone();
        int rawOffset = localTimezone.getRawOffset() / 60000;
        return this.getOffsetInMinutes(source, localTimezone) - rawOffset;
    }

    int getDSTOffset(Calendar source) {
        TimeZone timeZone = source.getTimeZone();
        int rawOffset = timeZone.getRawOffset() / 60000;
        return this.getOffsetInMinutes(source, timeZone) - rawOffset;
    }

    int getOffsetInMinutes(Calendar source, TimeZone timezone) {
        return timezone.getOffset(source.get(0), source.get(1), source.get(2), source.get(5), source.get(7), source.get(14)) / 60000;
    }

    String readSubstring(String source, int ofs, int end) {
        if (source == null || ofs > source.length() || end > source.length()) {
            return null;
        }
        return source.substring(ofs, end);
    }

    String readSubstring(String source, int ofs) {
        return this.readSubstring(source, ofs, source.length());
    }

    String readLiteral(String source, int ofs, String token) {
        return this.readSubstring(source, ofs, ofs + token.length());
    }

    String readNumber(String source, int ofs, String token, boolean adjacent) {
        if (adjacent) {
            return this.readSubstring(source, ofs, ofs + token.length());
        }
        int len = source.length();
        for (int i = ofs; i < len; ++i) {
            char ch = source.charAt(i);
            if (this.isNumeric(ch)) continue;
            if (i == 0) {
                return null;
            }
            return this.readSubstring(source, ofs, i);
        }
        return this.readSubstring(source, ofs);
    }

    int parseYear(String source, String token, int ofs) throws ParseException {
        int year = this.parseNumber(source, ofs, "year", -1, -1);
        int len = source.length();
        int tokenLen = token.length();
        int thisYear = Calendar.getInstance().get(1);
        if (len == 2 && tokenLen < 3) {
            int c = thisYear / 100 * 100;
            if ((year += c) > thisYear + 20) {
                year -= 100;
            }
            this.validateNumber(year, ofs, "year", 1000, thisYear + 1000);
        }
        return year;
    }

    String readDayOfWeek(String source, int ofs) {
        String fragment;
        int i = this.findEndText(source, ofs);
        if (i == -1) {
            i = source.length();
        }
        if ((fragment = this.readSubstring(source, ofs, i)) == null) {
            return null;
        }
        DateFormatSymbols ds = this.getDateFormatSymbols();
        for (String weekday : ds.getWeekdays()) {
            if (!fragment.equalsIgnoreCase(weekday)) continue;
            return this.readSubstring(source, ofs, ofs + weekday.length());
        }
        for (String weekday : ds.getShortWeekdays()) {
            if (!fragment.equalsIgnoreCase(weekday)) continue;
            return this.readSubstring(source, ofs, ofs + weekday.length());
        }
        if (ds.isLocalized()) {
            ds.setLocalized(false);
            String s = this.readDayOfWeek(source, ofs);
            ds.setLocalized(true);
            return s;
        }
        return null;
    }

    String readAmPmMarker(String source, int ofs) {
        String[] markers;
        String fragment;
        int i = this.findEndText(source, ofs);
        if (i == -1) {
            i = source.length();
        }
        if ((fragment = this.readSubstring(source, ofs, i).toLowerCase()) == null) {
            return null;
        }
        DateFormatSymbols ds = this.getDateFormatSymbols();
        for (String marker : markers = ds.getAmPmStrings()) {
            if (!fragment.toLowerCase().startsWith(marker.toLowerCase())) continue;
            return this.readSubstring(source, ofs, ofs + marker.length());
        }
        for (String marker : markers) {
            if (fragment.toLowerCase().charAt(0) != marker.toLowerCase().charAt(0)) continue;
            return this.readSubstring(source, ofs, ofs + 1);
        }
        if (ds.isLocalized()) {
            ds.setLocalized(false);
            String s = this.readAmPmMarker(source, ofs);
            ds.setLocalized(true);
            return s;
        }
        return null;
    }

    int parseAmPmMarker(String source, int ofs) throws ParseException {
        DateFormatSymbols ds = this.getDateFormatSymbols();
        String[] markers = this.getDateFormatSymbols().getAmPmStrings();
        int mlen = markers.length;
        for (int i = 0; i < mlen; ++i) {
            if (!markers[i].equalsIgnoreCase(source)) continue;
            return i;
        }
        char ch = source.charAt(ofs);
        if (ch == markers[0].charAt(0)) {
            return 0;
        }
        if (ch == markers[1].charAt(0)) {
            return 1;
        }
        if (ds.isLocalized()) {
            ds.setLocalized(false);
            int i = this.parseAmPmMarker(source, ofs);
            ds.setLocalized(true);
            return i;
        }
        return this.throwInvalid("am/pm marker", ofs);
    }

    String readMonth(String source, int ofs, String token, boolean adjacent) {
        String fragment;
        int i;
        if (token.length() < 3) {
            if (adjacent) {
                return this.readSubstring(source, ofs, ofs + token.length());
            }
            if (this.isNumeric(source.charAt(0))) {
                return this.readNumber(source, ofs, token, adjacent);
            }
        }
        if ((i = this.findEndText(source, ofs)) == -1) {
            i = source.length();
        }
        if ((fragment = this.readSubstring(source, ofs, i)) == null) {
            return null;
        }
        DateFormatSymbols ds = this.getDateFormatSymbols();
        for (String month : ds.getMonths()) {
            if (!fragment.equalsIgnoreCase(month)) continue;
            return this.readSubstring(source, ofs, ofs + month.length());
        }
        for (String month : ds.getShortMonths()) {
            if (!fragment.equalsIgnoreCase(month)) continue;
            return this.readSubstring(source, ofs, ofs + month.length());
        }
        if (ds.isLocalized()) {
            ds.setLocalized(false);
            String s = this.readMonth(source, ofs, token, adjacent);
            ds.setLocalized(true);
            return s;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int parseMonth(String month, int offset) throws ParseException {
        int i;
        if (month == null) {
            this.throwInvalid("month", offset);
        }
        if (month.length() < 3) {
            return this.parseNumber(month, offset, "month", 1, 12) - 1 + 0;
        }
        DateFormatSymbols ds = this.getDateFormatSymbols();
        String[] months = ds.getMonths();
        int mlen = months.length;
        for (i = 0; i < mlen; ++i) {
            if (!month.equalsIgnoreCase(months[i])) continue;
            return i + 0;
        }
        months = ds.getShortMonths();
        mlen = months.length;
        for (i = 0; i < mlen; ++i) {
            if (!month.equalsIgnoreCase(months[i])) continue;
            return i + 0;
        }
        if (ds.isLocalized()) {
            ds.setLocalized(false);
            i = 0;
            try {
                i = this.parseMonth(month, offset);
            }
            finally {
                ds.setLocalized(true);
            }
            return i;
        }
        return this.throwInvalid("month", offset);
    }

    String readTimeZone(String source, int ofs) {
        int sp = source.indexOf(32, ofs);
        String fragment = sp != -1 ? this.readSubstring(source, ofs, sp) : this.readSubstring(source, ofs);
        if (fragment == null) {
            return null;
        }
        int len = fragment.length();
        if (len == 0) {
            return null;
        }
        if (len == 1) {
            if (fragment.equalsIgnoreCase("z")) {
                return this.readSubstring(source, ofs, ofs + 1);
            }
            return null;
        }
        if (len >= 8 && fragment.toUpperCase().startsWith(GMT)) {
            return this.readSubstring(source, ofs);
        }
        char ch = fragment.charAt(0);
        if (len >= 5 && (ch == '-' || ch == '+')) {
            return this.readSubstring(source, ofs, ofs + 5);
        }
        DateFormatSymbols ds = this.getDateFormatSymbols();
        String[][] stringArray = ds.getZoneStrings();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] timezone;
            for (String z : timezone = stringArray[i]) {
                if (!z.equalsIgnoreCase(fragment)) continue;
                return this.readSubstring(source, ofs, ofs + z.length());
            }
        }
        if (ds.isLocalized()) {
            ds.setLocalized(false);
            String s = this.readTimeZone(source, ofs);
            ds.setLocalized(true);
            return s;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int parseTimeZone(String source, int ofs, TimeZoneResult res) throws ParseException {
        char tzSign;
        if (source == null) {
            this.throwInvalid("timezone", ofs);
        }
        if ((tzSign = source.charAt(0)) == 'z' || tzSign == 'Z') {
            return 0;
        }
        if (tzSign == '-' || tzSign == '+') {
            if ((source = this.readSubstring(source, 1)) == null) {
                this.throwInvalid("timezone", ofs);
            }
            int index = 2;
            if (source.length() == 3) {
                --index;
            }
            int tzHours = this.parseNumber(this.readSubstring(source, 0, index), ofs, "timezone", 0, 23);
            int tzMinutes = this.parseNumber(this.readSubstring(source, index), ofs, "timezone", 0, 59);
            tzMinutes += tzHours * 60;
            if (tzSign != '-') {
                tzMinutes = -tzMinutes;
            }
            return tzMinutes;
        }
        if (source.toUpperCase().startsWith(GMT)) {
            int index = source.indexOf(58);
            if (index != -1) {
                String part1 = this.readSubstring(source, 3, index);
                String part2 = this.readSubstring(source, index + 1);
                if (part1 == null || part2 == null) {
                    this.throwInvalid("timezone", ofs);
                }
                source = part1 + part2;
            } else {
                source = this.readSubstring(source, 3);
            }
            if (source.length() == 0) {
                return 0;
            }
            return this.parseTimeZone(source, ofs, res);
        }
        DateFormatSymbols ds = this.getDateFormatSymbols();
        String[][] part1 = ds.getZoneStrings();
        int n = part1.length;
        for (int i = 0; i < n; ++i) {
            String[] timezone;
            for (String z : timezone = part1[i]) {
                TimeZone tz;
                if (!z.equalsIgnoreCase(source)) continue;
                res.timeZone = tz = TimeZone.getTimeZone(timezone[0]);
                return -(tz.getRawOffset() / 60000);
            }
        }
        if (ds.isLocalized()) {
            ds.setLocalized(false);
            int i = 0;
            try {
                i = this.parseTimeZone(source, ofs, res);
            }
            finally {
                ds.setLocalized(true);
            }
            return i;
        }
        return this.throwInvalid("timezone", ofs);
    }

    int findEndText(String source, int ofs) {
        int slen = source.length();
        for (int i = ofs; i < slen; ++i) {
            if (this.isAlpha(source.charAt(i)) || this.isNumeric(source.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    boolean isAlpha(char ch) {
        return ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z';
    }

    boolean isNumeric(char ch) {
        return ch >= '0' && ch <= '9';
    }

    List<String> parseDatePattern(String pattern) {
        Vector<String> tokens = new Vector<String>();
        String tmp = null;
        int plen = pattern.length();
        for (int i = 0; i < plen; ++i) {
            boolean isValid;
            char ch = pattern.charAt(i);
            if (ch == '\'') {
                int n = pattern.indexOf(39, i + 1);
                if (n != -1) {
                    if (tmp != null) {
                        tokens.add(tmp.charAt(0) + tmp);
                        tmp = null;
                    }
                    tokens.add('*' + pattern.substring(i + 1, n));
                }
                i = n;
                continue;
            }
            boolean bl = isValid = PATTERN_LETTERS.indexOf(ch) != -1;
            if (!isValid) {
                int n;
                if (tmp != null) {
                    tokens.add(tmp.charAt(0) + tmp);
                    tmp = null;
                }
                for (n = i; n < plen && PATTERN_LETTERS.indexOf(ch = pattern.charAt(n)) == -1; ++n) {
                    if (!this.isAlpha(ch)) continue;
                    throw new IllegalArgumentException("Illegal pattern character: " + ch);
                }
                tokens.add('*' + pattern.substring(i, n));
                i = n - 1;
                continue;
            }
            if (tmp == null) {
                tmp = String.valueOf(ch);
                continue;
            }
            if (ch == tmp.charAt(0)) {
                tmp = tmp + ch;
                continue;
            }
            tokens.add(tmp.charAt(0) + tmp);
            tmp = String.valueOf(ch);
        }
        if (tmp != null) {
            tokens.add(tmp.charAt(0) + tmp);
        }
        return tokens;
    }

    private static class TimeZoneResult {
        TimeZone timeZone;

        private TimeZoneResult() {
        }
    }
}

