/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.location;

import com.codename1.location.Location;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Geofence {
    private final String id;
    private final Location loc;
    private final int radius;
    private final long expiration;

    public Geofence(String id, Location loc, int radius, long expiration) {
        this.id = id;
        this.loc = loc;
        this.radius = radius;
        this.expiration = expiration;
    }

    public static Comparator<Geofence> createDistanceComparator(final Geofence refRegion) {
        return new Comparator<Geofence>(){

            @Override
            public int compare(Geofence o1, Geofence o2) {
                double d2;
                double d1 = refRegion.getDistanceTo(o1);
                return d1 < (d2 = refRegion.getDistanceTo(o2)) ? -1 : (d2 < d1 ? 1 : 0);
            }
        };
    }

    public static Comparator<Geofence> createDistanceComparator(final Location refPoint) {
        return new Comparator<Geofence>(){

            @Override
            public int compare(Geofence o1, Geofence o2) {
                double d2;
                double d1 = Math.max(0.0, refPoint.getDistanceTo(o1.getLoc()) - (double)o1.getRadius());
                return d1 < (d2 = Math.max(0.0, refPoint.getDistanceTo(o2.getLoc()) - (double)o2.getRadius())) ? -1 : (d2 < d1 ? 1 : 0);
            }
        };
    }

    public String getId() {
        return this.id;
    }

    public Location getLoc() {
        return this.loc;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public int getRadius() {
        return this.radius;
    }

    public double getDistanceTo(Geofence gf) {
        return Math.max(0.0, this.getLoc().getDistanceTo(gf.getLoc()) - (double)gf.getRadius() - (double)this.getRadius());
    }

    public boolean equals(Object o) {
        if (o instanceof Geofence) {
            Geofence g = (Geofence)o;
            return this.eq(this.id, g.id) && g.radius == this.radius && this.eq(this.loc, g.loc) && g.expiration == this.expiration;
        }
        return false;
    }

    private boolean eq(Object o1, Object o2) {
        if (o1 != null) {
            return o1.equals(o2);
        }
        if (o2 != null) {
            return o2.equals(o1);
        }
        return true;
    }

    private boolean eq(Location l1, Location l2) {
        if (l1 != null) {
            return l1.equalsLatLng(l2);
        }
        if (l2 != null) {
            return l2.equalsLatLng(l1);
        }
        return true;
    }
}

