/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.location;

import com.codename1.io.Log;
import com.codename1.io.Storage;
import com.codename1.location.Geofence;
import com.codename1.location.GeofenceListener;
import com.codename1.location.Location;
import com.codename1.location.LocationListener;
import com.codename1.location.LocationManager;
import com.codename1.ui.Display;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeofenceManager
implements Iterable<Geofence> {
    private static final String STORAGE_KEY = "$AsyncGeoStreamer.geofences$";
    private static final String ACTIVE_FENCES_KEY = "$AsyncGeoStreamer.activegeofences$";
    private static final String CURRENT_ACTIVE_KEY = "$AsyncGeoStreamer.currentActive";
    private static final String EXPIRATIONS_KEY = "$AsyncGeoStreamer.expirations";
    private static final String LISTENER_CLASS_KEY = "$AsyncGeoStreamer.listenerClass";
    private static final String BUBBLE_GEOFENCE_ID = "$AsyncGeoStreamer.bubble";
    private static final int defaultTimeout = 10000;
    private static int MAX_ACTIVE_GEOFENCES = 19;
    private static GeofenceManager instance;
    Geofence lastBubble;
    private int bubbleRadius = 1000;
    private long bubbleExpiration = -1L;
    private Class<GeofenceListener> listenerClass;
    private List<String> activeKeys;
    private Map<String, Long> expiryTimes;
    private Map<String, Geofence> fences;
    private Map<String, Geofence> activeFences;

    private GeofenceManager() {
        if ("and".equals(Display.getInstance().getPlatformName())) {
            MAX_ACTIVE_GEOFENCES = 99;
        }
        this.update(10000, true);
    }

    public static GeofenceManager getInstance() {
        if (instance == null) {
            instance = new GeofenceManager();
        }
        return instance;
    }

    private synchronized Map<String, Long> getExpiryTimes(boolean reload) {
        if (reload || this.expiryTimes == null) {
            try {
                this.expiryTimes = (Map)Storage.getInstance().readObject(EXPIRATIONS_KEY);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.expiryTimes == null) {
                this.expiryTimes = new HashMap<String, Long>();
            }
        }
        return this.expiryTimes;
    }

    private synchronized void updateExpiryTimes(Geofence ... geofences) {
        Map<String, Long> times = this.getExpiryTimes(false);
        long now = System.currentTimeMillis();
        for (Geofence g : geofences) {
            if (g.getExpiration() <= 0L) {
                times.put(g.getId(), -1L);
                continue;
            }
            times.put(g.getId(), now + g.getExpiration());
        }
        Storage.getInstance().writeObject(EXPIRATIONS_KEY, times);
    }

    private synchronized void purgeExpired() {
        long now = System.currentTimeMillis();
        Map<String, Long> times = this.getExpiryTimes(false);
        Map<String, Geofence> fences = this.getFences(false);
        List<String> activeKeys = this.getActiveKeys(false);
        Map<String, Geofence> activeFences = this.getActiveFences(false);
        boolean saveFences = false;
        boolean saveActive = false;
        boolean saveActiveFences = false;
        for (Map.Entry<String, Long> time : times.entrySet()) {
            if (time.getValue() <= 0L || time.getValue() >= now) continue;
            times.remove(time.getKey());
            if (!saveFences && fences.containsKey(time.getKey())) {
                saveFences = true;
            }
            fences.remove(time.getKey());
            while (activeKeys.remove(time.getKey())) {
                saveActive = true;
            }
            if (!activeFences.containsKey(time.getKey())) continue;
            activeFences.remove(time.getKey());
            saveActiveFences = true;
        }
        Storage.getInstance().writeObject(EXPIRATIONS_KEY, times);
        if (saveFences) {
            this.saveFences();
        }
        if (saveActive) {
            this.saveActiveKeys();
        }
        if (saveActiveFences) {
            this.saveActiveFences();
        }
    }

    public int getBubbleRadius() {
        return this.bubbleRadius;
    }

    public void setBubbleRadius(int bubbleRadius) {
        this.bubbleRadius = bubbleRadius;
    }

    public long getBubbleExpiration() {
        return this.bubbleExpiration;
    }

    public void setBubbleExpiration(long bubbleExpiration) {
        this.bubbleExpiration = bubbleExpiration;
    }

    public boolean isBubble(String id) {
        return BUBBLE_GEOFENCE_ID.equals(id);
    }

    public synchronized Class<? extends GeofenceListener> getListenerClass() {
        String className;
        if (this.listenerClass == null && (className = (String)Storage.getInstance().readObject(LISTENER_CLASS_KEY)) != null) {
            try {
                this.listenerClass = Class.forName(className);
            }
            catch (Throwable t) {
                Log.e(t);
            }
        }
        return this.listenerClass;
    }

    public synchronized void setListenerClass(Class<? extends GeofenceListener> c) {
        this.listenerClass = c;
        if (c == null) {
            Storage.getInstance().deleteStorageFile(LISTENER_CLASS_KEY);
        } else {
            Storage.getInstance().writeObject(LISTENER_CLASS_KEY, c.getName());
        }
    }

    private GeofenceListener getListener() {
        Class<? extends GeofenceListener> c = this.getListenerClass();
        if (c != null) {
            try {
                return c.newInstance();
            }
            catch (Throwable t) {
                Log.e(t);
            }
        }
        return null;
    }

    public synchronized void add(Geofence ... geofence) {
        Map<String, Geofence> fences = this.getFences(false);
        for (Geofence f : geofence) {
            fences.put(f.getId(), f);
        }
        this.saveFences();
        this.updateExpiryTimes(geofence);
    }

    public synchronized void add(Collection<Geofence> geofences) {
        this.add(geofences.toArray(new Geofence[geofences.size()]));
    }

    private synchronized List<String> getActiveKeys(boolean reload) {
        if (reload || this.activeKeys == null) {
            this.activeKeys = (List)Storage.getInstance().readObject(CURRENT_ACTIVE_KEY);
            if (this.activeKeys == null) {
                this.activeKeys = new ArrayList<String>();
            }
        }
        return this.activeKeys;
    }

    public synchronized boolean isCurrentlyActive(String id) {
        return this.getActiveKeys(false).contains(id);
    }

    private synchronized void saveActiveKeys() {
        Storage.getInstance().writeObject(CURRENT_ACTIVE_KEY, this.getActiveKeys(false));
    }

    public synchronized void remove(String ... ids) {
        Map<String, Geofence> fences = this.getFences(false);
        for (String i : ids) {
            fences.remove(i);
        }
        this.saveFences();
    }

    public synchronized void remove(Collection<String> ids) {
        this.remove(ids.toArray(new String[ids.size()]));
    }

    public synchronized void clear() {
        Map<String, Geofence> fences = this.getFences(false);
        fences.clear();
        this.saveFences();
    }

    public synchronized int size() {
        return this.getFences(false).size();
    }

    public synchronized Map<String, Geofence> asMap() {
        return this.getFences(false);
    }

    public synchronized List<Geofence> asList() {
        return new ArrayList<Geofence>(this.getFences(false).values());
    }

    public synchronized List<Geofence> asSortedList() {
        List<Geofence> l = this.asList();
        Location curr = LocationManager.getLocationManager().getLastKnownLocation();
        if (curr != null) {
            Collections.sort(l, Geofence.createDistanceComparator(curr));
        }
        return l;
    }

    public synchronized void refresh() {
        this.getFences(true);
    }

    private Geofence fromMap(Map<String, Object> m) {
        double lng = (Double)m.get("lng");
        double lat = (Double)m.get("lat");
        String id = (String)m.get("id");
        int radius = (Integer)m.get("radius");
        Long expiration = (Long)m.get("expiration");
        if (expiration == null) {
            expiration = -1L;
        }
        Location l = new Location();
        l.setLatitude(lat);
        l.setLongitude(lng);
        return new Geofence(id, l, radius, expiration);
    }

    private Map<String, Object> toMap(Geofence g) {
        double lng = g.getLoc().getLongitude();
        double lat = g.getLoc().getLatitude();
        int radius = g.getRadius();
        String id = g.getId();
        HashMap<String, Object> out = new HashMap<String, Object>();
        out.put("lng", lng);
        out.put("lat", lat);
        out.put("radius", radius);
        out.put("id", id);
        out.put("expiration", g.getExpiration());
        return out;
    }

    private synchronized Map<String, Geofence> getActiveFences(boolean reload) {
        if (reload || this.activeFences == null) {
            this.activeFences = new HashMap<String, Geofence>();
            Map tmp = (Map)Storage.getInstance().readObject(ACTIVE_FENCES_KEY);
            if (tmp != null) {
                for (Map.Entry e : tmp.entrySet()) {
                    this.activeFences.put((String)e.getKey(), this.fromMap((Map)e.getValue()));
                }
            }
        }
        return this.activeFences;
    }

    private synchronized void saveActiveFences() {
        if (this.activeFences != null) {
            HashMap<String, Map<String, Object>> out = new HashMap<String, Map<String, Object>>();
            for (Map.Entry<String, Geofence> f : this.activeFences.entrySet()) {
                out.put(f.getValue().getId(), this.toMap(f.getValue()));
            }
            Storage.getInstance().writeObject(ACTIVE_FENCES_KEY, out);
        }
    }

    private synchronized Map<String, Geofence> getFences(boolean reload) {
        if (reload || this.fences == null) {
            this.fences = new HashMap<String, Geofence>();
            Map tmp = (Map)Storage.getInstance().readObject(STORAGE_KEY);
            if (tmp != null) {
                for (Map.Entry e : tmp.entrySet()) {
                    this.fences.put((String)e.getKey(), this.fromMap((Map)e.getValue()));
                }
            }
        }
        return this.fences;
    }

    private synchronized void saveFences() {
        if (this.fences != null) {
            HashMap<String, Map<String, Object>> out = new HashMap<String, Map<String, Object>>();
            for (Map.Entry<String, Geofence> f : this.fences.entrySet()) {
                out.put(f.getValue().getId(), this.toMap(f.getValue()));
            }
            Storage.getInstance().writeObject(STORAGE_KEY, out);
        }
    }

    private boolean isWithinRadius(Location l1, Location l2, int radius) {
        return l1.getDistanceTo(l2) <= (double)radius;
    }

    public synchronized void update(int timeout) {
        this.update(timeout, false);
    }

    public synchronized void update(int timeout, boolean forceRefresh) {
        Location here = LocationManager.getLocationManager().getCurrentLocationSync(timeout);
        if (here == null) {
            LocationManager.getLocationManager().setBackgroundLocationListener(Listener.class);
            return;
        }
        LocationManager.getLocationManager().setBackgroundLocationListener(null);
        ArrayList<String> activeIds = new ArrayList<String>(this.getActiveKeys(false));
        List<String> activeKeys = this.getActiveKeys(false);
        for (String id : activeIds) {
            Geofence g = this.getFences(false).get(id);
            if (!forceRefresh && g != null) {
                if (this.isWithinRadius(g.getLoc(), here, this.getBubbleRadius() + g.getRadius())) continue;
                LocationManager.getLocationManager().removeGeoFencing(id);
                this.removeAll(activeKeys, id);
                this.activeFences.remove(id);
                continue;
            }
            LocationManager.getLocationManager().removeGeoFencing(id);
            this.removeAll(activeKeys, id);
            this.activeFences.remove(id);
        }
        for (Geofence g : this.asSortedList()) {
            if (!this.isWithinRadius(g.getLoc(), here, this.getBubbleRadius() + g.getRadius())) continue;
            if (activeKeys.size() >= MAX_ACTIVE_GEOFENCES) break;
            Geofence ag = this.getActiveFences(false).get(g.getId());
            if (!forceRefresh && activeKeys.contains(g.getId()) && g.equals(ag)) continue;
            if (!activeKeys.contains(g.getId())) {
                activeKeys.add(g.getId());
            }
            this.activeFences.put(g.getId(), g);
            LocationManager.getLocationManager().addGeoFencing(Listener.class, g);
        }
        this.saveActiveKeys();
        this.saveActiveFences();
        Location hereCopy = new Location();
        hereCopy.setLatitude(here.getLatitude());
        hereCopy.setLongitude(here.getLongitude());
        Geofence bubble = new Geofence(BUBBLE_GEOFENCE_ID, hereCopy, this.getBubbleRadius(), this.getBubbleExpiration());
        if (this.lastBubble == null || this.lastBubble.getLoc().getDistanceTo(bubble.getLoc()) > (double)Math.min(100, this.bubbleRadius + 1)) {
            this.lastBubble = bubble;
            LocationManager.getLocationManager().addGeoFencing(Listener.class, bubble);
        }
        this.purgeExpired();
    }

    private void onExit(String id) {
        GeofenceListener l = this.getListener();
        if (l != null) {
            l.onExit(id);
        }
        if (BUBBLE_GEOFENCE_ID.equals(id)) {
            this.update(10000);
        }
    }

    private void removeAll(List l, Object o) {
        while (l.remove(o)) {
        }
    }

    private void onEntered(String id) {
        GeofenceListener l = this.getListener();
        if (l != null) {
            l.onEntered(id);
        }
    }

    @Override
    public Iterator<Geofence> iterator() {
        return this.getFences(false).values().iterator();
    }

    private void locationUpdated(Location location) {
        this.update(10000);
    }

    public static class Listener
    implements GeofenceListener,
    LocationListener {
        public void onExit(String id) {
            GeofenceManager.getInstance().onExit(id);
        }

        public void onEntered(String id) {
            GeofenceManager.getInstance().onEntered(id);
        }

        public void locationUpdated(Location location) {
            GeofenceManager.getInstance().locationUpdated(location);
        }

        public void providerStateChanged(int newState) {
        }
    }
}

