/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.location;

import com.codename1.util.MathUtil;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Location {
    private int status;
    private double latitude;
    private double longitude;
    private double altitude;
    private float accuracy;
    private float direction;
    private float velocity;
    private long timeStamp;

    public Location() {
    }

    public Location(double latitude, double longitude, double altitude, float direction) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.altitude = altitude;
        this.direction = direction;
    }

    public Location(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    private static double haversine(double lat1, double lon1, double lat2, double lon2) {
        double R = 6372.8;
        double dLat = Math.toRadians(lat2 - lat1);
        double dLon = Math.toRadians(lon2 - lon1);
        lat1 = Math.toRadians(lat1);
        lat2 = Math.toRadians(lat2);
        double a = MathUtil.pow(Math.sin(dLat / 2.0), 2.0) + MathUtil.pow(Math.sin(dLon / 2.0), 2.0) * Math.cos(lat1) * Math.cos(lat2);
        double c = 2.0 * MathUtil.asin(Math.sqrt(a));
        return R * c;
    }

    public float getAccuracy() {
        return this.accuracy;
    }

    public void setAccuracy(float accuracy) {
        if (accuracy != Float.NaN) {
            this.accuracy = accuracy;
        }
    }

    public double getAltitude() {
        return this.altitude;
    }

    public void setAltitude(double altitude) {
        this.altitude = altitude;
    }

    public float getDirection() {
        return this.direction;
    }

    public void setDirection(float direction) {
        this.direction = direction;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double longtitude) {
        this.longitude = longtitude;
    }

    public double getLongtitude() {
        return this.longitude;
    }

    public void setLongtitude(double longtitude) {
        this.longitude = longtitude;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public float getVelocity() {
        return this.velocity;
    }

    public void setVelocity(float velocity) {
        this.velocity = velocity;
    }

    public double getDistanceTo(Location l2) {
        return Location.haversine(this.getLatitude(), this.getLongitude(), l2.getLatitude(), l2.getLongitude()) * 1000.0;
    }

    public String toString() {
        return "altitude = " + this.altitude + "\nlatitude" + this.latitude + "\nlongtitude" + this.longitude + "\ndirection" + this.direction + "\ntimeStamp" + this.timeStamp + "\nvelocity" + this.velocity;
    }

    public Comparator<Location> createDistanceCompartor() {
        return new Comparator<Location>(){

            @Override
            public int compare(Location o1, Location o2) {
                double d2;
                double d1 = Location.this.getDistanceTo(o1);
                return d1 < (d2 = Location.this.getDistanceTo(o2)) ? -1 : (d2 < d1 ? 1 : 0);
            }
        };
    }

    boolean equalsLatLng(Location l) {
        return l != null && l.latitude == this.latitude && l.longitude == this.longitude;
    }
}

