/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.maps;

import com.codename1.io.NetworkEvent;
import com.codename1.io.services.ImageDownloadService;
import com.codename1.maps.BoundingBox;
import com.codename1.maps.Tile;
import com.codename1.ui.Graphics;
import com.codename1.ui.Image;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.geom.Dimension;
import com.codename1.util.StringUtil;

public class ProxyHttpTile
extends Tile {
    private Tile _tile;
    private final String _url;

    public ProxyHttpTile(Dimension tileSize, BoundingBox bbox, String url) {
        super(tileSize, bbox, null);
        this._url = url;
        String cacheId = url.substring(url.indexOf(":") + 1);
        cacheId = StringUtil.replaceAll(cacheId, "\\", "_");
        cacheId = StringUtil.replaceAll(cacheId, "/", "_");
        cacheId = StringUtil.replaceAll(cacheId, ".", "_");
        cacheId = StringUtil.replaceAll(cacheId, "?", "_");
        cacheId = StringUtil.replaceAll(cacheId, "&", "_");
        ImageDownloadService.createImageToStorage(url, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NetworkEvent ne = (NetworkEvent)evt;
                Image i = (Image)ne.getMetaData();
                i.lock();
                ProxyHttpTile.this._tile = new Tile(ProxyHttpTile.this.dimension(), ProxyHttpTile.this.getBoundingBox(), i);
                ProxyHttpTile.this.fireReady();
            }
        }, cacheId, true);
    }

    public boolean paint(Graphics g) {
        if (this._tile == null) {
            return false;
        }
        return this._tile.paint(g);
    }
}

