/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.maps;

import com.codename1.maps.BoundingBox;
import com.codename1.maps.Coord;
import com.codename1.ui.Font;
import com.codename1.ui.Graphics;
import com.codename1.ui.Image;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.geom.Dimension;
import com.codename1.ui.geom.Point;
import com.codename1.ui.plaf.UIManager;

public class Tile {
    private static Image tileLoadingImage;
    private static String tileLoadingText;
    private static final Font f;
    private static boolean paintLoading;
    private final Dimension dimension;
    private final BoundingBox bbox;
    private final Image tileImage;
    private ActionListener listener;

    public Tile(Dimension dimension, BoundingBox boundingBox, Image image) {
        this.dimension = dimension;
        this.bbox = boundingBox;
        this.tileImage = image;
        tileLoadingImage = UIManager.getInstance().getThemeImageConstant("mapTileLoadingImage");
        tileLoadingText = UIManager.getInstance().getThemeConstant("mapTileLoadingText", "Loading...");
    }

    public static void setPaintLoading(boolean toPaint) {
        paintLoading = toPaint;
    }

    public static void setTileLoadingImage(Image tileLoadingImage) {
        Tile.tileLoadingImage = tileLoadingImage;
    }

    public static void setTileLoadingText(String tileLoadingText) {
        Tile.tileLoadingText = tileLoadingText;
    }

    public Point pointPosition(Coord point) {
        int x = this.position(this.dimension.getWidth(), point.getLongitude(), this.bbox.getSouthWest().getLongitude(), this.bbox.getNorthEast().getLongitude());
        int y = this.position(this.dimension.getHeight(), point.getLatitude(), this.bbox.getSouthWest().getLatitude(), this.bbox.getNorthEast().getLatitude());
        return new Point(x, this.dimension.getHeight() - y);
    }

    private int position(int dx, double x, double x1, double x2) {
        return (int)((double)dx * (x - x1) / (x2 - x1));
    }

    private double coord(double percent, double x1, double x2) {
        return x1 + percent * (x2 - x1);
    }

    public Coord position(int posX, int posY) {
        double longitude = this.coord(1.0 * (double)posX / (double)this.dimension.getWidth(), this.bbox.getSouthWest().getLongitude(), this.bbox.getNorthEast().getLongitude());
        double latitude = this.coord(1.0 * (double)posY / (double)this.dimension.getHeight(), this.bbox.getSouthWest().getLatitude(), this.bbox.getNorthEast().getLatitude());
        return new Coord(latitude, longitude, this.bbox.getSouthWest().isProjected());
    }

    public Dimension dimension() {
        return this.dimension;
    }

    public BoundingBox getBoundingBox() {
        return this.bbox;
    }

    public boolean paint(Graphics g) {
        if (this.tileImage != null) {
            g.drawImage(this.tileImage, 0, 0);
            return true;
        }
        return false;
    }

    public void paint(Graphics g, int x, int y) {
        g.translate(x, y);
        if (!this.paint(g) && paintLoading) {
            this.paintTileLoading(g);
        }
        g.translate(-x, -y);
    }

    public void paintTileLoading(Graphics g) {
        if (tileLoadingImage == null) {
            this.paintLoadingText(g);
        } else {
            this.paintLoadingImage(g);
        }
    }

    private void paintLoadingText(Graphics g) {
        g.setColor(0x707070);
        g.fillRect(0, 0, this.dimension().getWidth(), this.dimension().getHeight());
        g.setColor(0xFFFFFF);
        g.setFont(f);
        Font f = g.getFont();
        int strWidth = f.stringWidth(tileLoadingText);
        g.drawString(tileLoadingText, (this.dimension().getWidth() - strWidth) / 2, (this.dimension().getHeight() - f.getHeight()) / 2);
    }

    private void paintLoadingImage(Graphics g) {
        for (int y = 0; y < this.dimension().getHeight(); y += tileLoadingImage.getHeight()) {
            for (int x = 0; x < this.dimension().getWidth(); x += tileLoadingImage.getWidth()) {
                g.drawImage(tileLoadingImage, x, y);
            }
        }
    }

    public void setsTileReadyListener(ActionListener listener) {
        this.listener = listener;
    }

    protected void fireReady() {
        if (this.listener != null) {
            this.listener.actionPerformed(null);
        }
    }

    public String toString() {
        return this.getClass().getName() + " dimension: " + this.dimension + " bbox: " + this.bbox;
    }

    static {
        tileLoadingText = "Loading...";
        f = Font.createSystemFont(32, 1, 16);
        paintLoading = false;
    }
}

