/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.maps.layers;

import com.codename1.maps.BoundingBox;
import com.codename1.maps.Coord;
import com.codename1.maps.Mercator;
import com.codename1.maps.Projection;
import com.codename1.maps.Tile;
import com.codename1.maps.layers.AbstractLayer;
import com.codename1.ui.Graphics;
import com.codename1.ui.geom.Point;
import java.util.Vector;

public class LinesLayer
extends AbstractLayer {
    protected int _lineColor = 0;
    private final Vector _lineSegments = new Vector();

    public LinesLayer() {
        this(new Mercator(), "");
    }

    public LinesLayer(String name) {
        this(new Mercator(), name);
    }

    public LinesLayer(Projection p, String name) {
        super(p, name);
    }

    public void paint(Graphics g, Tile screenTile) {
        g.setColor(this._lineColor);
        g.setAntiAliased(true);
        int segmentsNo = this._lineSegments.size();
        for (int i = 0; i < segmentsNo; ++i) {
            this.paintSegment(g, (Coord[])this._lineSegments.elementAt(i), screenTile);
        }
    }

    protected void paintSegment(Graphics g, Coord[] segment, Tile tile) {
        int pointsNo = segment.length;
        for (int i = 1; i < pointsNo; ++i) {
            Coord start = segment[i - 1];
            Coord end = segment[i];
            Point s = tile.pointPosition(start);
            Point e = tile.pointPosition(end);
            g.drawLine(s.getX(), s.getY(), e.getX(), e.getY());
            g.drawLine(s.getX() - 1, s.getY(), e.getX() - 1, e.getY());
            g.drawLine(s.getX() + 1, s.getY(), e.getX() + 1, e.getY());
            g.drawLine(s.getX(), s.getY() - 1, e.getX(), e.getY() - 1);
            g.drawLine(s.getX(), s.getY() + 1, e.getX(), e.getY() + 1);
        }
    }

    public void addLineSegment(Coord[] coords) {
        if (coords == null || coords.length <= 1) {
            return;
        }
        if (!coords[0].isProjected()) {
            coords = this.getProjection().fromWGS84(coords);
        }
        this._lineSegments.addElement(coords);
    }

    public void lineColor(int rgb) {
        this._lineColor = rgb;
    }

    public BoundingBox boundingBox() {
        BoundingBox bbox = null;
        for (int i = 0; i < this._lineSegments.size(); ++i) {
            Coord[] coords = (Coord[])this._lineSegments.elementAt(i);
            BoundingBox cBbox = BoundingBox.create(coords);
            bbox = bbox == null ? cBbox : bbox.extend(cBbox);
        }
        return bbox;
    }
}

