/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.maps.layers;

import com.codename1.maps.BoundingBox;
import com.codename1.maps.Coord;
import com.codename1.maps.Mercator;
import com.codename1.maps.Projection;
import com.codename1.maps.Tile;
import com.codename1.maps.layers.AbstractLayer;
import com.codename1.maps.layers.PointLayer;
import com.codename1.ui.Font;
import com.codename1.ui.Graphics;
import com.codename1.ui.Image;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.events.ActionSource;
import com.codename1.ui.util.EventDispatcher;
import java.util.Vector;

public class PointsLayer
extends AbstractLayer
implements ActionSource {
    private final Vector points = new Vector();
    private Image icon;
    private final EventDispatcher dispatcher = new EventDispatcher();
    private final Font f = Font.createSystemFont(0, 0, 0);

    public PointsLayer() {
        super(new Mercator(), "");
    }

    public PointsLayer(String name) {
        super(new Mercator(), name);
    }

    public PointsLayer(Projection p, String name) {
        super(p, name);
    }

    public void setPointIcon(Image icon) {
        this.icon = icon;
    }

    public void paint(Graphics g, Tile tile) {
        int length = this.points.size();
        g.setColor(0);
        g.setFont(this.f);
        for (int i = 0; i < length; ++i) {
            PointLayer point = (PointLayer)this.points.elementAt(i);
            if (!tile.getBoundingBox().contains(point)) continue;
            point.paint(g, tile);
        }
    }

    public void addPoint(PointLayer point) {
        Image pointIcon = point.getIcon();
        if (pointIcon == null) {
            point.setIcon(this.icon);
        }
        if (!point.isProjected()) {
            Coord c = this.getProjection().fromWGS84(point);
            point.setLatitude(c.getLatitude());
            point.setLongitude(c.getLongitude());
            point.setProjected(true);
        }
        this.points.addElement(point);
    }

    public void removePoint(PointLayer point) {
        if (!point.isProjected()) {
            Coord c = this.getProjection().fromWGS84(point);
            point.setLatitude(c.getLatitude());
            point.setLongitude(c.getLongitude());
            point.setProjected(true);
        }
        this.points.removeElement(point);
    }

    public BoundingBox boundingBox() {
        return BoundingBox.create(this.points);
    }

    public void addActionListener(ActionListener l) {
        this.dispatcher.addListener(l);
    }

    public void removeActionListener(ActionListener l) {
        this.dispatcher.removeListener(l);
    }

    public void fireActionEvent(BoundingBox box) {
        for (int i = 0; i < this.points.size(); ++i) {
            PointLayer point = (PointLayer)this.points.elementAt(i);
            if (!box.contains(point)) continue;
            this.dispatcher.fireActionEvent(new ActionEvent(point));
            return;
        }
    }
}

