/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.media;

import java.util.ArrayList;

public class AudioBuffer {
    private final Object refLock = new Object();
    private int refCounter;
    private final ArrayList<AudioBufferCallback> callbacks = new ArrayList();
    private final float[] buffer;
    private final float[] tmpDownSampleBuffer;
    private boolean inFireFrame = false;
    private final ArrayList<Runnable> pendingOps = new ArrayList();
    private int size;
    private int sampleRate;
    private int numChannels;

    public AudioBuffer(int maxSize) {
        this.buffer = new float[maxSize];
        this.tmpDownSampleBuffer = new float[maxSize];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int retain() {
        Object object = this.refLock;
        synchronized (object) {
            ++this.refCounter;
            return this.refCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int release() {
        Object object = this.refLock;
        synchronized (object) {
            --this.refCounter;
            return this.refCounter;
        }
    }

    public void copyFrom(AudioBuffer source) {
        this.copyFrom(source.getSampleRate(), source.getNumChannels(), source.buffer, 0, source.size);
    }

    public void copyFrom(int sampleRate, int numChannels, float[] source) {
        this.copyFrom(sampleRate, numChannels, source, 0, source.length);
    }

    public void copyFrom(int sampleRate, int numChannels, float[] source, int offset, int len) {
        if (len > this.buffer.length) {
            throw new IllegalArgumentException("Buffer size is " + this.buffer.length + " but attempt to copy " + len + " samples into it");
        }
        this.sampleRate = sampleRate;
        this.numChannels = numChannels;
        System.arraycopy(source, offset, this.buffer, 0, len);
        this.size = len;
        this.fireFrameReceived();
    }

    public void copyTo(AudioBuffer dest) {
        dest.copyFrom(this);
    }

    public void copyTo(float[] dest) {
        this.copyTo(dest, 0);
    }

    public void copyTo(float[] dest, int offset) {
        int len = this.size;
        if (dest.length < offset + len) {
            throw new IllegalArgumentException("Destination is not big enough to store len " + len + " at offset " + offset + ".  Length only " + dest.length);
        }
        System.arraycopy(this.buffer, 0, dest, offset, len);
    }

    public int getSize() {
        return this.size;
    }

    public int getMaxSize() {
        return this.buffer.length;
    }

    private void fireFrameReceived() {
        this.inFireFrame = true;
        try {
            for (AudioBufferCallback l : this.callbacks) {
                l.frameReceived(this);
            }
        }
        finally {
            this.inFireFrame = false;
            while (!this.pendingOps.isEmpty()) {
                Runnable r = this.pendingOps.remove(0);
                r.run();
            }
        }
    }

    public void addCallback(final AudioBufferCallback l) {
        if (this.inFireFrame) {
            this.pendingOps.add(new Runnable(){

                public void run() {
                    AudioBuffer.this.callbacks.add(l);
                }
            });
        } else {
            this.callbacks.add(l);
        }
    }

    public void removeCallback(final AudioBufferCallback l) {
        if (this.inFireFrame) {
            this.pendingOps.add(new Runnable(){

                public void run() {
                    AudioBuffer.this.callbacks.remove(l);
                }
            });
        } else {
            this.callbacks.remove(l);
        }
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int getNumChannels() {
        return this.numChannels;
    }

    public void downSample(int targetSampleRate) {
        if (targetSampleRate == this.sampleRate) {
            return;
        }
        if (targetSampleRate > this.sampleRate) {
            throw new IllegalArgumentException("downsample() expects a target rate that it same or lower than current sample rate.  Current rate=" + this.sampleRate + " target rate requested=" + targetSampleRate);
        }
        float ratio = (float)targetSampleRate / (float)this.sampleRate;
        float stepSize = 1.0f / ratio;
        int len = this.size;
        int j = 0;
        block0: for (int channel = 0; channel < this.numChannels; ++channel) {
            if (this.numChannels == 1) {
                System.arraycopy(this.buffer, 0, this.tmpDownSampleBuffer, 0, len);
            } else {
                int k = 0;
                for (int i = 0; i < this.size; i += this.numChannels) {
                    this.tmpDownSampleBuffer[k++] = this.buffer[i + channel];
                }
            }
            len = this.size / this.numChannels;
            for (float i = 0.0f; i < (float)len; i += stepSize) {
                float v;
                int i0 = (int)Math.floor(i);
                int i1 = (int)Math.ceil(i);
                if (i1 == i0 || i1 > len - 1) {
                    if (i0 > len - 1) continue block0;
                    this.buffer[j + channel] = this.tmpDownSampleBuffer[i0];
                    j += this.numChannels;
                    continue;
                }
                float v0 = this.tmpDownSampleBuffer[i0];
                float v1 = this.tmpDownSampleBuffer[i1];
                float t = Math.round(i) - i0;
                this.buffer[j + channel] = v = v0 + t * (v1 - v0);
                j += this.numChannels;
            }
        }
        this.size = j;
        this.sampleRate = targetSampleRate;
    }

    public static interface AudioBufferCallback {
        public void frameReceived(AudioBuffer var1);
    }
}

