/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.media;

import com.codename1.io.File;
import com.codename1.io.FileSystemStorage;
import com.codename1.io.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class WAVWriter
implements AutoCloseable {
    private final File outputFile;
    private OutputStream out;
    private final int samplingRate;
    private final int channels;
    private final int numBits;
    private long dataLength;

    public WAVWriter(File outputFile, int samplingRate, int channels, int numBits) throws IOException {
        this.outputFile = outputFile;
        this.out = FileSystemStorage.getInstance().openOutputStream(outputFile.getAbsolutePath());
        this.samplingRate = samplingRate;
        this.channels = channels;
        this.numBits = numBits;
    }

    private void writeHeader() throws IOException {
        byte[] header = new byte[44];
        long totalDataLen = this.dataLength + 36L;
        long bitrate = (long)this.samplingRate * (long)this.channels * (long)this.numBits;
        header[0] = 82;
        header[1] = 73;
        header[2] = 70;
        header[3] = 70;
        header[4] = (byte)(totalDataLen & 0xFFL);
        header[5] = (byte)(totalDataLen >> 8 & 0xFFL);
        header[6] = (byte)(totalDataLen >> 16 & 0xFFL);
        header[7] = (byte)(totalDataLen >> 24 & 0xFFL);
        header[8] = 87;
        header[9] = 65;
        header[10] = 86;
        header[11] = 69;
        header[12] = 102;
        header[13] = 109;
        header[14] = 116;
        header[15] = 32;
        header[16] = (byte)this.numBits;
        header[17] = 0;
        header[18] = 0;
        header[19] = 0;
        header[20] = 1;
        header[21] = 0;
        header[22] = (byte)this.channels;
        header[23] = 0;
        header[24] = (byte)(this.samplingRate & 0xFF);
        header[25] = (byte)(this.samplingRate >> 8 & 0xFF);
        header[26] = (byte)(this.samplingRate >> 16 & 0xFF);
        header[27] = (byte)(this.samplingRate >> 24 & 0xFF);
        header[28] = (byte)(bitrate / 8L & 0xFFL);
        header[29] = (byte)(bitrate / 8L >> 8 & 0xFFL);
        header[30] = (byte)(bitrate / 8L >> 16 & 0xFFL);
        header[31] = (byte)(bitrate / 8L >> 24 & 0xFFL);
        header[32] = (byte)(this.channels * this.numBits / 8);
        header[33] = 0;
        header[34] = 16;
        header[35] = 0;
        header[36] = 100;
        header[37] = 97;
        header[38] = 116;
        header[39] = 97;
        header[40] = (byte)(this.dataLength & 0xFFL);
        header[41] = (byte)(this.dataLength >> 8 & 0xFFL);
        header[42] = (byte)(this.dataLength >> 16 & 0xFFL);
        header[43] = (byte)(this.dataLength >> 24 & 0xFFL);
        this.out.write(header);
    }

    public void write(float[] pcmData, int offset, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            float sample = pcmData[offset + i];
            if (this.numBits == 8) {
                byte byteSample = (byte)(sample * 127.0f);
                this.out.write(byteSample & 0xFF);
                ++this.dataLength;
                continue;
            }
            if (this.numBits != 16) {
                throw new IllegalArgumentException("numBits must be 8 or 16 but found " + this.numBits);
            }
            short shortSample = (short)(sample * 32767.0f);
            this.out.write(shortSample & 0xFF);
            this.out.write(shortSample >> 8 & 0xFF);
            this.dataLength += 2L;
        }
    }

    private String getPCMFile() {
        return this.outputFile.getAbsolutePath() + ".pcm";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws Exception {
        this.out.close();
        FileSystemStorage fs = FileSystemStorage.getInstance();
        fs.rename(this.outputFile.getAbsolutePath(), new File(this.getPCMFile()).getName());
        try {
            this.out = fs.openOutputStream(this.outputFile.getAbsolutePath());
            InputStream in = fs.openInputStream(this.getPCMFile());
            this.writeHeader();
            Util.copy(in, this.out);
            try {
                this.out.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                in.close();
            }
            catch (Throwable throwable) {
            }
            Object var5_5 = null;
            fs.delete(this.getPCMFile());
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            fs.delete(this.getPCMFile());
            throw throwable;
        }
    }
}

