/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.payment;

import com.codename1.io.Externalizable;
import com.codename1.io.Util;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Receipt
implements Externalizable {
    public static final String STORE_CODE_ITUNES = "itunes";
    public static final String STORE_CODE_PLAY = "play";
    public static final String STORE_CODE_WINDOWS = "windows";
    public static final String STORE_CODE_SIMULATOR = "simulator";
    private static boolean externalizableRegistered;
    private String sku;
    private Date expiryDate;
    private Date cancellationDate;
    private Date purchaseDate;
    private int quantity;
    private String transactionId;
    private String orderData;
    private String storeCode;
    private String internalId;

    public Receipt() {
    }

    public Receipt(String sku, Date expiryDate, Date cancellationDate, Date purchaseDate, int quantity, String transactionId, String orderData, String storeCode, String internalId) {
        this.sku = sku;
        this.expiryDate = expiryDate;
        this.cancellationDate = cancellationDate;
        this.purchaseDate = purchaseDate;
        this.quantity = quantity;
        this.transactionId = transactionId;
        this.orderData = orderData;
        this.storeCode = storeCode;
        this.internalId = internalId;
    }

    static boolean isExternalizableRegistered() {
        return externalizableRegistered;
    }

    private static void setExternalizableRegistered(boolean aExternalizableRegistered) {
        externalizableRegistered = aExternalizableRegistered;
    }

    static void registerExternalizable() {
        if (!Receipt.isExternalizableRegistered()) {
            Util.register("com.codename1.payment.Receipt", Receipt.class);
            Receipt.setExternalizableRegistered(true);
        }
    }

    public String getSku() {
        return this.sku;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    public Date getExpiryDate() {
        return this.expiryDate;
    }

    public void setExpiryDate(Date expiryDate) {
        this.expiryDate = expiryDate;
    }

    public int getVersion() {
        return 1;
    }

    public void externalize(DataOutputStream out) throws IOException {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("sku", this.getSku());
        m.put("expiryDate", this.getExpiryDate());
        m.put("cancellationDate", this.getCancellationDate());
        m.put("purchaseDate", this.getPurchaseDate());
        m.put("orderData", this.getOrderData());
        m.put("transactionId", this.getTransactionId());
        m.put("quantity", this.getQuantity());
        m.put("storeCode", this.getStoreCode());
        m.put("internalId", this.getInternalId());
        Util.writeObject(m, out);
    }

    public void internalize(int version, DataInputStream in) throws IOException {
        Map m = (Map)Util.readObject(in);
        this.setSku((String)m.get("sku"));
        this.setExpiryDate((Date)m.get("expiryDate"));
        this.cancellationDate = (Date)m.get("cancellationDate");
        this.purchaseDate = (Date)m.get("purchaseDate");
        this.quantity = (Integer)m.get("quantity");
        this.transactionId = (String)m.get("transactionId");
        this.orderData = (String)m.get("orderData");
        this.storeCode = (String)m.get("storeCode");
        this.internalId = (String)m.get("internalId");
    }

    public String getObjectId() {
        return "com.codename1.payment.Receipt";
    }

    public Date getCancellationDate() {
        return this.cancellationDate;
    }

    public void setCancellationDate(Date cancellationDate) {
        this.cancellationDate = cancellationDate;
    }

    public Date getPurchaseDate() {
        return this.purchaseDate;
    }

    public void setPurchaseDate(Date originalPurchaseDate) {
        this.purchaseDate = originalPurchaseDate;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public String getOrderData() {
        return this.orderData;
    }

    public void setOrderData(String orderData) {
        this.orderData = orderData;
    }

    public String getStoreCode() {
        return this.storeCode;
    }

    public void setStoreCode(String storeCode) {
        this.storeCode = storeCode;
    }

    public String getInternalId() {
        return this.internalId;
    }

    public void setInternalId(String internalId) {
        this.internalId = internalId;
    }

    public String toString() {
        String sb = "Receipt {sku:" + this.sku + ", expiryDate:" + this.expiryDate + ", cancellationDate:" + this.cancellationDate + ", purchaseDate:" + this.purchaseDate + ", orderData:" + this.orderData + ", quantity:" + this.quantity + ", transactionId:" + this.transactionId + ", storeCode:" + this.storeCode + ", internalId:" + this.internalId + "}";
        return sb;
    }
}

