/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.processing;

import com.codename1.l10n.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;

class PrettyPrinter {
    Map myHashMap;

    private PrettyPrinter(Map h) {
        this.myHashMap = h;
    }

    public static String print(Map h) {
        return PrettyPrinter.print(h, 2, 0);
    }

    public static String print(List v) {
        return PrettyPrinter.print(v, 2, 0);
    }

    static String print(Map h, int indentFactor, int indent) {
        PrettyPrinter printer = new PrettyPrinter(h);
        return printer.toString(indentFactor, indent);
    }

    static String print(List v, int indentFactor, int indent) {
        int len = v.size();
        if (len == 0) {
            return "[]";
        }
        StringBuffer sb = new StringBuffer("[");
        if (len == 1) {
            sb.append(PrettyPrinter.valueToString(v.get(0), indentFactor, indent));
        } else {
            int i;
            int newindent = indent + indentFactor;
            sb.append('\n');
            for (i = 0; i < len; ++i) {
                if (i > 0) {
                    sb.append(",\n");
                }
                for (int j = 0; j < newindent; ++j) {
                    sb.append(' ');
                }
                sb.append(PrettyPrinter.valueToString(v.get(i), indentFactor, newindent));
            }
            sb.append('\n');
            for (i = 0; i < indent; ++i) {
                sb.append(' ');
            }
        }
        sb.append(']');
        return sb.toString();
    }

    static String valueToString(Object value, int indentFactor, int indent) {
        if (value == null || value.equals(null)) {
            return "null";
        }
        try {
            if (value instanceof String) {
                return PrettyPrinter.quote((String)value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (value instanceof Float || value instanceof Double || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
            return PrettyPrinter.numberToString(value);
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof Map) {
            return PrettyPrinter.print((Map)value, indentFactor, indent);
        }
        if (value instanceof List) {
            return PrettyPrinter.print((List)value, indentFactor, indent);
        }
        if (value instanceof Date) {
            return PrettyPrinter.quote(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS").format((Date)value));
        }
        return PrettyPrinter.quote(value.toString());
    }

    public static String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuffer sb = new StringBuffer(len + 4);
        sb.append('\"');
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u" + t.substring(t.length() - 4));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    static String valueToString(Object value) {
        if (value == null || value.equals(null)) {
            return "null";
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Float || value instanceof Double || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
            return PrettyPrinter.numberToString(value);
        }
        if (value instanceof Boolean || value instanceof Map || value instanceof List) {
            return value.toString();
        }
        return PrettyPrinter.quote(value.toString());
    }

    public static String trimNumber(String s) {
        if (s.indexOf(46) > 0 && s.indexOf(101) < 0 && s.indexOf(69) < 0) {
            while (s.endsWith("0")) {
                s = s.substring(0, s.length() - 1);
            }
            if (s.endsWith(".")) {
                s = s.substring(0, s.length() - 1);
            }
        }
        return s;
    }

    public static String numberToString(Object n) {
        if (n == null) {
            return null;
        }
        return PrettyPrinter.trimNumber(n.toString());
    }

    public int length() {
        return this.myHashMap.size();
    }

    public Enumeration keys() {
        return Collections.enumeration(this.myHashMap.keySet());
    }

    public String toString(int indentFactor) {
        return this.toString(indentFactor, 0);
    }

    String toString(int indentFactor, int indent) {
        int n = this.length();
        if (n == 0) {
            return "{}";
        }
        Enumeration keys = this.keys();
        StringBuffer sb = new StringBuffer("{");
        int newindent = indent + indentFactor;
        if (n == 1) {
            Object o = keys.nextElement();
            sb.append(PrettyPrinter.quote(o.toString()));
            sb.append(": ");
            sb.append(PrettyPrinter.valueToString(this.myHashMap.get(o), indentFactor, indent));
        } else {
            int i;
            while (keys.hasMoreElements()) {
                Object o = keys.nextElement();
                if (sb.length() > 1) {
                    sb.append(",\n");
                } else {
                    sb.append('\n');
                }
                for (i = 0; i < newindent; ++i) {
                    sb.append(' ');
                }
                sb.append(PrettyPrinter.quote(o.toString()));
                sb.append(": ");
                sb.append(PrettyPrinter.valueToString(this.myHashMap.get(o), indentFactor, newindent));
            }
            if (sb.length() > 1) {
                sb.append('\n');
                for (i = 0; i < indent; ++i) {
                    sb.append(' ');
                }
            }
        }
        sb.append('}');
        return sb.toString();
    }
}

