/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.properties;

import com.codename1.io.Log;
import com.codename1.properties.PropertyBase;
import com.codename1.properties.PropertyBusinessObject;
import com.codename1.properties.UiBinding;
import com.codename1.ui.ButtonGroup;
import com.codename1.ui.CheckBox;
import com.codename1.ui.Component;
import com.codename1.ui.Container;
import com.codename1.ui.Display;
import com.codename1.ui.RadioButton;
import com.codename1.ui.TextField;
import com.codename1.ui.layouts.BoxLayout;
import com.codename1.ui.layouts.GridLayout;
import com.codename1.ui.spinner.Picker;
import com.codename1.ui.table.TableLayout;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstantUI {
    private PropertyBase[] order;

    public void excludeProperty(PropertyBase exclude) {
        exclude.putClientProperty("cn1$excludeFromUI", Boolean.TRUE);
    }

    public void excludeProperties(PropertyBase ... exclude) {
        for (PropertyBase p : exclude) {
            p.putClientProperty("cn1$excludeFromUI", Boolean.TRUE);
        }
    }

    public boolean isExcludedProperty(PropertyBase exclude) {
        return exclude.getClientProperty("cn1$excludeFromUI") == Boolean.TRUE;
    }

    public void setMultiChoiceLabels(PropertyBase p, String ... labels) {
        p.putClientProperty("cn1$multiChceLbl", labels);
        if (p.getClientProperty("cn1$multiChceVal") == null) {
            p.putClientProperty("cn1$multiChceVal", labels);
        }
    }

    public void setMultiChoiceValues(PropertyBase p, Object ... values) {
        p.putClientProperty("cn1$multiChceVal", values);
    }

    public void setComponentClass(PropertyBase p, Class cmpCls) {
        p.putClientProperty("cn1$cmpCls", cmpCls);
    }

    public void setTextFieldConstraint(PropertyBase p, int cons) {
        p.putClientProperty("cn1$tconstraint", cons);
    }

    public int getTextFieldConstraint(PropertyBase p) {
        String n;
        Integer v = (Integer)p.getClientProperty("cn1$tconstraint");
        if (v != null) {
            return v;
        }
        Class t = p.getGenericType();
        if (t != null) {
            if (t == Integer.class || t == Long.class || t == Short.class || t == Byte.class) {
                return 2;
            }
            if (t == Double.class || t == Float.class) {
                return 5;
            }
        }
        if ((n = p.getName().toLowerCase()).indexOf("password") > -1) {
            return 65536;
        }
        if (n.indexOf("url") > -1 || n.indexOf("website") > -1 || n.indexOf("blog") > -1) {
            return 4;
        }
        if (n.indexOf("email") > -1) {
            return 1;
        }
        if (n.indexOf("phone") > -1 || n.indexOf("mobile") > -1) {
            return 3;
        }
        return 0;
    }

    public PropertyBase[] getOrder() {
        return this.order;
    }

    public void setOrder(PropertyBase ... order) {
        this.order = order;
    }

    public Container createEditUI(PropertyBusinessObject bo, boolean autoCommit) {
        Container cnt;
        if (Display.getInstance().isTablet()) {
            TableLayout tl = new TableLayout(1, 2);
            tl.setGrowHorizontally(true);
            cnt = new Container(tl);
        } else {
            cnt = new Container(BoxLayout.y());
        }
        UiBinding uib = new UiBinding();
        ArrayList<UiBinding.Binding> allBindings = new ArrayList<UiBinding.Binding>();
        if (this.order != null && this.order.length > 0) {
            for (PropertyBase b : this.order) {
                this.createEntryForProperty(b, cnt, allBindings, uib);
            }
        } else {
            for (PropertyBase b : bo.getPropertyIndex()) {
                this.createEntryForProperty(b, cnt, allBindings, uib);
            }
        }
        cnt.putClientProperty("cn1$iui-binding", uib.createGroupBinding(allBindings));
        return cnt;
    }

    private void createEntryForProperty(PropertyBase b, Container cnt, ArrayList<UiBinding.Binding> allBindings, UiBinding uib) throws RuntimeException {
        if (this.isExcludedProperty(b)) {
            return;
        }
        Class cls = (Class)b.getClientProperty("cn1$cmpCls");
        if (cls != null) {
            try {
                Component cmp = (Component)cls.newInstance();
                cmp.setName(b.getName());
                cnt.add(b.getLabel()).add(cmp);
                allBindings.add(uib.bind(b, cmp));
            }
            catch (Exception err) {
                Log.e(err);
                throw new RuntimeException("Custom property instant UI failed for " + b.getName() + " " + err);
            }
            return;
        }
        String[] multiLabels = (String[])b.getClientProperty("cn1$multiChceLbl");
        if (multiLabels != null) {
            Object[] multiValues = (Object[])b.getClientProperty("cn1$multiChceVal");
            if (multiLabels.length < 5) {
                ButtonGroup bg = new ButtonGroup();
                Component[] rbs = new RadioButton[multiLabels.length];
                cnt.add(b.getLabel());
                Container radioBox = new Container(new GridLayout(multiLabels.length));
                for (int iter = 0; iter < multiLabels.length; ++iter) {
                    rbs[iter] = RadioButton.createToggle(multiLabels[iter], bg);
                    radioBox.add(rbs[iter]);
                }
                cnt.add(radioBox);
                allBindings.add(uib.bindGroup(b, multiValues, rbs));
            } else {
                Picker stringPicker = new Picker();
                stringPicker.setStrings(multiLabels);
                HashMap<Object, Object> m1 = new HashMap<Object, Object>();
                HashMap<Object, Object> m2 = new HashMap<Object, Object>();
                for (int iter = 0; iter < multiLabels.length; ++iter) {
                    m1.put(multiLabels[iter], multiValues[iter]);
                    m2.put(multiValues[iter], multiLabels[iter]);
                }
                cnt.add(b.getLabel()).add(stringPicker);
                allBindings.add(uib.bind(b, stringPicker, new UiBinding.PickerAdapter(new UiBinding.MappingConverter(m1), new UiBinding.MappingConverter(m2))));
            }
            return;
        }
        Class t = b.getGenericType();
        if (t != null) {
            if (t == Boolean.class) {
                CheckBox cb = new CheckBox();
                uib.bind(b, cb);
                cnt.add(b.getLabel()).add(cb);
                return;
            }
            if (t == Date.class) {
                Picker dp = new Picker();
                dp.setType(1);
                uib.bind(b, dp);
                cnt.add(b.getLabel()).add(dp);
                return;
            }
        }
        TextField tf = new TextField();
        tf.setConstraint(this.getTextFieldConstraint(b));
        uib.bind(b, tf);
        cnt.add(b.getLabel()).add(tf);
    }

    public UiBinding.Binding getBindings(Container cnt) {
        return (UiBinding.Binding)cnt.getClientProperty("cn1$iui-binding");
    }
}

