/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.properties;

import com.codename1.io.Preferences;
import com.codename1.properties.Property;
import com.codename1.properties.PropertyBase;
import com.codename1.properties.PropertyBusinessObject;
import com.codename1.properties.PropertyChangeListener;

public class PreferencesObject {
    private PropertyBusinessObject bo;
    private String prefix;
    private boolean bound;

    private PreferencesObject() {
    }

    public static PreferencesObject create(PropertyBusinessObject bo) {
        PreferencesObject po = new PreferencesObject();
        po.bo = bo;
        po.prefix = bo.getPropertyIndex().getName() + ".";
        return po;
    }

    public PreferencesObject bind() {
        for (PropertyBase pb : this.bo.getPropertyIndex()) {
            String name = (String)pb.getClientProperty("cn1-po-name");
            if (name == null) {
                name = pb.getName();
            }
            Class type = pb.getGenericType();
            String n = this.prefix + name;
            if (type == String.class || type == null) {
                ((Property)pb).set(Preferences.getAndSet(n, (String)pb.get()));
                this.bindChangeListener((Property)pb, n, type);
                continue;
            }
            Object obj = pb.get();
            if (type == Boolean.class) {
                ((Property)pb).set(Preferences.getAndSet(n, obj != null && (Boolean)obj != false));
                this.bindChangeListener((Property)pb, n, type);
                continue;
            }
            if (type == Double.class) {
                ((Property)pb).set(Preferences.getAndSet(n, obj == null ? 0.0 : (Double)obj));
                this.bindChangeListener((Property)pb, n, type);
                continue;
            }
            if (type == Float.class) {
                ((Property)pb).set(Float.valueOf(Preferences.getAndSet(n, obj == null ? 0.0f : ((Float)obj).floatValue())));
                this.bindChangeListener((Property)pb, n, type);
                continue;
            }
            if (type == Integer.class) {
                ((Property)pb).set(Preferences.getAndSet(n, obj == null ? 0 : (Integer)obj));
                this.bindChangeListener((Property)pb, n, type);
                continue;
            }
            if (type == Long.class) {
                ((Property)pb).set(Preferences.getAndSet(n, obj == null ? 0L : (Long)obj));
                this.bindChangeListener((Property)pb, n, type);
                continue;
            }
            throw new IllegalStateException("Unsupported property type in preferences: " + type.getName());
        }
        this.bound = true;
        return this;
    }

    private void bindChangeListener(final Property pb, final String n, final Class type) {
        pb.addChangeListener(new PropertyChangeListener(){

            public void propertyChanged(PropertyBase p) {
                if (type == String.class || type == null) {
                    Preferences.set(n, (String)pb.get());
                    return;
                }
                if (type == Boolean.class) {
                    Preferences.set(n, (Boolean)pb.get());
                    return;
                }
                if (type == Double.class) {
                    Preferences.set(n, (Double)pb.get());
                    return;
                }
                if (type == Float.class) {
                    Preferences.set(n, ((Float)pb.get()).floatValue());
                    return;
                }
                if (type == Integer.class) {
                    Preferences.set(n, (Integer)pb.get());
                    return;
                }
                if (type == Long.class) {
                    Preferences.set(n, (Long)pb.get());
                }
            }
        });
    }

    private void checkBind() {
        if (this.bound) {
            throw new IllegalStateException("Method can't be invoked after binding");
        }
    }

    public PreferencesObject setPrefix(String prefix) {
        this.checkBind();
        this.prefix = prefix.intern();
        return this;
    }

    public PreferencesObject setName(PropertyBase pb, String name) {
        this.checkBind();
        pb.putClientProperty("cn1-po-name", name);
        return this;
    }
}

