/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.properties;

import com.codename1.io.Util;
import com.codename1.properties.CollectionProperty;
import com.codename1.properties.MapProperty;
import com.codename1.properties.PropertyBase;
import com.codename1.properties.PropertyBusinessObject;
import com.codename1.properties.PropertyIndex;
import com.codename1.xml.Element;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PropertyXMLElement
extends Element {
    private final PropertyIndex parent;
    private int index = -1;
    private PropertyXMLElement parentElement;

    PropertyXMLElement(PropertyIndex parent) {
        this.parent = parent;
    }

    PropertyXMLElement(PropertyXMLElement parentElement, PropertyIndex parent) {
        this.parent = parent;
        this.parentElement = parentElement;
    }

    @Override
    public void addChild(Element childElement) {
        throw new IllegalStateException();
    }

    @Override
    public boolean contains(Element element) {
        if (this == element) {
            return true;
        }
        Vector children = this.getChildren();
        if (children != null) {
            for (int i = 0; i < children.size(); ++i) {
                Element child = (Element)children.get(i);
                if (!child.contains(element)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getAttribute(String name) {
        PropertyBase o = this.parent.get(name);
        if (o == null) {
            return null;
        }
        return ((Object)o).toString();
    }

    @Override
    public int getAttributeAsInt(String name, int def) {
        PropertyBase o = this.parent.get(name);
        if (o == null) {
            return def;
        }
        return Util.toIntValue(o);
    }

    @Override
    public Hashtable getAttributes() {
        Hashtable<String, String> h = new Hashtable<String, String>();
        for (PropertyBase b : this.parent) {
            Object o;
            if (b.getGenericType() != null && b.getGenericType().isAssignableFrom(PropertyBusinessObject.class) || b instanceof CollectionProperty || b instanceof MapProperty || (o = b.get()) == null) continue;
            h.put(b.getName(), o.toString());
        }
        return super.getAttributes();
    }

    @Override
    public Element getChildAt(int index) {
        int current = -1;
        PropertyBase text = this.parent.getXmlTextElement();
        for (PropertyBase b : this.parent) {
            Object o;
            if (b == text && ++current == index) {
                Element e = new Element(b.getName(), true);
                if (b.get() != null) {
                    e.setText(b.get().toString());
                }
                return e;
            }
            if (b.getGenericType() == null || !b.getGenericType().isAssignableFrom(PropertyBusinessObject.class) || (o = b.get()) == null || ++current != index) continue;
            PropertyXMLElement i = new PropertyXMLElement(this, ((PropertyBusinessObject)o).getPropertyIndex());
            i.index = current;
            return i;
        }
        return null;
    }

    @Override
    public int getChildIndex(Element child) {
        return ((PropertyXMLElement)child).index;
    }

    @Override
    protected Vector getChildren() {
        Vector<Element> v = new Vector<Element>();
        int n = this.getNumChildren();
        for (int iter = 0; iter < n; ++iter) {
            v.add(this.getChildAt(iter));
        }
        return v;
    }

    @Override
    protected void setChildren(Vector children) {
        throw new RuntimeException();
    }

    @Override
    public Vector getChildrenByTagName(String name) {
        Object o;
        Vector<PropertyXMLElement> v = new Vector<PropertyXMLElement>();
        PropertyBase p = this.parent.get(name);
        if (p != null && (o = p.get()) != null) {
            v.add(new PropertyXMLElement(this, ((PropertyBusinessObject)o).getPropertyIndex()));
        }
        return v;
    }

    @Override
    public Vector getDescendantsByTagName(String name) {
        throw new RuntimeException();
    }

    @Override
    public Vector getDescendantsByTagName(String name, int depth) {
        throw new RuntimeException();
    }

    @Override
    public Vector getDescendantsByTagNameAndAttribute(String name, String attributeName, int depth) {
        throw new RuntimeException();
    }

    @Override
    public Element getElementById(String id) {
        String thisId = this.getAttribute("id");
        if (thisId != null && thisId.equals(id)) {
            return this;
        }
        Vector children = this.getChildren();
        if (children != null) {
            for (int i = 0; i < children.size(); ++i) {
                Element child = (Element)children.get(i);
                Element match = child.getElementById(id);
                if (match == null) continue;
                return match;
            }
        }
        return null;
    }

    @Override
    public Element getFirstChildByTagName(String name) {
        Object o;
        PropertyBase p = this.parent.get(name);
        if (p != null && (o = p.get()) != null) {
            return new PropertyXMLElement(this, ((PropertyBusinessObject)o).getPropertyIndex());
        }
        return null;
    }

    @Override
    public int getNumChildren() {
        int current = 0;
        for (PropertyBase b : this.parent) {
            Object o;
            if (b.getGenericType() == null || !b.getGenericType().isAssignableFrom(PropertyBusinessObject.class) || (o = b.get()) == null) continue;
            ++current;
        }
        PropertyBase text = this.parent.getXmlTextElement();
        if (text != null) {
            return current + 1;
        }
        return current;
    }

    @Override
    public Element getParent() {
        return this.parentElement;
    }

    @Override
    protected void setParent(Element parent) {
    }

    @Override
    public String getTagName() {
        return this.parent.getName();
    }

    @Override
    protected void setTagName(String name) {
    }

    @Override
    public String getText() {
        Object o = this.parent.getXmlTextElement().get();
        return o == null ? null : o.toString();
    }

    @Override
    public void setText(String str) {
    }

    @Override
    public Vector getTextChildren(String text, boolean caseSensitive) {
        throw new RuntimeException();
    }

    @Override
    public Vector getTextDescendants(String text, boolean caseSensitive) {
        throw new RuntimeException();
    }

    @Override
    public Vector getTextDescendants(String text, boolean caseSensitive, int depth) {
        throw new RuntimeException();
    }

    @Override
    public boolean hasTextChild() {
        return this.parent.getXmlTextElement() != null && this.parent.getXmlTextElement().get() != null;
    }

    @Override
    public void insertChildAt(Element child, int index) {
        throw new RuntimeException();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public int hashCode() {
        return this.parent.hashCode();
    }

    @Override
    public boolean isTextElement() {
        return false;
    }

    @Override
    protected void setTextElement(boolean textElement) {
    }

    @Override
    protected void removeAttribute(Object id) {
        throw new RuntimeException();
    }

    @Override
    public void removeAttribute(String attribute) {
        throw new RuntimeException();
    }

    @Override
    public Iterator<Element> iterator() {
        final int num = this.getNumChildren();
        return new Iterator<Element>(){
            private int offset = 0;

            @Override
            public boolean hasNext() {
                return this.offset < num;
            }

            @Override
            public Element next() {
                ++this.offset;
                return PropertyXMLElement.this.getChildAt(PropertyXMLElement.this.index);
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public void removeChildAt(int index) {
        throw new RuntimeException();
    }

    @Override
    public void replaceChild(Element oldChild, Element newChild) {
        throw new RuntimeException();
    }

    @Override
    protected void setAttribute(Object id, String value) {
        throw new RuntimeException();
    }

    @Override
    public int setAttribute(String attribute, String value) {
        PropertyBase pb = this.parent.get(attribute);
        if (this.parent.setSimpleObject(pb, value)) {
            return -1;
        }
        return 1;
    }

    @Override
    public String toString() {
        return this.toString("");
    }

    @Override
    public String toString(String spacing) {
        String str = spacing;
        str = str + "<" + this.getTagName();
        Hashtable attributes = this.getAttributes();
        if (attributes != null) {
            Enumeration e = attributes.keys();
            while (e.hasMoreElements()) {
                String attrStr = (String)e.nextElement();
                String val = (String)attributes.get(attrStr);
                str = str + " " + attrStr + "='" + val + "'";
            }
        }
        str = str + ">\n";
        Vector children = this.getChildren();
        if (children != null) {
            for (int i = 0; i < children.size(); ++i) {
                str = str + ((Element)children.get(i)).toString(spacing + ' ');
            }
        }
        str = str + spacing + "</" + this.getTagName() + ">\n";
        return str;
    }
}

