/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.properties;

import com.codename1.db.Cursor;
import com.codename1.db.Database;
import com.codename1.db.Row;
import com.codename1.io.Log;
import com.codename1.io.Util;
import com.codename1.properties.Property;
import com.codename1.properties.PropertyBase;
import com.codename1.properties.PropertyBusinessObject;
import com.codename1.ui.EncodedImage;
import com.codename1.util.Base64;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLMap {
    private boolean verbose = true;
    private Database db;

    private SQLMap() {
    }

    public static SQLMap create(Database db) {
        SQLMap s = new SQLMap();
        s.db = db;
        return s;
    }

    private static String getColumnNameImpl(PropertyBase prop) {
        String val = (String)prop.getClientProperty("cn1$sqlColumn");
        if (val == null) {
            return prop.getName();
        }
        return val;
    }

    public void setPrimaryKey(PropertyBusinessObject cmp, Property pk) {
        cmp.getPropertyIndex().putMetaDataOfClass("cn1$pk", pk.getName());
    }

    public void setPrimaryKeyAutoIncrement(PropertyBusinessObject cmp, Property pk) {
        cmp.getPropertyIndex().putMetaDataOfClass("cn1$pk", pk.getName());
        cmp.getPropertyIndex().putMetaDataOfClass("cn1$autoinc", Boolean.TRUE);
    }

    public void setSqlType(PropertyBase p, SqlType type) {
        p.putClientProperty("cn1$colType", (Object)type);
    }

    public SqlType getSqlType(PropertyBase p) {
        SqlType s = (SqlType)((Object)p.getClientProperty("cn1$colType"));
        if (s == null) {
            if (p instanceof Property) {
                Class gt = p.getGenericType();
                if (gt != null) {
                    if (gt == Integer.class) {
                        return SqlType.SQL_INTEGER;
                    }
                    if (gt == Boolean.class) {
                        return SqlType.SQL_BOOLEAN;
                    }
                    if (gt == Long.class) {
                        return SqlType.SQL_LONG;
                    }
                    if (gt == Short.class) {
                        return SqlType.SQL_SHORT;
                    }
                    if (gt == Float.class) {
                        return SqlType.SQL_FLOAT;
                    }
                    if (gt == Double.class) {
                        return SqlType.SQL_DOUBLE;
                    }
                    if (gt == Date.class) {
                        return SqlType.SQL_DATE;
                    }
                    if (gt == EncodedImage.class || gt == byte[].class) {
                        return SqlType.SQL_BLOB;
                    }
                    return SqlType.SQL_TEXT;
                }
                Object val = p.get();
                if (val != null) {
                    if (val instanceof Long) {
                        return SqlType.SQL_LONG;
                    }
                    if (val instanceof Integer) {
                        return SqlType.SQL_INTEGER;
                    }
                    if (val instanceof Short) {
                        return SqlType.SQL_SHORT;
                    }
                    if (val instanceof Float) {
                        return SqlType.SQL_FLOAT;
                    }
                    if (val instanceof Double) {
                        return SqlType.SQL_DOUBLE;
                    }
                    if (gt == Date.class) {
                        return SqlType.SQL_DATE;
                    }
                }
            }
            return SqlType.SQL_TEXT;
        }
        return s;
    }

    public void setTableName(PropertyBusinessObject cmp, String name) {
        cmp.getPropertyIndex().putMetaDataOfClass("cn1$tableName", name);
    }

    public String getTableName(PropertyBusinessObject cmp) {
        String s = (String)cmp.getPropertyIndex().getMetaDataOfClass("cn1$tableName");
        if (s != null) {
            return s;
        }
        return cmp.getPropertyIndex().getName();
    }

    public void setColumnName(PropertyBase prop, String name) {
        prop.putClientProperty("cn1$sqlColumn", name);
    }

    public String getColumnName(PropertyBase prop) {
        return SQLMap.getColumnNameImpl(prop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean createTable(PropertyBusinessObject cmp) throws IOException {
        boolean has;
        String tableName;
        block7: {
            tableName = this.getTableName(cmp);
            Cursor cr = null;
            has = false;
            try {
                cr = this.executeQuery("SELECT * FROM sqlite_master WHERE type='table' AND name='" + tableName + "'");
                has = cr.next();
                Object var6_5 = null;
                if (cr == null) break block7;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (cr != null) {
                    cr.close();
                }
                throw throwable;
            }
            cr.close();
        }
        if (has) {
            return false;
        }
        StringBuilder createStatement = new StringBuilder("CREATE TABLE ");
        createStatement.append(tableName);
        createStatement.append(" (");
        String pkName = (String)cmp.getPropertyIndex().getMetaDataOfClass("cn1$pk");
        boolean autoIncrement = cmp.getPropertyIndex().getMetaDataOfClass("cn1$autoinc") != null;
        boolean first = true;
        Iterator<PropertyBase> iterator = cmp.getPropertyIndex().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                createStatement.append(")");
                this.execute(createStatement.toString());
                return true;
            }
            PropertyBase p = iterator.next();
            SqlType tp = this.getSqlType(p);
            if (tp == SqlType.SQL_EXCLUDE) continue;
            if (!first) {
                createStatement.append(",");
            }
            first = false;
            String columnName = this.getColumnName(p);
            createStatement.append(columnName);
            createStatement.append(" ");
            createStatement.append(tp.dbType);
            if (!columnName.equalsIgnoreCase(pkName)) continue;
            createStatement.append(" PRIMARY KEY");
            if (!autoIncrement) continue;
            createStatement.append(" AUTOINCREMENT");
        }
    }

    private void execute(String stmt) throws IOException {
        if (this.verbose) {
            Log.p(stmt);
        }
        this.db.execute(stmt);
    }

    private void execute(String stmt, Object[] args) throws IOException {
        if (this.verbose) {
            Log.p(stmt);
        }
        this.db.execute(stmt, args);
    }

    private Cursor executeQuery(String stmt, Object[] args) throws IOException {
        if (this.verbose) {
            Log.p(stmt);
        }
        return this.db.executeQuery(stmt, args);
    }

    private Cursor executeQuery(String stmt) throws IOException {
        if (this.verbose) {
            Log.p(stmt);
        }
        return this.db.executeQuery(stmt);
    }

    public void dropTable(PropertyBusinessObject cmp) throws IOException {
        String tableName = this.getTableName(cmp);
        this.execute("Drop table " + tableName);
    }

    public void insert(PropertyBusinessObject cmp) throws IOException {
        String tableName = this.getTableName(cmp);
        StringBuilder createStatement = new StringBuilder("INSERT INTO ");
        createStatement.append(tableName);
        createStatement.append(" (");
        int count = 0;
        ArrayList<Object> values = new ArrayList<Object>();
        for (PropertyBase p : cmp.getPropertyIndex()) {
            SqlType tp = this.getSqlType(p);
            if (tp == SqlType.SQL_EXCLUDE) continue;
            if (count > 0) {
                createStatement.append(",");
            }
            if (p instanceof Property) {
                values.add(tp.asUpdateInsertValue(p.get(), (Property)p));
            } else {
                values.add(null);
            }
            ++count;
            String columnName = this.getColumnName(p);
            createStatement.append(columnName);
        }
        createStatement.append(") VALUES (?");
        for (int iter = 1; iter < values.size(); ++iter) {
            createStatement.append(",?");
        }
        createStatement.append(")");
        this.execute(createStatement.toString(), values.toArray());
    }

    public void update(PropertyBusinessObject cmp) throws IOException {
        String pkName = (String)cmp.getPropertyIndex().getMetaDataOfClass("cn1$pk");
        if (pkName == null) {
            throw new IOException("Primary key required for update");
        }
        String tableName = this.getTableName(cmp);
        StringBuilder createStatement = new StringBuilder("UPDATE ");
        createStatement.append(tableName);
        createStatement.append(" SET ");
        int count = 0;
        ArrayList<Object> values = new ArrayList<Object>();
        for (PropertyBase p : cmp.getPropertyIndex()) {
            SqlType tp = this.getSqlType(p);
            if (tp == SqlType.SQL_EXCLUDE) continue;
            if (count > 0) {
                createStatement.append(",");
            }
            if (p instanceof Property) {
                values.add(tp.asUpdateInsertValue(p.get(), (Property)p));
            } else {
                values.add(null);
            }
            ++count;
            String columnName = this.getColumnName(p);
            createStatement.append(columnName);
            createStatement.append(" = ?");
        }
        createStatement.append(" WHERE ");
        createStatement.append(pkName);
        createStatement.append(" = ?");
        Property p = (Property)cmp.getPropertyIndex().getIgnoreCase(pkName);
        values.add(p.get());
        this.execute(createStatement.toString(), values.toArray());
    }

    public void delete(PropertyBusinessObject cmp) throws IOException {
        String pkName = (String)cmp.getPropertyIndex().getMetaDataOfClass("cn1$pk");
        String tableName = this.getTableName(cmp);
        StringBuilder createStatement = new StringBuilder("DELETE FROM ");
        createStatement.append(tableName);
        createStatement.append(" WHERE ");
        if (pkName != null) {
            createStatement.append(pkName);
            createStatement.append(" = ?");
            Property p = (Property)cmp.getPropertyIndex().getIgnoreCase(pkName);
            this.execute(createStatement.toString(), new Object[]{p.get()});
        } else {
            int count = 0;
            Object[] values = new Object[cmp.getPropertyIndex().getSize()];
            for (PropertyBase p : cmp.getPropertyIndex()) {
                if (count != 0) {
                    createStatement.append(",");
                }
                values[count] = p instanceof Property ? p.get() : null;
                ++count;
                String columnName = this.getColumnName(p);
                createStatement.append(columnName);
                createStatement.append(" = ?");
            }
            this.execute(createStatement.toString(), values);
        }
    }

    public List<PropertyBusinessObject> select(PropertyBusinessObject cmp, Property orderBy, boolean ascending, int maxElements, int page) throws IOException, InstantiationException {
        return this.selectImpl(false, cmp, orderBy, ascending, maxElements, page);
    }

    public List<PropertyBusinessObject> selectNot(PropertyBusinessObject cmp, Property orderBy, boolean ascending, int maxElements, int page) throws IOException, InstantiationException {
        return this.selectImpl(true, cmp, orderBy, ascending, maxElements, page);
    }

    private List<PropertyBusinessObject> selectImpl(boolean not, PropertyBusinessObject cmp, Property orderBy, boolean ascending, int maxElements, int page) throws IOException, InstantiationException {
        ArrayList params = new ArrayList();
        StringBuilder createStatement = new StringBuilder();
        boolean found = false;
        for (PropertyBase p : cmp.getPropertyIndex()) {
            if (!(p instanceof Property) || p.get() == null) continue;
            if (found) {
                createStatement.append(" AND ");
            } else {
                createStatement.append(" WHERE ");
            }
            found = true;
            params.add(p.get());
            createStatement.append(this.getColumnName(p));
            if (not) {
                createStatement.append(" <> ?");
                continue;
            }
            createStatement.append(" = ?");
        }
        return this.selectImpl(cmp, createStatement.toString(), cmp.getClass(), params.toArray(), orderBy, ascending, maxElements, page);
    }

    private List<PropertyBusinessObject> selectImpl(PropertyBusinessObject cmp, String where, Class propertyClass, Object[] params, Property orderBy, boolean ascending, int maxElements, int page) throws IOException, InstantiationException {
        String tableName = this.getTableName(cmp);
        StringBuilder createStatement = new StringBuilder("SELECT * FROM ");
        createStatement.append(tableName);
        if (where != null && where.length() > 0) {
            if (!where.toUpperCase().startsWith(" WHERE ")) {
                createStatement.append(" WHERE ");
            }
            createStatement.append(where);
        }
        if (orderBy != null) {
            createStatement.append(" ORDER BY ");
            createStatement.append(this.getColumnName(orderBy));
            if (!ascending) {
                createStatement.append(" DESC");
            }
        }
        if (maxElements > 0) {
            createStatement.append(" LIMIT ");
            createStatement.append(maxElements);
            if (page > 0) {
                createStatement.append(" OFFSET ");
                createStatement.append(page * maxElements);
            }
        }
        Cursor c = null;
        try {
            ArrayList<PropertyBusinessObject> response = new ArrayList<PropertyBusinessObject>();
            c = this.executeQuery(createStatement.toString(), params);
            while (c.next()) {
                PropertyBusinessObject pb = (PropertyBusinessObject)propertyClass.newInstance();
                for (PropertyBase p : pb.getPropertyIndex()) {
                    Row currentRow = c.getRow();
                    SqlType t = this.getSqlType(p);
                    if (t == SqlType.SQL_EXCLUDE) continue;
                    Object value = t.getValue(currentRow, c.getColumnIndex(this.getColumnName(p)), p);
                    if (!(p instanceof Property)) continue;
                    ((Property)p).set(value);
                }
                response.add(pb);
            }
            c.close();
            return response;
        }
        catch (Throwable t) {
            Log.e(t);
            if (c != null) {
                c.close();
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new IOException(t.toString());
        }
    }

    public SelectBuilder selectBuild() {
        return new SelectBuilder().seed();
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SelectBuilder {
        private final PropertyBase property;
        private final String operator;
        private final String prefix;
        private final String suffix;
        private final SelectBuilder parent;
        private SelectBuilder child;

        private SelectBuilder() {
            this(null, null, null, null, null);
        }

        private SelectBuilder(PropertyBase property, String operator, String prefix, String suffix, SelectBuilder parent) {
            this.property = property;
            this.operator = operator;
            this.prefix = prefix;
            this.suffix = suffix;
            this.parent = parent;
            parent.child = this;
        }

        public SelectBuilder orderBy(PropertyBase property, boolean ascending) {
            return new SelectBuilder(property, null, " ORDER BY ", ascending ? "ASC" : "DESC", this);
        }

        public SelectBuilder equals(PropertyBase property) {
            return new SelectBuilder(property, " = ", null, null, this);
        }

        public SelectBuilder notEquals(PropertyBase property) {
            return new SelectBuilder(property, " <> ", null, null, this);
        }

        public SelectBuilder gt(PropertyBase property) {
            return new SelectBuilder(property, " > ", null, null, this);
        }

        public SelectBuilder lt(PropertyBase property) {
            return new SelectBuilder(property, " < ", null, null, this);
        }

        public List<PropertyBusinessObject> build(PropertyBusinessObject obj, int maxElements, int page) throws IOException, InstantiationException {
            ArrayList params = new ArrayList();
            SelectBuilder root = this;
            while (root.parent.property != null) {
                root = root.parent;
            }
            StringBuilder createStatement = new StringBuilder();
            boolean found = false;
            ArrayList paramList = new ArrayList();
            SelectBuilder sb = root;
            while (sb != null) {
                if (sb.prefix != null) {
                    createStatement.append(sb.prefix);
                }
                if (sb.property != null) {
                    if (found) {
                        createStatement.append(" AND ");
                    } else {
                        createStatement.append(" WHERE ");
                    }
                    found = true;
                    String columnName = SQLMap.getColumnNameImpl(sb.property);
                    createStatement.append(columnName);
                    createStatement.append(this.operator);
                    createStatement.append(" ? ");
                    paramList.add(obj.getPropertyIndex().get(sb.property.getName()).get());
                }
                if (sb.suffix != null) {
                    createStatement.append(sb.suffix);
                }
                sb = sb.child;
            }
            return SQLMap.this.selectImpl(obj, createStatement.toString(), obj.getClass(), params.toArray(), null, false, maxElements, page);
        }

        SelectBuilder seed() {
            return new SelectBuilder(null, null, null, null, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SqlType {
        SQL_EXCLUDE(null),
        SQL_TEXT("TEXT"),
        SQL_INTEGER("INTEGER"){

            protected Object getValue(Row row, int index, PropertyBase base) throws IOException {
                return row.getInteger(index);
            }
        }
        ,
        SQL_BOOLEAN("BOOLEAN"){

            protected Object getValue(Row row, int index, PropertyBase base) throws IOException {
                Integer i = row.getInteger(index);
                if (i == null) {
                    return null;
                }
                return i == 1;
            }

            protected Object asUpdateInsertValue(Object data, Property p) {
                if (data == null) {
                    return null;
                }
                return Util.toBooleanValue(data) ? 1 : 0;
            }
        }
        ,
        SQL_LONG("INTEGER"){

            protected Object getValue(Row row, int index, PropertyBase base) throws IOException {
                return row.getLong(index);
            }
        }
        ,
        SQL_DATE("INTEGER"){

            protected Object getValue(Row row, int index, PropertyBase base) throws IOException {
                return new Date(row.getLong(index) * 1000L);
            }

            protected Object asUpdateInsertValue(Object data, Property p) {
                if (data == null) {
                    return null;
                }
                return ((Date)data).getTime() / 1000L;
            }
        }
        ,
        SQL_SHORT("INTEGER"){

            protected Object getValue(Row row, int index, PropertyBase base) throws IOException {
                return row.getShort(index);
            }
        }
        ,
        SQL_FLOAT("REAL"){

            protected Object getValue(Row row, int index, PropertyBase base) throws IOException {
                return Float.valueOf(row.getFloat(index));
            }
        }
        ,
        SQL_BLOB("TEXT"){

            protected Object getValue(Row row, int index, PropertyBase base) throws IOException {
                String s = row.getString(index);
                if (s == null) {
                    return null;
                }
                byte[] d = Base64.decode(s.getBytes());
                Class t = base.getGenericType();
                if (t == EncodedImage.class) {
                    return EncodedImage.create(d);
                }
                return d;
            }

            protected Object asUpdateInsertValue(Object data, Property p) {
                if (data == null) {
                    return null;
                }
                Class t = p.getGenericType();
                if (t == EncodedImage.class) {
                    return Base64.encode(((EncodedImage)data).getImageData());
                }
                return Base64.encode((byte[])data);
            }
        }
        ,
        SQL_DOUBLE("REAL"){

            protected Object getValue(Row row, int index, PropertyBase base) throws IOException {
                return row.getDouble(index);
            }
        };

        String dbType;

        private SqlType(String dbType) {
            this.dbType = dbType;
        }

        protected Object getValue(Row row, int index, PropertyBase base) throws IOException {
            return row.getString(index);
        }

        protected Object asUpdateInsertValue(Object data, Property p) {
            return data;
        }
    }
}

