/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.push;

import com.codename1.io.ConnectionRequest;
import com.codename1.io.JSONParser;
import com.codename1.io.Log;
import com.codename1.io.NetworkManager;
import com.codename1.io.Preferences;
import com.codename1.ui.Display;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;

public class Push {
    public static final String GOOGLE_PUSH_KEY = "googlePlay";
    private final String token;
    private final String body;
    private final String[] deviceKeys;
    private boolean production;
    private String googleAuthKey = "";
    private String iosCertificateURL = "";
    private String iosCertificatePassword = "";
    private String wnsSID = "";
    private String wnsClientSecret = "";
    private int pushType = 1;

    public Push(String token, String body, String ... deviceKeys) {
        this.token = token;
        this.body = body;
        this.deviceKeys = deviceKeys;
    }

    public static boolean sendPushMessage(String body, String deviceKey, boolean production, String googleAuthKey, String iosCertificateURL, String iosCertificatePassword) {
        ConnectionRequest cr = Push.createPushMessage(body, deviceKey, production, googleAuthKey, iosCertificateURL, iosCertificatePassword, "", "", "", "");
        NetworkManager.getInstance().addToQueueAndWait(cr);
        return cr.getResposeCode() == 200;
    }

    public static boolean sendPushMessage(String body, String deviceKey, boolean production, String googleAuthKey, String iosCertificateURL, String iosCertificatePassword, String bbUrl, String bbApp, String bbPass, String bbPort) {
        ConnectionRequest cr = Push.createPushMessage(body, deviceKey, production, googleAuthKey, iosCertificateURL, iosCertificatePassword, bbUrl, bbApp, bbPass, bbPort);
        NetworkManager.getInstance().addToQueueAndWait(cr);
        return cr.getResposeCode() == 200;
    }

    public static void sendPushMessageAsync(String body, String deviceKey, boolean production, String googleAuthKey, String iosCertificateURL, String iosCertificatePassword) {
        NetworkManager.getInstance().addToQueue(Push.createPushMessage(body, deviceKey, production, googleAuthKey, iosCertificateURL, iosCertificatePassword, "", "", "", ""));
    }

    public static void sendPushMessageAsync(String body, String deviceKey, boolean production, String googleAuthKey, String iosCertificateURL, String iosCertificatePassword, String bbUrl, String bbApp, String bbPass, String bbPort) {
        NetworkManager.getInstance().addToQueue(Push.createPushMessage(body, deviceKey, production, googleAuthKey, iosCertificateURL, iosCertificatePassword, bbUrl, bbApp, bbPass, bbPort));
    }

    private static ConnectionRequest createPushMessage(String body, String deviceKey, boolean production, String googleAuthKey, String iosCertificateURL, String iosCertificatePassword, String bbUrl, String bbApp, String bbPass, String bbPort) {
        throw new RuntimeException("The old push servers no longer work! Please migrate to the new Push servers!");
    }

    public static String getDeviceKey() {
        long l = Preferences.get("push_id", -1L);
        if (l == -1L) {
            return null;
        }
        return "" + l;
    }

    public static String getPushKey() {
        String key = Preferences.get("push_key", null);
        if (key != null) {
            if (!key.startsWith("cn1-")) {
                String pushPrefix = Display.getInstance().getProperty("cn1_push_prefix", null);
                if (pushPrefix != null) {
                    return "cn1-" + pushPrefix + "-" + key;
                }
            } else {
                return key;
            }
        }
        return null;
    }

    public static boolean sendPushMessage(String token, String body, String deviceKey, boolean production, String googleAuthKey, String iosCertificateURL, String iosCertificatePassword) {
        PushConnection cr = Push.createPushMessage(token, body, production, googleAuthKey, iosCertificateURL, iosCertificatePassword, "", "", "", "", "", "", 1, deviceKey);
        NetworkManager.getInstance().addToQueueAndWait(cr);
        return cr.successful;
    }

    public static boolean sendPushMessage(String token, String body, boolean production, String googleAuthKey, String iosCertificateURL, String iosCertificatePassword, int pushType, String ... deviceKey) {
        PushConnection cr = Push.createPushMessage(token, body, production, googleAuthKey, iosCertificateURL, iosCertificatePassword, "", "", "", "", "", "", pushType, deviceKey);
        NetworkManager.getInstance().addToQueueAndWait(cr);
        return cr.successful;
    }

    public static boolean sendPushMessage(String token, String body, String deviceKey, boolean production, String googleAuthKey, String iosCertificateURL, String iosCertificatePassword, String bbUrl, String bbApp, String bbPass, String bbPort) {
        PushConnection cr = Push.createPushMessage(token, body, production, googleAuthKey, iosCertificateURL, iosCertificatePassword, bbUrl, bbApp, bbPass, bbPort, "", "", 1, deviceKey);
        NetworkManager.getInstance().addToQueueAndWait(cr);
        return cr.successful;
    }

    public static void sendPushMessageAsync(String token, String body, String deviceKey, boolean production, String googleAuthKey, String iosCertificateURL, String iosCertificatePassword) {
        NetworkManager.getInstance().addToQueue(Push.createPushMessage(token, body, production, googleAuthKey, iosCertificateURL, iosCertificatePassword, "", "", "", "", "", "", 1, deviceKey));
    }

    public static void sendPushMessageAsync(String token, String body, String deviceKey, boolean production, String googleAuthKey, String iosCertificateURL, String iosCertificatePassword, String bbUrl, String bbApp, String bbPass, String bbPort) {
        NetworkManager.getInstance().addToQueue(Push.createPushMessage(token, body, production, googleAuthKey, iosCertificateURL, iosCertificatePassword, bbUrl, bbApp, bbPass, bbPort, "", "", 1, deviceKey));
    }

    private static PushConnection createPushMessage(String token, String body, boolean production, String googleAuthKey, String iosCertificateURL, String iosCertificatePassword, String bbUrl, String bbApp, String bbPass, String bbPort, String wnsSID, String wnsClientSecret, int type, String ... deviceKeys) {
        PushConnection cr = new PushConnection();
        cr.setPost(true);
        cr.setUrl("https://push.codenameone.com/push/push");
        cr.addArgument("token", token);
        cr.addArguments("device", deviceKeys);
        cr.addArgument("type", "" + type);
        cr.addArgument("auth", googleAuthKey);
        cr.addArgument("certPassword", iosCertificatePassword);
        cr.addArgument("cert", iosCertificateURL);
        cr.addArgument("body", body);
        cr.addArgument("burl", bbUrl);
        cr.addArgument("bbAppId", bbApp);
        cr.addArgument("bbPass", bbPass);
        cr.addArgument("bbPort", bbPort);
        cr.addArgument("sid", wnsSID);
        cr.addArgument("client_secret", wnsClientSecret);
        if (production) {
            cr.addArgument("production", "true");
        } else {
            cr.addArgument("production", "false");
        }
        cr.setFailSilently(true);
        return cr;
    }

    public Push gcmAuth(String googleAuthKey) {
        this.googleAuthKey = googleAuthKey;
        return this;
    }

    public Push apnsAuth(String iosCertificateURL, String iosCertificatePassword, boolean production) {
        this.iosCertificateURL = iosCertificateURL;
        this.iosCertificatePassword = iosCertificatePassword;
        this.production = production;
        return this;
    }

    public Push wnsAuth(String wnsSID, String wnsClientSecret) {
        this.wnsSID = wnsSID;
        this.wnsClientSecret = wnsClientSecret;
        return this;
    }

    public Push pushType(int pushType) {
        this.pushType = pushType;
        return this;
    }

    public boolean send() {
        PushConnection cr = Push.createPushMessage(this.token, this.body, this.production, this.googleAuthKey, this.iosCertificateURL, this.iosCertificatePassword, "", "", "", "", this.wnsSID, this.wnsClientSecret, this.pushType, this.deviceKeys);
        NetworkManager.getInstance().addToQueueAndWait(cr);
        return cr.successful;
    }

    public void sendAsync() {
        NetworkManager.getInstance().addToQueue(Push.createPushMessage(this.token, this.body, this.production, this.googleAuthKey, this.iosCertificateURL, this.iosCertificatePassword, "", "", "", "", this.wnsSID, this.wnsClientSecret, this.pushType, this.deviceKeys));
    }

    static class PushConnection
    extends ConnectionRequest {
        boolean successful;

        PushConnection() {
        }

        protected void readResponse(InputStream input) throws IOException {
            JSONParser jp = new JSONParser();
            Map<String, Object> data = jp.parseJSON(new InputStreamReader(input, "UTF-8"));
            String error = (String)data.get("error");
            if (error != null) {
                Log.p(error);
                Log.p("Full error: " + data);
                this.successful = false;
            } else {
                this.successful = true;
            }
        }

        protected void handleErrorResponseCode(int code, String message) {
            this.successful = false;
        }

        protected void handleException(Exception err) {
            this.successful = false;
            Log.e(err);
        }
    }
}

