/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.push;

import com.codename1.xml.Element;

public class PushBuilder {
    private String title;
    private String body;
    private String metaData;
    private String imageUrl;
    private String category;
    private int type;
    private int badge;

    public PushBuilder title(String title) {
        this.title = title;
        return this;
    }

    public PushBuilder badge(int badge) {
        this.badge = badge;
        return this;
    }

    public PushBuilder body(String body) {
        this.body = body;
        return this;
    }

    public PushBuilder metaData(String metaData) {
        this.metaData = metaData;
        return this;
    }

    public PushBuilder imageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
        return this;
    }

    public PushBuilder category(String category) {
        this.category = category;
        return this;
    }

    public PushBuilder type(int type) {
        this.type = type;
        return this;
    }

    public boolean isRichPush() {
        return this.imageUrl != null || this.category != null;
    }

    public int getType() {
        if (this.isRichPush()) {
            return 99;
        }
        return this.type;
    }

    public String build() {
        StringBuilder sb = new StringBuilder();
        switch (this.type) {
            case 0: 
            case 1: 
            case 5: {
                sb.append(this.body);
                break;
            }
            case 2: {
                sb.append(this.metaData);
                break;
            }
            case 3: {
                sb.append(this.metaData).append(";").append(this.body);
                break;
            }
            case 4: {
                sb.append(this.title).append(";").append(this.body);
                break;
            }
            case 6: 
            case 100: {
                sb.append(this.badge);
                break;
            }
            case 101: {
                sb.append(this.badge).append(" ").append(this.body);
                break;
            }
            case 102: {
                sb.append(this.badge).append(";").append(this.title).append(";").append(this.body);
            }
        }
        if (this.isRichPush()) {
            String b = sb.toString();
            sb.setLength(0);
            Element el = new Element("push");
            el.setAttribute("type", "" + this.type);
            el.setAttribute("body", b);
            if (this.category != null) {
                el.setAttribute("category", this.category);
            }
            if (this.imageUrl != null) {
                Element imgEl = new Element("img");
                imgEl.setAttribute("src", this.imageUrl);
                el.addChild(imgEl);
            }
            return el.toString();
        }
        return sb.toString();
    }
}

