/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.social;

import com.codename1.compat.java.util.Objects;
import com.codename1.io.AccessToken;
import com.codename1.io.Log;
import com.codename1.io.Oauth2;
import com.codename1.io.Preferences;
import com.codename1.io.Storage;
import com.codename1.io.Util;
import com.codename1.social.LoginCallback;
import com.codename1.ui.CN;
import com.codename1.ui.Display;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.util.AsyncResource;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Login {
    LoginCallback callback = new LoginCallBackProxy();
    String oauth2URL;
    String clientId;
    String redirectURI;
    String clientSecret;
    String scope;
    private LoginCallback loginCallback;
    private final ArrayList<LoginCallback> loginCallbacksSingleUse = new ArrayList();
    private boolean callbackEnabled = true;
    private String validateErr = null;
    private AccessToken token;
    private boolean preferRedirectPrompt = false;

    public Login addScopes(String ... scopes) {
        ArrayList<String> existing = new ArrayList<String>();
        if (this.scope != null) {
            for (String str : Util.split(this.scope, " ")) {
                if ((str = str.trim()).length() == 0 || existing.contains(str)) continue;
                existing.add(str);
            }
        }
        for (String scope : scopes) {
            if (scope.trim().length() == 0 || existing.contains(scope)) continue;
            existing.add(scope);
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String scope : existing) {
            if (first) {
                first = false;
            } else {
                sb.append(" ");
            }
            sb.append(scope);
        }
        this.scope = sb.toString();
        return this;
    }

    public AsyncResource<Login> connect() {
        final AsyncResource<Login> out = new AsyncResource<Login>();
        if (this.isUserLoggedIn()) {
            out.complete(this);
        } else {
            this.doLogin(new LoginCallback(){

                public void loginSuccessful() {
                    out.complete(Login.this);
                }

                public void loginFailed(String errorMessage) {
                    out.error(new RuntimeException(errorMessage));
                }
            });
        }
        return out;
    }

    public void doLogin(LoginCallback callback) {
        if (callback != null) {
            this.loginCallbacksSingleUse.add(callback);
        }
        this.doLogin();
    }

    public void doLogin() {
        if (this.isNativeLoginSupported()) {
            this.nativelogin();
        } else {
            if (this.oauth2URL == null) {
                System.out.println("No oauth2URL found Use setOauth2URL");
                return;
            }
            if (this.clientId == null) {
                System.out.println("No ClientId found Use setClientId");
                return;
            }
            if (this.redirectURI == null) {
                System.out.println("No redirectURI found Use setRedirectURI");
                return;
            }
            if (this.clientSecret == null) {
                System.out.println("No clientSecret found Use setClientSecret");
                return;
            }
            Oauth2 auth = this.createOauth2();
            auth.showAuthentication(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    if (evt.getSource() instanceof AccessToken) {
                        AccessToken t = (AccessToken)evt.getSource();
                        Login.this.setAccessToken(t);
                        if (Login.this.callback != null) {
                            Login.this.callback.loginSuccessful();
                        }
                        return;
                    }
                    if (evt.getSource() instanceof String) {
                        String t = (String)evt.getSource();
                        Login.this.setAccessToken(new AccessToken(t, null));
                        if (Login.this.callback != null) {
                            Login.this.callback.loginSuccessful();
                        }
                        return;
                    }
                    if (evt.getSource() instanceof Exception && Login.this.callback != null) {
                        Exception e = (Exception)evt.getSource();
                        Log.e(e);
                        System.out.println("Calling loginFailed of callback " + Login.this.callback);
                        String msg = e.getMessage();
                        if (msg == null) {
                            msg = "Unknown error";
                        }
                        Login.this.callback.loginFailed(msg);
                    }
                }
            });
        }
    }

    public void doLogout() {
        if (this.isNativeLoginSupported()) {
            this.nativeLogout();
        } else {
            this.setAccessToken(null);
        }
        Preferences.delete(this.getClass().getName() + "Token");
    }

    public boolean isUserLoggedIn() {
        if (this.isNativeLoginSupported()) {
            return this.nativeIsLoggedIn();
        }
        AccessToken accessTok = this.getAccessToken();
        if (accessTok != null && accessTok.getExpiryDate() != null && accessTok.isExpired()) {
            return false;
        }
        return this.token != null;
    }

    public boolean nativeIsLoggedIn() {
        throw new RuntimeException("Native isLoggedIn not implemented");
    }

    public void nativelogin() {
        throw new RuntimeException("Native login not implemented");
    }

    public void nativeLogout() {
        throw new RuntimeException("Native logout not implemented");
    }

    public abstract boolean isNativeLoginSupported();

    public AccessToken getAccessToken() {
        if (this.token == null) {
            Util.register(new AccessToken());
            this.token = (AccessToken)Storage.getInstance().readObject(this.getClass().getName() + "AccessToken");
        }
        return this.token;
    }

    public void setAccessToken(AccessToken token) {
        if (!Objects.equals(token, this.token)) {
            this.token = token;
            Storage.getInstance().writeObject(this.getClass().getName() + "AccessToken", token);
        }
    }

    public void validateToken() throws IOException {
        String token = Preferences.get(this.getClass().getName() + "Token", null);
        if (token == null || !this.validateToken(token)) {
            AccessToken accessTok = this.getAccessToken();
            if (accessTok != null && accessTok.getRefreshToken() != null) {
                String refreshTok = accessTok.getRefreshToken();
                Oauth2.RefreshTokenRequest refreshReq = this.createOauth2().refreshToken(refreshTok);
                try {
                    System.out.println("Attempting to refresh the access token");
                    AccessToken newTok = (AccessToken)refreshReq.get(5000);
                    this.setAccessToken(newTok);
                    Preferences.set(this.getClass().getName() + "Token", this.getAccessToken().getToken());
                    return;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.callbackEnabled = false;
            this.doLogin();
            Display.getInstance().invokeAndBlock(new Runnable(){

                public void run() {
                    while (!Login.this.callbackEnabled) {
                        Util.sleep(100);
                    }
                }
            });
            if (this.validateErr != null) {
                throw new IOException(this.validateErr);
            }
        }
    }

    protected abstract boolean validateToken(String var1);

    public void setCallback(LoginCallback lc) {
        this.loginCallback = lc;
    }

    public void setClientId(String id) {
        this.clientId = id;
    }

    public void setClientSecret(String secret) {
        this.clientSecret = secret;
    }

    public void setRedirectURI(String URI2) {
        this.redirectURI = URI2;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setOauth2URL(String oauth2URL) {
        this.oauth2URL = oauth2URL;
    }

    protected Oauth2 createOauth2() {
        Oauth2 auth = new Oauth2(this.oauth2URL, this.clientId, this.redirectURI, this.scope);
        return auth;
    }

    public boolean isPreferRedirectPrompt() {
        return this.preferRedirectPrompt;
    }

    public void setPreferRedirectPrompt(boolean preferRedirectPrompt) {
        this.preferRedirectPrompt = preferRedirectPrompt;
    }

    class LoginCallBackProxy
    extends LoginCallback {
        LoginCallBackProxy() {
        }

        public void loginSuccessful() {
            Preferences.set(Login.this.getClass().getName() + "Token", Login.this.getAccessToken().getToken());
            if (Login.this.callbackEnabled) {
                if (Login.this.loginCallback != null) {
                    Login.this.loginCallback.loginSuccessful();
                }
                while (!Login.this.loginCallbacksSingleUse.isEmpty()) {
                    final LoginCallback cb = (LoginCallback)Login.this.loginCallbacksSingleUse.remove(0);
                    if (!CN.isEdt()) {
                        CN.callSerially(new Runnable(){

                            public void run() {
                                cb.loginSuccessful();
                            }
                        });
                        continue;
                    }
                    cb.loginSuccessful();
                }
                return;
            }
            Login.this.callbackEnabled = true;
            Login.this.validateErr = null;
        }

        public void loginFailed(final String errorMessage) {
            if (Login.this.callbackEnabled) {
                if (Login.this.loginCallback != null) {
                    Login.this.loginCallback.loginFailed(errorMessage);
                }
                while (!Login.this.loginCallbacksSingleUse.isEmpty()) {
                    final LoginCallback cb = (LoginCallback)Login.this.loginCallbacksSingleUse.remove(0);
                    if (!CN.isEdt()) {
                        CN.callSerially(new Runnable(){

                            public void run() {
                                cb.loginFailed(errorMessage);
                            }
                        });
                        continue;
                    }
                    cb.loginFailed(errorMessage);
                }
                return;
            }
            Login.this.callbackEnabled = true;
            Login.this.validateErr = errorMessage;
        }
    }
}

