/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.system;

import com.codename1.io.Log;
import com.codename1.io.Preferences;
import com.codename1.system.CrashReport;
import com.codename1.ui.Button;
import com.codename1.ui.CheckBox;
import com.codename1.ui.Command;
import com.codename1.ui.Container;
import com.codename1.ui.Dialog;
import com.codename1.ui.Display;
import com.codename1.ui.TextArea;
import com.codename1.ui.layouts.BoxLayout;
import com.codename1.ui.layouts.GridLayout;
import java.util.Timer;
import java.util.TimerTask;

public class DefaultCrashReporter
implements CrashReport {
    private static String errorText = "The application encountered an error, do you wish to report it?";
    private static String sendButtonText = "Send";
    private static String dontSendButtonText = "Don't Send";
    private static String checkboxText = "Don't show this dialog again";
    private boolean promptUser = false;

    private DefaultCrashReporter() {
    }

    public static String getErrorText() {
        return errorText;
    }

    public static void setErrorText(String aErrorText) {
        errorText = aErrorText;
    }

    public static String getSendButtonText() {
        return sendButtonText;
    }

    public static void setSendButtonText(String aSendButtonText) {
        sendButtonText = aSendButtonText;
    }

    public static String getDontSendButtonText() {
        return dontSendButtonText;
    }

    public static void setDontSendButtonText(String aDontSendButtonText) {
        dontSendButtonText = aDontSendButtonText;
    }

    public static String getCheckboxText() {
        return checkboxText;
    }

    public static void setCheckboxText(String aCheckboxText) {
        checkboxText = aCheckboxText;
    }

    public static void init(boolean promptUser, int frequency) {
        if (Preferences.get("$CN1_crashBlocked", false) || Log.getReportingLevel() == Log.REPORTING_NONE) {
            return;
        }
        if (Preferences.get("$CN1_pendingCrash", false)) {
            Log.sendLog();
            Preferences.set("$CN1_pendingCrash", false);
        }
        if (Log.getReportingLevel() == Log.REPORTING_DEBUG && frequency > 0) {
            Timer t = new Timer();
            t.schedule(new TimerTask(){

                public void run() {
                    if (!Display.getInstance().isEdt()) {
                        Display.getInstance().callSerially(this);
                        return;
                    }
                    Log.sendLog();
                }
            }, (long)frequency * 60000L, (long)frequency * 60000L);
        }
        DefaultCrashReporter d = new DefaultCrashReporter();
        d.promptUser = promptUser && Preferences.get("$CN1_prompt", true);
        Display.getInstance().setCrashReporter(d);
    }

    public void exception(Throwable t) {
        Preferences.set("$CN1_pendingCrash", true);
        if (this.promptUser) {
            Dialog error = new Dialog("Error");
            error.setLayout(new BoxLayout(2));
            TextArea txt = new TextArea(errorText);
            txt.setEditable(false);
            txt.setUIID("DialogBody");
            error.addComponent(txt);
            CheckBox cb = new CheckBox(checkboxText);
            cb.setUIID("DialogBody");
            error.addComponent(cb);
            Container grid = new Container(new GridLayout(1, 2));
            error.addComponent(grid);
            Command ok = new Command(sendButtonText);
            Command dont = new Command(dontSendButtonText);
            Button send = new Button(ok);
            Button dontSend = new Button(dont);
            grid.addComponent(send);
            grid.addComponent(dontSend);
            Command result = error.showPacked("Center", true);
            if (result == dont) {
                if (cb.isSelected()) {
                    Preferences.set("$CN1_crashBlocked", true);
                }
                Preferences.set("$CN1_pendingCrash", false);
                return;
            }
            if (cb.isSelected()) {
                Preferences.set("$CN1_prompt", false);
            }
        }
        Log.sendLog();
        Preferences.set("$CN1_pendingCrash", false);
    }
}

