/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.system;

import com.codename1.io.Log;
import com.codename1.system.NativeInterface;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeLookup {
    private static boolean verbose = true;
    private static HashMap<Class, Class> interfaceToClassLookup;

    private NativeLookup() {
    }

    public static boolean isVerbose() {
        return verbose;
    }

    public static void setVerbose(boolean aVerbose) {
        verbose = aVerbose;
    }

    public static <T extends NativeInterface> T create(Class<T> c) {
        try {
            if (interfaceToClassLookup != null) {
                Class cls = interfaceToClassLookup.get(c);
                if (cls == null) {
                    return null;
                }
                return (T)((NativeInterface)cls.newInstance());
            }
            return (T)((NativeInterface)Class.forName(c.getName() + "Impl").newInstance());
        }
        catch (Throwable ex) {
            if (verbose) {
                Log.e(ex);
            }
            return null;
        }
    }

    public static void register(Class ni, Class cls) {
        if (interfaceToClassLookup == null) {
            interfaceToClassLookup = new HashMap();
        }
        interfaceToClassLookup.put(ni, cls);
    }
}

