/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.testing;

import com.codename1.components.ToastBar;
import com.codename1.io.Log;
import com.codename1.testing.AbstractTest;
import com.codename1.ui.Button;
import com.codename1.ui.CN;
import com.codename1.ui.ComponentSelector;
import com.codename1.ui.Container;
import com.codename1.ui.Form;
import com.codename1.ui.Label;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.layouts.BorderLayout;
import com.codename1.ui.layouts.BoxLayout;
import java.util.ArrayList;
import java.util.Collections;

public class TestRunnerComponent
extends Container {
    private final ArrayList<AbstractTest> tests = new ArrayList();
    private final Container resultsPane = new Container(BoxLayout.y());

    public TestRunnerComponent() {
        super(new BorderLayout());
        Button btn = new Button("Run Tests");
        btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CN.callSerially(new Runnable(){

                    public void run() {
                        TestRunnerComponent.this.runTests();
                    }
                });
            }
        });
        this.add((Object)"North", btn);
        this.resultsPane.setScrollableY(true);
        this.add((Object)4, this.resultsPane);
    }

    public TestRunnerComponent add(AbstractTest ... tests) {
        Collections.addAll(this.tests, tests);
        return this;
    }

    public Form showForm() {
        Form f = this.getComponentForm();
        if (f == null) {
            f = new Form("Test Runner", new BorderLayout());
            f.add((Object)4, this);
        }
        f.show();
        return f;
    }

    private void runTest(final AbstractTest test, final Button statusLabel) {
        try {
            if (test.runTest()) {
                CN.callSerially(new Runnable(){

                    public void run() {
                        statusLabel.setText(test + ": Passed");
                        ComponentSelector.$(statusLabel).selectAllStyles().setBgColor(65280).revalidate();
                    }
                });
            } else {
                CN.callSerially(new Runnable(){

                    public void run() {
                        statusLabel.setText(test + ": Failed");
                        ComponentSelector.$(statusLabel).selectAllStyles().setBgColor(0xFF0000).revalidate();
                    }
                });
            }
        }
        catch (Throwable t) {
            Log.e(t);
            CN.callSerially(new Runnable(){

                public void run() {
                    statusLabel.setText(test + ": Failed");
                    ComponentSelector.$(statusLabel).selectAllStyles().setBgColor(0xFF0000).revalidate();
                    statusLabel.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent ev) {
                            ToastBar.showInfoMessage(t.getMessage());
                            Log.e(t);
                        }
                    });
                }
            });
        }
    }

    public void runTests() {
        Form f = this.getComponentForm();
        this.resultsPane.removeAll();
        this.resultsPane.revalidate();
        this.resultsPane.add(new Label("Running " + this.tests.size() + " tests"));
        for (final AbstractTest test : this.tests) {
            final Button statusLabel = new Button(test + ": Running...");
            if (f != CN.getCurrentForm()) {
                f.showBack();
            }
            ComponentSelector.$(statusLabel).selectAllStyles().setBgColor(0xFFFF00).setBgTransparency(255);
            this.resultsPane.add(statusLabel);
            this.resultsPane.revalidate();
            if (test.shouldExecuteOnEDT()) {
                this.runTest(test, statusLabel);
            } else {
                CN.invokeAndBlock(new Runnable(){

                    public void run() {
                        TestRunnerComponent.this.runTest(test, statusLabel);
                    }
                });
            }
            this.resultsPane.revalidate();
        }
        if (f != CN.getCurrentForm()) {
            f.showBack();
        }
    }
}

