/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.testing;

import com.codename1.compat.java.util.Objects;
import com.codename1.io.Storage;
import com.codename1.testing.TestReporting;
import com.codename1.ui.Button;
import com.codename1.ui.Command;
import com.codename1.ui.Component;
import com.codename1.ui.Container;
import com.codename1.ui.Display;
import com.codename1.ui.Form;
import com.codename1.ui.Image;
import com.codename1.ui.Label;
import com.codename1.ui.List;
import com.codename1.ui.SideMenuBar;
import com.codename1.ui.TextArea;
import com.codename1.ui.Toolbar;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.list.ContainerList;
import com.codename1.ui.spinner.GenericSpinner;
import com.codename1.ui.util.ImageIO;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestUtils {
    private static boolean verbose;

    private TestUtils() {
    }

    public static void setVerboseMode(boolean v) {
        verbose = v;
    }

    public static void waitFor(final int millis) {
        if (verbose) {
            TestUtils.log("waitFor(" + millis + ")");
        }
        if (Display.getInstance().isEdt()) {
            Display.getInstance().invokeAndBlock(new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(millis);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            });
        } else {
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static Component findByName(String componentName) {
        Component c;
        if (verbose) {
            TestUtils.log("findByName(" + componentName + ")");
        }
        if ((c = TestUtils.findByName(Display.getInstance().getCurrent(), componentName)) == null) {
            TestUtils.waitFor(30);
            return TestUtils.findByName(Display.getInstance().getCurrent(), componentName);
        }
        return c;
    }

    public static void selectInList(String listName, int offset) {
        TestUtils.selectListOffset(TestUtils.findByName(listName), offset);
    }

    private static void selectListOffset(Component c, int offset) {
        TestUtils.assertBool(c != null, "List not found");
        if (c instanceof List) {
            ((List)c).setSelectedIndex(offset);
            return;
        }
        if (c instanceof ContainerList) {
            ((ContainerList)c).setSelectedIndex(offset);
            return;
        }
        if (c instanceof GenericSpinner) {
            ((GenericSpinner)c).getModel().setSelectedIndex(offset);
            return;
        }
        TestUtils.assertBool(false, "Unsupported list type: " + c.getName());
    }

    public static void selectInList(int[] path, int offset) {
        TestUtils.selectListOffset(TestUtils.getComponentByPath(path), offset);
    }

    private static Component findByName(Container root, String componentName) {
        if (verbose) {
            TestUtils.log("findByName(" + root + ", " + componentName + ")");
        }
        int count = root.getComponentCount();
        for (int iter = 0; iter < count; ++iter) {
            Component c = root.getComponentAt(iter);
            String n = c.getName();
            if (n != null && n.equals(componentName)) {
                return c;
            }
            if (!(c instanceof Container) || (c = TestUtils.findByName((Container)c, componentName)) == null) continue;
            return c;
        }
        return null;
    }

    public static Label findLabelText(String text) {
        if (verbose) {
            TestUtils.log("findLabelText(" + text + ")");
        }
        return TestUtils.findLabelText(Display.getInstance().getCurrent(), text);
    }

    private static Label findLabelText(Container root, String text) {
        if (verbose) {
            TestUtils.log("findLabelText(" + root + ", " + text + ")");
        }
        int count = root.getComponentCount();
        for (int iter = 0; iter < count; ++iter) {
            Label l;
            Component c = root.getComponentAt(iter);
            if (c instanceof Label) {
                String n = ((Label)c).getText();
                if (n != null && n.equals(text)) {
                    return (Label)c;
                }
                n = (String)c.getClientProperty("cn1$origText");
                if (n == null || !n.equals(text)) continue;
                return (Label)c;
            }
            if (!(c instanceof Container) || (l = TestUtils.findLabelText((Container)c, text)) == null) continue;
            return l;
        }
        return null;
    }

    public static void clickButtonByLabel(String text) {
        if (verbose) {
            TestUtils.log("clickButtonByLabel(" + text + ")");
        }
        Button b = (Button)TestUtils.findLabelText(text);
        TestUtils.waitFor(20);
        b.pressed();
        TestUtils.waitFor(20);
        b.released();
        TestUtils.waitFor(20);
    }

    public static void clickButtonByName(String name) {
        if (verbose) {
            TestUtils.log("clickButtonByName(" + name + ")");
        }
        Button b = (Button)TestUtils.findByName(name);
        TestUtils.waitFor(20);
        b.pressed();
        TestUtils.waitFor(20);
        b.released();
        TestUtils.waitFor(20);
    }

    private static String toString(int[] p) {
        if (p == null) {
            return "null";
        }
        if (p.length == 0) {
            return "{}";
        }
        String s = "{" + p[0];
        for (int iter = 1; iter < p.length; ++iter) {
            s = s + ", " + p[iter];
        }
        return s + "}";
    }

    public static void clickButtonByPath(int[] path) {
        if (verbose) {
            TestUtils.log("clickButtonByPath(" + TestUtils.toString(path) + ")");
        }
        Button b = (Button)TestUtils.getComponentByPath(path);
        b.pressed();
        TestUtils.waitFor(10);
        b.released();
        TestUtils.waitFor(10);
    }

    public static void goBack() {
        Form f;
        Command c;
        if (verbose) {
            TestUtils.log("goBack()");
        }
        TestUtils.assertBool((c = (f = Display.getInstance().getCurrent()).getBackCommand()) != null, "The current form doesn't have a back command at this moment! for form name " + f.getName());
        f.dispatchCommand(c, new ActionEvent((Object)c, ActionEvent.Type.Command));
        TestUtils.waitFor(20);
    }

    public static void clickMenuItem(String name) {
        if (verbose) {
            TestUtils.log("clickMenuItem(" + name + ")");
        }
        Form f = Display.getInstance().getCurrent();
        for (int iter = 0; iter < f.getCommandCount(); ++iter) {
            Command c = f.getCommand(iter);
            if (!name.equals(c.getCommandName())) continue;
            f.dispatchCommand(c, new ActionEvent((Object)c, ActionEvent.Type.Command));
            return;
        }
        throw new RuntimeException("Command not found: " + name);
    }

    public static Command[] getToolbarCommands() {
        Form f = Display.getInstance().getCurrent();
        Toolbar tb = f.getToolbar();
        ArrayList<Command> result = new ArrayList<Command>();
        TestUtils.addAllCommands(tb.getLeftBarCommands(), result);
        TestUtils.addAllCommands(tb.getRightBarCommands(), result);
        TestUtils.addAllCommands(tb.getOverflowCommands(), result);
        TestUtils.addAllCommands(tb.getSideMenuCommands(), result);
        Command[] carr = new Command[result.size()];
        result.toArray(carr);
        return carr;
    }

    private static void addAllCommands(Iterable<Command> cs, ArrayList<Command> result) {
        if (cs != null) {
            for (Command c : cs) {
                result.add(c);
            }
        }
    }

    public static void showSidemenu() {
        Form f = Display.getInstance().getCurrent();
        Toolbar tb = f.getToolbar();
        if (tb != null) {
            tb.openSideMenu();
        } else {
            ((SideMenuBar)f.getMenuBar()).openMenu(null);
        }
    }

    public static void executeToolbarCommandAtOffset(final int offset) {
        Form f = Display.getInstance().getCurrent();
        if (!Display.getInstance().isEdt()) {
            Display.getInstance().callSerially(new Runnable(){

                public void run() {
                    TestUtils.executeToolbarCommandAtOffset(offset);
                }
            });
            return;
        }
        Command cmd = TestUtils.getToolbarCommands()[offset];
        f.dispatchCommand(cmd, new ActionEvent(cmd));
    }

    public static void ensureVisible(Component c) {
        if (verbose) {
            TestUtils.log("ensureVisible(" + c + ")");
        }
        Form f = Display.getInstance().getCurrent();
        f.scrollComponentToVisible(c);
    }

    public static void ensureVisible(String componentName) {
        if (verbose) {
            TestUtils.log("ensureVisible(" + componentName + ")");
        }
        TestUtils.ensureVisible(TestUtils.findByName(componentName));
    }

    public static void ensureVisible(int[] path) {
        if (verbose) {
            TestUtils.log("ensureVisible(" + TestUtils.toString(path) + ")");
        }
        TestUtils.ensureVisible(TestUtils.getComponentByPath(path));
    }

    public static void waitForFormTitle(final String title, final long timeout) {
        if (verbose) {
            TestUtils.log("waitForFormTitle(" + title + ")");
        }
        if (Display.getInstance().isEdt()) {
            Display.getInstance().invokeAndBlock(new Runnable(){

                public void run() {
                    TestUtils.waitForFormTitleImpl(title, timeout);
                }
            });
        } else {
            TestUtils.waitForFormTitleImpl(title, timeout);
        }
        TestUtils.waitFor(50);
    }

    public static void waitForFormTitle(String title) {
        TestUtils.waitForFormTitle(title, 90000L);
    }

    private static String getFormTitle(Form f) {
        if (f.getToolbar() != null) {
            Component c = f.getToolbar().getTitleComponent();
            if (c instanceof Label) {
                return ((Label)c).getText();
            }
            return null;
        }
        return f.getTitle();
    }

    private static void waitForFormTitleImpl(String title, long timeout) {
        long t = System.currentTimeMillis() + timeout;
        while (!title.equals(TestUtils.getFormTitle(Display.getInstance().getCurrent()))) {
            try {
                Thread.sleep(50L);
                if (System.currentTimeMillis() <= t) continue;
                TestUtils.assertBool(false, "Waiting for form " + title + " timed out! Current form title is: " + Display.getInstance().getCurrent().getTitle());
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static void waitForFormName(final String name, final long timeout) {
        if (verbose) {
            TestUtils.log("waitForFormName(" + name + ")");
        }
        if (Display.getInstance().isEdt()) {
            Display.getInstance().invokeAndBlock(new Runnable(){

                public void run() {
                    TestUtils.waitForFormNameImpl(name, timeout);
                }
            });
        } else {
            TestUtils.waitForFormNameImpl(name, timeout);
        }
        TestUtils.waitFor(50);
    }

    public static void waitForFormName(String name) {
        TestUtils.waitForFormName(name, 90000L);
    }

    private static void waitForFormNameImpl(String title, long timeout) {
        long t = System.currentTimeMillis() + timeout;
        while (!title.equals(Display.getInstance().getCurrent().getName())) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (System.currentTimeMillis() <= t) continue;
            TestUtils.assertBool(false, "Waiting for form " + title + " timed out! Current form name is: " + Display.getInstance().getCurrent().getName());
        }
    }

    public static void waitForUnnamedForm(final long timeout) {
        if (verbose) {
            TestUtils.log("waitForUnnamedForm()");
        }
        if (Display.getInstance().isEdt()) {
            Display.getInstance().invokeAndBlock(new Runnable(){

                public void run() {
                    TestUtils.waitForUnnamedFormImpl(timeout);
                }
            });
        } else {
            TestUtils.waitForUnnamedFormImpl(timeout);
        }
        TestUtils.waitFor(50);
    }

    public static void waitForUnnamedForm() {
        TestUtils.waitForUnnamedForm(90000L);
    }

    private static void waitForUnnamedFormImpl(long timeout) {
        long t = System.currentTimeMillis() + timeout;
        while (Display.getInstance().getCurrent().getName() != null) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (System.currentTimeMillis() <= t) continue;
            TestUtils.assertBool(false, "Waiting for form unnamed form timed out! Current form name is: " + Display.getInstance().getCurrent().getName());
        }
    }

    public static boolean screenshotTest(String screenshotName) {
        if (verbose) {
            TestUtils.log("screenshotTest(" + screenshotName + ")");
        }
        try {
            ImageIO io = ImageIO.getImageIO();
            if (io == null || !io.isFormatSupported("png")) {
                TestUtils.log("screenshot test skipped due to no image IO support for PNG format");
                return true;
            }
            Image mute = Image.createImage(Display.getInstance().getDisplayWidth(), Display.getInstance().getDisplayHeight());
            Display.getInstance().getCurrent().paintComponent(mute.getGraphics(), true);
            screenshotName = screenshotName + ".png";
            if (Storage.getInstance().exists(screenshotName)) {
                int[] rgba = mute.getRGBCached();
                Image orig = Image.createImage(Storage.getInstance().createInputStream(screenshotName));
                int[] origRgba = orig.getRGBCached();
                for (int iter = 0; iter < rgba.length; ++iter) {
                    if (rgba[iter] == origRgba[iter]) continue;
                    TestUtils.log("screenshots do not match at offset " + iter + " saving additional image under " + screenshotName + ".fail");
                    io.save(mute, Storage.getInstance().createOutputStream(screenshotName + ".fail"), "png", 1.0f);
                    return false;
                }
            } else {
                io.save(mute, Storage.getInstance().createOutputStream(screenshotName), "png", 1.0f);
            }
            return true;
        }
        catch (IOException err) {
            TestUtils.log(err);
            return false;
        }
    }

    public static void log(String t) {
        TestReporting.getInstance().logMessage(t);
    }

    public static void log(Throwable t) {
        TestReporting.getInstance().logException(t);
    }

    public static void keyPress(int keyCode) {
        if (verbose) {
            TestUtils.log("keyPress(" + keyCode + ")");
        }
        Display.getInstance().getCurrent().keyPressed(keyCode);
        TestUtils.waitFor(10);
    }

    public static void keyRelease(int keyCode) {
        if (verbose) {
            TestUtils.log("keyRelease(" + keyCode + ")");
        }
        Display.getInstance().getCurrent().keyReleased(keyCode);
        TestUtils.waitFor(10);
    }

    public static void gameKeyPress(int gameKey) {
        if (verbose) {
            TestUtils.log("gameKeyPress(" + gameKey + ")");
        }
        Display.getInstance().getCurrent().keyPressed(Display.getInstance().getKeyCode(gameKey));
        TestUtils.waitFor(10);
    }

    public static void gameKeyRelease(int gameKey) {
        if (verbose) {
            TestUtils.log("gameKeyRelease(" + gameKey + ")");
        }
        Display.getInstance().getCurrent().keyReleased(Display.getInstance().getKeyCode(gameKey));
        TestUtils.waitFor(10);
    }

    public static void pointerPress(float x, float y, String componentName) {
        if (verbose) {
            if (componentName == null) {
                TestUtils.log("pointerPress(" + x + ", " + y + ", null)");
            } else {
                TestUtils.log("pointerPress(" + x + ", " + y + ", " + componentName + ")");
            }
        }
        TestUtils.waitFor(20);
        if (componentName != null) {
            Component c = TestUtils.findByName(componentName);
            int actualX = c.getAbsoluteX() + (int)(x * (float)c.getWidth());
            int actualY = c.getAbsoluteY() + (int)(y * (float)c.getHeight());
            Display.getInstance().getCurrent().pointerPressed(actualX, actualY);
        } else {
            Display.getInstance().getCurrent().pointerPressed((int)(x * (float)Display.getInstance().getDisplayWidth()), (int)(y * (float)Display.getInstance().getDisplayHeight()));
        }
        TestUtils.waitFor(10);
    }

    public static void pointerRelease(float x, float y, String componentName) {
        if (verbose) {
            TestUtils.log("pointerRelease(" + x + ", " + y + ", " + componentName + ")");
        }
        Component c = TestUtils.findByName(componentName);
        int actualX = c.getAbsoluteX() + (int)(x * (float)c.getWidth());
        int actualY = c.getAbsoluteY() + (int)(y * (float)c.getHeight());
        Display.getInstance().getCurrent().pointerReleased(actualX, actualY);
        TestUtils.waitFor(30);
    }

    public static void pointerDrag(float x, float y, String componentName) {
        if (verbose) {
            TestUtils.log("pointerDrag(" + x + ", " + y + ", " + componentName + ")");
        }
        Component c = TestUtils.findByName(componentName);
        int actualX = c.getAbsoluteX() + (int)(x * (float)c.getWidth());
        int actualY = c.getAbsoluteY() + (int)(y * (float)c.getHeight());
        Display.getInstance().getCurrent().pointerDragged(actualX, actualY);
    }

    public static void pointerPress(float x, float y, int[] path) {
        if (verbose) {
            TestUtils.log("pointerPress(" + x + ", " + y + ", " + TestUtils.toString(path) + ")");
        }
        Component c = TestUtils.getComponentByPath(path);
        int actualX = c.getAbsoluteX() + (int)(x * (float)c.getWidth());
        int actualY = c.getAbsoluteY() + (int)(y * (float)c.getHeight());
        Display.getInstance().getCurrent().pointerPressed(actualX, actualY);
        TestUtils.waitFor(10);
    }

    public static void pointerRelease(float x, float y, int[] path) {
        if (verbose) {
            TestUtils.log("pointerRelease(" + x + ", " + y + ", " + TestUtils.toString(path) + ")");
        }
        Component c = TestUtils.getComponentByPath(path);
        int actualX = c.getAbsoluteX() + (int)(x * (float)c.getWidth());
        int actualY = c.getAbsoluteY() + (int)(y * (float)c.getHeight());
        Display.getInstance().getCurrent().pointerReleased(actualX, actualY);
        TestUtils.waitFor(10);
    }

    public static void pointerDrag(float x, float y, int[] path) {
        if (verbose) {
            TestUtils.log("pointerDrag(" + x + ", " + y + ", " + TestUtils.toString(path) + ")");
        }
        Component c = TestUtils.getComponentByPath(path);
        int actualX = c.getAbsoluteX() + (int)(x * (float)c.getWidth());
        int actualY = c.getAbsoluteY() + (int)(y * (float)c.getHeight());
        Display.getInstance().getCurrent().pointerDragged(actualX, actualY);
    }

    public static Component getComponentByPath(int[] path) {
        Component current = Display.getInstance().getCurrent().getContentPane();
        for (int iter = 0; iter < path.length; ++iter) {
            current = current.getComponentAt(path[iter]);
        }
        return current;
    }

    public static void setText(String name, String text) {
        Component c;
        if (verbose) {
            TestUtils.log("setText(" + name + ", " + text + ")");
        }
        if ((c = TestUtils.findByName(name)) instanceof Label) {
            ((Label)c).setText(text);
            return;
        }
        ((TextArea)c).setText(text);
        Display.getInstance().onEditingComplete(c, text);
    }

    public static void setText(int[] path, String text) {
        Component c;
        if (verbose) {
            TestUtils.log("setText(" + TestUtils.toString(path) + ", " + text + ")");
        }
        if ((c = TestUtils.getComponentByPath(path)) instanceof Label) {
            ((Label)c).setText(text);
            return;
        }
        ((TextArea)c).setText(text);
    }

    public static void assertBool(boolean b) {
        if (verbose) {
            TestUtils.log("assertBool(" + b + ")");
        }
        if (!b) {
            throw new RuntimeException();
        }
    }

    public static void assertBool(boolean b, String errorMessage) {
        if (verbose) {
            TestUtils.log("assertBool(" + b + ", " + errorMessage + ")");
        }
        if (!b) {
            TestUtils.log("Assert failed on: " + errorMessage);
            throw new RuntimeException(errorMessage);
        }
    }

    public static void fail() {
        if (verbose) {
            TestUtils.log("fail()");
        }
        TestUtils.assertBool(false);
    }

    public static void fail(String errorMessage) {
        if (verbose) {
            TestUtils.log("fail(" + errorMessage + ")");
        }
        TestUtils.assertBool(false, errorMessage);
    }

    public static void assertTrue(boolean value) {
        if (verbose) {
            TestUtils.log("assertTrue(" + value + ")");
        }
        TestUtils.assertBool(value);
    }

    public static void assertTrue(boolean value, String errorMessage) {
        if (verbose) {
            TestUtils.log("assertTrue(" + value + ", " + errorMessage + ")");
        }
        TestUtils.assertBool(value, errorMessage);
    }

    public static void assertFalse(boolean value) {
        if (verbose) {
            TestUtils.log("assertFalse(" + value + ")");
        }
        TestUtils.assertBool(!value);
    }

    public static void assertFalse(boolean value, String errorMessage) {
        if (verbose) {
            TestUtils.log("assertFalse(" + value + ", " + errorMessage + ")");
        }
        TestUtils.assertBool(!value, errorMessage);
    }

    public static void assertNull(Object object) {
        if (verbose) {
            TestUtils.log("assertNull(" + object + ")");
        }
        TestUtils.assertBool(object == null);
    }

    public static void assertNull(Object object, String errorMessage) {
        if (verbose) {
            TestUtils.log("assertNull(" + object + ", " + errorMessage + ")");
        }
        TestUtils.assertBool(object == null, errorMessage);
    }

    public static void assertNotNull(Object object) {
        if (verbose) {
            TestUtils.log("assertNotNull(" + object + ")");
        }
        TestUtils.assertBool(object != null);
    }

    public static void assertNotNull(Object object, String errorMessage) {
        if (verbose) {
            TestUtils.log("assertNotNull(" + object + ", " + errorMessage + ")");
        }
        TestUtils.assertBool(object != null, errorMessage);
    }

    public static void assertSame(Object expected, Object actual) {
        if (verbose) {
            TestUtils.log("assertSame(" + expected + ", " + actual + ")");
        }
        TestUtils.assertBool(expected == actual);
    }

    public static void assertSame(Object expected, Object actual, String errorMessage) {
        if (verbose) {
            TestUtils.log("assertSame(" + expected + ", " + actual + ", " + errorMessage + ")");
        }
        TestUtils.assertBool(expected == actual, errorMessage);
    }

    public static void assertNotSame(Object expected, Object actual) {
        if (verbose) {
            TestUtils.log("assertNotSame(" + expected + ", " + actual + ")");
        }
        TestUtils.assertBool(expected != actual);
    }

    public static void assertNotSame(Object expected, Object actual, String errorMessage) {
        if (verbose) {
            TestUtils.log("assertNotSame(" + expected + ", " + actual + ", " + errorMessage + ")");
        }
        TestUtils.assertBool(expected != actual, errorMessage);
    }

    private static void assertRelativeErrorExceeded(float expected, float actual, double minRelativeError) {
        double relative_error;
        if (verbose) {
            TestUtils.log("assertRelativeErrorExceeded(" + expected + ", " + actual + ", " + minRelativeError + ")");
        }
        if ((relative_error = (double)(Math.abs((expected - actual) / actual) * 100.0f)) < minRelativeError) {
            TestUtils.assertBool(false);
        }
    }

    private static void assertRelativeErrorExceeded(double expected, double actual, double minRelativeError) {
        double relative_error;
        if (verbose) {
            TestUtils.log("assertRelativeErrorExceeded(" + expected + ", " + actual + ", " + minRelativeError + ")");
        }
        if ((relative_error = Math.abs((expected - actual) / actual) * 100.0) < minRelativeError) {
            TestUtils.assertBool(false);
        }
    }

    private static void assertRelativeErrorExceeded(float expected, float actual, double minRelativeError, String errorMessage) {
        double relative_error;
        if (verbose) {
            TestUtils.log("assertRelativeErrorExceeded(" + expected + ", " + actual + ", " + minRelativeError + ", " + errorMessage + ")");
        }
        if ((relative_error = (double)(Math.abs((expected - actual) / actual) * 100.0f)) < minRelativeError) {
            TestUtils.assertBool(false, errorMessage);
        }
    }

    private static void assertRelativeErrorExceeded(double expected, double actual, double minRelativeError, String errorMessage) {
        double relative_error;
        if (verbose) {
            TestUtils.log("assertRelativeErrorExceeded(" + expected + ", " + actual + ", " + minRelativeError + ", " + errorMessage + ")");
        }
        if ((relative_error = Math.abs((expected - actual) / actual) * 100.0) < minRelativeError) {
            TestUtils.assertBool(false, errorMessage);
        }
    }

    private static void assertRelativeErrorNotExceeded(float expected, float actual, double maxRelativeError) {
        double relative_error;
        if (verbose) {
            TestUtils.log("assertRelativeErrorNotExceeded(" + expected + ", " + actual + ", " + maxRelativeError + ")");
        }
        if ((relative_error = (double)(Math.abs((expected - actual) / actual) * 100.0f)) > maxRelativeError) {
            TestUtils.assertBool(false);
        }
    }

    private static void assertRelativeErrorNotExceeded(double expected, double actual, double maxRelativeError) {
        double relative_error;
        if (verbose) {
            TestUtils.log("assertRelativeErrorNotExceeded(" + expected + ", " + actual + ", " + maxRelativeError + ")");
        }
        if ((relative_error = Math.abs((expected - actual) / actual) * 100.0) > maxRelativeError) {
            TestUtils.assertBool(false);
        }
    }

    private static void assertRelativeErrorNotExceeded(float expected, float actual, double maxRelativeError, String errorMessage) {
        double relative_error;
        if (verbose) {
            TestUtils.log("assertRelativeErrorNotExceeded(" + expected + ", " + actual + ", " + maxRelativeError + ", " + errorMessage + ")");
        }
        if ((relative_error = (double)(Math.abs((expected - actual) / actual) * 100.0f)) > maxRelativeError) {
            TestUtils.assertBool(false, errorMessage);
        }
    }

    private static void assertRelativeErrorNotExceeded(double expected, double actual, double maxRelativeError, String errorMessage) {
        double relative_error;
        if (verbose) {
            TestUtils.log("assertRelativeErrorNotExceeded(" + expected + ", " + actual + ", " + maxRelativeError + ", " + errorMessage + ")");
        }
        if ((relative_error = Math.abs((expected - actual) / actual) * 100.0) > maxRelativeError) {
            TestUtils.assertBool(false, errorMessage);
        }
    }

    private static void assertErrorNotExceeded(double expected, double actual, double maxError, String errorMessage) {
        double error;
        if (verbose) {
            TestUtils.log("assertErrorNotExceeded(" + expected + ", " + actual + ", " + maxError + ", " + errorMessage + ")");
        }
        if ((error = Math.abs(expected - actual)) > maxError) {
            TestUtils.assertBool(false, errorMessage);
        }
    }

    public static void assertEqual(byte expected, byte actual) {
        if (verbose) {
            TestUtils.log("assertEqual(" + expected + ", " + actual + ")");
        }
        TestUtils.assertBool(expected == actual);
    }

    public static void assertEqual(byte expected, byte actual, String errorMessage) {
        if (verbose) {
            TestUtils.log("assertEqual(" + expected + ", " + actual + ", " + errorMessage + ")");
        }
        TestUtils.assertBool(expected == actual, errorMessage);
    }

    public static void assertEqual(short expected, short actual) {
        if (verbose) {
            TestUtils.log("assertEqual(" + expected + ", " + actual + ")");
        }
        TestUtils.assertBool(expected == actual);
    }

    public static void assertEqual(short expected, short actual, String errorMessage) {
        if (verbose) {
            TestUtils.log("assertEqual(" + expected + ", " + actual + ", " + errorMessage + ")");
        }
        TestUtils.assertBool(expected == actual, errorMessage);
    }

    public static void assertEqual(int expected, int actual) {
        if (verbose) {
            TestUtils.log("assertEqual(" + expected + ", " + actual + ")");
        }
        TestUtils.assertBool(expected == actual, "Expected [" + expected + "], Actual [" + actual + "]");
    }

    public static void assertEqual(int expected, int actual, String errorMessage) {
        if (verbose) {
            TestUtils.log("assertEqual(" + expected + ", " + actual + ", " + errorMessage + ")");
        }
        TestUtils.assertBool(expected == actual, errorMessage + ";Expected [" + expected + "], Actual [" + actual + "]");
    }

    public static void assertEqual(long expected, long actual) {
        if (verbose) {
            TestUtils.log("assertEqual(" + expected + ", " + actual + ")");
        }
        TestUtils.assertBool(expected == actual, "Expected [" + expected + "], Actual [" + actual + "]");
    }

    public static void assertEqual(long expected, long actual, String errorMessage) {
        if (verbose) {
            TestUtils.log("assertEqual(" + expected + ", " + actual + ", " + errorMessage + ")");
        }
        TestUtils.assertBool(expected == actual, errorMessage + "; Expected [" + expected + "], Actual [" + actual + "]");
    }

    public static void assertEqual(float expected, float actual, double maxRelativeError) {
        if (verbose) {
            TestUtils.log("assertEqual(" + expected + ", " + actual + ")");
        }
        if (expected != actual) {
            TestUtils.assertRelativeErrorNotExceeded(expected, actual, maxRelativeError, "Expected [" + expected + "], Actual [" + actual + "]");
        }
    }

    public static void assertEqual(float expected, float actual, double maxRelativeError, String errorMessage) {
        if (verbose) {
            TestUtils.log("assertEqual(" + expected + ", " + actual + ", " + errorMessage + ")");
        }
        if (expected != actual) {
            TestUtils.assertRelativeErrorNotExceeded(expected, actual, maxRelativeError, errorMessage + "; Expected [" + expected + "], Actual [" + actual + "]");
        }
    }

    public static void assertEqual(double expected, double actual, double maxRelativeError) {
        if (verbose) {
            TestUtils.log("assertEqual(" + expected + ", " + actual + ")");
        }
        if (expected != actual) {
            TestUtils.assertRelativeErrorNotExceeded(expected, actual, maxRelativeError, "Expected [" + expected + "], Actual [" + actual + "]");
        }
    }

    public static void assertRange(double expected, double actual, double absoluteError) {
        if (verbose) {
            TestUtils.log("assertRange(" + expected + ", " + actual + ")");
        }
        if (expected != actual) {
            TestUtils.assertErrorNotExceeded(expected, actual, absoluteError, "Expected [" + expected + "], Actual [" + actual + "]");
        }
    }

    public static void assertEqual(double expected, double actual, double maxRelativeError, String errorMessage) {
        if (verbose) {
            TestUtils.log("assertEqual(" + expected + ", " + actual + ", " + errorMessage + ")");
        }
        if (expected != actual) {
            TestUtils.assertRelativeErrorNotExceeded(expected, actual, maxRelativeError, errorMessage + "; Expected [" + expected + "], Actual [" + actual + "]");
        }
    }

    public static void assertRange(double expected, double actual, double maxAbsoluteError, String errorMessage) {
        if (verbose) {
            TestUtils.log("assertRange(" + expected + ", " + actual + ", " + errorMessage + ")");
        }
        if (expected != actual) {
            TestUtils.assertErrorNotExceeded(expected, actual, maxAbsoluteError, errorMessage + "; Expected [" + expected + "], Actual [" + actual + "]");
        }
    }

    public static void assertEqual(Object expected, Object actual) {
        if (verbose) {
            TestUtils.log("assertEqual(" + expected + ", " + actual + ")");
        }
        TestUtils.assertBool(Objects.equals(expected, actual), "Expected [" + expected + "], Actual [" + actual + "]");
    }

    public static void assertEqual(Object expected, Object actual, String errorMessage) {
        if (verbose) {
            TestUtils.log("assertEqual(" + expected + ", " + actual + ", " + errorMessage + ")");
        }
        TestUtils.assertBool(Objects.equals(expected, actual), errorMessage + "; Expected [" + expected + "], Actual [" + actual + "]");
    }

    public static void assertNotEqual(byte expected, byte actual) {
        if (verbose) {
            TestUtils.log("assertNotEqual(" + expected + ", " + actual + ")");
        }
        TestUtils.assertBool(expected != actual);
    }

    public static void assertNotEqual(byte expected, byte actual, String errorMessage) {
        if (verbose) {
            TestUtils.log("assertNotEqual(" + expected + ", " + actual + ", " + errorMessage + ")");
        }
        TestUtils.assertBool(expected != actual, errorMessage);
    }

    public static void assertNotEqual(short expected, short actual) {
        if (verbose) {
            TestUtils.log("assertNotEqual(" + expected + ", " + actual + ")");
        }
        TestUtils.assertBool(expected != actual);
    }

    public static void assertNotEqual(short expected, short actual, String errorMessage) {
        if (verbose) {
            TestUtils.log("assertNotEqual(" + expected + ", " + actual + ", " + errorMessage + ")");
        }
        TestUtils.assertBool(expected != actual, errorMessage);
    }

    public static void assertNotEqual(int expected, int actual) {
        if (verbose) {
            TestUtils.log("assertNotEqual(" + expected + ", " + actual + ")");
        }
        TestUtils.assertBool(expected != actual);
    }

    public static void assertNotEqual(int expected, int actual, String errorMessage) {
        if (verbose) {
            TestUtils.log("assertNotEqual(" + expected + ", " + actual + ", " + errorMessage + ")");
        }
        TestUtils.assertBool(expected != actual, errorMessage);
    }

    public static void assertNotEqual(long expected, long actual, double minRelativeError) {
        if (verbose) {
            TestUtils.log("assertNotEqual(" + expected + ", " + actual + ", " + minRelativeError + ")");
        }
        if (expected == actual) {
            TestUtils.assertBool(false);
        } else {
            TestUtils.assertRelativeErrorExceeded(expected, actual, minRelativeError);
        }
    }

    public static void assertNotEqual(long expected, long actual, double minRelativeError, String errorMessage) {
        if (verbose) {
            TestUtils.log("assertNotEqual(" + expected + ", " + actual + ", " + minRelativeError + ", " + errorMessage + ")");
        }
        if (expected == actual) {
            TestUtils.assertBool(false, errorMessage);
        } else {
            TestUtils.assertRelativeErrorExceeded(expected, actual, minRelativeError, errorMessage);
        }
    }

    public static void assertNotEqual(double expected, double actual, double minRelativeError) {
        if (verbose) {
            TestUtils.log("assertNotEqual(" + expected + ", " + actual + ", " + minRelativeError + ")");
        }
        if (expected == actual) {
            TestUtils.assertBool(false);
        } else {
            TestUtils.assertRelativeErrorExceeded(expected, actual, minRelativeError);
        }
    }

    public static void assertNotEqual(double expected, double actual, double minRelativeError, String errorMessage) {
        if (verbose) {
            TestUtils.log("assertNotEqual(" + expected + ", " + actual + ", " + minRelativeError + ", " + errorMessage + ")");
        }
        if (expected == actual) {
            TestUtils.assertBool(false, errorMessage);
        } else {
            TestUtils.assertRelativeErrorExceeded(expected, actual, minRelativeError, errorMessage);
        }
    }

    public static void assertNotEqual(Object expected, Object actual) {
        if (verbose) {
            TestUtils.log("assertNotEqual(" + expected + ", " + actual + ")");
        }
        if (Objects.equals(expected, actual)) {
            TestUtils.fail("Assertion failed.  Expected not equal, but found that " + expected + " equals " + actual);
        }
    }

    public static void assertNotEqual(Object expected, Object actual, String errorMessage) {
        if (verbose) {
            TestUtils.log("assertNotEqual(" + expected + ", " + actual + ", " + errorMessage + ")");
        }
        if (Objects.equals(expected, actual)) {
            TestUtils.fail("Assertion failed.  Expected not equal, but found that " + expected + " equals " + actual + ".  " + errorMessage);
        }
    }

    private static String arrayToString(byte[] array) {
        StringBuilder result = new StringBuilder("[");
        for (int index = 0; index < array.length - 1; ++index) {
            result.append(array[index]).append(",");
        }
        if (array.length > 0) {
            result.append(array[array.length - 1]);
        }
        result.append("]");
        return result.toString();
    }

    private static String arrayToString(short[] array) {
        StringBuilder result = new StringBuilder("[");
        for (int index = 0; index < array.length - 1; ++index) {
            result.append(array[index]).append(",");
        }
        if (array.length > 0) {
            result.append(array[array.length - 1]);
        }
        result.append("]");
        return result.toString();
    }

    private static String arrayToString(int[] array) {
        StringBuilder result = new StringBuilder("[");
        for (int index = 0; index < array.length - 1; ++index) {
            result.append(array[index]).append(",");
        }
        if (array.length > 0) {
            result.append(array[array.length - 1]);
        }
        result.append("]");
        return result.toString();
    }

    private static String arrayToString(long[] array) {
        StringBuilder result = new StringBuilder("[");
        for (int index = 0; index < array.length - 1; ++index) {
            result.append(array[index]).append(",");
        }
        if (array.length > 0) {
            result.append(array[array.length - 1]);
        }
        result.append("]");
        return result.toString();
    }

    private static String arrayToString(float[] array) {
        StringBuilder result = new StringBuilder("[");
        for (int index = 0; index < array.length - 1; ++index) {
            result.append(array[index]).append(",");
        }
        if (array.length > 0) {
            result.append(array[array.length - 1]);
        }
        result.append("]");
        return result.toString();
    }

    private static String arrayToString(double[] array) {
        StringBuilder result = new StringBuilder("[");
        for (int index = 0; index < array.length - 1; ++index) {
            result.append(array[index]).append(",");
        }
        if (array.length > 0) {
            result.append(array[array.length - 1]);
        }
        result.append("]");
        return result.toString();
    }

    private static String arrayToString(Object[] array) {
        StringBuilder result = new StringBuilder("[");
        for (int index = 0; index < array.length - 1; ++index) {
            result.append(array[index]).append(",");
        }
        if (array.length > 0) {
            result.append(array[array.length - 1]);
        }
        result.append("]");
        return result.toString();
    }

    public static void assertArrayEqual(byte[] expected, byte[] actual) {
        if (verbose) {
            TestUtils.log("assertArrayEqual(" + TestUtils.arrayToString(expected) + ", " + TestUtils.arrayToString(actual) + ")");
        }
        if (expected.length != actual.length) {
            TestUtils.assertBool(false);
        }
        for (int index = 0; index < expected.length; ++index) {
            TestUtils.assertEqual(expected[index], actual[index]);
        }
    }

    public static void assertArrayEqual(byte[] expected, byte[] actual, String errorMessage) {
        if (verbose) {
            TestUtils.log("assertArrayEqual(" + TestUtils.arrayToString(expected) + ", " + TestUtils.arrayToString(actual) + ", " + errorMessage + ")");
        }
        if (expected.length != actual.length) {
            TestUtils.assertBool(false);
        }
        for (int index = 0; index < expected.length; ++index) {
            TestUtils.assertEqual(expected[index], actual[index], errorMessage);
        }
    }

    public static void assertArrayEqual(short[] expected, short[] actual) {
        if (verbose) {
            TestUtils.log("assertArrayEqual(" + TestUtils.arrayToString(expected) + ", " + TestUtils.arrayToString(actual) + ")");
        }
        if (expected.length != actual.length) {
            TestUtils.assertBool(false);
        }
        for (int index = 0; index < expected.length; ++index) {
            TestUtils.assertEqual(expected[index], actual[index]);
        }
    }

    public static void assertArrayEqual(short[] expected, short[] actual, String errorMessage) {
        if (verbose) {
            TestUtils.log("assertArrayEqual(" + TestUtils.arrayToString(expected) + ", " + TestUtils.arrayToString(actual) + ", " + errorMessage + ")");
        }
        if (expected.length != actual.length) {
            TestUtils.assertBool(false);
        }
        for (int index = 0; index < expected.length; ++index) {
            TestUtils.assertEqual(expected[index], actual[index], errorMessage);
        }
    }

    public static void assertArrayEqual(int[] expected, int[] actual) {
        if (verbose) {
            TestUtils.log("assertArrayEqual(" + TestUtils.arrayToString(expected) + ", " + TestUtils.arrayToString(actual) + ")");
        }
        if (expected.length != actual.length) {
            TestUtils.assertBool(false);
        }
        for (int index = 0; index < expected.length; ++index) {
            TestUtils.assertEqual(expected[index], actual[index]);
        }
    }

    public static void assertArrayEqual(int[] expected, int[] actual, String errorMessage) {
        if (verbose) {
            TestUtils.log("assertArrayEqual(" + TestUtils.arrayToString(expected) + ", " + TestUtils.arrayToString(actual) + ", " + errorMessage + ")");
        }
        if (expected.length != actual.length) {
            TestUtils.assertBool(false);
        }
        for (int index = 0; index < expected.length; ++index) {
            TestUtils.assertEqual(expected[index], actual[index], errorMessage);
        }
    }

    public static void assertArrayEqual(long[] expected, long[] actual, double maxRelativeError) {
        if (verbose) {
            TestUtils.log("assertArrayEqual(" + TestUtils.arrayToString(expected) + ", " + TestUtils.arrayToString(actual) + ")");
        }
        if (expected.length != actual.length) {
            TestUtils.assertBool(false);
        }
        for (int index = 0; index < expected.length; ++index) {
            TestUtils.assertEqual((float)expected[index], (float)actual[index], maxRelativeError);
        }
    }

    public static void assertArrayEqual(long[] expected, long[] actual, double maxRelativeError, String errorMessage) {
        if (verbose) {
            TestUtils.log("assertArrayEqual(" + TestUtils.arrayToString(expected) + ", " + TestUtils.arrayToString(actual) + ", " + errorMessage + ")");
        }
        if (expected.length != actual.length) {
            TestUtils.assertBool(false);
        }
        for (int index = 0; index < expected.length; ++index) {
            TestUtils.assertEqual(expected[index], actual[index], maxRelativeError, errorMessage);
        }
    }

    public static void assertArrayEqual(float[] expected, float[] actual, double maxRelativeError) {
        if (verbose) {
            TestUtils.log("assertArrayEqual(" + TestUtils.arrayToString(expected) + ", " + TestUtils.arrayToString(actual) + ")");
        }
        if (expected.length != actual.length) {
            TestUtils.assertBool(false);
        }
        for (int index = 0; index < expected.length; ++index) {
            TestUtils.assertEqual(expected[index], actual[index], maxRelativeError);
        }
    }

    public static void assertArrayEqual(float[] expected, float[] actual, double maxRelativeError, String errorMessage) {
        if (verbose) {
            TestUtils.log("assertArrayEqual(" + TestUtils.arrayToString(expected) + ", " + TestUtils.arrayToString(actual) + ", " + errorMessage + ")");
        }
        if (expected.length != actual.length) {
            TestUtils.assertBool(false);
        }
        for (int index = 0; index < expected.length; ++index) {
            TestUtils.assertEqual(expected[index], actual[index], maxRelativeError, errorMessage);
        }
    }

    public static void assertArrayEqual(double[] expected, double[] actual, double maxRelativeError) {
        if (verbose) {
            TestUtils.log("assertArrayEqual(" + TestUtils.arrayToString(expected) + ", " + TestUtils.arrayToString(actual) + ")");
        }
        if (expected.length != actual.length) {
            TestUtils.assertBool(false);
        }
        for (int index = 0; index < expected.length; ++index) {
            TestUtils.assertEqual(expected[index], actual[index], maxRelativeError);
        }
    }

    public static void assertArrayEqual(double[] expected, double[] actual, double maxRelativeError, String errorMessage) {
        if (verbose) {
            TestUtils.log("assertArrayEqual(" + TestUtils.arrayToString(expected) + ", " + TestUtils.arrayToString(actual) + ", " + errorMessage + ")");
        }
        if (expected.length != actual.length) {
            TestUtils.assertBool(false);
        }
        for (int index = 0; index < expected.length; ++index) {
            TestUtils.assertEqual(expected[index], actual[index], maxRelativeError, errorMessage);
        }
    }

    public static void assertArrayEqual(Object[] expected, Object[] actual) {
        if (verbose) {
            TestUtils.log("assertArrayEqual(" + TestUtils.arrayToString(expected) + ", " + TestUtils.arrayToString(actual) + ")");
        }
        if (expected.length != actual.length) {
            TestUtils.assertBool(false);
        }
        for (int index = 0; index < expected.length; ++index) {
            TestUtils.assertEqual(expected[index], actual[index]);
        }
    }

    public static void assertArrayEqual(Object[] expected, Object[] actual, String errorMessage) {
        if (verbose) {
            TestUtils.log("assertArrayEqual(" + TestUtils.arrayToString(expected) + ", " + TestUtils.arrayToString(actual) + ", " + errorMessage + ")");
        }
        if (expected.length != actual.length) {
            TestUtils.assertBool(false);
        }
        for (int index = 0; index < expected.length; ++index) {
            TestUtils.assertEqual(expected[index], actual[index], errorMessage);
        }
    }

    public static void assertException(RuntimeException exception, Runnable expression) {
        if (verbose) {
            TestUtils.log("assertException(" + exception + ", " + expression + ")");
        }
        try {
            expression.run();
        }
        catch (RuntimeException failure) {
            if (exception.getClass() != failure.getClass()) {
                TestUtils.fail();
            }
            return;
        }
        TestUtils.fail();
    }

    public static void assertException(RuntimeException exception, Runnable expression, String errorMessage) {
        if (verbose) {
            TestUtils.log("assertException(" + exception + ", " + expression + ", " + errorMessage + ")");
        }
        try {
            expression.run();
        }
        catch (RuntimeException failure) {
            if (exception.getClass() != failure.getClass()) {
                TestUtils.fail(errorMessage);
            }
            return;
        }
        TestUtils.fail(errorMessage);
    }

    public static void assertNoException(Runnable expression) {
        if (verbose) {
            TestUtils.log("assertNoException(" + expression + ")");
        }
        try {
            expression.run();
        }
        catch (RuntimeException failure) {
            TestUtils.fail();
        }
    }

    public static void assertNoException(Runnable expression, String errorMessage) {
        if (verbose) {
            TestUtils.log("assertNoException(" + expression + ", " + errorMessage + ")");
        }
        try {
            expression.run();
        }
        catch (RuntimeException failure) {
            TestUtils.fail(errorMessage);
        }
    }

    public static void assertTitle(String title) {
        if (verbose) {
            TestUtils.log("assertTitle(" + title + ")");
        }
        TestUtils.assertBool(Display.getInstance().getCurrent().getTitle().equals(title), title);
    }

    public static void assertLabel(String name, String text) {
        Label l;
        if (verbose) {
            TestUtils.log("assertLabel(" + name + ", " + text + ")");
        }
        TestUtils.assertBool((l = (Label)TestUtils.findByName(name)) != null, "Null label" + text);
        TestUtils.assertBool(text == l.getText() || text.equals(l.getText()), name + " != " + text);
    }

    public static void assertLabel(int[] path, String text) {
        Label l;
        if (verbose) {
            TestUtils.log("assertLabel(" + TestUtils.toString(path) + ", " + text + ")");
        }
        TestUtils.assertBool((l = (Label)TestUtils.getComponentByPath(path)) != null, "Null label" + text);
        TestUtils.assertBool(text == l.getText() || text.equals(l.getText()), l.getText() + " != " + text);
    }

    public static void assertLabel(String text) {
        Label l;
        if (verbose) {
            TestUtils.log("assertLabel(" + text + ")");
        }
        TestUtils.assertBool((l = TestUtils.findLabelText(text)) != null, "Null label " + text);
    }

    public static void assertTextArea(String name, String text) {
        TextArea l;
        if (verbose) {
            TestUtils.log("assertTextArea(" + name + ", " + text + ")");
        }
        TestUtils.assertBool((l = (TextArea)TestUtils.findByName(name)) != null, "Null area " + text);
        TestUtils.assertBool(l.getText().equals(text), "assertTextArea: " + l.getText() + " != " + text);
    }

    public static void assertTextAreaContaining(String name, String text) {
        TextArea l;
        if (verbose) {
            TestUtils.log("assertTextAreaContaining(" + name + ", " + text + ")");
        }
        TestUtils.assertBool((l = (TextArea)TestUtils.findByName(name)) != null, "Null area " + text);
        TestUtils.assertBool(l.getText().indexOf(text) > -1, "assertTextArea: \"" + l.getText() + "\" is not containing: \"" + text + "\"");
    }

    public static void assertTextAreaStartingWith(String name, String text) {
        TextArea l;
        if (verbose) {
            TestUtils.log("assertTextAreaStartingWith(" + name + ", " + text + ")");
        }
        TestUtils.assertBool((l = (TextArea)TestUtils.findByName(name)) != null, "Null area " + text);
        TestUtils.assertBool(l.getText().startsWith(text), "assertTextArea: \"" + l.getText() + "\" is not starting with: \"" + text + "\"");
    }

    public static void assertTextAreaEndingWith(String name, String text) {
        TextArea l;
        if (verbose) {
            TestUtils.log("assertTextAreaEndingWith(" + name + ", " + text + ")");
        }
        TestUtils.assertBool((l = (TextArea)TestUtils.findByName(name)) != null, "Null area " + text);
        TestUtils.assertBool(l.getText().endsWith(text), "assertTextArea: \"" + l.getText() + "\" is not ending with: \"" + text + "\"");
    }

    public static void assertTextArea(int[] path, String text) {
        TextArea l;
        if (verbose) {
            TestUtils.log("assertTextArea(" + TestUtils.toString(path) + ", " + text + ")");
        }
        TestUtils.assertBool((l = (TextArea)TestUtils.getComponentByPath(path)) != null, "Null area " + text);
        TestUtils.assertBool(l.getText().equals(text), "assertTextArea: " + l.getText() + " != " + text);
    }

    public static void assertTextArea(String text) {
        TextArea l;
        if (verbose) {
            TestUtils.log("assertTextArea(" + text + ")");
        }
        TestUtils.assertBool((l = TestUtils.findTextAreaText(text)) != null, "Null text " + text);
    }

    public static TextArea findTextAreaText(String text) {
        return TestUtils.findTextAreaText(Display.getInstance().getCurrent(), text);
    }

    private static TextArea findTextAreaText(Container root, String text) {
        int count = root.getComponentCount();
        for (int iter = 0; iter < count; ++iter) {
            TextArea l;
            Component c = root.getComponentAt(iter);
            if (c instanceof TextArea) {
                String n = ((TextArea)c).getText();
                if (n == null || !n.equals(text)) continue;
                return (TextArea)c;
            }
            if (!(c instanceof Container) || (l = TestUtils.findTextAreaText((Container)c, text)) == null) continue;
            return l;
        }
        return null;
    }
}

