/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui;

import com.codename1.ui.BrowserComponent;
import com.codename1.ui.Command;
import com.codename1.ui.Display;
import com.codename1.ui.Form;
import com.codename1.ui.Toolbar;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.layouts.BorderLayout;
import com.codename1.ui.util.EventDispatcher;
import com.codename1.util.AsyncResource;

public class BrowserWindow {
    private final Object nativeWindow;
    private BrowserForm form;
    private BrowserComponent webview;

    public BrowserWindow(String startURL) {
        this.nativeWindow = this.createNativeWindow(startURL);
        if (this.nativeWindow == null) {
            this.form = new BrowserForm();
            this.webview.setURL(startURL);
        }
    }

    private Object createNativeWindow(String startURL) {
        return Display.impl.createNativeBrowserWindow(startURL);
    }

    public void addLoadListener(ActionListener l) {
        if (this.nativeWindow != null) {
            Display.impl.addNativeBrowserWindowOnLoadListener(this.nativeWindow, l);
        } else {
            this.webview.addWebEventListener("onLoad", l);
        }
    }

    public void removeLoadListener(ActionListener l) {
        if (this.nativeWindow != null) {
            Display.impl.removeNativeBrowserWindowOnLoadListener(this.nativeWindow, l);
        } else {
            this.webview.removeWebEventListener("onLoad", l);
        }
    }

    public void setTitle(String title) {
        if (this.nativeWindow != null) {
            Display.impl.nativeBrowserWindowSetTitle(this.nativeWindow, title);
        } else {
            this.form.setTitle(title);
        }
    }

    public void setSize(int width, int height) {
        if (this.nativeWindow != null) {
            Display.impl.nativeBrowserWindowSetSize(this.nativeWindow, width, height);
        }
    }

    public void close() {
        if (this.nativeWindow != null) {
            Display.impl.nativeBrowserWindowHide(this.nativeWindow);
            Display.impl.nativeBrowserWindowCleanup(this.nativeWindow);
        } else {
            this.form.close();
        }
    }

    public void addCloseListener(ActionListener l) {
        if (this.nativeWindow != null) {
            Display.impl.nativeBrowserWindowAddCloseListener(this.nativeWindow, l);
        } else {
            this.form.closeListeners.addListener(l);
        }
    }

    public void removeCloseListener(ActionListener l) {
        if (this.nativeWindow != null) {
            Display.impl.nativeBrowserWindowRemoveCloseListener(this.nativeWindow, l);
        } else {
            this.form.closeListeners.removeListener(l);
        }
    }

    public void show() {
        if (this.nativeWindow != null) {
            Display.impl.nativeBrowserWindowShow(this.nativeWindow);
        } else {
            this.form.show();
        }
    }

    private class BrowserForm
    extends Form {
        private final EventDispatcher closeListeners = new EventDispatcher();
        private final Form backForm;
        private boolean closed;

        BrowserForm() {
            this.setLayout(new BorderLayout());
            BrowserWindow.this.webview = new BrowserComponent();
            this.add((Object)"Center", BrowserWindow.this.webview);
            this.backForm = Display.getInstance().getCurrent();
            Toolbar tb = new Toolbar();
            this.setToolbar(tb);
            tb.addMaterialCommandToLeftBar("", '\ue5e0', new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    if (BrowserForm.this.closed) {
                        return;
                    }
                    BrowserForm.this.closed = true;
                    BrowserForm.this.backForm.showBack();
                    BrowserForm.this.closeListeners.fireActionEvent(evt);
                }
            });
            this.setBackCommand(new Command(""){

                public void actionPerformed(ActionEvent e) {
                    if (BrowserForm.this.closed) {
                        return;
                    }
                    BrowserForm.this.closed = true;
                    BrowserForm.this.backForm.showBack();
                    BrowserForm.this.closeListeners.fireActionEvent(e);
                }
            });
        }

        void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.backForm.showBack();
            this.closeListeners.fireActionEvent(new ActionEvent(this));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EvalRequest
    extends AsyncResource<String> {
        private String js;

        public String getJS() {
            return this.js;
        }

        public void setJS(String js) {
            this.js = js;
        }
    }
}

